<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

use Joomla\Registry\Registry;

defined('_JEXEC') or die();
defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jimport('joomla.form.formfield');


class JFormFieldDjarticle extends JFormField {

	protected $type = 'Djarticle';

	protected function getInput()
	{
		$app = JFactory::getApplication();
		$params = JComponentHelper::getParams('com_djcatalog2');

		$id    = isset($this->element['id']) ? $this->element['id'] : null;
		$cssId = '#' . $this->getId($id, $this->element['name']);
		$urlVars = 'index.php?option=com_djcatalog2&task=searchArticleAjax';
		$url = $app->isSite() ? JUri::root() . $urlVars : JUri::base() . $urlVars;

		$chosenAjaxSettings = new Registry(
			array(
				'selector'      => $cssId,
				'type'          => 'GET',
				'url'           => $url,
				'dataType'      => 'json',
				'jsonTermKey'   => 'like',
				'minTermLength' => 3,
				'disable_search_threshold' => 20
			)
		);

		$chosenSettings = array();
		$chosenSettings['max_selected_options'] = 1;
		$chosenSettings['disable_search_threshold'] = 0;
		$chosenSettings['placeholder_text_multiple'] = JText::_('COM_DJCATALOG2_CONFIG_AJAX_USER_PLACEHOLDER');
		$chosenSettings['placeholder_text_single'] = JText::_('COM_DJCATALOG2_CONFIG_AJAX_USER_PLACEHOLDER');
		$chosenSettings = new Registry($chosenSettings);

		JHtml::_('formbehavior.chosen', $cssId, null, $chosenSettings);
		JHtml::_('formbehavior.ajaxchosen', $chosenAjaxSettings);

		// Initialize some field attributes.
		$size		= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
		$maxLength	= $this->element['maxlength'] ? ' maxlength="'.(int) $this->element['maxlength'].'"' : '';
		$attr = '';

		$class = $this->element['class'] ? (string) $this->element['class'] : '';
		$class .= $this->element['required']=='true' ? ' required' : '';

		$attr .= 'class="'.$class.'"';
		$name = $this->name;
		$attr .= ' multiple="true" size="10"';

		if ($this->onchange != '') {
			$attr .= ' onchange="'.trim($this->onchange).'"';
		}

		$options[] = JHTML::_('select.option',0 , JText::_('COM_DJCATALOG2_DJARTICLE_NONE'));

		$selected = array();

		if (!empty($this->value)) {
			if (is_array($this->value)) {
				$articles = $this->getArticlesByValue($this->value);
				if(count($articles)) {
					foreach ($articles as $article) {
						$options[] = JHtml::_('select.option', $article->value, $article->text);
					}
				}
			}
		}

		$out = JHtml::_('select.genericlist', $options, $name, trim($attr), 'value', 'text', $this->value, $this->id);

		return ($out);
	}


	private function getArticlesByValue($value) {
		// Required objects
		$app = JFactory::getApplication();

		$like = trim($app->input->get('like', null, 'string'));

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select(array($db->quoteName('a.id', 'value'), $db->quoteName('a.title', 'text')))
			->from($db->quoteName('#__content', 'a'))
			->where($db->quoteName('a.id') . ' IN (' . implode($value, ",") . ')');


		$db->setQuery($query);
		return  $db->loadObjectList();
	}
}
?>