<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// no direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

class Djcatalog2ModelExrates extends JModelList
{
	public function __construct($config = array())
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'rate_date', 'a.rate_date', 'currency_pair', 'target_rate', 'a.target_rate'
			);
		}

		parent::__construct($config);
	}
	protected function populateState($ordering = null, $direction = null)
	{
		// List state information.
		parent::populateState('a.rate_date', 'desc');
		
		// Initialise variables.
		$app = JFactory::getApplication();
		$session = JFactory::getSession();
		
		$search = $this->getUserStateFromRequest($this->context.'.filter.search', 'filter_search');
		$this->setState('filter.search', $search);
		
		$target_id = $this->getUserStateFromRequest($this->context.'.filter.target_id', 'target_id', false);
		$this->setState('filter.target_id', $target_id);

		// Load the parameters.
		$params = JComponentHelper::getParams('com_djcatalog2');
		$this->setState('params', $params);
	}
	
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id	.= ':'.$this->getState('filter.search');
	
		return parent::getStoreId($id);
	}

	protected function getListQuery()
	{
		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select',
				'a.*, c1.currency as base, c2.currency as quote'
			)
		);
		$query->from('#__djc2_currency_exchange AS a');
		$query->join('inner', '#__djc2_currencies AS c1 ON c1.id = a.base_id');
		$query->join('inner','#__djc2_currencies AS c2 ON c2.id = a.target_id');
		
		if ($target_id = $this->getState('filter.target_id')) {
			$query->where('a.target_id='.(int)$target_id);
		}
		
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = '.(int) substr($search, 3));
			}
			else {
				$search = $db->quote($search);
				$query->where('( DATE(a.rate_date)= DATE('.$search.') )');
			}
		}
		
		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering');
		$orderDirn	= $this->state->get('list.direction');
		
		if ($orderCol == 'currency_pair') {
			$orderCol = 'c1.currency '.$orderDirn.', c2.currency ASC';
			$orderDirn = '';
		}
	
		$query->order($db->escape($orderCol.' '.$orderDirn));
		return $query;
	}
	
}