<?php 
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
use Joomla\Registry\Registry;

defined('_JEXEC') or die();

require_once(JPATH_ROOT.'/administrator/components/com_djcatalog2/lib/categories.php');

class Djc2ProducerCategoryNode extends Djc2CategoryNode
{
	public function getProductCount() {
		if (!isset($this->item_count)) {
			$db = JFactory::getDbo();
			
			
			$childrenList = array($this->id);
			$this->makeChildrenList($childrenList);
			$cids = implode(',', $childrenList);
			
			$query = $db->getQuery(true);
			
			$query->select('COUNT(DISTINCT i.id)');
			$query->from('#__djc2_producers AS i');
			//$query->join('INNER', '#__djc2_producer_categories AS c ON c.id IN ('.$cids.')');
			$query->where('i.published = 1');
			$query->where('i.cat_id IN ('.$cids.')');
			//$query->where('i.cat_id = '.$this->id);
			
			$nullDate = $db->quote($db->getNullDate());
			$date = JFactory::getDate();
			$nowDate = $db->quote($date->toSql());
			
			$db->setQuery($query);
			
			$count = $db->loadResult();
			if ($count !== false) {
				$this->item_count = $count;
			}
		}
		
		return (isset($this->item_count)) ? $this->item_count : false;
	}
}

class Djc2ProducerCategories extends Djc2Categories
{
	function __construct($options)
	{
		$params = JComponentHelper::getParams('com_djcatalog2');
		
		$category_ordering = $params->get('category_ordering', 'c.ordering');
		if ($category_ordering != 'c.ordering' && $category_ordering != 'c.name') {
			$category_ordering = 'c.ordering';
		}
		
		if (!array_key_exists('order', $options) || !$options['order']) {
			$options['order'] = $category_ordering;
		}
		if (!array_key_exists('order_dir', $options) || !$options['order_dir']) {
			$options['order_dir'] = 'ASC';
		}
		
		if(isset($options['ignore_lang']) && $options['ignore_lang']) {
			$options['ignore_lang'] = true;
		} else {
			$options['ignore_lang'] = false;
		}
		
		$this->options = $options;
		$this->nodes[0] = new Djc2ProducerCategoryNode();
		$this->categories = $this->getCategories($options);
		$this->createNodes($this->categories);
		$this->buildTree();
	}
	
	protected function createNodes($categories) {
		foreach ($categories as $category) {
			$this->nodes[$category->id] = new Djc2ProducerCategoryNode($category);
		}
	}
	
	public static function getInstance($options = array()) {
		$hash = md5('producers|'.serialize($options));
		
		if (isset(self::$instances[$hash])) {
			return self::$instances[$hash];
		}
		self::$instances[$hash] = new Djc2ProducerCategories($options);
		return self::$instances[$hash];
	}
	
	protected function getCategories($options = array()) {
		$db	= JFactory::getDbo();
		$app = JFactory::getApplication();
		
		$where = array();
		
		if (array_key_exists('state', $options)) {
			if ($options['state'] == 1) {
				$where[] = 'c.published=1';
			}
		}
		if (array_key_exists('access', $options)) {
			$groups = (is_array($options['access'])) ? implode(',', array_unique($options['access'])) : $options['access'];
			$where[] = 'c.access IN ('.$groups.') ';
		}
		
		if($app->isClient('site') && empty($options['ignore_lang'])) {
			$where[] = '(c.language = ' . $db->quote(JFactory::getLanguage()->getTag()) . ' OR c.language = ' . $db->quote('*') . ')';
		}
		
		$where 		= ( count( $where ) ? ' WHERE '. implode( ' AND ', $where ) : '' );
		
		$orderby = ' ORDER BY c.parent_id ASC, '.$options['order'].' '.$options['order_dir'];
		
		$db	= JFactory::getDbo();
		$app = JFactory::getApplication();
		$query = ' SELECT c.* '
			.' FROM #__djc2_producer_categories AS c '
			.$where
			.$orderby;
			$db->setQuery($query);
			$list = $db->loadObjectList();
			
			$query = $db->getQuery(true);
			$query->select('i.id, img.fullname as item_image, img.caption AS image_caption, img.path AS image_path, img.fullpath AS image_fullpath');
			$query->from('#__djc2_producer_categories as i');
			$query->join('inner', '#__djc2_images as img on img.id=(select id from #__djc2_images where type=\'producercategory\' and item_id=i.id order by ordering asc limit 1)');
			
			if($app->isClient('site') && empty($options['ignore_lang'])) {
				$query->where('(i.language = ' . $db->quote(JFactory::getLanguage()->getTag()) . ' OR i.language = ' . $db->quote('*') . ')');
			}
			
			$db->setQuery($query);
			$image_list = $db->loadObjectList('id');
			
			foreach ($list as $k=>$v) {
				$list[$k]->catslug  = $list[$k]->slug = (!empty($v->alias)) ? $v->id.':'.$v->alias : $v->id;
				
				$list[$k]->item_image = isset($image_list[$v->id]) ? $image_list[$v->id]->item_image : null;
				$list[$k]->image_caption = isset($image_list[$v->id]) ? $image_list[$v->id]->image_caption : null;
				$list[$k]->image_path = isset($image_list[$v->id]) ? $image_list[$v->id]->image_path : null;
				$list[$k]->image_fullpath = isset($image_list[$v->id]) ? $image_list[$v->id]->image_fullpath : null;
			}
			
			return $list;
	} 
}