CREATE TABLE IF NOT EXISTS `#__djc2_price_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation` enum('add','sub') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sub',
  `type` enum('percent','amount') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `value` decimal(14,4) UNSIGNED DEFAULT '0.0000',
  `calc_type` enum('grand_total','total_items','each_item','delivery','payment') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'grand_total',
  `change_old_price` tinyint(4) NOT NULL DEFAULT '1',
  `start_date` datetime DEFAULT NULL,
  `expire_date` datetime DEFAULT NULL,
  `product_id` text COLLATE utf8mb4_unicode_ci,
  `category_id` text COLLATE utf8mb4_unicode_ci,
  `excluded_product_id` text COLLATE utf8mb4_unicode_ci,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `postcodes` text COLLATE utf8mb4_unicode_ci,
  `countries` mediumtext COLLATE utf8mb4_unicode_ci,
  `min_orders` int(11) NOT NULL DEFAULT '0',
  `max_orders` int(11) NOT NULL DEFAULT '-1',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(11) NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;