CREATE TABLE IF NOT EXISTS `#__djc2_producer_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `description` mediumtext,
  `parent_id` int(11) NOT NULL,
  `metatitle` varchar(255) DEFAULT NULL,
  `metakey` text,
  `metadesc` text,
  `heading` varchar(255) DEFAULT NULL,
  `published` int(11) NOT NULL DEFAULT '1',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL,
  `params` text,
  `checked_out` int(11) NOT NULL,
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_parent_id` (`parent_id`),
  KEY `idx_published` (`published`),
  KEY `idx_access` (`access`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_ordering` ( `ordering` ), 
  KEY `idx_published_parent_ordering` ( `published` , `parent_id` , `ordering` ) 
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `#__djc2_producers` ADD `cat_id` INT NOT NULL DEFAULT '0' AFTER `alias`;

CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `imagelabel` VARCHAR( 255 ) NULL,
  `type` varchar(50) NOT NULL,
  `published` int(11) NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL,
  `visibility` int(11) NOT NULL,
  `required` SMALLINT NOT NULL DEFAULT '0',
  `params` text,
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_type` (`type`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;


CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields_values_date` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` date NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_field` (`item_id`,`field_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci ;


CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields_values_text` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_item_field` (`item_id`,`field_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields_values_int` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_item_field` (`item_id`,`field_id`),
  KEY `idx_value` (`value`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields_options` (
	`id` INT NOT NULL AUTO_INCREMENT, 
	`field_id` INT NOT NULL, 
	`value` VARCHAR(100) NOT NULL, 
	`ordering` INT NOT NULL, 
	`params` text,
	PRIMARY KEY (`id`),
  	KEY `idx_field_id` (`field_id`),
  	KEY `idx_value` (`value`),
  	KEY `idx_ordering` (`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
