CREATE TABLE IF NOT EXISTS `#__djc2_addresses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `firstname` varchar(100) DEFAULT NULL,
  `lastname` varchar(100) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `state` varchar(100) DEFAULT NULL,
  `state_id` int(11) DEFAULT '0',
  `phone` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_cart_extra_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` int(11) NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `required` smallint(6) NOT NULL DEFAULT '0',
  `visibility` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_type` (`type`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_cart_extra_fields_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) NOT NULL,
  `value` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_field_id` (`field_id`),
  KEY `idx_value` (`value`),
  KEY `idx_ordering` (`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `metatitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci,
  `heading` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` int(11) NOT NULL DEFAULT '1',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci DEFAULT '*',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `sections` longtext COLLATE utf8mb4_unicode_ci,
  `params` text COLLATE utf8mb4_unicode_ci,
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_complex` (`id`,`parent_id`,`published`,`access`,`ordering`),
  KEY `idx_parent_id` (`parent_id`),
  KEY `idx_published` (`published`),
  KEY `idx_access` (`access`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_ordering` (`ordering`),
  KEY `idx_published_parent_ordering` (`published`,`parent_id`,`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_combination_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `combination_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `price` decimal(14,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_group` (`combination_id`,`group_id`),
  UNIQUE KEY `group_item` (`group_id`,`combination_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_countries` (
  `id` smallint(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `country_name` char(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_3_code` char(3) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_2_code` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `is_eu` smallint(6) NOT NULL DEFAULT '0',
  `is_default` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_country_3_code` (`country_3_code`),
  KEY `idx_country_2_code` (`country_2_code`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_countries_states` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_country_id` (`country_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(31) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('percent','amount') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `value` decimal(14,4) DEFAULT '0.0000',
  `start_date` datetime DEFAULT NULL,
  `expire_date` datetime DEFAULT NULL,
  `reuse` tinyint(1) NOT NULL DEFAULT '0',
  `reuse_limit` int(11) NOT NULL DEFAULT '1',
  `reuse_count` int(11) NOT NULL DEFAULT '0',
  `user_reuse` tinyint(1) NOT NULL DEFAULT '0',
  `user_reuse_limit` int(11) NOT NULL DEFAULT '1',
  `product_id` text COLLATE utf8mb4_unicode_ci,
  `category_id` text COLLATE utf8mb4_unicode_ci,
  `producer_id` text COLLATE utf8mb4_unicode_ci,
  `excluded_product_id` text COLLATE utf8mb4_unicode_ci,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_code` (`code`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_coupons_used` (
  `coupon_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `used_date` datetime DEFAULT NULL
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_currency_exchange` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `base_id` int(11) NOT NULL,
  `target_id` int(11) NOT NULL,
  `target_rate` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `rate_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `#__djc2_customer_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_default` tinyint(4) NOT NULL DEFAULT '0',
  `user_group` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_group` (`user_group`),
  KEY `ordering` (`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_customisations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` char(1) NOT NULL DEFAULT 'c',
  `price` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `tax_rule_id` int(11) NOT NULL DEFAULT '0',
  `price_modifier` char(1) NOT NULL DEFAULT 's',
  `required` tinyint(4) NOT NULL DEFAULT '0',
  `min_quantity` int(11) NOT NULL DEFAULT '0',
  `max_quantity` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `input_params` mediumtext,
  `params` mediumtext,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_deliveries_payments` (
  `delivery_id` int(11) NOT NULL,
  `payment_id` int(11) NOT NULL,
  PRIMARY KEY (`delivery_id`,`payment_id`),
  UNIQUE KEY `payment_delivery` (`payment_id`,`delivery_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_delivery_methods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `plugin` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(14,4) DEFAULT NULL,
  `additional_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tax_rule_id` int(11) NOT NULL DEFAULT '0',
  `free_amount` decimal(14,4) DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `shipping_details` tinyint(4) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  `access` int(11) NOT NULL DEFAULT '0',
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `countries` mediumtext COLLATE utf8mb4_unicode_ci,
  `postcodes` text COLLATE utf8mb4_unicode_ci,
  `min_weight` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `max_weight` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `weight_unit` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_plugin` (`plugin`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(11) NOT NULL DEFAULT '0',
  `fullname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fullpath` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `caption` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT 'local',
  PRIMARY KEY (`id`),
  KEY `idx_type_item` (`type`,`item_id`),
  KEY `idx_item_type` (`item_id`,`type`),
  KEY `idx_item_type_ordering` (`item_id`,`type`,`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fullname` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fullpath` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `caption` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `exclude` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_type_item` (`type`,`item_id`),
  KEY `idx_item_type` (`item_id`,`type`),
  KEY `idx_item_type_ordering` (`item_id`,`type`,`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_import_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `csv_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_db` tinyint(4) NOT NULL DEFAULT '0',
  `db_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `db_lookup_column` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `db_value_column` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `db_operator` tinyint(4) NOT NULL DEFAULT '0',
  `db_where_clause` text COLLATE utf8mb4_unicode_ci,
  `merging` char(1) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `html_wrapper` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_inv_counters` (
  `year` int(11) NOT NULL DEFAULT '0',
  `counter` int(11) NOT NULL DEFAULT '0',
  `doctype` enum('invoice','proforma') NOT NULL DEFAULT 'invoice'
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `producer_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sku` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `intro_desc` text COLLATE utf8mb4_unicode_ci,
  `price` decimal(14,4) DEFAULT NULL DEFAULT '0.0',
  `special_price` decimal(14,4) NULL DEFAULT '0.0',
  `price_restrict` tinyint(4) NOT NULL DEFAULT '0',
  `tax_rule_id` int(11) NOT NULL DEFAULT '0',
  `price_tier_modifier` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `price_tier_break` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'i',
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` int(11) DEFAULT NULL,
  `state` int(11) DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` decimal(18,15) DEFAULT NULL,
  `longitude` decimal(18,15) DEFAULT NULL,
  `available` int(11) NOT NULL DEFAULT '0',
  `avail_info` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_days` int(11) NOT NULL DEFAULT '0',
  `onstock` int(11) NOT NULL DEFAULT '1',
  `stock` decimal(10,4) NULL DEFAULT '0.0000',
  `unit_id` int(11) NOT NULL DEFAULT '0',
  `gauge_id` int(11) NOT NULL DEFAULT '0',
  `length` decimal(10,4) NULL DEFAULT '0.0000',
  `width` decimal(10,4) NULL DEFAULT '0.0000',
  `height` decimal(10,4) NULL DEFAULT '0.0000',
  `dimensions_unit` int(11) NOT NULL DEFAULT '0',
  `weight` decimal(10,4) NULL DEFAULT '0.0000',
  `weight_unit` int(11) NOT NULL DEFAULT '0',
  `product_type` enum('tangible','virtual','subscription','hybrid') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'tangible',
  `expiration` int(11) NOT NULL DEFAULT '0',
  `grant_usergroup` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `granted_usergroups` text,
  `metatitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci,
  `heading` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` int(11) NOT NULL DEFAULT '1',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci DEFAULT '*',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured` int(11) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  `sections_source` int(11) NOT NULL DEFAULT '0',
  `sections` longtext COLLATE utf8mb4_unicode_ci,
  `config_conditions` longtext COLLATE utf8mb4_unicode_ci,
  `config_dimensions` text COLLATE utf8mb4_unicode_ci,
  `config_dimensions_unit` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `config_dimensions_settings` mediumtext COLLATE utf8mb4_unicode_ci,
  `params` text COLLATE utf8mb4_unicode_ci,
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `created_by` int(10) NOT NULL DEFAULT '0',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_by` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_cat_id` (`cat_id`),
  KEY `idx_parent_id` (`parent_id`),
  KEY `idx_group_id` (`group_id`),
  KEY `idx_producer_id` (`producer_id`),
  KEY `idx_published` (`published`),
  KEY `idx_access` (`access`),
  KEY `idx_featured` (`featured`),
  KEY `idx_ordering` (`ordering`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_country` (`country`),
  KEY `idx_state` (`state`),
  KEY `idx_latitude` (`latitude`),
  KEY `idx_longitude` (`longitude`),
  KEY `idx_publish_up` (`publish_up`),
  KEY `idx_publish_down` (`publish_down`),
  KEY `idx_language` (`language`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_categories` (
  `item_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  PRIMARY KEY (`category_id`,`item_id`),
  UNIQUE KEY `item_category` (`item_id`,`category_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_combinations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `sku` varchar(50) DEFAULT NULL,
  `price` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `stock` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `length` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `width` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `height` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `dimensions_unit` int(11) NOT NULL DEFAULT '0',
  `weight` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `weight_unit` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_item_id` (`item_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_items_combinations_fields` (
  `combination_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` int(11) NOT NULL,
  UNIQUE KEY `idx_combination_field_value` (`combination_id`,`field_id`,`value`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_items_customisations` (
  `item_id` int(11) NOT NULL,
  `customisation_id` int(11) NOT NULL DEFAULT '0',
  `price` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `required` int(11) NOT NULL DEFAULT '0',
  `min_quantity` int(11) NOT NULL DEFAULT '0',
  `max_quantity` int(11) NOT NULL DEFAULT '0',
  `params` mediumtext,
  UNIQUE KEY `item_id` (`item_id`,`customisation_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_items_extra_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `label_type` tinyint(4) NOT NULL DEFAULT '1',
  `imagelabel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` int(11) NOT NULL DEFAULT '1',
  `language` char(7) COLLATE utf8mb4_unicode_ci DEFAULT '*',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `filterable` int(11) NOT NULL DEFAULT '0',
  `filter_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `searchable` int(11) NOT NULL DEFAULT '0',
  `visibility` int(11) NOT NULL DEFAULT '0',
  `separate_column` int(11) NOT NULL DEFAULT '0',
  `required` smallint(6) NOT NULL DEFAULT '0',
  `sortable` smallint(6) NOT NULL DEFAULT '0',
  `comparable` smallint(6) NOT NULL DEFAULT '0',
  `cart_variant` smallint(6) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_filterable` (`filterable`),
  KEY `idx_searchable` (`searchable`),
  KEY `idx_separate_column` (`separate_column`),
  KEY `idx_type` (`type`),
  KEY `idx_group_id` (`group_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_extra_fields_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_extra_fields_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) NOT NULL,
  `value` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_field_id` (`field_id`),
  KEY `idx_value` (`value`),
  KEY `idx_ordering` (`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_extra_fields_values_date` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` date NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_field` (`item_id`,`field_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_extra_fields_values_int` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_item_field` (`item_id`,`field_id`),
  KEY `idx_value` (`value`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_extra_fields_values_text` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_item_field` (`item_id`,`field_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_groups` (
  `item_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  PRIMARY KEY (`group_id`,`item_id`),
  UNIQUE KEY `item_group` (`item_id`,`group_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_price_tiers` (
  `item_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT '0',
  `price` decimal(14,4) NOT NULL DEFAULT '0.0000',
  UNIQUE KEY `idx_item_quantity` (`item_id`,`quantity`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_items_related` (
  `item_id` int(11) NOT NULL,
  `related_item` int(11) NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `params` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`related_item`,`item_id`),
  UNIQUE KEY `item_related` (`item_id`,`related_item`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_items_related_accessories` (
  `item_id` int(11) NOT NULL,
  `related_item` int(11) NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `params` mediumtext COLLATE utf8mb4_unicode_ci
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_item_rating` (
  `item_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`item_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_item_reviews` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `review` mediumtext DEFAULT NULL,
  `rating` int(11) NOT NULL,
  `author` varchar(255) DEFAULT NULL,
  `ip` varchar(50) DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `language` char(7) DEFAULT '*',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `#__djc2_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'label',
  `params` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_labels_items` (
  `item_id` int(11) NOT NULL,
  `label_id` int(11) NOT NULL,
  PRIMARY KEY (`item_id`,`label_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_messages` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_from` int(10) NOT NULL DEFAULT '0',
  `sender_name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sender_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_to` int(10) NOT NULL DEFAULT '0',
  `recipient_name` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `recipient_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` mediumtext COLLATE utf8mb4_unicode_ci,
  `sent_time` datetime DEFAULT NULL,
  `additional_data` mediumtext COLLATE utf8mb4_unicode_ci,
  `attachments` mediumtext COLLATE utf8mb4_unicode_ci,
  `is_opened` tinyint(4) NOT NULL DEFAULT '0',
  `template_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_from_to` (`user_from`,`user_to`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_message_templates` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `subject` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` mediumtext COLLATE utf8mb4_unicode_ci,
  `attachments` mediumtext COLLATE utf8mb4_unicode_ci,
  `created` datetime DEFAULT NULL,
  `created_by` int(10) NOT NULL DEFAULT '0',
  `checked_out` int(10) NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_type` (`type`)
) AUTO_INCREMENT=1000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `recurring` tinyint(4) NOT NULL DEFAULT '0',
  `recurring_params` text,
  `payment_params` mediumtext,
  `delivery_params` mediumtext,
  `order_number` int(11) NOT NULL DEFAULT '0',
  `invoice_counter` int(11) NOT NULL DEFAULT '0',
  `invoice_number` varchar(64) DEFAULT NULL,
  `proforma_counter` int(11) NOT NULL DEFAULT '0',
  `proforma_number` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `token` varchar(32) DEFAULT NULL,
  `salesman_id` int(11) NOT NULL DEFAULT '0',
  `created_date` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `invoice_date` datetime DEFAULT NULL,
  `service_date` datetime DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `total` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `grand_total` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `tax` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `coupon_id` int(11) DEFAULT '0',
  `coupon_code` varchar(31) DEFAULT NULL,
  `coupon_type` enum('percent','amount','other') DEFAULT 'percent',
  `coupon_value` decimal(14,4) DEFAULT '0.0000',
  `payment_method` varchar(255) DEFAULT NULL,
  `payment_method_id` int(11) NOT NULL DEFAULT '0',
  `payment_price` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `payment_tax` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `payment_tax_rate` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `payment_total` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `delivery_method` varchar(255) DEFAULT NULL,
  `delivery_method_id` int(11) NOT NULL DEFAULT '0',
  `delivery_shipping_days` int(11) NOT NULL DEFAULT '1',
  `delivery_price` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `delivery_tax` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `delivery_tax_rate` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `delivery_total` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `currency` varchar(20) DEFAULT NULL,
  `status` char(1) NOT NULL DEFAULT 'N',
  `email` varchar(255) DEFAULT NULL,
  `firstname` varchar(100) DEFAULT NULL,
  `lastname` varchar(100) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `position` varchar(100) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `state` varchar(100) DEFAULT NULL,
  `state_id` int(11) DEFAULT '0',
  `phone` varchar(20) DEFAULT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `www` varchar(255) DEFAULT NULL,
  `vat_id` varchar(20) DEFAULT NULL,
  `delivery_to_billing` tinyint(4) NOT NULL DEFAULT '0',
  `delivery_firstname` varchar(100) DEFAULT NULL,
  `delivery_lastname` varchar(100) DEFAULT NULL,
  `delivery_company` varchar(100) DEFAULT NULL,
  `delivery_address` varchar(100) DEFAULT NULL,
  `delivery_city` varchar(100) DEFAULT NULL,
  `delivery_postcode` varchar(100) DEFAULT NULL,
  `delivery_country` varchar(100) DEFAULT NULL,
  `delivery_country_id` int(11) NOT NULL DEFAULT '0',
  `delivery_state` varchar(100) DEFAULT NULL,
  `delivery_state_id` int(11) DEFAULT '0',
  `delivery_phone` varchar(20) DEFAULT NULL,
  `customer_note` mediumtext,
  `gdpr_agreement` tinyint(4) NOT NULL DEFAULT '0',
  `gdpr_policy` tinyint(4) NOT NULL DEFAULT '0',
  `additional_user_data` mediumtext,
  `want_invoice` tinyint(4) NOT NULL DEFAULT '0',
  `paynotify_cnt` int(11) NOT NULL DEFAULT '0',
  `ratingnotify_cnt` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_country_id` (`country_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_orders_recurring` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `start` datetime NOT NULL,
  `executed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_order_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `order_id` int(11) NOT NULL,
  `item_id` int(11) DEFAULT '0',
  `combination_id` int(11) NOT NULL DEFAULT '0',
  `sku` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_day` int(11) NOT NULL DEFAULT '1',
  `quantity` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `unit` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `base_cost` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `tax` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `tax_rate` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `total` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `additional_info` text COLLATE utf8mb4_unicode_ci,
  `combination_info` mediumtext COLLATE utf8mb4_unicode_ci,
  `features_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order_id`),
  KEY `idx_item_id` (`item_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_order_statuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `status_code` char(1) NOT NULL,
  `message_template` varchar(100) DEFAULT NULL,
  `is_core` tinyint(4) NOT NULL DEFAULT '0',
  `description` mediumtext,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_payments_currencies` (
  `payment_id` int(11) NOT NULL,
  `currency_id` int(11) NOT NULL,
  PRIMARY KEY (`payment_id`,`currency_id`),
  UNIQUE KEY `gauge_delivery` (`currency_id`,`payment_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_payment_methods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` mediumtext COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `published` tinyint(4) NOT NULL DEFAULT '0',
  `plugin` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(14,4) DEFAULT NULL,
  `additional_fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tax_rule_id` int(11) NOT NULL DEFAULT '0',
  `free_amount` decimal(14,4) DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  `access` int(11) NOT NULL DEFAULT '0',
  `note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `countries` mediumtext COLLATE utf8mb4_unicode_ci,
  `postcodes` text COLLATE utf8mb4_unicode_ci,
  `recurring` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_plugin` (`plugin`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `price` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `available` int(11) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_group` (`item_id`,`group_id`),
  UNIQUE KEY `group_item` (`group_id`,`item_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_price_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation` enum('add','sub') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sub',
  `type` enum('percent','amount') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'percent',
  `value` decimal(14,4) UNSIGNED DEFAULT '0.0000',
  `calc_type` ENUM('grand_total','total_items','each_item','delivery','payment','min_price','buy_x_discount','after_delivery_payment') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'grand_total',
  `change_old_price` tinyint(4) NOT NULL DEFAULT '1',
  `start_date` datetime DEFAULT NULL,
  `expire_date` datetime DEFAULT NULL,
  `product_id` text COLLATE utf8mb4_unicode_ci,
  `category_id` text COLLATE utf8mb4_unicode_ci,
  `producer_id` text COLLATE utf8mb4_unicode_ci,
  `excluded_product_id` text COLLATE utf8mb4_unicode_ci,
  `extra_fields` text COLLATE utf8mb4_unicode_ci,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `deliveries` text COLLATE utf8mb4_unicode_ci,
  `payments` text COLLATE utf8mb4_unicode_ci,
  `customer_groups` mediumtext COLLATE utf8mb4_unicode_ci,
  `postcodes` text COLLATE utf8mb4_unicode_ci,
  `countries` mediumtext COLLATE utf8mb4_unicode_ci,
  `min_orders` int(11) NOT NULL DEFAULT '0',
  `max_orders` int(11) NOT NULL DEFAULT '-1',
  `min_price` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `buy_x_count` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_price_rules_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `price_rule_id` int(11) NOT NULL,
  `label_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_price_rule_label` (`price_rule_id`,`label_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_producers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `metatitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci,
  `published` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci DEFAULT '*',
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_ordering` (`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `imagelabel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `published` int(11) NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci DEFAULT '*',
  `visibility` int(11) NOT NULL DEFAULT '0',
  `required` smallint(6) NOT NULL DEFAULT '0',
  `filterable` int(11) NOT NULL DEFAULT '0',
  `filter_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `searchable` int(11) NOT NULL DEFAULT '0',
  `sortable` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_filterable` (`filterable`),
  KEY `idx_searchable` (`searchable`),
  KEY `idx_sortable` (`sortable`),
  KEY `idx_type` (`type`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) NOT NULL,
  `value` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_field_id` (`field_id`),
  KEY `idx_value` (`value`),
  KEY `idx_ordering` (`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields_values_date` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` date NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_field` (`item_id`,`field_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields_values_int` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_item_field` (`item_id`,`field_id`),
  KEY `idx_value` (`value`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_producers_extra_fields_values_text` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_item_field` (`item_id`,`field_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_producer_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `metatitle` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci,
  `heading` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` int(11) NOT NULL DEFAULT '1',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci DEFAULT '*',
  `params` text COLLATE utf8mb4_unicode_ci,
  `checked_out` int(11) NOT NULL DEFAULT '0',
  `checked_out_time` datetime DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_parent_id` (`parent_id`),
  KEY `idx_published` (`published`),
  KEY `idx_access` (`access`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_ordering` (`ordering`),
  KEY `idx_published_parent_ordering` (`published`,`parent_id`,`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_quotes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `token` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salesman_id` int(11) NOT NULL DEFAULT '0',
  `created_date` datetime DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `grand_total` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'N',
  `firstname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` int(11) DEFAULT '0',
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `www` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vat_id` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_note` mediumtext COLLATE utf8mb4_unicode_ci,
  `gdpr_agreement` tinyint(4) NOT NULL DEFAULT '0',
  `gdpr_policy` tinyint(4) NOT NULL DEFAULT '0',
  `additional_user_data` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_country_id` (`country_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_quote_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'item',
  `quote_id` int(11) NOT NULL,
  `item_id` int(11) DEFAULT '0',
  `combination_id` int(11) NOT NULL DEFAULT '0',
  `sku` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `item_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `unit` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `total` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `additional_info` text COLLATE utf8mb4_unicode_ci,
  `combination_info` mediumtext COLLATE utf8mb4_unicode_ci,
  `features_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_quote_id` (`quote_id`),
  KEY `idx_item_id` (`item_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_resmushit` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `md5` varchar(50) NOT NULL,
  `path` varchar(255) NOT NULL,
  `original_size` int(8) UNSIGNED NOT NULL DEFAULT '0',
  `size` int(8) UNSIGNED NOT NULL DEFAULT '0',
  `percent` double(4,2) NOT NULL DEFAULT '0.00',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5` (`md5`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_stocknotify` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `item_type` varchar(50) NOT NULL,
  `email` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS `#__djc2_subscriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `order_id` int(11) NOT NULL DEFAULT '0',
  `status` tinyint(2) NOT NULL DEFAULT '1',
  `expiry_notified` tinyint(2) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `expire_date` datetime DEFAULT NULL,
  `extended` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `extend_date` datetime DEFAULT NULL,
  `granted_usergroup` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `granted_usergroups` text,
  `modified` datetime DEFAULT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`,`status`),
  KEY `idx_status` (`status`),
  KEY `idx_expire` (`expire_date`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_tax_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `value` decimal(14,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_tax_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_rate_id` int(11) NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `client_type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'A',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tax_rate_id` (`tax_rate_id`,`country_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `created` datetime DEFAULT NULL,
  `paid` tinyint(4) NOT NULL DEFAULT '0',
  `total` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_order_id` (`order_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `unit` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `unit_type` enum('length','weight','capacity','other') COLLATE utf8mb4_unicode_ci DEFAULT 'other',
  `is_default` tinyint(4) NOT NULL DEFAULT '0',
  `is_int` tinyint(4) NOT NULL DEFAULT '1',
  `min_quantity` decimal(10,4) NOT NULL DEFAULT '1.0000',
  `max_quantity` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `step` decimal(10,4) NOT NULL DEFAULT '1.0000',
  `show_box` tinyint(4) NOT NULL DEFAULT '1',
  `show_unit` tinyint(4) NOT NULL DEFAULT '1',
  `show_buttons` tinyint(4) NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_usercarts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL  DEFAULT '0',
  `items` text NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `email_sent` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `customer_group_id` int(11) NOT NULL DEFAULT '0',
  `client_type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'A',
  `firstname` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `state_id` int(11) NOT NULL DEFAULT '0',
  `vat_id` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `www` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_note` text COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gdpr_agreement` tinyint(4) NOT NULL DEFAULT '0',
  `gdpr_policy` tinyint(4) NOT NULL DEFAULT '0',
  `modified` datetime DEFAULT NULL,
  `tos` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_user_id` (`user_id`),
  KEY `idx_customer_group_id` (`customer_group_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_users_extra_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `is_core` tinyint(4) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` text COLLATE utf8mb4_unicode_ci,
  `description` text COLLATE utf8mb4_unicode_ci,
  `placeholder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attributes` text COLLATE utf8mb4_unicode_ci,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_type` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'A',
  `imagelabel` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `target_fieldset` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'djcatalog2profile',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `in_register` tinyint(4) NOT NULL DEFAULT '0',
  `in_profile` tinyint(4) NOT NULL DEFAULT '1',
  `in_checkout` tinyint(4) NOT NULL DEFAULT '1',
  `in_query` tinyint(4) NOT NULL DEFAULT '1',
  `in_delivery` tinyint(4) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`)
) AUTO_INCREMENT=1000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_users_extra_fields_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_id` int(11) NOT NULL,
  `value` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `idx_field_id` (`field_id`),
  KEY `idx_value` (`value`),
  KEY `idx_ordering` (`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_users_extra_fields_values_date` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` date NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `item_field` (`item_id`,`field_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_users_extra_fields_values_int` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_item_field` (`item_id`,`field_id`),
  KEY `idx_value` (`value`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_users_extra_fields_values_text` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_item_field` (`item_id`,`field_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_vat_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `country_id` int(11) NOT NULL DEFAULT '0',
  `state_id` int(11) NOT NULL DEFAULT '0',
  `client_type` char(1) NOT NULL DEFAULT 'A',
  `value` decimal(14,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  KEY `idx_country_client` (`country_id`,`client_type`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_vat_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `value` decimal(14,4) NOT NULL DEFAULT '0.0000',
  `ordering` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_vat_rules_xref` (
  `rule_id` int(11) NOT NULL,
  `rate_id` int(11) NOT NULL,
  UNIQUE KEY `idx_rule_rate` (`rule_id`,`rate_id`)
) DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `#__djc2_vendors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_vendors_customers` (
  `vendor_id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  UNIQUE KEY `idx_vendor_customer` (`vendor_id`,`customer_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_videos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` enum('local','remote') COLLATE utf8mb4_unicode_ci NOT NULL,
  `fullname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fullpath` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `caption` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cover_fullpath` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_type_item` (`type`,`item_id`),
  KEY `idx_item_type` (`item_id`,`type`),
  KEY `idx_item_type_ordering` (`item_id`,`type`,`ordering`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_wishes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL,
  `created` datetime DEFAULT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

INSERT INTO `#__djc2_units` (`id`, `name`, `unit`, `unit_type`, `is_default`, `is_int`, `min_quantity`, `max_quantity`, `step`, `show_box`, `show_unit`, `show_buttons`, `ordering`) VALUES
(1, 'Piece', 'pc', 'other', 1, 1, '1.0000', '0.0000', '1.0000', 1, 0, 1, 1),
(2, 'Kilogram', 'kg', 'weight', 0, 0, '0.2500', '5.0000', '0.2500', 1, 1, 1, 2),
(3, 'Litre', 'l', 'capacity', 0, 0, '0.1000', '0.0000', '0.1000', 1, 1, 1, 3),
(4, 'Meter', 'm', 'length', 0, 0, '0.1000', '0.0000', '0.1000', 1, 1, 1, 4);

INSERT INTO `#__djc2_order_statuses` (`id`, `name`, `status_code`, `is_core`, `description`) VALUES
(1, 'New', 'N', 1, ''),
(2, 'Accepted by customer', 'A', 1, ''),
(3, 'Paid', 'P', 1, ''),
(4, 'Confirmed', 'C', 1, ''),
(5, 'Rejected', 'R', 1, ''),
(6, 'Cancelled by customer', 'W', 1, ''),
(7, 'Completed/Delivered', 'F', 1, '');

INSERT IGNORE INTO `#__djc2_countries` (`id`, `country_name`, `country_3_code`, `country_2_code`, `published`, `is_eu`, `is_default`) VALUES
(1, 'Afghanistan', 'AFG', 'AF', 1, 0, 0),
(2, 'Albania', 'ALB', 'AL', 1, 0, 0),
(3, 'Algeria', 'DZA', 'DZ', 1, 0, 0),
(4, 'American Samoa', 'ASM', 'AS', 1, 0, 0),
(5, 'Andorra', 'AND', 'AD', 1, 0, 0),
(6, 'Angola', 'AGO', 'AO', 1, 0, 0),
(7, 'Anguilla', 'AIA', 'AI', 1, 0, 0),
(8, 'Antarctica', 'ATA', 'AQ', 1, 0, 0),
(9, 'Antigua and Barbuda', 'ATG', 'AG', 1, 0, 0),
(10, 'Argentina', 'ARG', 'AR', 1, 0, 0),
(11, 'Armenia', 'ARM', 'AM', 1, 0, 0),
(12, 'Aruba', 'ABW', 'AW', 1, 0, 0),
(13, 'Australia', 'AUS', 'AU', 1, 0, 0),
(14, 'Austria', 'AUT', 'AT', 1, 1, 0),
(15, 'Azerbaijan', 'AZE', 'AZ', 1, 0, 0),
(16, 'Bahamas', 'BHS', 'BS', 1, 0, 0),
(17, 'Bahrain', 'BHR', 'BH', 1, 0, 0),
(18, 'Bangladesh', 'BGD', 'BD', 1, 0, 0),
(19, 'Barbados', 'BRB', 'BB', 1, 0, 0),
(20, 'Belarus', 'BLR', 'BY', 1, 0, 0),
(21, 'Belgium', 'BEL', 'BE', 1, 1, 0),
(22, 'Belize', 'BLZ', 'BZ', 1, 0, 0),
(23, 'Benin', 'BEN', 'BJ', 1, 0, 0),
(24, 'Bermuda', 'BMU', 'BM', 1, 0, 0),
(25, 'Bhutan', 'BTN', 'BT', 1, 0, 0),
(26, 'Bolivia', 'BOL', 'BO', 1, 0, 0),
(27, 'Bosnia and Herzegowina', 'BIH', 'BA', 1, 0, 0),
(28, 'Botswana', 'BWA', 'BW', 1, 0, 0),
(29, 'Bouvet Island', 'BVT', 'BV', 1, 0, 0),
(30, 'Brazil', 'BRA', 'BR', 1, 0, 0),
(31, 'British Indian Ocean Territory', 'IOT', 'IO', 1, 0, 0),
(32, 'Brunei Darussalam', 'BRN', 'BN', 1, 0, 0),
(33, 'Bulgaria', 'BGR', 'BG', 1, 1, 0),
(34, 'Burkina Faso', 'BFA', 'BF', 1, 0, 0),
(35, 'Burundi', 'BDI', 'BI', 1, 0, 0),
(36, 'Cambodia', 'KHM', 'KH', 1, 0, 0),
(37, 'Cameroon', 'CMR', 'CM', 1, 0, 0),
(38, 'Canada', 'CAN', 'CA', 1, 0, 0),
(39, 'Cape Verde', 'CPV', 'CV', 1, 0, 0),
(40, 'Cayman Islands', 'CYM', 'KY', 1, 0, 0),
(41, 'Central African Republic', 'CAF', 'CF', 1, 0, 0),
(42, 'Chad', 'TCD', 'TD', 1, 0, 0),
(43, 'Chile', 'CHL', 'CL', 1, 0, 0),
(44, 'China', 'CHN', 'CN', 1, 0, 0),
(45, 'Christmas Island', 'CXR', 'CX', 1, 0, 0),
(46, 'Cocos (Keeling) Islands', 'CCK', 'CC', 1, 0, 0),
(47, 'Colombia', 'COL', 'CO', 1, 0, 0),
(48, 'Comoros', 'COM', 'KM', 1, 0, 0),
(49, 'Congo', 'COG', 'CG', 1, 0, 0),
(50, 'Cook Islands', 'COK', 'CK', 1, 0, 0),
(51, 'Costa Rica', 'CRI', 'CR', 1, 0, 0),
(52, 'Cote D''Ivoire', 'CIV', 'CI', 1, 0, 0),
(53, 'Croatia', 'HRV', 'HR', 1, 0, 0),
(54, 'Cuba', 'CUB', 'CU', 1, 0, 0),
(55, 'Cyprus', 'CYP', 'CY', 1, 1, 0),
(56, 'Czech Republic', 'CZE', 'CZ', 1, 1, 0),
(57, 'Denmark', 'DNK', 'DK', 1, 1, 0),
(58, 'Djibouti', 'DJI', 'DJ', 1, 0, 0),
(59, 'Dominica', 'DMA', 'DM', 1, 0, 0),
(60, 'Dominican Republic', 'DOM', 'DO', 1, 0, 0),
(61, 'East Timor', 'TMP', 'TL', 1, 0, 0),
(62, 'Ecuador', 'ECU', 'EC', 1, 0, 0),
(63, 'Egypt', 'EGY', 'EG', 1, 0, 0),
(64, 'El Salvador', 'SLV', 'SV', 1, 0, 0),
(65, 'Equatorial Guinea', 'GNQ', 'GQ', 1, 0, 0),
(66, 'Eritrea', 'ERI', 'ER', 1, 0, 0),
(67, 'Estonia', 'EST', 'EE', 1, 1, 0),
(68, 'Ethiopia', 'ETH', 'ET', 1, 0, 0),
(69, 'Falkland Islands (Malvinas)', 'FLK', 'FK', 1, 0, 0),
(70, 'Faroe Islands', 'FRO', 'FO', 1, 0, 0),
(71, 'Fiji', 'FJI', 'FJ', 1, 0, 0),
(72, 'Finland', 'FIN', 'FI', 1, 1, 0),
(73, 'France', 'FRA', 'FR', 1, 1, 0),
(75, 'French Guiana', 'GUF', 'GF', 1, 0, 0),
(76, 'French Polynesia', 'PYF', 'PF', 1, 0, 0),
(77, 'French Southern Territories', 'ATF', 'TF', 1, 0, 0),
(78, 'Gabon', 'GAB', 'GA', 1, 0, 0),
(79, 'Gambia', 'GMB', 'GM', 1, 0, 0),
(80, 'Georgia', 'GEO', 'GE', 1, 0, 0),
(81, 'Germany', 'DEU', 'DE', 1, 1, 0),
(82, 'Ghana', 'GHA', 'GH', 1, 0, 0),
(83, 'Gibraltar', 'GIB', 'GI', 1, 0, 0),
(84, 'Greece', 'GRC', 'GR', 1, 1, 0),
(85, 'Greenland', 'GRL', 'GL', 1, 0, 0),
(86, 'Grenada', 'GRD', 'GD', 1, 0, 0),
(87, 'Guadeloupe', 'GLP', 'GP', 1, 0, 0),
(88, 'Guam', 'GUM', 'GU', 1, 0, 0),
(89, 'Guatemala', 'GTM', 'GT', 1, 0, 0),
(90, 'Guinea', 'GIN', 'GN', 1, 0, 0),
(91, 'Guinea-bissau', 'GNB', 'GW', 1, 0, 0),
(92, 'Guyana', 'GUY', 'GY', 1, 0, 0),
(93, 'Haiti', 'HTI', 'HT', 1, 0, 0),
(94, 'Heard and Mc Donald Islands', 'HMD', 'HM', 1, 0, 0),
(95, 'Honduras', 'HND', 'HN', 1, 0, 0),
(96, 'Hong Kong', 'HKG', 'HK', 1, 0, 0),
(97, 'Hungary', 'HUN', 'HU', 1, 1, 0),
(98, 'Iceland', 'ISL', 'IS', 1, 0, 0),
(99, 'India', 'IND', 'IN', 1, 0, 0),
(100, 'Indonesia', 'IDN', 'ID', 1, 0, 0),
(101, 'Iran (Islamic Republic of)', 'IRN', 'IR', 1, 0, 0),
(102, 'Iraq', 'IRQ', 'IQ', 1, 0, 0),
(103, 'Ireland', 'IRL', 'IE', 1, 1, 0),
(104, 'Israel', 'ISR', 'IL', 1, 0, 0),
(105, 'Italy', 'ITA', 'IT', 1, 1, 0),
(106, 'Jamaica', 'JAM', 'JM', 1, 0, 0),
(107, 'Japan', 'JPN', 'JP', 1, 0, 0),
(108, 'Jordan', 'JOR', 'JO', 1, 0, 0),
(109, 'Kazakhstan', 'KAZ', 'KZ', 1, 0, 0),
(110, 'Kenya', 'KEN', 'KE', 1, 0, 0),
(111, 'Kiribati', 'KIR', 'KI', 1, 0, 0),
(112, 'Korea, Democratic People''s Republic of', 'PRK', 'KP', 1, 0, 0),
(113, 'Korea, Republic of', 'KOR', 'KR', 1, 0, 0),
(114, 'Kuwait', 'KWT', 'KW', 1, 0, 0),
(115, 'Kyrgyzstan', 'KGZ', 'KG', 1, 0, 0),
(116, 'Lao People''s Democratic Republic', 'LAO', 'LA', 1, 0, 0),
(117, 'Latvia', 'LVA', 'LV', 1, 1, 0),
(118, 'Lebanon', 'LBN', 'LB', 1, 0, 0),
(119, 'Lesotho', 'LSO', 'LS', 1, 0, 0),
(120, 'Liberia', 'LBR', 'LR', 1, 0, 0),
(121, 'Libya', 'LBY', 'LY', 1, 0, 0),
(122, 'Liechtenstein', 'LIE', 'LI', 1, 0, 0),
(123, 'Lithuania', 'LTU', 'LT', 1, 1, 0),
(124, 'Luxembourg', 'LUX', 'LU', 1, 1, 0),
(125, 'Macau', 'MAC', 'MO', 1, 0, 0),
(126, 'Macedonia, The Former Yugoslav Republic of', 'MKD', 'MK', 1, 0, 0),
(127, 'Madagascar', 'MDG', 'MG', 1, 0, 0),
(128, 'Malawi', 'MWI', 'MW', 1, 0, 0),
(129, 'Malaysia', 'MYS', 'MY', 1, 0, 0),
(130, 'Maldives', 'MDV', 'MV', 1, 0, 0),
(131, 'Mali', 'MLI', 'ML', 1, 0, 0),
(132, 'Malta', 'MLT', 'MT', 1, 1, 0),
(133, 'Marshall Islands', 'MHL', 'MH', 1, 0, 0),
(134, 'Martinique', 'MTQ', 'MQ', 1, 0, 0),
(135, 'Mauritania', 'MRT', 'MR', 1, 0, 0),
(136, 'Mauritius', 'MUS', 'MU', 1, 0, 0),
(137, 'Mayotte', 'MYT', 'YT', 1, 0, 0),
(138, 'Mexico', 'MEX', 'MX', 1, 0, 0),
(139, 'Micronesia, Federated States of', 'FSM', 'FM', 1, 0, 0),
(140, 'Moldova, Republic of', 'MDA', 'MD', 1, 0, 0),
(141, 'Monaco', 'MCO', 'MC', 1, 0, 0),
(142, 'Mongolia', 'MNG', 'MN', 1, 0, 0),
(143, 'Montserrat', 'MSR', 'MS', 1, 0, 0),
(144, 'Morocco', 'MAR', 'MA', 1, 0, 0),
(145, 'Mozambique', 'MOZ', 'MZ', 1, 0, 0),
(146, 'Myanmar', 'MMR', 'MM', 1, 0, 0),
(147, 'Namibia', 'NAM', 'NA', 1, 0, 0),
(148, 'Nauru', 'NRU', 'NR', 1, 0, 0),
(149, 'Nepal', 'NPL', 'NP', 1, 0, 0),
(150, 'Netherlands', 'NLD', 'NL', 1, 1, 0),
(151, 'Netherlands Antilles', 'ANT', 'AN', 1, 0, 0),
(152, 'New Caledonia', 'NCL', 'NC', 1, 0, 0),
(153, 'New Zealand', 'NZL', 'NZ', 1, 0, 0),
(154, 'Nicaragua', 'NIC', 'NI', 1, 0, 0),
(155, 'Niger', 'NER', 'NE', 1, 0, 0),
(156, 'Nigeria', 'NGA', 'NG', 1, 0, 0),
(157, 'Niue', 'NIU', 'NU', 1, 0, 0),
(158, 'Norfolk Island', 'NFK', 'NF', 1, 0, 0),
(159, 'Northern Mariana Islands', 'MNP', 'MP', 1, 0, 0),
(160, 'Norway', 'NOR', 'NO', 1, 0, 0),
(161, 'Oman', 'OMN', 'OM', 1, 0, 0),
(162, 'Pakistan', 'PAK', 'PK', 1, 0, 0),
(163, 'Palau', 'PLW', 'PW', 1, 0, 0),
(164, 'Panama', 'PAN', 'PA', 1, 0, 0),
(165, 'Papua New Guinea', 'PNG', 'PG', 1, 0, 0),
(166, 'Paraguay', 'PRY', 'PY', 1, 0, 0),
(167, 'Peru', 'PER', 'PE', 1, 0, 0),
(168, 'Philippines', 'PHL', 'PH', 1, 0, 0),
(169, 'Pitcairn', 'PCN', 'PN', 1, 0, 0),
(170, 'Poland', 'POL', 'PL', 1, 1, 0),
(171, 'Portugal', 'PRT', 'PT', 1, 1, 0),
(172, 'Puerto Rico', 'PRI', 'PR', 1, 0, 0),
(173, 'Qatar', 'QAT', 'QA', 1, 0, 0),
(174, 'Reunion', 'REU', 'RE', 1, 0, 0),
(175, 'Romania', 'ROM', 'RO', 1, 1, 0),
(176, 'Russian Federation', 'RUS', 'RU', 1, 0, 0),
(177, 'Rwanda', 'RWA', 'RW', 1, 0, 0),
(178, 'Saint Kitts and Nevis', 'KNA', 'KN', 1, 0, 0),
(179, 'Saint Lucia', 'LCA', 'LC', 1, 0, 0),
(180, 'Saint Vincent and the Grenadines', 'VCT', 'VC', 1, 0, 0),
(181, 'Samoa', 'WSM', 'WS', 1, 0, 0),
(182, 'San Marino', 'SMR', 'SM', 1, 0, 0),
(183, 'Sao Tome and Principe', 'STP', 'ST', 1, 0, 0),
(184, 'Saudi Arabia', 'SAU', 'SA', 1, 0, 0),
(185, 'Senegal', 'SEN', 'SN', 1, 0, 0),
(186, 'Seychelles', 'SYC', 'SC', 1, 0, 0),
(187, 'Sierra Leone', 'SLE', 'SL', 1, 0, 0),
(188, 'Singapore', 'SGP', 'SG', 1, 0, 0),
(189, 'Slovakia', 'SVK', 'SK', 1, 1, 0),
(190, 'Slovenia', 'SVN', 'SI', 1, 1, 0),
(191, 'Solomon Islands', 'SLB', 'SB', 1, 0, 0),
(192, 'Somalia', 'SOM', 'SO', 1, 0, 0),
(193, 'South Africa', 'ZAF', 'ZA', 1, 0, 0),
(194, 'South Georgia and the South Sandwich Islands', 'SGS', 'GS', 1, 0, 0),
(195, 'Spain', 'ESP', 'ES', 1, 1, 0),
(196, 'Sri Lanka', 'LKA', 'LK', 1, 0, 0),
(197, 'St. Helena', 'SHN', 'SH', 1, 0, 0),
(198, 'St. Pierre and Miquelon', 'SPM', 'PM', 1, 0, 0),
(199, 'Sudan', 'SDN', 'SD', 1, 0, 0),
(200, 'Suriname', 'SUR', 'SR', 1, 0, 0),
(201, 'Svalbard and Jan Mayen Islands', 'SJM', 'SJ', 1, 0, 0),
(202, 'Swaziland', 'SWZ', 'SZ', 1, 0, 0),
(203, 'Sweden', 'SWE', 'SE', 1, 1, 0),
(204, 'Switzerland', 'CHE', 'CH', 1, 0, 0),
(205, 'Syrian Arab Republic', 'SYR', 'SY', 1, 0, 0),
(206, 'Taiwan', 'TWN', 'TW', 1, 0, 0),
(207, 'Tajikistan', 'TJK', 'TJ', 1, 0, 0),
(208, 'Tanzania, United Republic of', 'TZA', 'TZ', 1, 0, 0),
(209, 'Thailand', 'THA', 'TH', 1, 0, 0),
(210, 'Togo', 'TGO', 'TG', 1, 0, 0),
(211, 'Tokelau', 'TKL', 'TK', 1, 0, 0),
(212, 'Tonga', 'TON', 'TO', 1, 0, 0),
(213, 'Trinidad and Tobago', 'TTO', 'TT', 1, 0, 0),
(214, 'Tunisia', 'TUN', 'TN', 1, 0, 0),
(215, 'Turkey', 'TUR', 'TR', 1, 0, 0),
(216, 'Turkmenistan', 'TKM', 'TM', 1, 0, 0),
(217, 'Turks and Caicos Islands', 'TCA', 'TC', 1, 0, 0),
(218, 'Tuvalu', 'TUV', 'TV', 1, 0, 0),
(219, 'Uganda', 'UGA', 'UG', 1, 0, 0),
(220, 'Ukraine', 'UKR', 'UA', 1, 0, 0),
(221, 'United Arab Emirates', 'ARE', 'AE', 1, 0, 0),
(222, 'United Kingdom', 'GBR', 'GB', 1, 0, 0),
(223, 'United States', 'USA', 'US', 1, 0, 0),
(224, 'United States Minor Outlying Islands', 'UMI', 'UM', 1, 0, 0),
(225, 'Uruguay', 'URY', 'UY', 1, 0, 0),
(226, 'Uzbekistan', 'UZB', 'UZ', 1, 0, 0),
(227, 'Vanuatu', 'VUT', 'VU', 1, 0, 0),
(228, 'Vatican City State (Holy See)', 'VAT', 'VA', 1, 0, 0),
(229, 'Venezuela', 'VEN', 'VE', 1, 0, 0),
(230, 'Viet Nam', 'VNM', 'VN', 1, 0, 0),
(231, 'Virgin Islands (British)', 'VGB', 'VG', 1, 0, 0),
(232, 'Virgin Islands (U.S.)', 'VIR', 'VI', 1, 0, 0),
(233, 'Wallis and Futuna Islands', 'WLF', 'WF', 1, 0, 0),
(234, 'Western Sahara', 'ESH', 'EH', 1, 0, 0),
(235, 'Yemen', 'YEM', 'YE', 1, 0, 0),
(237, 'The Democratic Republic of Congo', 'DRC', 'DC', 1, 0, 0),
(238, 'Zambia', 'ZMB', 'ZM', 1, 0, 0),
(239, 'Zimbabwe', 'ZWE', 'ZW', 1, 0, 0),
(240, 'East Timor', 'XET', 'XE', 1, 0, 0),
(241, 'Jersey', 'JEY', 'JE', 1, 0, 0),
(242, 'St. Barthelemy', 'XSB', 'XB', 1, 0, 0),
(243, 'St. Eustatius', 'XSE', 'XU', 1, 0, 0),
(244, 'Canary Islands', 'XCA', 'XC', 1, 0, 0),
(245, 'Serbia', 'SRB', 'RS', 1, 0, 0),
(246, 'Sint Maarten (French Antilles)', 'MAF', 'MF', 1, 0, 0),
(247, 'Sint Maarten (Netherlands Antilles)', 'SXM', 'SX', 1, 0, 0),
(248, 'Palestinian Territory, occupied', 'PSE', 'PS', 1, 0, 0),
(249, 'Montenegro', 'MNE', 'ME', 1, 0, 0),
(250, 'Caribbean Netherlands', 'BES', 'BQ', 1, 0, 0),
(251, 'Congo, Democratic Republic', 'COD', 'CD', 1, 0, 0),
(252, 'South Sudan', 'SSD', 'SS', 1, 0, 0);

CREATE TABLE IF NOT EXISTS `#__djc2_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `order_id` int(11) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `paid` tinyint(4) NOT NULL DEFAULT '0',
  `total` decimal(10,4) NOT NULL DEFAULT '0.0000',
  `description` mediumtext,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_order_id` (`order_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_price_rules_labels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `price_rule_id` int(11) NOT NULL DEFAULT '0',
  `label_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_price_rule_label` (`price_rule_id`,`label_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_deliveries_gauges` (
  `delivery_id` int(11) NOT NULL,
  `gauge_id` int(11) NOT NULL,
  PRIMARY KEY (`delivery_id`,`gauge_id`),
  UNIQUE KEY `gauge_delivery` (`gauge_id`,`delivery_id`)
) DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `#__djc2_gauges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `is_default` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8mb4;

INSERT INTO `#__djc2_message_templates` (`id`, `type`, `name`, `state`, `subject`, `body`, `attachments`, `created`, `created_by`, `checked_out`, `checked_out_time`, `params`) VALUES
(1, 'order', 'Order - customer notification', 1, 'We have received your order no. [[order_number]]', '<h1 style=\"text-align: center;\">Order no. [[order_number]]</h1>\r\n<p>Dear [[recipient_name]],</p>\r\n<p>Thank you for placing your order no [[order_number]]</p>\r\n<div>[[order_customer_data]]</div>\r\n<div>[[order_items]]</div>\r\n<p>Click <a href=\"[[order_link]]\">here</a> in order to check the order details on our website.</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(2, 'order_admin', 'Order - admin notification', 1, 'Customer placed the order no. [[order_number]]', '<h1 style=\"text-align: center;\">Order no. [[order_number]]</h1>\r\n<p>Hello, </p>\r\n<p>[[recipient_name]] has just placed a new order.</p>\r\n<div>[[order_customer_data]]</div>\r\n<div>[[order_items]]</div>\r\n<p>Click <a href=\"[[order_link]]\">here</a> in order to check the order details on the website.</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(3, 'order_status', 'Order status - customer notification', 1, 'The status of the order no. [[order_number]] has changed to [[order_status]]', '<p>Hi [[recipient_name]],</p>\r\n<p>The status of your order no. [[order_number]] has changed to [[order_status]].</p>\r\n<p>[[order_status_description]]</p>\r\n<p>Click <a href=\"[[order_link]]\">here</a> in order to check the order details on our website.</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(4, 'order_status_admin', 'Order status changed - admin notification', 1, 'The status of the order no. [[order_number]] has changed to [[order_status]]', '<p>Hi,</p>\r\n<p>The status of an order no. [[order_number]] made by [[recipient_name]] has changed to [[order_status]].</p>\r\n<p>[[order_status_description]]</p>\r\n<p>Click <a href=\"[[order_link]]\">here</a> in order to check the order details on the website.</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(5, 'query', 'Query - customer notification', 1, 'We have received your query', '<h1 style=\"text-align: center;\">Inquiry</h1>\r\n<p>Dear [[recipient_name]],</p>\r\n<p>Thank you for your inquiry.</p>\r\n<div>[[query_customer_data]]</div>\r\n<div>[[query_items]]</div>\r\n<p>Click <a href=\"[[order_link]]\">here</a> in order to check the order details on our website.</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(6, 'query_admin', 'Query admin - admin notification', 1, 'Customer sent an inquiry', '<h1 style=\"text-align: center;\">Inquiry</h1>\r\n<p>Hello, </p>\r\n<p>[[recipient_name]] has just placed a new order.</p>\r\n<div>[[query_customer_data]]</div>\r\n<div>[[query_items]]</div>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(7, 'subscription_new', 'New subscription - customer notification', 1, 'Subscription activation', '<p>Dear [[recipient_name]],</p>\r\n<p>Your subscription has been activated. Below you fill find necessary details regarading type of subscription(s) and their expiration date. Thank you.</p>\r\n<div>[[subscription_items]]</div>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(8, 'subscription_expire_soon', 'Expiring subscription - customer notification', 1, 'Your subscription will soon expire', '<p>Dear [[recipient_name]],<br /><br />Your \"[[subscription_item]]\" subscription is about to expire on [[expiration_date]].<br /><br />Should you have any questions, don\'t hesitate to contact us.</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(9, 'subscription_expired', 'Expired subscription - customer notification', 1, 'Your subscription has expired', '<p>Dear [[recipient_name]],<br /><br />Your \"[[subscription_item]]\" subscription has expired.<br /><br />Should you have any questions, don\'t hesitate to contact us.</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(10, 'stock_available', 'Stock Available', 1, 'Stock Available - [[product_name]]', '<p>Dear customer,</p>\r\n<p>We are happy to announce that a product ([[product_name]]) in which you were interested is in stock and available for purchase.</p>\r\n<p><a href=\"[[product_link]]\">Click here</a> to open product page.</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(11, 'stock_request', 'Stock Request - Admin notification', 1, 'Customer requested [[product_name]]', '<p>Hello,</p>\r\n<p>Customer [[customer_email]] in interested in a product that is not on stock: <a href=\"[[product_link]]\">[[product_name]]</a></p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(12, 'cart_abandoned', 'Abandoned Cart', 1, 'You forgot to complete your order', '<p>Hi,</p>\r\n<p>It seems that haven\'t completed your order. Following products are still in your cart:</p>\r\n<p>[[cart_items]]</p>\r\n<p>You can see the cart and complete your inquiry by <a href=\"[[cart_link]]\">clicking here</a>.</p>\r\n<p> </p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(13, 'order_rating', 'Rate purchased items', 1, 'We would love to get feedback from you', '<p>Hi [[recipient_name]],</p>\r\n<p>You have recently purchased some of the products available in our store and we would like you to rate them:</p>\r\n<p>[[order_items]]</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL),
(14, 'order_payment', 'Complete the payment', 1, 'Payment reminder - [[order_number]]', '<p>Hi [[recipient_name]],</p>\r\n<p>We would like to remind you that you still need to make the payment for order no. [[order_number]]</p>\r\n<p>In order to see the order details and complete the payment, <a href=\"[[order_link]]\">click here</a>.</p>', '[]', '0000-00-00 00:00:00', 0, 0, '0000-00-00 00:00:00', NULL);


INSERT IGNORE INTO `#__djc2_countries_states` (`id`, `country_id`, `name`, `state_code`, `published`) VALUES
(1, 6, 'Huíla', 'HUI', 1),
(2, 6, 'Lunda Norte', 'LNO', 1),
(3, 6, 'Lunda Sul', 'LSU', 1),
(4, 6, 'Luanda', 'LUA', 1),
(5, 6, 'Malange', 'MAL', 1),
(6, 6, 'Moxico', 'MOX', 1),
(7, 6, 'Namibe', 'NAM', 1),
(8, 6, 'Uíge', 'UIG', 1),
(9, 6, 'Zaire', 'ZAI', 1),
(10, 10, 'Salta', 'A', 1),
(11, 10, 'Buenos Aires', 'B', 1),
(12, 10, 'Ciudad Autónoma de Buenos Aires', 'C', 1),
(13, 10, 'San Luis', 'D', 1),
(14, 10, 'Entre Ríos', 'E', 1),
(15, 10, 'La Rioja', 'F', 1),
(16, 10, 'Santiago del Estero', 'G', 1),
(17, 10, 'Chaco', 'H', 1),
(18, 10, 'San Juan', 'J', 1),
(19, 10, 'Catamarca', 'K', 1),
(20, 10, 'La Pampa', 'L', 1),
(21, 10, 'Mendoza', 'M', 1),
(22, 10, 'Misiones', 'N', 1),
(23, 10, 'Formosa', 'P', 1),
(24, 10, 'Neuquén', 'Q', 1),
(25, 10, 'Río Negro', 'R', 1),
(26, 10, 'Santa Fe', 'S', 1),
(27, 10, 'Tucumán', 'T', 1),
(28, 10, 'Chubut', 'U', 1),
(29, 10, 'Tierra del Fuego', 'V', 1),
(30, 10, 'Corrientes', 'W', 1),
(31, 10, 'Córdoba', 'X', 1),
(32, 10, 'Jujuy', 'Y', 1),
(33, 10, 'Santa Cruz', 'Z', 1),
(34, 14, 'Burgenland', '1', 1),
(35, 14, 'Kärnten', '2', 1),
(36, 14, 'Niederösterreich', '3', 1),
(37, 14, 'Oberösterreich', '4', 1),
(38, 14, 'Salzburg', '5', 1),
(39, 14, 'Steiermark', '6', 1),
(40, 14, 'Tirol', '7', 1),
(41, 14, 'Vorarlberg', '8', 1),
(42, 14, 'Wien', '9', 1),
(43, 13, 'Australian Capital Territory', 'ACT', 1),
(44, 13, 'New South Wales', 'NSW', 1),
(45, 13, 'Northern Territory', 'NT', 1),
(46, 13, 'Queensland', 'QLD', 1),
(47, 13, 'South Australia', 'SA', 1),
(48, 13, 'Tasmania', 'TAS', 1),
(49, 13, 'Victoria', 'VIC', 1),
(50, 13, 'Western Australia', 'WA', 1),
(51, 15, 'Abseron', 'ABS', 1),
(52, 15, 'Agstafa', 'AGA', 1),
(53, 15, 'Agcab?di', 'AGC', 1),
(54, 15, 'Agdam', 'AGM', 1),
(55, 15, 'Agdas', 'AGS', 1),
(56, 15, 'Agsu', 'AGU', 1),
(57, 15, 'Astara', 'AST', 1),
(58, 15, 'Baki', 'BA', 1),
(59, 15, 'Bab?k', 'BAB', 1),
(60, 15, 'Balak?n', 'BAL', 1),
(61, 15, 'B?rd?', 'BAR', 1),
(62, 15, 'Beyl?qan', 'BEY', 1),
(63, 15, 'Bil?suvar', 'BIL', 1),
(64, 15, 'C?brayil', 'CAB', 1),
(65, 15, 'C?lilabad', 'CAL', 1),
(66, 15, 'Culfa', 'CUL', 1),
(67, 15, 'Dask?s?n', 'DAS', 1),
(68, 15, 'Füzuli', 'FUZ', 1),
(69, 15, 'G?nc?', 'GA', 1),
(70, 15, 'G?d?b?y', 'GAD', 1),
(71, 15, 'Goranboy', 'GOR', 1),
(72, 15, 'Göyçay', 'GOY', 1),
(73, 15, 'Göygöl', 'GYG', 1),
(74, 15, 'Haciqabul', 'HAC', 1),
(75, 15, 'Imisli', 'IMI', 1),
(76, 15, 'Ismayilli', 'ISM', 1),
(77, 15, 'K?lb?c?r', 'KAL', 1),
(78, 15, 'K?ng?rli', 'KAN', 1),
(79, 15, 'Kürd?mir', 'KUR', 1),
(80, 15, 'L?nk?ran', 'LA', 1),
(81, 15, 'Laçin', 'LAC', 1),
(82, 15, 'L?nk?ran', 'LAN', 1),
(83, 15, 'Lerik', 'LER', 1),
(84, 15, 'Masalli', 'MAS', 1),
(85, 15, 'Ming?çevir', 'MI', 1),
(86, 15, 'Naftalan', 'NA', 1),
(87, 15, 'Neftçala', 'NEF', 1),
(88, 15, 'Naxçivan', 'NV', 1),
(89, 15, 'Naxçivan', 'NX', 1),
(90, 15, 'Oguz', 'OGU', 1),
(91, 15, 'Ordubad', 'ORD', 1),
(92, 15, 'Q?b?l?', 'QAB', 1),
(93, 15, 'Qax', 'QAX', 1),
(94, 15, 'Qazax', 'QAZ', 1),
(95, 15, 'Quba', 'QBA', 1),
(96, 15, 'Qubadli', 'QBI', 1),
(97, 15, 'Qobustan', 'QOB', 1),
(98, 15, 'Qusar', 'QUS', 1),
(99, 15, 'S?ki', 'SA', 1),
(100, 15, 'Sabirabad', 'SAB', 1),
(101, 15, 'S?d?r?k', 'SAD', 1),
(102, 15, 'Sahbuz', 'SAH', 1),
(103, 15, 'S?ki', 'SAK', 1),
(104, 15, 'Salyan', 'SAL', 1),
(105, 15, 'S?rur', 'SAR', 1),
(106, 15, 'Saatli', 'SAT', 1),
(107, 15, 'Sabran', 'SBN', 1),
(108, 15, 'Siy?z?n', 'SIY', 1),
(109, 15, 'S?mkir', 'SKR', 1),
(110, 15, 'Sumqayit', 'SM', 1),
(111, 15, 'Samaxi', 'SMI', 1),
(112, 15, 'Samux', 'SMX', 1),
(113, 15, 'Sirvan', 'SR', 1),
(114, 15, 'Susa', 'SUS', 1),
(115, 15, 'T?rt?r', 'TAR', 1),
(116, 15, 'Tovuz', 'TOV', 1),
(117, 15, 'Ucar', 'UCA', 1),
(118, 15, 'Xank?ndi', 'XA', 1),
(119, 15, 'Xaçmaz', 'XAC', 1),
(120, 15, 'Xocali', 'XCI', 1),
(121, 15, 'Xizi', 'XIZ', 1),
(122, 15, 'Xocav?nd', 'XVD', 1),
(123, 15, 'Yardimli', 'YAR', 1),
(124, 15, 'Yevlax', 'YE', 1),
(125, 15, 'Yevlax', 'YEV', 1),
(126, 15, 'Z?ngilan', 'ZAN', 1),
(127, 15, 'Zaqatala', 'ZAQ', 1),
(128, 15, 'Z?rdab', 'ZAR', 1),
(129, 27, 'Federacija Bosne i Hercegovine', 'BIH', 1),
(130, 27, 'Brcko distrikt', 'BRC', 1),
(131, 27, 'Republika Srpska', 'SRP', 1),
(132, 19, 'Christ Church', '01', 1),
(133, 19, 'Saint Andrew', '02', 1),
(134, 19, 'Saint George', '03', 1),
(135, 19, 'Saint James', '04', 1),
(136, 19, 'Saint John', '05', 1),
(137, 19, 'Saint Joseph', '06', 1),
(138, 19, 'Saint Lucy', '07', 1),
(139, 19, 'Saint Michael', '08', 1),
(140, 19, 'Saint Peter', '09', 1),
(141, 19, 'Saint Philip', '10', 1),
(142, 19, 'Saint Thomas', '11', 1),
(143, 18, 'Bandarban', '01', 1),
(144, 18, 'Barguna', '02', 1),
(145, 18, 'Bogra', '03', 1),
(146, 18, 'Brahmanbaria', '04', 1),
(147, 18, 'Bagerhat', '05', 1),
(148, 18, 'Barisal', '06', 1),
(149, 18, 'Bhola', '07', 1),
(150, 18, 'Comilla', '08', 1),
(151, 18, 'Chandpur', '09', 1),
(152, 18, 'Chittagong', '10', 1),
(153, 18, 'Cox''s Bazar', '11', 1),
(154, 18, 'Chuadanga', '12', 1),
(155, 18, 'Dhaka', '13', 1),
(156, 18, 'Dinajpur', '14', 1),
(157, 18, 'Faridpur', '15', 1),
(158, 18, 'Feni', '16', 1),
(159, 18, 'Gopalganj', '17', 1),
(160, 18, 'Gazipur', '18', 1),
(161, 18, 'Gaibandha', '19', 1),
(162, 18, 'Habiganj', '20', 1),
(163, 18, 'Jamalpur', '21', 1),
(164, 18, 'Jessore', '22', 1),
(165, 18, 'Jhenaidah', '23', 1),
(166, 18, 'Jaipurhat', '24', 1),
(167, 18, 'Jhalakati', '25', 1),
(168, 18, 'Kishoreganj', '26', 1),
(169, 18, 'Khulna', '27', 1),
(170, 18, 'Kurigram', '28', 1),
(171, 18, 'Khagrachari', '29', 1),
(172, 18, 'Kushtia', '30', 1),
(173, 18, 'Lakshmipur', '31', 1),
(174, 18, 'Lalmonirhat', '32', 1),
(175, 18, 'Manikganj', '33', 1),
(176, 18, 'Mymensingh', '34', 1),
(177, 18, 'Munshiganj', '35', 1),
(178, 18, 'Madaripur', '36', 1),
(179, 5, 'Canillo', '02', 1),
(180, 5, 'Encamp', '03', 1),
(181, 5, 'La Massana', '04', 1),
(182, 5, 'Ordino', '05', 1),
(183, 5, 'Sant Juliŕ de Lňria', '06', 1),
(184, 5, 'Andorra la Vella', '07', 1),
(185, 5, 'Escaldes-Engordany', '08', 1),
(186, 221, '''Ajman', 'AJ', 1),
(187, 221, 'Abu Z¸aby [Abu Dhabi]', 'AZ', 1),
(188, 221, 'Dubayy [Dubai]', 'DU', 1),
(189, 221, 'Al Fujayrah', 'FU', 1),
(190, 221, 'Ra’s al Khaymah', 'RK', 1),
(191, 221, 'Ash Shariqah [Sharjah]', 'SH', 1),
(192, 221, 'Umm al Qaywayn', 'UQ', 1),
(193, 1, 'Balkh', 'BAL', 1),
(194, 1, 'Bamyan', 'BAM', 1),
(195, 1, 'Badghis', 'BDG', 1),
(196, 1, 'Badakhshan', 'BDS', 1),
(197, 1, 'Baghlan', 'BGL', 1),
(198, 1, 'Daykundi', 'DAY', 1),
(199, 1, 'Farah', 'FRA', 1),
(200, 1, 'Faryab', 'FYB', 1),
(201, 1, 'Ghazni', 'GHA', 1),
(202, 1, 'Ghor', 'GHO', 1),
(203, 1, 'Helmand', 'HEL', 1),
(204, 1, 'Herat', 'HER', 1),
(205, 1, 'Jowzjan', 'JOW', 1),
(206, 1, 'Kabul', 'KAB', 1),
(207, 1, 'Kandahar', 'KAN', 1),
(208, 1, 'Kapisa', 'KAP', 1),
(209, 1, 'Kunduz', 'KDZ', 1),
(210, 1, 'Khost', 'KHO', 1),
(211, 1, 'Kuna?', 'KNR', 1),
(212, 1, 'Laghman', 'LAG', 1),
(213, 1, 'Logar', 'LOG', 1),
(214, 1, 'Nangarhar', 'NAN', 1),
(215, 1, 'Nimroz', 'NIM', 1),
(216, 1, 'Nuristan', 'NUR', 1),
(217, 1, 'Panjshayr', 'PAN', 1),
(218, 1, 'Parwan', 'PAR', 1),
(219, 1, 'Paktiya', 'PIA', 1),
(220, 1, 'Paktika', 'PKA', 1),
(221, 1, 'Samangan', 'SAM', 1),
(222, 1, 'Sar-e Pul', 'SAR', 1),
(223, 1, 'Takhar', 'TAK', 1),
(224, 1, 'Uruzgan', 'URU', 1),
(225, 1, 'Wardak', 'WAR', 1),
(226, 1, 'Zabul', 'ZAB', 1),
(227, 9, 'Saint George', '03', 1),
(228, 9, 'Saint John', '04', 1),
(229, 9, 'Saint Mary', '05', 1),
(230, 9, 'Saint Paul', '06', 1),
(231, 9, 'Saint Peter', '07', 1),
(232, 9, 'Saint Philip', '08', 1),
(233, 9, 'Barbuda', '10', 1),
(234, 9, 'Redonda', '11', 1),
(235, 2, 'Berat', '01', 1),
(236, 2, 'Durrës', '02', 1),
(237, 2, 'Elbasan', '03', 1),
(238, 2, 'Fier', '04', 1),
(239, 2, 'Gjirokastër', '05', 1),
(240, 2, 'Korçë', '06', 1),
(241, 2, 'Kukës', '07', 1),
(242, 2, 'Lezhë', '08', 1),
(243, 2, 'Dibër', '09', 1),
(244, 2, 'Shkodër', '10', 1),
(245, 2, 'Tiranë', '11', 1),
(246, 2, 'Vlorë', '12', 1),
(247, 11, 'Aragac?otn', 'AG', 1),
(248, 11, 'Ararat', 'AR', 1),
(249, 11, 'Armavir', 'AV', 1),
(250, 11, 'Erevan', 'ER', 1),
(251, 11, 'Gegark''unik''', 'GR', 1),
(252, 11, 'Kotayk''', 'KT', 1),
(253, 11, 'Lo?i', 'LO', 1),
(254, 11, 'Širak', 'SH', 1),
(255, 11, 'Syunik''', 'SU', 1),
(256, 11, 'Tavuš', 'TV', 1),
(257, 11, 'Vayoc Jor', 'VD', 1),
(258, 6, 'Bengo', 'BGO', 1),
(259, 6, 'Benguela', 'BGU', 1),
(260, 6, 'Bié', 'BIE', 1),
(261, 6, 'Cabinda', 'CAB', 1),
(262, 6, 'Kuando Kubango', 'CCU', 1),
(263, 6, 'Cunene', 'CNN', 1),
(264, 6, 'Kwanza Norte', 'CNO', 1),
(265, 6, 'Kwanza Sul', 'CUS', 1),
(266, 6, 'Huambo', 'HUA', 1),
(267, 18, 'Magura', '37', 1),
(268, 18, 'Moulvibazar', '38', 1),
(269, 18, 'Meherpur', '39', 1),
(270, 18, 'Narayanganj', '40', 1),
(271, 18, 'Netrakona', '41', 1),
(272, 18, 'Narsingdi', '42', 1),
(273, 18, 'Narail', '43', 1),
(274, 18, 'Natore', '44', 1),
(275, 18, 'Nawabganj', '45', 1),
(276, 18, 'Nilphamari', '46', 1),
(277, 18, 'Noakhali', '47', 1),
(278, 18, 'Naogaon', '48', 1),
(279, 18, 'Pabna', '49', 1),
(280, 18, 'Pirojpur', '50', 1),
(281, 18, 'Patuakhali', '51', 1),
(282, 18, 'Panchagarh', '52', 1),
(283, 18, 'Rajbari', '53', 1),
(284, 18, 'Rajshahi', '54', 1),
(285, 18, 'Rangpur', '55', 1),
(286, 18, 'Rangamati', '56', 1),
(287, 18, 'Sherpur', '57', 1),
(288, 18, 'Satkhira', '58', 1),
(289, 18, 'Sirajganj', '59', 1),
(290, 18, 'Sylhet', '60', 1),
(291, 18, 'Sunamganj', '61', 1),
(292, 18, 'Shariatpur', '62', 1),
(293, 18, 'Tangail', '63', 1),
(294, 18, 'Thakurgaon', '64', 1),
(295, 21, 'Bruxelles-Capitale, Région de', 'BRU', 1),
(296, 21, 'Antwerpen', 'VAN', 1),
(297, 21, 'Vlaams Brabant', 'VBR', 1),
(298, 21, 'Limburg', 'VLI', 1),
(299, 21, 'Oost-Vlaanderen', 'VOV', 1),
(300, 21, 'West-Vlaanderen', 'VWV', 1),
(301, 21, 'Brabant wallon', 'WBR', 1),
(302, 21, 'Hainaut', 'WHT', 1),
(303, 21, 'Ličge', 'WLG', 1),
(304, 21, 'Luxembourg', 'WLX', 1),
(305, 21, 'Namur', 'WNA', 1),
(306, 34, 'Balé', 'BAL', 1),
(307, 34, 'Bam', 'BAM', 1),
(308, 34, 'Banwa', 'BAN', 1),
(309, 34, 'Bazčga\nga', 'BAZ', 1),
(310, 34, 'Bougouriba', 'BGR', 1),
(311, 34, 'Boulgou', 'BLG', 1),
(312, 34, 'Boulkiemdé', 'BLK', 1),
(313, 34, 'Comoé', 'COM', 1),
(314, 34, 'Ganzourgou', 'GAN', 1),
(315, 34, 'Gnagna', 'GNA', 1),
(316, 34, 'Gourma', 'GOU', 1),
(317, 34, 'Houet', 'HOU', 1),
(318, 34, 'Ioba', 'IOB', 1),
(319, 34, 'Kadiogo', 'KAD', 1),
(320, 34, 'Kénédougou', 'KEN', 1),
(321, 34, 'Komondjari', 'KMD', 1),
(322, 34, 'Kompienga', 'KMP', 1),
(323, 34, 'Koulpélogo', 'KOP', 1),
(324, 34, 'Kossi', 'KOS', 1),
(325, 34, 'Kouritenga', 'KOT', 1),
(326, 34, 'Kourwéogo', 'KOW', 1),
(327, 34, 'Léraba', 'LER', 1),
(328, 34, 'Loroum', 'LOR', 1),
(329, 34, 'Mouhoun', 'MOU', 1),
(330, 34, 'Namentenga', 'NAM', 1),
(331, 34, 'Nahouri', 'NAO', 1),
(332, 34, 'Nayala', 'NAY', 1),
(333, 34, 'Noumbiel', 'NOU', 1),
(334, 34, 'Oubritenga', 'OUB', 1),
(335, 34, 'Oudalan', 'OUD', 1),
(336, 34, 'Passoré', 'PAS', 1),
(337, 34, 'Poni', 'PON', 1),
(338, 34, 'Séno', 'SEN', 1),
(339, 34, 'Sissili', 'SIS', 1),
(340, 34, 'Sanmatenga', 'SMT', 1),
(341, 34, 'Sanguié', 'SNG', 1),
(342, 34, 'Soum', 'SOM', 1),
(343, 34, 'Sourou', 'SOR', 1),
(344, 34, 'Tapoa', 'TAP', 1),
(345, 34, 'Tui', 'TUI', 1),
(346, 34, 'Yagha', 'YAG', 1),
(347, 34, 'Yatenga', 'YAT', 1),
(348, 34, 'Ziro', 'ZIR', 1),
(349, 34, 'Zondoma', 'ZON', 1),
(350, 34, 'Zoundwéogo', 'ZOU', 1),
(351, 33, 'Blagoevgrad', '01', 1),
(352, 33, 'Burgas', '02', 1),
(353, 33, 'Varna', '03', 1),
(354, 33, 'Veliko Tarnovo', '04', 1),
(355, 33, 'Vidin', '05', 1),
(356, 33, 'Vratsa', '06', 1),
(357, 33, 'Gabrovo', '07', 1),
(358, 33, 'Dobrich', '08', 1),
(359, 33, 'Kardzhali', '09', 1),
(360, 33, 'Kjustendil', '10', 1),
(361, 33, 'Lovech', '11', 1),
(362, 33, 'Montana', '12', 1),
(363, 33, 'Pazardzik', '13', 1),
(364, 33, 'Pernik', '14', 1),
(365, 33, 'Pleven', '15', 1),
(366, 33, 'Plovdiv', '16', 1),
(367, 33, 'Razgrad', '17', 1),
(368, 33, 'Ruse', '18', 1),
(369, 33, 'Silistra', '19', 1),
(370, 33, 'Sliven', '20', 1),
(371, 33, 'Smolyan', '21', 1),
(372, 33, 'Sofia (stolitsa)', '22', 1),
(373, 33, 'Sofia', '23', 1),
(374, 33, 'Stara Zagora', '24', 1),
(375, 33, 'Targovishte', '25', 1),
(376, 33, 'Haskovo', '26', 1),
(377, 33, 'Shumen', '27', 1),
(378, 33, 'Yambol', '28', 1),
(379, 17, 'Al ‘Asimah', '13', 1),
(380, 17, 'Al Janubiyah', '14', 1),
(381, 17, 'Al Mu?arraq', '15', 1),
(382, 17, 'Ash Shamaliyah', '17', 1),
(383, 35, 'Bubanza', 'BB', 1),
(384, 35, 'Bujumbura Rural', 'BL', 1),
(385, 35, 'Bujumbura Mairie', 'BM', 1),
(386, 35, 'Bururi', 'BR', 1),
(387, 35, 'Cankuzo', 'CA', 1),
(388, 35, 'Cibitoke', 'CI', 1),
(389, 35, 'Gitega', 'GI', 1),
(390, 35, 'Kirundo', 'KI', 1),
(391, 35, 'Karuzi', 'KR', 1),
(392, 35, 'Kayanza', 'KY', 1),
(393, 35, 'Makamba', 'MA', 1),
(394, 35, 'Muramvya', 'MU', 1),
(395, 35, 'Mwaro', 'MW', 1),
(396, 35, 'Muyinga', 'MY', 1),
(397, 35, 'Ngozi', 'NG', 1),
(398, 35, 'Rumonge', 'RM', 1),
(399, 35, 'Rutana', 'RT', 1),
(400, 35, 'Ruyigi', 'RY', 1),
(401, 23, 'Atacora', 'AK', 1),
(402, 23, 'Alibori', 'AL', 1),
(403, 23, 'Atlantique', 'AQ', 1),
(404, 23, 'Borgou', 'BO', 1),
(405, 23, 'Collines', 'CO', 1),
(406, 23, 'Donga', 'DO', 1),
(407, 23, 'Couffo', 'KO', 1),
(408, 23, 'Littoral', 'LI', 1),
(409, 23, 'Mono', 'MO', 1),
(410, 23, 'Ouémé', 'OU', 1),
(411, 23, 'Plateau', 'PL', 1),
(412, 23, 'Zou', 'ZO', 1),
(413, 32, 'Belait', 'BE', 1),
(414, 32, 'Brunei-Muara', 'BM', 1),
(415, 32, 'Temburong', 'TE', 1),
(416, 32, 'Tutong', 'TU', 1),
(417, 26, 'El Beni', 'B', 1),
(418, 26, 'Cochabamba', 'C', 1),
(419, 26, 'Chuquisaca', 'H', 1),
(420, 26, 'La Paz', 'L', 1),
(421, 26, 'Pando', 'N', 1),
(422, 26, 'Oruro', 'O', 1),
(423, 26, 'Potosí', 'P', 1),
(424, 26, 'Santa Cruz', 'S', 1),
(425, 26, 'Tarija', 'T', 1),
(426, 250, 'Bonaire', 'BO', 1),
(427, 250, 'Saba', 'SA', 1),
(428, 250, 'Sint Eustatius', 'SE', 1),
(429, 30, 'Acre', 'AC', 1),
(430, 30, 'Alagoas', 'AL', 1),
(431, 30, 'Amazonas', 'AM', 1),
(432, 30, 'Amapá', 'AP', 1),
(433, 30, 'Bahia', 'BA', 1),
(434, 30, 'Ceará', 'CE', 1),
(435, 30, 'Distrito Federal', 'DF', 1),
(436, 30, 'Espírito Santo', 'ES', 1),
(437, 30, 'Goiás', 'GO', 1),
(438, 30, 'Maranhăo', 'MA', 1),
(439, 30, 'Minas Gerais', 'MG', 1),
(440, 30, 'Mato Grosso do Sul', 'MS', 1),
(441, 30, 'Mato Grosso', 'MT', 1),
(442, 30, 'Pará', 'PA', 1),
(443, 30, 'Paraíba', 'PB', 1),
(444, 30, 'Pernambuco', 'PE', 1),
(445, 30, 'Piauí', 'PI', 1),
(446, 30, 'Paraná', 'PR', 1),
(447, 30, 'Rio de Janeiro', 'RJ', 1),
(448, 30, 'Rio Grande do Norte', 'RN', 1),
(449, 30, 'Rondônia', 'RO', 1),
(450, 30, 'Roraima', 'RR', 1),
(451, 30, 'Rio Grande do Sul', 'RS', 1),
(452, 30, 'Santa Catarina', 'SC', 1),
(453, 30, 'Sergipe', 'SE', 1),
(454, 30, 'Săo Paulo', 'SP', 1),
(455, 30, 'Tocantins', 'TO', 1),
(456, 16, 'Acklins', 'AK', 1),
(457, 16, 'Bimini', 'BI', 1),
(458, 16, 'Black Point', 'BP', 1),
(459, 16, 'Berry Islands', 'BY', 1),
(460, 16, 'Central Eleuthera', 'CE', 1),
(461, 16, 'Cat Island', 'CI', 1),
(462, 16, 'Crooked Island and Long Cay', 'CK', 1),
(463, 16, 'Central Abaco', 'CO', 1),
(464, 16, 'Central Andros', 'CS', 1),
(465, 16, 'East Grand Bahama', 'EG', 1),
(466, 16, 'Exuma', 'EX', 1),
(467, 16, 'City of Freeport', 'FP', 1),
(468, 16, 'Grand Cay', 'GC', 1),
(469, 16, 'Harbour Island', 'HI', 1),
(470, 16, 'Hope Town', 'HT', 1),
(471, 16, 'Inagua', 'IN', 1),
(472, 16, 'Long Island', 'LI', 1),
(473, 16, 'Mangrove Cay', 'MC', 1),
(474, 16, 'Mayaguana', 'MG', 1),
(475, 16, 'Moore''s Island', 'MI', 1),
(476, 16, 'North Eleuthera', 'NE', 1),
(477, 16, 'North Abaco', 'NO', 1),
(478, 16, 'North Andros', 'NS', 1),
(479, 16, 'Rum Cay', 'RC', 1),
(480, 16, 'Ragged Island', 'RI', 1),
(481, 16, 'South Andros', 'SA', 1),
(482, 16, 'South Eleuthera', 'SE', 1),
(483, 16, 'South Abaco', 'SO', 1),
(484, 16, 'San Salvador', 'SS', 1),
(485, 16, 'Spanish Wells', 'SW', 1),
(486, 16, 'West Grand Bahama', 'WG', 1),
(487, 25, 'Paro', '11', 1),
(488, 25, 'Chhukha', '12', 1),
(489, 25, 'Ha', '13', 1),
(490, 25, 'Samtse', '14', 1),
(491, 25, 'Thimphu', '15', 1),
(492, 25, 'Tsirang', '21', 1),
(493, 25, 'Dagana', '22', 1),
(494, 25, 'Punakha', '23', 1),
(495, 25, 'Wangdue Phodrang', '24', 1),
(496, 25, 'Sarpang', '31', 1),
(497, 25, 'Trongsa', '32', 1),
(498, 25, 'Bumthang', '33', 1),
(499, 25, 'Zhemgang', '34', 1),
(500, 25, 'Trashigang', '41', 1),
(501, 25, 'Monggar', '42', 1),
(502, 25, 'Pemagatshel', '43', 1),
(503, 25, 'Lhuentse', '44', 1),
(504, 25, 'Samdrup Jongkha', '45', 1),
(505, 25, 'Gasa', 'GA', 1),
(506, 25, 'Trashi Yangtse', 'TY', 1),
(507, 28, 'Central', 'CE', 1),
(508, 28, 'Chobe', 'CH', 1),
(509, 28, 'Francistown', 'FR', 1),
(510, 28, 'Gaborone', 'GA', 1),
(511, 28, 'Ghanzi', 'GH', 1),
(512, 28, 'Jwaneng', 'JW', 1),
(513, 28, 'Kgalagadi', 'KG', 1),
(514, 28, 'Kgatleng', 'KL', 1),
(515, 28, 'Kweneng', 'KW', 1),
(516, 28, 'Lobatse', 'LO', 1),
(517, 28, 'North East', 'NE', 1),
(518, 28, 'North West', 'NW', 1),
(519, 28, 'South East', 'SE', 1),
(520, 28, 'Southern', 'SO', 1),
(521, 28, 'Selibe Phikwe', 'SP', 1),
(522, 28, 'Sowa Town', 'ST', 1),
(523, 20, 'Bresckaja voblasc (be) - Brestskaja oblast'' (ru)', 'BR', 1),
(524, 20, 'Horad Minsk', 'HM', 1),
(525, 20, 'Homyel''skaya voblasts'' (be) - Gomel''skaya oblast'' (ru)', 'HO', 1),
(526, 20, 'Hrodzenskaya voblasts'' (be) - Grodnenskaya oblast'' (ru)', 'HR', 1),
(527, 20, 'Mahilyowskaya voblasts'' (be) - Mogilevskaya oblast'' (ru)', 'MA', 1),
(528, 20, 'Minskaya voblasts'' (be) - Minskaya oblast'' (ru)', 'MI', 1),
(529, 20, 'Vitsyebskaya voblasts'' (be) - Vitebskaya oblast'' (ru)', 'VI', 1),
(530, 22, 'Belize', 'BZ', 1),
(531, 22, 'Cayo', 'CY', 1),
(532, 22, 'Corozal', 'CZL', 1),
(533, 22, 'Orange Walk', 'OW', 1),
(534, 22, 'Stann Creek', 'SC', 1),
(535, 22, 'Toledo', 'TOL', 1),
(536, 38, 'Alberta', 'AB', 1),
(537, 38, 'British Columbia', 'BC', 1),
(538, 38, 'Manitoba', 'MB', 1),
(539, 38, 'New Brunswick', 'NB', 1),
(540, 38, 'Newfoundland and Labrador', 'NL', 1),
(541, 38, 'Nova Scotia', 'NS', 1),
(542, 38, 'Northwest Territories', 'NT', 1),
(543, 38, 'Nunavut', 'NU', 1),
(544, 38, 'Ontario', 'ON', 1),
(545, 38, 'Prince Edward Island', 'PE', 1),
(546, 38, 'Quebec', 'QC', 1),
(547, 38, 'Saskatchewan', 'SK', 1),
(548, 38, 'Yukon', 'YT', 1),
(549, 251, 'Bas-Congo', 'BC', 1),
(550, 251, 'Bandundu', 'BN', 1),
(551, 251, 'Équateur', 'EQ', 1),
(552, 251, 'Katanga', 'KA', 1),
(553, 251, 'Kasai-Oriental', 'KE', 1),
(554, 251, 'Kinshasa', 'KN', 1),
(555, 251, 'Kasai-Occidental', 'KW', 1),
(556, 251, 'Maniema', 'MA', 1),
(557, 251, 'Nord-Kivu', 'NK', 1),
(558, 251, 'Orientale', 'OR', 1),
(559, 251, 'Sud-Kivu', 'SK', 1),
(560, 41, 'Ouham', 'AC', 1),
(561, 41, 'Bamingui-Bangoran', 'BB', 1),
(562, 41, 'Bangui', 'BGF', 1),
(563, 41, 'Basse-Kotto', 'BK', 1),
(564, 41, 'Haute-Kotto', 'HK', 1),
(565, 41, 'Haut-Mbomou', 'HM', 1),
(566, 41, 'Mambéré-Kadéď', 'HS', 1),
(567, 41, 'Gribingui', 'KB', 1),
(568, 41, 'Kémo-Gribingui', 'KG', 1),
(569, 41, 'Lobaye', 'LB', 1),
(570, 41, 'Mbomou', 'MB', 1),
(571, 41, 'Ombella-Mpoko', 'MP', 1),
(572, 41, 'Nana-Mambéré', 'NM', 1),
(573, 41, 'Ouham-Pendé', 'OP', 1),
(574, 41, 'Sangha', 'SE', 1),
(575, 41, 'Ouaka', 'UK', 1),
(576, 41, 'Vakaga', 'VK', 1),
(577, 49, 'Bouenza', '11', 1),
(578, 49, 'Pool', '12', 1),
(579, 49, 'Sangha', '13', 1),
(580, 49, 'Plateaux', '14', 1),
(581, 49, 'Cuvette-Ouest', '15', 1),
(582, 49, 'Pointe-Noire', '16', 1),
(583, 49, 'Lékoumou', '2', 1),
(584, 49, 'Kouilou', '5', 1),
(585, 49, 'Likouala', '7', 1),
(586, 49, 'Cuvette', '8', 1),
(587, 49, 'Niari', '9', 1),
(588, 49, 'Brazzaville', 'BZV', 1),
(589, 204, 'Aargau (de)', 'AG', 1),
(590, 204, 'Appenzell Innerrhoden (de)', 'AI', 1),
(591, 204, 'Appenzell Ausserrhoden (de)', 'AR', 1),
(592, 204, 'Bern (de)', 'BE', 1),
(593, 204, 'Basel-Landschaft (de)', 'BL', 1),
(594, 204, 'Basel-Stadt (de)', 'BS', 1),
(595, 204, 'Fribourg (fr)', 'FR', 1),
(596, 204, 'Genčve (fr)', 'GE', 1),
(597, 204, 'Glarus (de)', 'GL', 1),
(598, 204, 'Graubünden (de)', 'GR', 1),
(599, 204, 'Jura (fr)', 'JU', 1),
(600, 204, 'Luzern (de)', 'LU', 1),
(601, 204, 'Neuchâtel (fr)', 'NE', 1),
(602, 204, 'Nidwalden (de)', 'NW', 1),
(603, 204, 'Obwalden (de)', 'OW', 1),
(604, 204, 'Sankt Gallen (de)', 'SG', 1),
(605, 204, 'Schaffhausen (de)', 'SH', 1),
(606, 204, 'Solothurn (de)', 'SO', 1),
(607, 204, 'Schwyz (de)', 'SZ', 1),
(608, 204, 'Thurgau (de)', 'TG', 1),
(609, 204, 'Ticino (it)', 'TI', 1),
(610, 204, 'Uri (de)', 'UR', 1),
(611, 204, 'Vaud (fr)', 'VD', 1),
(612, 204, 'Valais (fr)', 'VS', 1),
(613, 204, 'Zug (de)', 'ZG', 1),
(614, 204, 'Zürich (de)', 'ZH', 1),
(615, 52, 'Abidjan', 'AB', 1),
(616, 52, 'Bas-Sassandra', 'BS', 1),
(617, 52, '	Comoé', 'CM', 1),
(618, 52, 'Denguélé', 'DN', 1),
(619, 52, 'Gôh-Djiboua', 'GD', 1),
(620, 52, 'Lacs', 'LC', 1),
(621, 52, 'Lagunes', 'LG', 1),
(622, 52, 'Montagnes', 'MG', 1),
(623, 52, 'Sassandra-Marahoué', 'SM', 1),
(624, 52, 'Savanes', 'SV', 1),
(625, 52, 'Vallée du Bandama', 'VB', 1),
(626, 52, 'Woroba', 'WR', 1),
(627, 52, 'Yamoussoukro', 'YM', 1),
(628, 52, 'Zanzan', 'ZZ', 1),
(629, 43, 'Aysén', 'AI', 1),
(630, 43, 'Antofagasta', 'AN', 1),
(631, 43, 'Arica y Parinacota', 'AP', 1),
(632, 43, 'Araucanía', 'AR', 1),
(633, 43, 'Atacama', 'AT', 1),
(634, 43, 'Biobío', 'BI', 1),
(635, 43, 'Coquimbo', 'CO', 1),
(636, 43, 'Libertador General Bernardo O''Higgins', 'LI', 1),
(637, 43, 'Los Lagos', 'LL', 1),
(638, 43, 'Los Ríos', 'LR', 1),
(639, 43, 'Magallanes', 'MA', 1),
(640, 43, 'Maule', 'ML', 1),
(641, 43, 'Región Metropolitana de Santiago', 'RM', 1),
(642, 43, 'Tarapacá', 'TA', 1),
(643, 43, 'Valparaíso', 'VS', 1),
(644, 37, 'Adamaoua', 'AD', 1),
(645, 37, 'Centre', 'CE', 1),
(646, 37, 'Far North', 'EN', 1),
(647, 37, 'East', 'ES', 1),
(648, 37, 'Littoral', 'LT', 1),
(649, 37, 'North', 'NO', 1),
(650, 37, 'North-West', 'NW', 1),
(651, 37, 'West', 'OU', 1),
(652, 37, 'South', 'SU', 1),
(653, 37, 'South-West', 'SW', 1),
(654, 44, 'Beijing', '11', 1),
(655, 44, 'Tianjin', '12', 1),
(656, 44, 'Hebei', '13', 1),
(657, 44, 'Shanxi', '14', 1),
(658, 44, 'Nei Mongol (mn)', '15', 1),
(659, 44, 'Liaoning', '21', 1),
(660, 44, 'Jilin', '22', 1),
(661, 44, 'Heilongjiang', '23', 1),
(662, 44, 'Shanghai', '31', 1),
(663, 44, 'Jiangsu', '32', 1),
(664, 44, 'Zhejiang', '33', 1),
(665, 44, 'Anhui', '34', 1),
(666, 44, 'Fujian', '35', 1),
(667, 44, 'Jiangxi', '36', 1),
(668, 44, 'Shandong', '37', 1),
(669, 44, 'Henan', '41', 1),
(670, 44, 'Hubei', '42', 1),
(671, 44, 'Hunan', '43', 1),
(672, 44, 'Guangdong', '44', 1),
(673, 44, 'Guangxi', '45', 1),
(674, 44, 'Hainan', '46', 1),
(675, 44, 'Chongqing', '50', 1),
(676, 44, 'Sichuan', '51', 1),
(677, 44, 'Guizhou', '52', 1),
(678, 44, 'Yunnan', '53', 1),
(679, 44, 'Xizang', '54', 1),
(680, 44, 'Shaanxi', '61', 1),
(681, 44, 'Gansu', '62', 1),
(682, 44, 'Qinghai', '63', 1),
(683, 44, 'Ningxia', '64', 1),
(684, 44, 'Xinjiang', '65', 1),
(685, 44, 'Taiwan', '71', 1),
(686, 44, 'Xianggang', '91', 1),
(687, 44, 'Aomen', '92', 1),
(688, 47, 'Amazonas', 'AMA', 1),
(689, 47, 'Antioquia', 'ANT', 1),
(690, 47, 'Arauca', 'ARA', 1),
(691, 47, 'Atlántico', 'ATL', 1),
(692, 47, 'Bolívar', 'BOL', 1),
(693, 47, 'Boyacá', 'BOY', 1),
(694, 47, 'Caldas', 'CAL', 1),
(695, 47, 'Caquetá', 'CAQ', 1),
(696, 47, 'Casanare', 'CAS', 1),
(697, 47, 'Cauca', 'CAU', 1),
(698, 47, 'Cesar', 'CES', 1),
(699, 47, 'Chocó', 'CHO', 1),
(700, 47, 'Córdoba', 'COR', 1),
(701, 47, 'Cundinamarca', 'CUN', 1),
(702, 47, 'Distrito Capital de Bogotá', 'DC', 1),
(703, 47, 'Guainía', 'GUA', 1),
(704, 47, 'Guaviare', 'GUV', 1),
(705, 47, 'Huila', 'HUI', 1),
(706, 47, 'La Guajira', 'LAG', 1),
(707, 47, 'Magdalena', 'MAG', 1),
(708, 47, 'Meta', 'MET', 1),
(709, 47, 'Narińo', 'NAR', 1),
(710, 47, 'Norte de Santander', 'NSA', 1),
(711, 47, 'Putumayo', 'PUT', 1),
(712, 47, 'Quindío', 'QUI', 1),
(713, 47, 'Risaralda', 'RIS', 1),
(714, 47, 'Santander', 'SAN', 1),
(715, 47, 'San Andrés, Providencia y Santa Catalina', 'SAP', 1),
(716, 47, 'Sucre', 'SUC', 1),
(717, 47, 'Tolima', 'TOL', 1),
(718, 47, 'Valle del Cauca', 'VAC', 1),
(719, 47, 'Vaupés', 'VAU', 1),
(720, 47, 'Vichada', 'VID', 1),
(721, 51, 'Alajuela', 'A', 1),
(722, 51, 'Cartago', 'C', 1),
(723, 51, 'Guanacaste', 'G', 1),
(724, 51, 'Heredia', 'H', 1),
(725, 51, 'Limón', 'L', 1),
(726, 51, 'Puntarenas', 'P', 1),
(727, 51, 'San José', 'SJ', 1),
(728, 54, 'Pinar del Río', '01', 1),
(729, 54, 'La Habana', '02', 1),
(730, 54, 'Ciudad de La Habana', '03', 1),
(731, 54, 'Matanzas', '04', 1),
(732, 54, 'Villa Clara', '05', 1),
(733, 54, 'Cienfuegos', '06', 1),
(734, 54, 'Sancti Spíritus', '07', 1),
(735, 54, 'Ciego de Ávila', '08', 1),
(736, 54, 'Camagüey', '09', 1),
(737, 54, 'Las Tunas', '10', 1),
(738, 54, 'Holguín', '11', 1),
(739, 54, 'Granma', '12', 1),
(740, 54, 'Santiago de Cuba', '13', 1),
(741, 54, 'Guantánamo', '14', 1),
(742, 54, 'Artemisa', '15', 1),
(743, 54, 'Mayabeque', '16', 1),
(744, 54, 'Isla de la Juventud', '99', 1),
(745, 39, 'Brava', 'BR', 1),
(746, 39, 'Boa Vista', 'BV', 1),
(747, 39, 'Santa Catarina', 'CA', 1),
(748, 39, 'Santa Catarina do Fogo', 'CF', 1),
(749, 39, 'Santa Cruz', 'CR', 1),
(750, 39, 'Maio', 'MA', 1),
(751, 39, 'Mosteiros', 'MO', 1),
(752, 39, 'Paul', 'PA', 1),
(753, 39, 'Porto Novo', 'PN', 1),
(754, 39, 'Praia', 'PR', 1),
(755, 39, 'Ribeira Brava', 'RB', 1),
(756, 39, 'Ribeira Grande', 'RG', 1),
(757, 39, 'Ribeira Grande de Santiago', 'RS', 1),
(758, 39, 'Săo Domingos', 'SD', 1),
(759, 39, 'Săo Filipe', 'SF', 1),
(760, 39, 'Sal', 'SL', 1),
(761, 39, 'Săo Miguel', 'SM', 1),
(762, 39, 'Săo Lourenço dos Órgăos', 'SO', 1),
(763, 39, 'Săo Salvador do Mundo', 'SS', 1),
(764, 39, 'Săo Vicente', 'SV', 1),
(765, 39, 'Tarrafal', 'TA', 1),
(766, 39, 'Tarrafal de Săo Nicolau', 'TS', 1),
(767, 55, 'Lefkosia', '01', 1),
(768, 55, 'Lemesos', '02', 1),
(769, 55, 'Larnaka', '03', 1),
(770, 55, 'Ammochostos', '04', 1),
(771, 55, 'Pafos', '05', 1),
(772, 55, 'Keryneia', '06', 1),
(773, 56, 'Jihoceský kraj', 'JC', 1),
(774, 56, 'Jihomoravský kraj', 'JM', 1),
(775, 56, 'Karlovarský kraj', 'KA', 1),
(776, 56, 'Královéhradecký kraj', 'KR', 1),
(777, 56, 'Liberecký kraj', 'LI', 1),
(778, 56, 'Moravskoslezský kraj', 'MO', 1),
(779, 56, 'Olomoucký kraj', 'OL', 1),
(780, 56, 'Pardubický kraj', 'PA', 1),
(781, 56, 'Plzenský kraj', 'PL', 1),
(782, 56, 'Praha, hlavní mesto', 'PR', 1),
(783, 56, 'Stredoceský kraj', 'ST', 1),
(784, 56, 'Ústecký kraj', 'US', 1),
(785, 56, 'Vysocina', 'VY', 1),
(786, 56, 'Zlínský kraj', 'ZL', 1),
(787, 81, 'Brandenburg', 'BB', 1),
(788, 81, 'Berlin', 'BE', 1),
(789, 81, 'Baden-Württemberg', 'BW', 1),
(790, 81, 'Bayern', 'BY', 1),
(791, 81, 'Bremen', 'HB', 1),
(792, 81, 'Hessen', 'HE', 1),
(793, 81, 'Hamburg', 'HH', 1),
(794, 81, 'Mecklenburg-Vorpommern', 'MV', 1),
(795, 81, 'Niedersachsen', 'NI', 1),
(796, 81, 'Nordrhein-Westfalen', 'NW', 1),
(797, 81, 'Rheinland-Pfalz', 'RP', 1),
(798, 81, 'Schleswig-Holstein', 'SH', 1),
(799, 81, 'Saarland', 'SL', 1),
(800, 81, 'Sachsen', 'SN', 1),
(801, 81, 'Sachsen-Anhalt', 'ST', 1),
(802, 81, 'Thüringen', 'TH', 1),
(803, 58, 'Arta', 'AR', 1),
(804, 58, 'Ali Sabieh', 'AS', 1),
(805, 58, 'Dikhil', 'DI', 1),
(806, 58, 'Djibouti', 'DJ', 1),
(807, 58, 'Obock', 'OB', 1),
(808, 58, 'Tadjourah', 'TA', 1),
(809, 57, 'Nordjylland', '81', 1),
(810, 57, 'Midtjylland', '82', 1),
(811, 57, 'Syddanmark', '83', 1),
(812, 57, 'Hovedstaden', '84', 1),
(813, 57, 'Sjćlland', '85', 1),
(814, 59, 'Saint Andrew', '02', 1),
(815, 59, 'Saint David', '03', 1),
(816, 59, 'Saint George', '04', 1),
(817, 59, 'Saint John', '05', 1),
(818, 59, 'Saint Joseph', '06', 1),
(819, 59, 'Saint Luke', '07', 1),
(820, 59, 'Saint Mark', '08', 1),
(821, 59, 'Saint Patrick', '09', 1),
(822, 59, 'Saint Paul', '10', 1),
(823, 59, 'Saint Peter', '11', 1),
(824, 60, 'Distrito Nacional (Santo Domingo)', '01', 1),
(825, 60, 'Azua', '02', 1),
(826, 60, 'Baoruco', '03', 1),
(827, 60, 'Barahona', '04', 1),
(828, 60, 'Dajabón', '05', 1),
(829, 60, 'Duarte', '06', 1),
(830, 60, 'La Estrelleta [Elías Pińa]', '07', 1),
(831, 60, 'El Seibo', '08', 1),
(832, 60, 'Espaillat', '09', 1),
(833, 60, 'Independencia', '10', 1),
(834, 60, 'La Altagracia', '11', 1),
(835, 60, 'La Romana', '12', 1),
(836, 60, 'La Vega', '13', 1),
(837, 60, 'María Trinidad Sánchez', '14', 1),
(838, 60, 'Monte Cristi', '15', 1),
(839, 60, 'Pedernales', '16', 1),
(840, 60, 'Peravia', '17', 1),
(841, 60, 'Puerto Plata', '18', 1),
(842, 60, 'Hermanas Mirabal', '19', 1),
(843, 60, 'Samaná', '20', 1),
(844, 60, 'San Cristóbal', '21', 1),
(845, 60, 'San Juan', '22', 1),
(846, 60, 'San Pedro de Macorís', '23', 1),
(847, 60, 'Sánchez Ramírez', '24', 1),
(848, 60, 'Santiago', '25', 1),
(849, 60, 'Santiago Rodríguez', '26', 1),
(850, 60, 'Valverde', '27', 1),
(851, 60, 'Monseńor Nouel', '28', 1),
(852, 60, 'Monte Plata', '29', 1),
(853, 60, 'Hato Mayor', '30', 1),
(854, 60, 'San José de Ocoa', '31', 1),
(855, 60, 'Santo Domingo', '32', 1),
(856, 60, 'Cibao Nordeste', '33', 1),
(857, 60, 'Cibao Noroeste', '34', 1),
(858, 60, 'Cibao Norte', '35', 1),
(859, 60, 'Cibao Sur', '36', 1),
(860, 60, 'El Valle', '37', 1),
(861, 60, 'Enriquillo', '38', 1),
(862, 60, 'Higuamo', '39', 1),
(863, 60, 'Ozama', '40', 1),
(864, 60, 'Valdesia', '41', 1),
(865, 60, 'Yuma', '42', 1),
(866, 3, 'Adrar', '01', 1),
(867, 3, 'Chlef', '02', 1),
(868, 3, 'Laghouat', '03', 1),
(869, 3, 'Oum el Bouaghi', '04', 1),
(870, 3, 'Batna', '05', 1),
(871, 3, 'Béjaďa', '06', 1),
(872, 3, 'Biskra', '07', 1),
(873, 3, 'Béchar', '08', 1),
(874, 3, 'Blida', '09', 1),
(875, 3, 'Bouira', '10', 1),
(876, 3, 'Tamanrasset', '11', 1),
(877, 3, 'Tébessa', '12', 1),
(878, 3, 'Tlemcen', '13', 1),
(879, 3, 'Tiaret', '14', 1),
(880, 3, 'Tizi Ouzou', '15', 1),
(881, 3, 'Alger', '16', 1),
(882, 3, 'Djelfa', '17', 1),
(883, 3, 'Jijel', '18', 1),
(884, 3, 'Sétif', '19', 1),
(885, 3, 'Saďda', '20', 1),
(886, 3, 'Skikda', '21', 1),
(887, 3, 'Sidi Bel Abbčs', '22', 1),
(888, 3, 'Annaba', '23', 1),
(889, 3, 'Guelma', '24', 1),
(890, 3, 'Constantine', '25', 1),
(891, 3, 'Médéa', '26', 1),
(892, 3, 'Mostaganem', '27', 1),
(893, 3, 'Msila', '28', 1),
(894, 3, 'Mascara', '29', 1),
(895, 3, 'Ouargla', '30', 1),
(896, 3, 'Oran', '31', 1),
(897, 3, 'El Bayadh', '32', 1),
(898, 3, 'Illizi', '33', 1),
(899, 3, 'Bordj Bou Arréridj', '34', 1),
(900, 3, 'Boumerdčs', '35', 1),
(901, 3, 'El Tarf', '36', 1),
(902, 3, 'Tindouf', '37', 1),
(903, 3, 'Tissemsilt', '38', 1),
(904, 3, 'El Oued', '39', 1),
(905, 3, 'Khenchela', '40', 1),
(906, 3, 'Souk Ahras', '41', 1),
(907, 3, 'Tipaza', '42', 1),
(908, 3, 'Mila', '43', 1),
(909, 3, 'Aďn Defla', '44', 1),
(910, 3, 'Naama', '45', 1),
(911, 3, 'Aďn Témouchent', '46', 1),
(912, 3, 'Ghardaďa', '47', 1),
(913, 3, 'Relizane', '48', 1),
(914, 62, 'Azuay', 'A', 1),
(915, 62, 'Bolívar', 'B', 1),
(916, 62, 'Carchi', 'C', 1),
(917, 62, 'Orellana', 'D', 1),
(918, 62, 'Esmeraldas', 'E', 1),
(919, 62, 'Cańar', 'F', 1),
(920, 62, 'Guayas', 'G', 1),
(921, 62, 'Chimborazo', 'H', 1),
(922, 62, 'Imbabura', 'I', 1),
(923, 62, 'Loja', 'L', 1),
(924, 62, 'Manabí', 'M', 1),
(925, 62, 'Napo', 'N', 1),
(926, 62, 'El Oro', 'O', 1),
(927, 62, 'Pichincha', 'P', 1),
(928, 62, 'Los Ríos', 'R', 1),
(929, 62, 'Morona-Santiago', 'S', 1),
(930, 62, 'Santo Domingo de los Tsáchilas', 'SD', 1),
(931, 62, 'Santa Elena', 'SE', 1),
(932, 62, 'Tungurahua', 'T', 1),
(933, 62, 'Sucumbíos', 'U', 1),
(934, 62, 'Galápagos', 'W', 1),
(935, 62, 'Cotopaxi', 'X', 1),
(936, 62, 'Pastaza', 'Y', 1),
(937, 62, 'Zamora-Chinchipe', 'Z', 1),
(938, 67, 'Harjumaa', '37', 1),
(939, 67, 'Hiiumaa', '39', 1),
(940, 67, 'Ida-Virumaa', '44', 1),
(941, 67, 'Jőgevamaa', '49', 1),
(942, 67, 'Järvamaa', '51', 1),
(943, 67, 'Läänemaa', '57', 1),
(944, 67, 'Lääne-Virumaa', '59', 1),
(945, 67, 'Pőlvamaa', '65', 1),
(946, 67, 'Pärnumaa', '67', 1),
(947, 67, 'Raplamaa', '70', 1),
(948, 67, 'Saaremaa', '74', 1),
(949, 67, 'Tartumaa', '78', 1),
(950, 67, 'Valgamaa', '82', 1),
(951, 67, 'Viljandimaa', '84', 1),
(952, 67, 'Vőrumaa', '86', 1),
(953, 63, 'AI Iskandariyah', 'ALX', 1),
(954, 63, 'Aswan', 'ASN', 1),
(955, 63, 'Asyut', 'AST', 1),
(956, 63, 'Al Ba?r al A?mar', 'BA', 1),
(957, 63, 'Al Bu?ayrah', 'BH', 1),
(958, 63, 'Bani Suwayf', 'BNS', 1),
(959, 63, 'AI Qahirah', 'C', 1),
(960, 63, 'Ad Daqahliyah', 'DK', 1),
(961, 63, 'Dumyat', 'DT', 1),
(962, 63, 'AI Fayyum', 'FYM', 1),
(963, 63, 'AI Gharbiyah', 'GH', 1),
(964, 63, 'AI Jizah', 'GZ', 1),
(965, 63, 'AI Isma ''iliyah', 'IS', 1),
(966, 63, 'Janub Sina''', 'JS', 1),
(967, 63, 'AI Qalyubiyah', 'KB', 1),
(968, 63, 'Kafr ash Shaykh', 'KFS', 1),
(969, 63, 'Qina', 'KN', 1),
(970, 63, 'Al Uqsur', 'LX', 1),
(971, 63, 'AI Minya', 'MN', 1),
(972, 63, 'AI Minufiyah', 'MNF', 1),
(973, 63, 'Matruh', 'MT', 1),
(974, 63, 'Bur Sa''id', 'PTS', 1),
(975, 63, 'Suhaj', 'SHG', 1),
(976, 63, 'Ash Sharqiyah', 'SHR', 1),
(977, 63, 'Shamal Sina''', 'SIN', 1),
(978, 63, 'As Suways', 'SUZ', 1),
(979, 63, 'AI Wadi al Jadid', 'WAD', 1),
(980, 66, '‘Anseba', 'AN', 1),
(981, 66, 'Debubawi K’eyyi? Ba?ri', 'DK', 1),
(982, 66, 'Debub', 'DU', 1),
(983, 66, 'Gash-Barka', 'GB', 1),
(984, 66, 'Ma’ikel', 'MA', 1),
(985, 66, 'Semienawi K’eyyi? Ba?ri', 'SK', 1),
(986, 195, 'Alicante / Alacant', 'A', 1),
(987, 195, 'Albacete', 'AB', 1),
(988, 195, 'Almería', 'AL', 1),
(989, 195, 'Ávila', 'AV', 1),
(990, 195, 'Barcelona  [Barcelona]', 'B', 1),
(991, 195, 'Badajoz', 'BA', 1),
(992, 195, 'Biskaia', 'BI', 1),
(993, 195, 'Burgos', 'BU', 1),
(994, 195, 'A Coruńa  [La Coruńa]', 'C', 1),
(995, 195, 'Cádiz', 'CA', 1),
(996, 195, 'Cáceres', 'CC', 1),
(997, 195, 'Ceuta', 'CE', 1),
(998, 195, 'Córdoba', 'CO', 1),
(999, 195, 'Ciudad Real', 'CR', 1),
(1000, 195, 'Castellón / Castelló', 'CS', 1),
(1001, 195, 'Cuenca', 'CU', 1),
(1002, 195, 'Las Palmas', 'GC', 1),
(1003, 195, 'Girona  [Gerona]', 'GI', 1),
(1004, 195, 'Granada', 'GR', 1),
(1005, 195, 'Guadalajara', 'GU', 1),
(1006, 195, 'Huelva', 'H', 1),
(1007, 195, 'Huesca', 'HU', 1),
(1008, 195, 'Jaén', 'J', 1),
(1009, 195, 'Lleida  [Lérida]', 'L', 1),
(1010, 195, 'León', 'LE', 1),
(1011, 195, 'La Rioja', 'LO', 1),
(1012, 195, 'Lugo  [Lugo]', 'LU', 1),
(1013, 195, 'Madrid', 'M', 1),
(1014, 195, 'Málaga', 'MA', 1),
(1015, 195, 'Melilla', 'ML', 1),
(1016, 195, 'Murcia', 'MU', 1),
(1017, 195, 'Navarra / Nafarroa', 'NA', 1),
(1018, 195, 'Asturias', 'O', 1),
(1019, 195, 'Ourense  [Orense]', 'OR', 1),
(1020, 195, 'Palencia', 'P', 1),
(1021, 195, 'Balears  [Baleares]', 'PM', 1),
(1022, 195, 'Pontevedra  [Pontevedra]', 'PO', 1),
(1023, 195, 'Cantabria', 'S', 1),
(1024, 195, 'Salamanca', 'SA', 1),
(1025, 195, 'Sevilla', 'SE', 1),
(1026, 195, 'Segovia', 'SG', 1),
(1027, 195, 'Soria', 'SO', 1),
(1028, 195, 'Gipuzkoa', 'SS', 1),
(1029, 195, 'Tarragona  [Tarragona]', 'T', 1),
(1030, 195, 'Teruel', 'TE', 1),
(1031, 195, 'Santa Cruz de Tenerife', 'TF', 1),
(1032, 195, 'Toledo', 'TO', 1),
(1033, 195, 'Valencia / Valčncia', 'V', 1),
(1034, 195, 'Valladolid', 'VA', 1),
(1035, 195, 'Álava / Araba', 'VI', 1),
(1036, 195, 'Zaragoza', 'Z', 1),
(1037, 195, 'Zamora', 'ZA', 1),
(1038, 68, 'Adis Abeba', 'AA', 1),
(1039, 68, 'Afar', 'AF', 1),
(1040, 68, 'Amara', 'AM', 1),
(1041, 68, 'Binshangul Gumuz', 'BE', 1),
(1042, 68, 'Dire Dawa', 'DD', 1),
(1043, 68, 'Gambela Hizboch', 'GA', 1),
(1044, 68, 'Hareri Hizb', 'HA', 1),
(1045, 68, 'Oromiya', 'OR', 1),
(1046, 68, 'YeDebub Biheroch Bihereseboch na Hizboch', 'SN', 1),
(1047, 68, 'Sumale', 'SO', 1),
(1048, 68, 'Tigray', 'TI', 1),
(1049, 72, 'Ahvenanmaan maakunta', '01', 1),
(1050, 72, 'Etelä-Karjala', '02', 1),
(1051, 72, 'Etelä-Pohjanmaa', '03', 1),
(1052, 72, 'Etelä-Savo', '04', 1),
(1053, 72, 'Kainuu', '05', 1),
(1054, 72, 'Kanta-Häme', '06', 1),
(1055, 72, 'Keski-Pohjanmaa', '07', 1),
(1056, 72, 'Keski-Suomi', '08', 1),
(1057, 72, 'Kymenlaakso', '09', 1),
(1058, 72, 'Lappi', '10', 1),
(1059, 72, 'Pirkanmaa', '11', 1),
(1060, 72, 'Pohjanmaa', '12', 1),
(1061, 72, 'Pohjois-Karjala', '13', 1),
(1062, 72, 'Pohjois-Pohjanmaa', '14', 1),
(1063, 72, 'Pohjois-Savo', '15', 1),
(1064, 72, 'Päijät-Häme', '16', 1),
(1065, 72, 'Satakunta', '17', 1),
(1066, 72, 'Uusimaa', '18', 1),
(1067, 72, 'Varsinais-Suomi', '19', 1),
(1068, 71, 'Ba', '01', 1),
(1069, 71, 'Bua', '02', 1),
(1070, 71, 'Cakaudrove', '03', 1),
(1071, 71, 'Kadavu', '04', 1),
(1072, 71, 'Lau', '05', 1),
(1073, 71, 'Lomaiviti', '06', 1),
(1074, 71, 'Macuata', '07', 1),
(1075, 71, 'Nadroga and Navosa', '08', 1),
(1076, 71, 'Naitasiri', '09', 1),
(1077, 71, 'Namosi', '10', 1),
(1078, 71, 'Ra', '11', 1),
(1079, 71, 'Rewa', '12', 1),
(1080, 71, 'Serua', '13', 1),
(1081, 71, 'Tailevu', '14', 1),
(1082, 71, 'Central', 'C', 1),
(1083, 71, 'Eastern', 'E', 1),
(1084, 71, 'Northern', 'N', 1),
(1085, 71, 'Rotuma', 'R', 1),
(1086, 71, 'Western', 'W', 1),
(1087, 139, 'Kosrae', 'KSA', 1),
(1088, 139, 'Pohnpei', 'PNI', 1),
(1089, 139, 'Chuuk', 'TRK', 1),
(1090, 139, 'Yap', 'YAP', 1),
(1091, 73, 'Ain', '01', 1),
(1092, 73, 'Aisne', '02', 1),
(1093, 73, 'Allier', '03', 1),
(1094, 73, 'Alpes-de-Haute-Provence', '04', 1),
(1095, 73, 'Hautes-Alpes', '05', 1),
(1096, 73, 'Alpes-Maritimes', '06', 1),
(1097, 73, 'Ardčche', '07', 1),
(1098, 73, 'Ardennes', '08', 1),
(1099, 73, 'Aričge', '09', 1),
(1100, 73, 'Aube', '10', 1),
(1101, 73, 'Aude', '11', 1),
(1102, 73, 'Aveyron', '12', 1),
(1103, 73, 'Bouches-du-Rhône', '13', 1),
(1104, 73, 'Calvados', '14', 1),
(1105, 73, 'Cantal', '15', 1),
(1106, 73, 'Charente', '16', 1),
(1107, 73, 'Charente-Maritime', '17', 1),
(1108, 73, 'Cher', '18', 1),
(1109, 73, 'Corrčze', '19', 1),
(1110, 73, 'Côte-d''Or', '21', 1),
(1111, 73, 'Côtes-d''Armor', '22', 1),
(1112, 73, 'Creuse', '23', 1),
(1113, 73, 'Dordogne', '24', 1),
(1114, 73, 'Doubs', '25', 1),
(1115, 73, 'Drôme', '26', 1),
(1116, 73, 'Eure', '27', 1),
(1117, 73, 'Eure-et-Loir', '28', 1),
(1118, 73, 'Finistčre', '29', 1),
(1119, 73, 'Corse-du-Sud', '2A', 1),
(1120, 73, 'Haute-Corse', '2B', 1),
(1121, 73, 'Gard', '30', 1),
(1122, 73, 'Haute-Garonne', '31', 1),
(1123, 73, 'Gers', '32', 1),
(1124, 73, 'Gironde', '33', 1),
(1125, 73, 'Hérault', '34', 1),
(1126, 73, 'Ille-et-Vilaine', '35', 1),
(1127, 73, 'Indre', '36', 1),
(1128, 73, 'Indre-et-Loire', '37', 1),
(1129, 73, 'Isčre', '38', 1),
(1130, 73, 'Jura', '39', 1),
(1131, 73, 'Landes', '40', 1),
(1132, 73, 'Loir-et-Cher', '41', 1),
(1133, 73, 'Loire', '42', 1),
(1134, 73, 'Haute-Loire', '43', 1),
(1135, 73, 'Loire-Atlantique', '44', 1),
(1136, 73, 'Loiret', '45', 1),
(1137, 73, 'Lot', '46', 1),
(1138, 73, 'Lot-et-Garonne', '47', 1),
(1139, 73, 'Lozčre', '48', 1),
(1140, 73, 'Maine-et-Loire', '49', 1),
(1141, 73, 'Manche', '50', 1),
(1142, 73, 'Marne', '51', 1),
(1143, 73, 'Haute-Marne', '52', 1),
(1144, 73, 'Mayenne', '53', 1),
(1145, 73, 'Meurthe-et-Moselle', '54', 1),
(1146, 73, 'Meuse', '55', 1),
(1147, 73, 'Morbihan', '56', 1),
(1148, 73, 'Moselle', '57', 1),
(1149, 73, 'Ničvre', '58', 1),
(1150, 73, 'Nord', '59', 1),
(1151, 73, 'Oise', '60', 1),
(1152, 73, 'Orne', '61', 1),
(1153, 73, 'Pas-de-Calais', '62', 1),
(1154, 73, 'Puy-de-Dôme', '63', 1),
(1155, 73, 'Pyrénées-Atlantiques', '64', 1),
(1156, 73, 'Hautes-Pyrénées', '65', 1),
(1157, 73, 'Pyrénées-Orientales', '66', 1),
(1158, 73, 'Bas-Rhin', '67', 1),
(1159, 73, 'Haut-Rhin', '68', 1),
(1160, 73, 'Rhône', '69', 1),
(1161, 73, 'Haute-Saône', '70', 1),
(1162, 73, 'Saône-et-Loire', '71', 1),
(1163, 73, 'Sarthe', '72', 1),
(1164, 73, 'Savoie', '73', 1),
(1165, 73, 'Haute-Savoie', '74', 1),
(1166, 73, 'Paris', '75', 1),
(1167, 73, 'Seine-Maritime', '76', 1),
(1168, 73, 'Seine-et-Marne', '77', 1),
(1169, 73, 'Yvelines', '78', 1),
(1170, 73, 'Deux-Sčvres', '79', 1),
(1171, 73, 'Somme', '80', 1),
(1172, 73, 'Tarn', '81', 1),
(1173, 73, 'Tarn-et-Garonne', '82', 1),
(1174, 73, 'Var', '83', 1),
(1175, 73, 'Vaucluse', '84', 1),
(1176, 73, 'Vendée', '85', 1),
(1177, 73, 'Vienne', '86', 1),
(1178, 73, 'Haute-Vienne', '87', 1),
(1179, 73, 'Vosges', '88', 1),
(1180, 73, 'Yonne', '89', 1),
(1181, 73, 'Territoire de Belfort', '90', 1),
(1182, 73, 'Essonne', '91', 1),
(1183, 73, 'Hauts-de-Seine', '92', 1),
(1184, 73, 'Seine-Saint-Denis', '93', 1),
(1185, 73, 'Val-de-Marne', '94', 1),
(1186, 73, 'Val-d''Oise', '95', 1),
(1187, 78, 'Estuaire', '1', 1),
(1188, 78, 'Haut-Ogooué', '2', 1),
(1189, 78, 'Moyen-Ogooué', '3', 1),
(1190, 78, 'Ngounié', '4', 1),
(1191, 78, 'Nyanga', '5', 1),
(1192, 78, 'Ogooué-Ivindo', '6', 1),
(1193, 78, 'Ogooué-Lolo', '7', 1),
(1194, 78, 'Ogooué-Maritime', '8', 1),
(1195, 78, 'Woleu-Ntem', '9', 1),
(1196, 222, 'Armagh, Banbridge and Craigavon', 'ABC', 1),
(1197, 222, 'Aberdeenshire', 'ABD', 1),
(1198, 222, 'Aberdeen City', 'ABE', 1),
(1199, 222, 'Argyll and Bute', 'AGB', 1),
(1200, 222, 'Isle of Anglesey [Sir Ynys Môn GB-YNM]', 'AGY', 1),
(1201, 222, 'Ards and North Down', 'AND', 1),
(1202, 222, 'Antrim and Newtownabbey', 'ANN', 1),
(1203, 222, 'Angus', 'ANS', 1),
(1204, 222, 'Armagh', 'ARM', 1),
(1205, 222, 'Bath and North East Somerset', 'BAS', 1),
(1206, 222, 'Blackburn with Darwen', 'BBD', 1),
(1207, 222, 'Bedford', 'BDF', 1),
(1208, 222, 'Barking and Dagenham', 'BDG', 1),
(1209, 222, 'Brent', 'BEN', 1),
(1210, 222, 'Bexley', 'BEX', 1),
(1211, 222, 'Belfast', 'BFS', 1),
(1212, 222, 'Bridgend [Pen-y-bont ar Ogwr GB-POG]', 'BGE', 1),
(1213, 222, 'Blaenau Gwent', 'BGW', 1),
(1214, 222, 'Birmingham', 'BIR', 1),
(1215, 222, 'Buckinghamshire', 'BKM', 1),
(1216, 222, 'Bournemouth', 'BMH', 1),
(1217, 222, 'Barnet', 'BNE', 1),
(1218, 222, 'Brighton and Hove', 'BNH', 1),
(1219, 222, 'Barnsley', 'BNS', 1),
(1220, 222, 'Bolton', 'BOL', 1),
(1221, 222, 'Blackpool', 'BPL', 1),
(1222, 222, 'Bracknell Forest', 'BRC', 1),
(1223, 222, 'Bradford', 'BRD', 1),
(1224, 222, 'Bromley', 'BRY', 1),
(1225, 222, 'Bristol, City of', 'BST', 1),
(1226, 222, 'Bury', 'BUR', 1),
(1227, 222, 'Cambridgeshire', 'CAM', 1),
(1228, 222, 'Caerphilly [Caerffili GB-CAF]', 'CAY', 1),
(1229, 222, 'Central Bedfordshire', 'CBF', 1),
(1230, 222, 'Causeway Coast and Glens', 'CCG', 1),
(1231, 222, 'Ceredigion [Sir Ceredigion]', 'CGN', 1),
(1232, 222, 'Cheshire East', 'CHE', 1),
(1233, 222, 'Cheshire West and Chester', 'CHW', 1),
(1234, 222, 'Calderdale', 'CLD', 1),
(1235, 222, 'Clackmannanshire', 'CLK', 1),
(1236, 222, 'Cumbria', 'CMA', 1),
(1237, 222, 'Camden', 'CMD', 1),
(1238, 222, 'Carmarthenshire [Sir Gaerfyrddin GB-GFY]', 'CMN', 1),
(1239, 222, 'Cornwall', 'CON', 1),
(1240, 222, 'Coventry', 'COV', 1),
(1241, 222, 'Cardiff [Caerdydd GB-CRD]', 'CRF', 1),
(1242, 222, 'Croydon', 'CRY', 1),
(1243, 222, 'Conwy', 'CWY', 1),
(1244, 222, 'Darlington', 'DAL', 1),
(1245, 222, 'Derbyshire', 'DBY', 1),
(1246, 222, 'Denbighshire [Sir Ddinbych GB-DDB]', 'DEN', 1),
(1247, 222, 'Derby', 'DER', 1),
(1248, 222, 'Devon', 'DEV', 1),
(1249, 222, 'Dumfries and Galloway', 'DGY', 1),
(1250, 222, 'Doncaster', 'DNC', 1),
(1251, 222, 'Dundee City', 'DND', 1),
(1252, 222, 'Dorset', 'DOR', 1),
(1253, 222, '	Derry and Strabane', 'DRS', 1),
(1254, 222, 'Dudley', 'DUD', 1),
(1255, 222, 'Durham', 'DUR', 1),
(1256, 222, 'Ealing', 'EAL', 1),
(1257, 222, 'East Ayrshire', 'EAY', 1),
(1258, 222, 'Edinburgh, City of', 'EDH', 1),
(1259, 222, 'East Dunbartonshire', 'EDU', 1),
(1260, 222, 'East Lothian', 'ELN', 1),
(1261, 222, 'Eilean Siar', 'ELS', 1),
(1262, 222, 'Enfield', 'ENF', 1),
(1263, 222, 'East Renfrewshire', 'ERW', 1),
(1264, 222, 'East Riding of Yorkshire', 'ERY', 1),
(1265, 222, 'Essex', 'ESS', 1),
(1266, 222, 'East Sussex', 'ESX', 1),
(1267, 222, 'Falkirk', 'FAL', 1),
(1268, 222, 'Fife', 'FIF', 1),
(1269, 222, 'Flintshire [Sir y Fflint GB-FFL]', 'FLN', 1),
(1270, 222, '	Fermanagh and Omagh', 'FMO', 1),
(1271, 222, 'Gateshead', 'GAT', 1),
(1272, 222, 'Glasgow City', 'GLG', 1),
(1273, 222, 'Gloucestershire', 'GLS', 1),
(1274, 222, 'Greenwich', 'GRE', 1),
(1275, 222, 'Gwynedd', 'GWN', 1),
(1276, 222, 'Halton', 'HAL', 1),
(1277, 222, 'Hampshire', 'HAM', 1),
(1278, 222, 'Havering', 'HAV', 1),
(1279, 222, 'Hackney', 'HCK', 1),
(1280, 222, 'Herefordshire', 'HEF', 1),
(1281, 222, 'Hillingdon', 'HIL', 1),
(1282, 222, 'Highland', 'HLD', 1),
(1283, 222, 'Hammersmith and Fulham', 'HMF', 1),
(1284, 222, 'Hounslow', 'HNS', 1),
(1285, 222, 'Hartlepool', 'HPL', 1),
(1286, 222, 'Hertfordshire', 'HRT', 1),
(1287, 222, 'Harrow', 'HRW', 1),
(1288, 222, 'Haringey', 'HRY', 1),
(1289, 222, 'Isles of Scilly', 'IOS', 1),
(1290, 222, 'Isle of Wight', 'IOW', 1),
(1291, 222, 'Islington', 'ISL', 1),
(1292, 222, 'Inverclyde', 'IVC', 1),
(1293, 222, 'Kensington and Chelsea', 'KEC', 1),
(1294, 222, 'Kent', 'KEN', 1),
(1295, 222, 'Kingston upon Hull', 'KHL', 1),
(1296, 222, 'Kirklees', 'KIR', 1),
(1297, 222, 'Kingston upon Thames', 'KTT', 1),
(1298, 222, 'Knowsley', 'KWL', 1),
(1299, 222, 'Lancashire', 'LAN', 1),
(1300, 222, 'Lisburn and Castlereagh', 'LBC', 1),
(1301, 222, 'Lambeth', 'LBH', 1),
(1302, 222, 'Leicester', 'LCE', 1),
(1303, 222, 'Leeds', 'LDS', 1),
(1304, 222, 'Leicestershire', 'LEC', 1),
(1305, 222, 'Lewisham', 'LEW', 1),
(1306, 222, 'Lincolnshire', 'LIN', 1),
(1307, 222, 'Liverpool', 'LIV', 1),
(1308, 222, 'London, City of', 'LND', 1),
(1309, 222, 'Luton', 'LUT', 1),
(1310, 222, 'Manchester', 'MAN', 1),
(1311, 222, 'Middlesbrough', 'MDB', 1),
(1312, 222, 'Medway', 'MDW', 1),
(1313, 222, 'Mid and East Antrim', 'MEA', 1),
(1314, 222, 'Milton Keynes', 'MIK', 1),
(1315, 222, 'Midlothian', 'MLN', 1),
(1316, 222, 'Monmouthshire [Sir Fynwy GB-FYN]', 'MON', 1),
(1317, 222, 'Merton', 'MRT', 1),
(1318, 222, 'Moray', 'MRY', 1),
(1319, 222, 'Merthyr Tydfil [Merthyr Tudful GB-MTU]', 'MTY', 1),
(1320, 222, 'Mid Ulster', 'MUL', 1),
(1321, 222, 'North Ayrshire', 'NAY', 1),
(1322, 222, 'Northumberland', 'NBL', 1),
(1323, 222, 'North East Lincolnshire', 'NEL', 1),
(1324, 222, 'Newcastle upon Tyne', 'NET', 1),
(1325, 222, 'Norfolk', 'NFK', 1),
(1326, 222, 'Nottingham', 'NGM', 1),
(1327, 222, 'North Lanarkshire', 'NLK', 1),
(1328, 222, 'North Lincolnshire', 'NLN', 1),
(1329, 222, 'Newry, Mourne and Down', 'NMD', 1),
(1330, 222, 'North Somerset', 'NSM', 1),
(1331, 222, 'Northamptonshire', 'NTH', 1),
(1332, 222, 'Neath Port Talbot [Castell-nedd Port Talbot GB-CTL]', 'NTL', 1),
(1333, 222, 'Nottinghamshire', 'NTT', 1),
(1334, 222, 'North Tyneside', 'NTY', 1),
(1335, 222, 'Newham', 'NWM', 1),
(1336, 222, 'Newport [Casnewydd GB-CNW]', 'NWP', 1),
(1337, 222, 'North Yorkshire', 'NYK', 1),
(1338, 222, 'Oldham', 'OLD', 1),
(1339, 222, 'Orkney Islands', 'ORK', 1),
(1340, 222, 'Oxfordshire', 'OXF', 1),
(1341, 222, 'Pembrokeshire [Sir Benfro GB-BNF]', 'PEM', 1),
(1342, 222, 'Perth and Kinross', 'PKN', 1),
(1343, 222, 'Plymouth', 'PLY', 1),
(1344, 222, 'Poole', 'POL', 1),
(1345, 222, 'Portsmouth', 'POR', 1),
(1346, 222, 'Powys', 'POW', 1),
(1347, 222, 'Peterborough', 'PTE', 1),
(1348, 222, 'Redcar and Cleveland', 'RCC', 1),
(1349, 222, 'Rochdale', 'RCH', 1),
(1350, 222, 'Rhondda, Cynon, Taff [Rhondda, Cynon,Taf]', 'RCT', 1),
(1351, 222, 'Redbridge', 'RDB', 1),
(1352, 222, 'Reading', 'RDG', 1),
(1353, 222, 'Renfrewshire', 'RFW', 1),
(1354, 222, 'Richmond upon Thames', 'RIC', 1),
(1355, 222, 'Rotherham', 'ROT', 1),
(1356, 222, 'Rutland', 'RUT', 1),
(1357, 222, 'Sandwell', 'SAW', 1),
(1358, 222, 'South Ayrshire', 'SAY', 1),
(1359, 222, 'Scottish Borders, The', 'SCB', 1),
(1360, 222, 'Suffolk', 'SFK', 1),
(1361, 222, 'Sefton', 'SFT', 1),
(1362, 222, 'South Gloucestershire', 'SGC', 1),
(1363, 222, 'Sheffield', 'SHF', 1),
(1364, 222, 'St. Helens', 'SHN', 1),
(1365, 222, 'Shropshire', 'SHR', 1),
(1366, 222, 'Stockport', 'SKP', 1),
(1367, 222, 'Salford', 'SLF', 1),
(1368, 222, 'Slough', 'SLG', 1),
(1369, 222, 'South Lanarkshire', 'SLK', 1),
(1370, 222, 'Sunderland', 'SND', 1),
(1371, 222, 'Solihull', 'SOL', 1),
(1372, 222, 'Somerset', 'SOM', 1),
(1373, 222, 'Southend-on-Sea', 'SOS', 1),
(1374, 222, 'Surrey', 'SRY', 1),
(1375, 222, 'Stoke-on-Trent', 'STE', 1),
(1376, 222, 'Stirling', 'STG', 1),
(1377, 222, 'Southampton', 'STH', 1),
(1378, 222, 'Sutton', 'STN', 1),
(1379, 222, 'Staffordshire', 'STS', 1),
(1380, 222, 'Stockton-on-Tees', 'STT', 1),
(1381, 222, 'South Tyneside', 'STY', 1),
(1382, 222, 'Swansea [Abertawe GB-ATA]', 'SWA', 1),
(1383, 222, 'Swindon', 'SWD', 1),
(1384, 222, 'Southwark', 'SWK', 1),
(1385, 222, 'Tameside', 'TAM', 1),
(1386, 222, 'Telford and Wrekin', 'TFW', 1),
(1387, 222, 'Thurrock', 'THR', 1),
(1388, 222, 'Torbay', 'TOB', 1),
(1389, 222, 'Torfaen [Tor-faen]', 'TOF', 1),
(1390, 222, 'Trafford', 'TRF', 1),
(1391, 222, 'Tower Hamlets', 'TWH', 1),
(1392, 222, 'Vale of Glamorgan, The [Bro Morgannwg GB-BMG]', 'VGL', 1),
(1393, 222, 'Warwickshire', 'WAR', 1),
(1394, 222, 'West Berkshire', 'WBK', 1),
(1395, 222, 'West Dunbartonshire', 'WDU', 1),
(1396, 222, 'Waltham Forest', 'WFT', 1),
(1397, 222, 'Wigan', 'WGN', 1),
(1398, 222, 'Wiltshire', 'WIL', 1),
(1399, 222, 'Wakefield', 'WKF', 1),
(1400, 222, 'Walsall', 'WLL', 1),
(1401, 222, 'West Lothian', 'WLN', 1),
(1402, 222, 'Wolverhampton', 'WLV', 1),
(1403, 222, 'Wandsworth', 'WND', 1),
(1404, 222, 'Windsor and Maidenhead', 'WNM', 1),
(1405, 222, 'Wokingham', 'WOK', 1),
(1406, 222, 'Worcestershire', 'WOR', 1),
(1407, 222, 'Wirral', 'WRL', 1),
(1408, 222, 'Warrington', 'WRT', 1),
(1409, 222, 'Wrexham [Wrecsam GB-WRC]', 'WRX', 1),
(1410, 222, 'Westminster', 'WSM', 1),
(1411, 222, 'West Sussex', 'WSX', 1),
(1412, 222, 'York', 'YOR', 1),
(1413, 222, 'Shetland Islands', 'ZET', 1),
(1414, 86, 'Saint Andrew', '01', 1),
(1415, 86, 'Saint David', '02', 1),
(1416, 86, 'Saint George', '03', 1),
(1417, 86, 'Saint John', '04', 1),
(1418, 86, 'Saint Mark', '05', 1),
(1419, 86, 'Saint Patrick', '06', 1),
(1420, 86, 'Southern Grenadine Islands', '10', 1),
(1421, 80, 'Abkhazia', 'AB', 1),
(1422, 80, 'Ajaria', 'AJ', 1),
(1423, 80, 'Guria', 'GU', 1),
(1424, 80, 'Imeret''i', 'IM', 1),
(1425, 80, 'Kakhet''i', 'KA', 1),
(1426, 80, 'K''vemo K''art''li', 'KK', 1),
(1427, 80, 'Mts''khet''a-Mt''ianet''i', 'MM', 1),
(1428, 80, 'Racha-Lech’khumi-K’vemo Svanet’i', 'RL', 1),
(1429, 80, 'Samts''khe-Javakhet''i', 'SJ', 1),
(1430, 80, 'Shida K''art''li', 'SK', 1),
(1431, 80, 'Samegrelo-Zemo Svanet''i', 'SZ', 1),
(1432, 80, 'T''bilisi', 'TB', 1),
(1433, 82, 'Greater Accra', 'AA', 1),
(1434, 82, 'Ashanti', 'AH', 1),
(1435, 82, 'Brong-Ahafo', 'BA', 1),
(1436, 82, 'Central', 'CP', 1),
(1437, 82, 'Eastern', 'EP', 1),
(1438, 82, 'Northern', 'NP', 1),
(1439, 82, 'Volta', 'TV', 1),
(1440, 82, 'Upper East', 'UE', 1),
(1441, 82, 'Upper West', 'UW', 1),
(1442, 82, 'Western', 'WP', 1),
(1443, 85, 'Kommune Kujalleq', 'KU', 1),
(1444, 85, 'Qaasuitsup Kommunia', 'QA', 1),
(1445, 85, 'Qeqqata Kommunia', 'QE', 1),
(1446, 85, 'Kommuneqarfik Sermersooq', 'SM', 1),
(1447, 79, 'Banjul', 'B', 1),
(1448, 79, 'Lower River', 'L', 1),
(1449, 79, 'Central River', 'M', 1),
(1450, 79, 'North Bank', 'N', 1),
(1451, 79, 'Upper River', 'U', 1),
(1452, 79, 'Western', 'W', 1),
(1453, 90, 'Beyla', 'BE', 1),
(1454, 90, 'Boffa', 'BF', 1),
(1455, 90, 'Boké', 'BK', 1),
(1456, 90, 'Coyah', 'CO', 1),
(1457, 90, 'Dabola', 'DB', 1),
(1458, 90, 'Dinguiraye', 'DI', 1),
(1459, 90, 'Dalaba', 'DL', 1),
(1460, 90, 'Dubréka', 'DU', 1),
(1461, 90, 'Faranah', 'FA', 1),
(1462, 90, 'Forécariah', 'FO', 1),
(1463, 90, 'Fria', 'FR', 1),
(1464, 90, 'Gaoual', 'GA', 1),
(1465, 90, 'Guékédou', 'GU', 1),
(1466, 90, 'Kankan', 'KA', 1),
(1467, 90, 'Koubia', 'KB', 1),
(1468, 90, 'Kindia', 'KD', 1),
(1469, 90, 'Kérouané', 'KE', 1),
(1470, 90, 'Koundara', 'KN', 1),
(1471, 90, 'Kouroussa', 'KO', 1),
(1472, 90, 'Kissidougou', 'KS', 1),
(1473, 90, 'Labé', 'LA', 1),
(1474, 90, 'Lélouma', 'LE', 1),
(1475, 90, 'Lola', 'LO', 1),
(1476, 90, 'Macenta', 'MC', 1),
(1477, 90, 'Mandiana', 'MD', 1),
(1478, 90, 'Mali', 'ML', 1),
(1479, 90, 'Mamou', 'MM', 1),
(1480, 90, 'Nzérékoré', 'NZ', 1),
(1481, 90, 'Pita', 'PI', 1),
(1482, 90, 'Siguiri', 'SI', 1),
(1483, 90, 'Télimélé', 'TE', 1),
(1484, 90, 'Tougué', 'TO', 1),
(1485, 90, 'Yomou', 'YO', 1),
(1486, 65, 'Annobón', 'AN', 1),
(1487, 65, 'Bioko Norte', 'BN', 1),
(1488, 65, 'Bioko Sur', 'BS', 1),
(1489, 65, 'Centro Sur', 'CS', 1),
(1490, 65, 'Kié-Ntem', 'KN', 1),
(1491, 65, 'Litoral', 'LI', 1),
(1492, 65, 'Wele-Nzas', 'WN', 1),
(1493, 84, 'Aitoloakarnanía', '01', 1),
(1494, 84, 'Voiotia', '03', 1),
(1495, 84, 'Evvoia', '04', 1),
(1496, 84, 'Evrytania', '05', 1),
(1497, 84, 'Fthiotida', '06', 1),
(1498, 84, 'Fokida', '07', 1),
(1499, 84, 'Argolida', '11', 1),
(1500, 84, 'Arkadia', '12', 1),
(1501, 84, 'Achaďa', '13', 1),
(1502, 84, 'Ileia', '14', 1),
(1503, 84, 'Korinthia', '15', 1),
(1504, 84, 'Lakonia', '16', 1),
(1505, 84, 'Messinia', '17', 1),
(1506, 84, 'Zakynthos', '21', 1),
(1507, 84, 'Kerkyra', '22', 1),
(1508, 84, 'Kefallinía', '23', 1),
(1509, 84, 'Lefkada', '24', 1),
(1510, 84, 'Arta', '31', 1),
(1511, 84, 'Thesprotia', '32', 1),
(1512, 84, 'Ioannina', '33', 1),
(1513, 84, 'Preveza', '34', 1),
(1514, 84, 'Karditsa', '41', 1),
(1515, 84, 'Larisa', '42', 1),
(1516, 84, 'Magnisia', '43', 1),
(1517, 84, 'Trikala', '44', 1),
(1518, 84, 'Grevena', '51', 1),
(1519, 84, 'Drama', '52', 1),
(1520, 84, 'Imathia', '53', 1),
(1521, 84, 'Thessaloniki', '54', 1),
(1522, 84, 'Kavala', '55', 1),
(1523, 84, 'Kastoria', '56', 1),
(1524, 84, 'Kilkis', '57', 1),
(1525, 84, 'Kozani', '58', 1),
(1526, 84, 'Pella', '59', 1),
(1527, 84, 'Pieria', '61', 1),
(1528, 84, 'Serres', '62', 1),
(1529, 84, 'Florina', '63', 1),
(1530, 84, 'Chalkidiki', '64', 1),
(1531, 84, 'Ágion Óros', '69', 1);
INSERT INTO `#__djc2_countries_states` (`id`, `country_id`, `name`, `state_code`, `published`) VALUES
(1532, 84, 'Evros', '71', 1),
(1533, 84, 'Xanthi', '72', 1),
(1534, 84, 'Rodopi', '73', 1),
(1535, 84, 'Dodekánisa', '81', 1),
(1536, 84, 'Kyklades', '82', 1),
(1537, 84, 'Lesvos', '83', 1),
(1538, 84, 'Samos', '84', 1),
(1539, 84, 'Chios', '85', 1),
(1540, 84, 'Irakleio', '91', 1),
(1541, 84, 'Lasithi', '92', 1),
(1542, 84, 'Rethýmnis', '93', 1),
(1543, 84, 'Chania', '94', 1),
(1544, 84, 'Attiki', 'A1', 1),
(1545, 89, 'Alta Verapaz', 'AV', 1),
(1546, 89, 'Baja Verapaz', 'BV', 1),
(1547, 89, 'Chimaltenango', 'CM', 1),
(1548, 89, 'Chiquimula', 'CQ', 1),
(1549, 89, 'Escuintla', 'ES', 1),
(1550, 89, 'Guatemala', 'GU', 1),
(1551, 89, 'Huehuetenango', 'HU', 1),
(1552, 89, 'Izabal', 'IZ', 1),
(1553, 89, 'Jalapa', 'JA', 1),
(1554, 89, 'Jutiapa', 'JU', 1),
(1555, 89, 'Petén', 'PE', 1),
(1556, 89, 'El Progreso', 'PR', 1),
(1557, 89, 'Quiché', 'QC', 1),
(1558, 89, 'Quetzaltenango', 'QZ', 1),
(1559, 89, 'Retalhuleu', 'RE', 1),
(1560, 89, 'Sacatepéquez', 'SA', 1),
(1561, 89, 'San Marcos', 'SM', 1),
(1562, 89, 'Sololá', 'SO', 1),
(1563, 89, 'Santa Rosa', 'SR', 1),
(1564, 89, 'Suchitepéquez', 'SU', 1),
(1565, 89, 'Totonicapán', 'TO', 1),
(1566, 89, 'Zacapa', 'ZA', 1),
(1567, 91, 'Bafatá', 'BA', 1),
(1568, 91, 'Bolama', 'BL', 1),
(1569, 91, 'Biombo', 'BM', 1),
(1570, 91, 'Bissau', 'BS', 1),
(1571, 91, 'Cacheu', 'CA', 1),
(1572, 91, 'Gabú', 'GA', 1),
(1573, 91, 'Oio', 'OI', 1),
(1574, 91, 'Quinara', 'QU', 1),
(1575, 91, 'Tombali ', 'TO', 1),
(1576, 92, 'Barima-Waini', 'BA', 1),
(1577, 92, 'Cuyuni-Mazaruni', 'CU', 1),
(1578, 92, 'Demerara-Mahaica', 'DE', 1),
(1579, 92, 'East Berbice-Corentyne', 'EB', 1),
(1580, 92, 'Essequibo Islands-West Demerara', 'ES', 1),
(1581, 92, 'Mahaica-Berbice', 'MA', 1),
(1582, 92, 'Pomeroon-Supenaam', 'PM', 1),
(1583, 92, 'Potaro-Siparuni', 'PT', 1),
(1584, 92, 'Upper Demerara-Berbice', 'UD', 1),
(1585, 92, 'Upper Takutu-Upper Essequibo', 'UT', 1),
(1586, 95, 'Atlántida', 'AT', 1),
(1587, 95, 'Choluteca', 'CH', 1),
(1588, 95, 'Colón', 'CL', 1),
(1589, 95, 'Comayagua', 'CM', 1),
(1590, 95, 'Copán', 'CP', 1),
(1591, 95, 'Cortés', 'CR', 1),
(1592, 95, 'El Paraíso', 'EP', 1),
(1593, 95, 'Francisco Morazán', 'FM', 1),
(1594, 95, 'Gracias a Dios', 'GD', 1),
(1595, 95, 'Islas de la Bahía', 'IB', 1),
(1596, 95, 'Intibucá', 'IN', 1),
(1597, 95, 'Lempira', 'LE', 1),
(1598, 95, 'La Paz', 'LP', 1),
(1599, 95, 'Ocotepeque', 'OC', 1),
(1600, 95, 'Olancho', 'OL', 1),
(1601, 95, 'Santa Bárbara', 'SB', 1),
(1602, 95, 'Valle', 'VA', 1),
(1603, 95, 'Yoro', 'YO', 1),
(1604, 53, 'Zagrebacka županija', '01', 1),
(1605, 53, 'Krapinsko-zagorska županija', '02', 1),
(1606, 53, 'Sisacko-moslavacka županija', '03', 1),
(1607, 53, 'Karlovacka županija', '04', 1),
(1608, 53, 'Varaždinska županija', '05', 1),
(1609, 53, 'Koprivnicko-križevacka županija', '06', 1),
(1610, 53, 'Bjelovarsko-bilogorska županija', '07', 1),
(1611, 53, 'Primorsko-goranska županija', '08', 1),
(1612, 53, 'Licko-senjska županija', '09', 1),
(1613, 53, 'Viroviticko-podravska županija', '10', 1),
(1614, 53, 'Požeško-slavonska županija', '11', 1),
(1615, 53, 'Brodsko-posavska županija', '12', 1),
(1616, 53, 'Zadarska županija', '13', 1),
(1617, 53, 'Osjecko-baranjska županija', '14', 1),
(1618, 53, 'Šibensko-kninska županija', '15', 1),
(1619, 53, 'Vukovarsko-srijemska županija', '16', 1),
(1620, 53, 'Splitsko-dalmatinska županija', '17', 1),
(1621, 53, 'Istarska županija', '18', 1),
(1622, 53, 'Dubrovacko-neretvanska županija', '19', 1),
(1623, 53, 'Medimurska županija', '20', 1),
(1624, 53, 'Grad Zagreb', '21', 1),
(1625, 93, 'Artibonite', 'AR', 1),
(1626, 93, 'Centre', 'CE', 1),
(1627, 93, 'Grande’Anse', 'GA', 1),
(1628, 93, 'Nord', 'ND', 1),
(1629, 93, 'Nord-Est', 'NE', 1),
(1630, 93, 'Nippes', 'NI', 1),
(1631, 93, 'Nord-Ouest', 'NO', 1),
(1632, 93, 'Ouest', 'OU', 1),
(1633, 93, 'Sud', 'SD', 1),
(1634, 93, 'Sud-Est', 'SE', 1),
(1635, 97, 'Baranya', 'BA', 1),
(1636, 97, 'Békéscsaba', 'BC', 1),
(1637, 97, 'Békés', 'BE', 1),
(1638, 97, 'Bács-Kiskun', 'BK', 1),
(1639, 97, 'Budapest', 'BU', 1),
(1640, 97, 'Borsod-Abaúj-Zemplén', 'BZ', 1),
(1641, 97, 'Csongrád', 'CS', 1),
(1642, 97, 'Debrecen', 'DE', 1),
(1643, 97, 'Dunaújváros', 'DU', 1),
(1644, 97, 'Eger', 'EG', 1),
(1645, 97, 'Érd', 'ER', 1),
(1646, 97, 'Fejér', 'FE', 1),
(1647, 97, 'Gyor-Moson-Sopron', 'GS', 1),
(1648, 97, 'Gyor', 'GY', 1),
(1649, 97, 'Hajdú-Bihar', 'HB', 1),
(1650, 97, 'Heves', 'HE', 1),
(1651, 97, 'Hódmezovásárhely', 'HV', 1),
(1652, 97, 'Jász-Nagykun-Szolnok', 'JN', 1),
(1653, 97, 'Komárom-Esztergom', 'KE', 1),
(1654, 97, 'Kecskemét', 'KM', 1),
(1655, 97, 'Kaposvár', 'KV', 1),
(1656, 97, 'Miskolc', 'MI', 1),
(1657, 97, 'Nagykanizsa', 'NK', 1),
(1658, 97, 'Nógrád', 'NO', 1),
(1659, 97, 'Nyíregyháza', 'NY', 1),
(1660, 97, 'Pest', 'PE', 1),
(1661, 97, 'Pécs', 'PS', 1),
(1662, 97, 'Szeged', 'SD', 1),
(1663, 97, 'Székesfehérvár', 'SF', 1),
(1664, 97, 'Szombathely', 'SH', 1),
(1665, 97, 'Szolnok', 'SK', 1),
(1666, 97, 'Sopron', 'SN', 1),
(1667, 97, 'Somogy', 'SO', 1),
(1668, 97, 'Szekszárd', 'SS', 1),
(1669, 97, 'Salgótarján', 'ST', 1),
(1670, 97, 'Szabolcs-Szatmár-Bereg', 'SZ', 1),
(1671, 97, 'Tatabánya', 'TB', 1),
(1672, 97, 'Tolna', 'TO', 1),
(1673, 97, 'Vas', 'VA', 1),
(1674, 97, 'Veszprém', 'VE', 1),
(1675, 97, 'Veszprém', 'VM', 1),
(1676, 97, 'Zala', 'ZA', 1),
(1677, 97, 'Zalaegerszeg', 'ZE', 1),
(1678, 100, 'Aceh', 'AC', 1),
(1679, 100, 'Bali', 'BA', 1),
(1680, 100, 'Bangka Belitung', 'BB', 1),
(1681, 100, 'Bengkulu', 'BE', 1),
(1682, 100, 'Banten', 'BT', 1),
(1683, 100, 'Gorontalo', 'GO', 1),
(1684, 100, 'Jambi', 'JA', 1),
(1685, 100, 'Jawa Barat', 'JB', 1),
(1686, 100, 'Jawa Timur', 'JI', 1),
(1687, 100, 'Jakarta Raya', 'JK', 1),
(1688, 100, 'Jawa Tengah', 'JT', 1),
(1689, 100, 'Kalimantan Barat', 'KB', 1),
(1690, 100, 'Kalimantan Timur', 'KI', 1),
(1691, 100, 'Kepulauan Riau', 'KR', 1),
(1692, 100, 'Kalimantan Selatan', 'KS', 1),
(1693, 100, 'Kalimantan Tengah', 'KT', 1),
(1694, 100, 'Kalimantan Utara', 'KU', 1),
(1695, 100, 'Lampung', 'LA', 1),
(1696, 100, 'Maluku', 'MA', 1),
(1697, 100, 'Maluku Utara', 'MU', 1),
(1698, 100, 'Nusa Tenggara Barat', 'NB', 1),
(1699, 100, 'Nusa Tenggara Timur', 'NT', 1),
(1700, 100, 'Papua', 'PA', 1),
(1701, 100, 'Papua Barat', 'PB', 1),
(1702, 100, 'Riau', 'RI', 1),
(1703, 100, 'Sulawesi Utara', 'SA', 1),
(1704, 100, 'Sumatera Barat', 'SB', 1),
(1705, 100, 'Sulawesi Tenggara', 'SG', 1),
(1706, 100, 'Sulawesi Selatan', 'SN', 1),
(1707, 100, 'Sulawesi Barat', 'SR', 1),
(1708, 100, 'Sumatera Selatan', 'SS', 1),
(1709, 100, 'Sulawesi Tengah', 'ST', 1),
(1710, 100, 'Sumatera Utara', 'SU', 1),
(1711, 100, 'Yogyakarta', 'YO', 1),
(1712, 103, 'Clare', 'CE', 1),
(1713, 103, 'Cavan', 'CN', 1),
(1714, 103, 'Cork', 'CO', 1),
(1715, 103, 'Carlow', 'CW', 1),
(1716, 103, 'Dublin', 'D', 1),
(1717, 103, 'Donegal', 'DL', 1),
(1718, 103, 'Galway', 'G', 1),
(1719, 103, 'Kildare', 'KE', 1),
(1720, 103, 'Kilkenny', 'KK', 1),
(1721, 103, 'Kerry', 'KY', 1),
(1722, 103, 'Longford', 'LD', 1),
(1723, 103, 'Louth', 'LH', 1),
(1724, 103, 'Limerick', 'LK', 1),
(1725, 103, 'Leitrim', 'LM', 1),
(1726, 103, 'Laois', 'LS', 1),
(1727, 103, 'Meath', 'MH', 1),
(1728, 103, 'Monaghan', 'MN', 1),
(1729, 103, 'Mayo', 'MO', 1),
(1730, 103, 'Offaly', 'OY', 1),
(1731, 103, 'Roscommon', 'RN', 1),
(1732, 103, 'Sligo', 'SO', 1),
(1733, 103, 'Tipperary', 'TA', 1),
(1734, 103, 'Waterford', 'WD', 1),
(1735, 103, 'Westmeath', 'WH', 1),
(1736, 103, 'Wicklow', 'WW', 1),
(1737, 103, 'Wexford', 'WX', 1),
(1738, 104, 'HaDarom', 'D', 1),
(1739, 104, ' H_efa', 'HA', 1),
(1740, 104, 'Yerushalayim', 'JM', 1),
(1741, 104, 'HaMerkaz', 'M', 1),
(1742, 104, 'Tel-Aviv', 'TA', 1),
(1743, 104, 'HaTsafon', 'Z', 1),
(1744, 99, 'Andaman and Nicobar Islands', 'AN', 1),
(1745, 99, 'Andhra Pradesh', 'AP', 1),
(1746, 99, 'Arunachal Pradesh', 'AR', 1),
(1747, 99, 'Assam', 'AS', 1),
(1748, 99, 'Bihar', 'BR', 1),
(1749, 99, 'Chandigarh', 'CH', 1),
(1750, 99, 'Chhattisgarh', 'CT', 1),
(1751, 99, 'Daman and Diu', 'DD', 1),
(1752, 99, 'Delhi', 'DL', 1),
(1753, 99, 'Dadra and Nagar Haveli', 'DN', 1),
(1754, 99, 'Goa', 'GA', 1),
(1755, 99, 'Gujarat', 'GJ', 1),
(1756, 99, 'Himachal Pradesh', 'HP', 1),
(1757, 99, 'Haryana', 'HR', 1),
(1758, 99, 'Jharkhand', 'JH', 1),
(1759, 99, 'Jammu and Kashmir', 'JK', 1),
(1760, 99, 'Karnataka', 'KA', 1),
(1761, 99, 'Kerala', 'KL', 1),
(1762, 99, 'Lakshadweep', 'LD', 1),
(1763, 99, 'Maharashtra', 'MH', 1),
(1764, 99, 'Meghalaya', 'ML', 1),
(1765, 99, 'Manipur', 'MN', 1),
(1766, 99, 'Madhya Pradesh', 'MP', 1),
(1767, 99, 'Mizoram', 'MZ', 1),
(1768, 99, 'Nagaland', 'NL', 1),
(1769, 99, 'Odisha', 'OR', 1),
(1770, 99, 'Punjab', 'PB', 1),
(1771, 99, 'Puducherry', 'PY', 1),
(1772, 99, 'Rajasthan', 'RJ', 1),
(1773, 99, 'Sikkim', 'SK', 1),
(1774, 99, 'Telangana', 'TG', 1),
(1775, 99, 'Tamil Nadu', 'TN', 1),
(1776, 99, 'Tripura', 'TR', 1),
(1777, 99, 'Uttar Pradesh', 'UP', 1),
(1778, 99, 'Uttarakhand', 'UT', 1),
(1779, 99, 'West Bengal', 'WB', 1),
(1780, 102, 'AI Anbar', 'AN', 1),
(1781, 102, 'Arbil', 'AR', 1),
(1782, 102, 'Al Basrah', 'BA', 1),
(1783, 102, 'Babil', 'BB', 1),
(1784, 102, 'Baghdad', 'BG', 1),
(1785, 102, 'Dahuk', 'DA', 1),
(1786, 102, 'Diyalá', 'DI', 1),
(1787, 102, 'Dhi Qar', 'DQ', 1),
(1788, 102, 'Karbala''', 'KA', 1),
(1789, 102, 'Kirkuk', 'KI', 1),
(1790, 102, 'Maysan', 'MA', 1),
(1791, 102, 'AI Muthanná', 'MU', 1),
(1792, 102, 'An Najaf', 'NA', 1),
(1793, 102, 'Ninawá', 'NI', 1),
(1794, 102, 'Al Qadisiyah', 'QA', 1),
(1795, 102, 'Salah ad Din', 'SD', 1),
(1796, 102, 'As Sulaymaniyah', 'SU', 1),
(1797, 102, 'Wasit', 'WA', 1),
(1798, 101, 'AZarbayjan-e Sharqi', '01', 1),
(1799, 101, 'AZarbayjan-e Gharbi', '02', 1),
(1800, 101, 'Ardabil', '03', 1),
(1801, 101, 'Esfahan', '04', 1),
(1802, 101, 'Ilam', '05', 1),
(1803, 101, 'Bushehr', '06', 1),
(1804, 101, 'Tehran', '07', 1),
(1805, 101, 'Chahar Ma?al va Bakhtiari', '08', 1),
(1806, 101, 'Khuzestan', '10', 1),
(1807, 101, 'Zanjan', '11', 1),
(1808, 101, 'Semnan', '12', 1),
(1809, 101, 'Sistan va Baluchestan', '13', 1),
(1810, 101, 'Fars', '14', 1),
(1811, 101, 'Kerman', '15', 1),
(1812, 101, 'Kordestan', '16', 1),
(1813, 101, 'Kermanshah', '17', 1),
(1814, 101, 'Kohgiluyeh va Bowyer A?mad', '18', 1),
(1815, 101, 'Gilan', '19', 1),
(1816, 101, 'Lorestan', '20', 1),
(1817, 101, 'Mazandaran', '21', 1),
(1818, 101, 'Markazi', '22', 1),
(1819, 101, 'Hormozgan', '23', 1),
(1820, 101, 'Hamadan', '24', 1),
(1821, 101, 'Yazd', '25', 1),
(1822, 101, 'Qom', '26', 1),
(1823, 101, 'Golestan', '27', 1),
(1824, 101, 'Qazvin', '28', 1),
(1825, 101, 'Khorasan-e Jonubi', '29', 1),
(1826, 101, '	Khorasan-e Ra?avi', '30', 1),
(1827, 101, 'Khorasan-e Shomali', '31', 1),
(1828, 101, 'Alborz', '32', 1),
(1829, 98, 'Höfuđborgarsvćđi utan Reykjavíkur', '1', 1),
(1830, 98, 'Suđurnes', '2', 1),
(1831, 98, 'Vesturland', '3', 1),
(1832, 98, 'Vestfirđir', '4', 1),
(1833, 98, 'Norđurland vestra', '5', 1),
(1834, 98, 'Norđurland eystra', '6', 1),
(1835, 98, 'Austurland', '7', 1),
(1836, 98, 'Suđurland', '8', 1),
(1837, 105, 'Agrigento', 'AG', 1),
(1838, 105, 'Alessandria', 'AL', 1),
(1839, 105, 'Ancona', 'AN', 1),
(1840, 105, 'Aosta / Aoste (fr)', 'AO', 1),
(1841, 105, 'Ascoli Piceno', 'AP', 1),
(1842, 105, 'L''Aquila', 'AQ', 1),
(1843, 105, 'Arezzo', 'AR', 1),
(1844, 105, 'Asti', 'AT', 1),
(1845, 105, 'Avellino', 'AV', 1),
(1846, 105, 'Bari', 'BA', 1),
(1847, 105, 'Bergamo', 'BG', 1),
(1848, 105, 'Biella', 'BI', 1),
(1849, 105, 'Belluno', 'BL', 1),
(1850, 105, 'Benevento', 'BN', 1),
(1851, 105, 'Bologna', 'BO', 1),
(1852, 105, 'Brindisi', 'BR', 1),
(1853, 105, 'Brescia', 'BS', 1),
(1854, 105, 'Barletta-Andria-Trani', 'BT', 1),
(1855, 105, 'Bolzano / Bozen (de)', 'BZ', 1),
(1856, 105, 'Cagliari', 'CA', 1),
(1857, 105, 'Campobasso', 'CB', 1),
(1858, 105, 'Caserta', 'CE', 1),
(1859, 105, 'Chieti', 'CH', 1),
(1860, 105, 'Carbonia-Iglesias', 'CI', 1),
(1861, 105, 'Caltanissetta', 'CL', 1),
(1862, 105, 'Cuneo', 'CN', 1),
(1863, 105, 'Como', 'CO', 1),
(1864, 105, 'Cremona', 'CR', 1),
(1865, 105, 'Cosenza', 'CS', 1),
(1866, 105, 'Catania', 'CT', 1),
(1867, 105, 'Catanzaro', 'CZ', 1),
(1868, 105, 'Enna', 'EN', 1),
(1869, 105, 'Forlě-Cesena', 'FC', 1),
(1870, 105, 'Ferrara', 'FE', 1),
(1871, 105, 'Foggia', 'FG', 1),
(1872, 105, 'Firenze', 'FI', 1),
(1873, 105, 'Fermo', 'FM', 1),
(1874, 105, 'Frosinone', 'FR', 1),
(1875, 105, 'Genova', 'GE', 1),
(1876, 105, 'Gorizia', 'GO', 1),
(1877, 105, 'Grosseto', 'GR', 1),
(1878, 105, 'Imperia', 'IM', 1),
(1879, 105, 'Isernia', 'IS', 1),
(1880, 105, 'Crotone', 'KR', 1),
(1881, 105, 'Lecco', 'LC', 1),
(1882, 105, 'Lecce', 'LE', 1),
(1883, 105, 'Livorno', 'LI', 1),
(1884, 105, 'Lodi', 'LO', 1),
(1885, 105, 'Latina', 'LT', 1),
(1886, 105, 'Lucca', 'LU', 1),
(1887, 105, 'Monza e Brianza', 'MB', 1),
(1888, 105, 'Macerata', 'MC', 1),
(1889, 105, 'Messina', 'ME', 1),
(1890, 105, 'Milano', 'MI', 1),
(1891, 105, 'Mantova', 'MN', 1),
(1892, 105, 'Modena', 'MO', 1),
(1893, 105, 'Massa-Carrara', 'MS', 1),
(1894, 105, 'Matera', 'MT', 1),
(1895, 105, 'Napoli', 'NA', 1),
(1896, 105, 'Novara', 'NO', 1),
(1897, 105, 'Nuoro', 'NU', 1),
(1898, 105, 'Ogliastra', 'OG', 1),
(1899, 105, 'Oristano', 'OR', 1),
(1900, 105, 'Olbia-Tempio', 'OT', 1),
(1901, 105, 'Palermo', 'PA', 1),
(1902, 105, 'Piacenza', 'PC', 1),
(1903, 105, 'Padova', 'PD', 1),
(1904, 105, 'Pescara', 'PE', 1),
(1905, 105, 'Perugia', 'PG', 1),
(1906, 105, 'Pisa', 'PI', 1),
(1907, 105, 'Pordenone', 'PN', 1),
(1908, 105, 'Prato', 'PO', 1),
(1909, 105, 'Parma', 'PR', 1),
(1910, 105, 'Pistoia', 'PT', 1),
(1911, 105, 'Pesaro e Urbino', 'PU', 1),
(1912, 105, 'Pavia', 'PV', 1),
(1913, 105, 'Potenza', 'PZ', 1),
(1914, 105, 'Ravenna', 'RA', 1),
(1915, 105, 'Reggio Calabria', 'RC', 1),
(1916, 105, 'Reggio Emilia', 'RE', 1),
(1917, 105, 'Ragusa', 'RG', 1),
(1918, 105, 'Rieti', 'RI', 1),
(1919, 105, 'Roma', 'RM', 1),
(1920, 105, 'Rimini', 'RN', 1),
(1921, 105, 'Rovigo', 'RO', 1),
(1922, 105, 'Salerno', 'SA', 1),
(1923, 105, 'Siena', 'SI', 1),
(1924, 105, 'Sondrio', 'SO', 1),
(1925, 105, 'La Spezia', 'SP', 1),
(1926, 105, 'Siracusa', 'SR', 1),
(1927, 105, 'Sassari', 'SS', 1),
(1928, 105, 'Savona', 'SV', 1),
(1929, 105, 'Taranto', 'TA', 1),
(1930, 105, 'Teramo', 'TE', 1),
(1931, 105, 'Trento', 'TN', 1),
(1932, 105, 'Torino', 'TO', 1),
(1933, 105, 'Trapani', 'TP', 1),
(1934, 105, 'Terni', 'TR', 1),
(1935, 105, 'Trieste', 'TS', 1),
(1936, 105, 'Treviso', 'TV', 1),
(1937, 105, 'Udine', 'UD', 1),
(1938, 105, 'Varese', 'VA', 1),
(1939, 105, 'Verbano-Cusio-Ossola', 'VB', 1),
(1940, 105, 'Vercelli', 'VC', 1),
(1941, 105, 'Venezia', 'VE', 1),
(1942, 105, 'Vicenza', 'VI', 1),
(1943, 105, 'Verona', 'VR', 1),
(1944, 105, 'Medio Campidano', 'VS', 1),
(1945, 105, 'Viterbo', 'VT', 1),
(1946, 105, 'Vibo Valentia', 'VV', 1),
(1947, 106, 'Kingston', '01', 1),
(1948, 106, 'Saint Andrew', '02', 1),
(1949, 106, 'Saint Thomas', '03', 1),
(1950, 106, 'Portland', '04', 1),
(1951, 106, 'Saint Mary', '05', 1),
(1952, 106, 'Saint Ann', '06', 1),
(1953, 106, 'Trelawny', '07', 1),
(1954, 106, 'Saint James', '08', 1),
(1955, 106, 'Hanover', '09', 1),
(1956, 106, 'Westmoreland', '10', 1),
(1957, 106, 'Saint Elizabeth', '11', 1),
(1958, 106, 'Manchester', '12', 1),
(1959, 106, 'Clarendon', '13', 1),
(1960, 106, 'Saint Catherine', '14', 1),
(1961, 108, '	‘Ajlun', 'AJ', 1),
(1962, 108, 'Al ‘AŻsimah', 'AM', 1),
(1963, 108, '	Al ‘Aqabah', 'AQ', 1),
(1964, 108, 'At Tafilah', 'AT', 1),
(1965, 108, 'Az Zarqa’', 'AZ', 1),
(1966, 108, 'Al Balqa’', 'BA', 1),
(1967, 108, 'Irbid', 'IR', 1),
(1968, 108, 'Jarash', 'JA', 1),
(1969, 108, 'AI Karak', 'KA', 1),
(1970, 108, 'AI Mafraq', 'MA', 1),
(1971, 108, 'Madaba', 'MD', 1),
(1972, 108, 'Ma‘an', 'MN', 1),
(1973, 107, 'Hokkaidô [Hokkaido]', '01', 1),
(1974, 107, 'Aomori', '02', 1),
(1975, 107, 'Iwate', '03', 1),
(1976, 107, 'Miyagi', '04', 1),
(1977, 107, 'Akita', '05', 1),
(1978, 107, 'Yamagata', '06', 1),
(1979, 107, 'Hukusima [Fukushima]', '07', 1),
(1980, 107, 'Ibaraki', '08', 1),
(1981, 107, 'Totigi [Tochigi]', '09', 1),
(1982, 107, 'Gunma', '10', 1),
(1983, 107, 'Saitama', '11', 1),
(1984, 107, 'Tiba [Chiba]', '12', 1),
(1985, 107, 'Tôkyô [Tokyo]', '13', 1),
(1986, 107, 'Kanagawa', '14', 1),
(1987, 107, 'Niigata', '15', 1),
(1988, 107, 'Toyama', '16', 1),
(1989, 107, 'Isikawa [Ishikawa]', '17', 1),
(1990, 107, 'Hukui [Fukui]', '18', 1),
(1991, 107, 'Yamanasi [Yamanashi]', '19', 1),
(1992, 107, 'Nagano', '20', 1),
(1993, 107, 'Gihu [Gifu]', '21', 1),
(1994, 107, 'Sizuoka [Shizuoka]', '22', 1),
(1995, 107, 'Aiti [Aichi]', '23', 1),
(1996, 107, 'Mie', '24', 1),
(1997, 107, 'Siga [Shiga]', '25', 1),
(1998, 107, 'Hyôgo [Kyoto]', '26', 1),
(1999, 107, 'Ôsaka [Osaka]', '27', 1),
(2000, 107, 'Hyôgo[Hyogo]', '28', 1),
(2001, 107, 'Nara', '29', 1),
(2002, 107, 'Wakayama', '30', 1),
(2003, 107, 'Tottori', '31', 1),
(2004, 107, 'Simane [Shimane]', '32', 1),
(2005, 107, 'Okayama', '33', 1),
(2006, 107, 'Hirosima [Hiroshima]', '34', 1),
(2007, 107, 'Yamaguti [Yamaguchi]', '35', 1),
(2008, 107, 'Tokusima [Tokushima]', '36', 1),
(2009, 107, 'Kagawa', '37', 1),
(2010, 107, 'Ehime', '38', 1),
(2011, 107, 'Kôti [Kochi]', '39', 1),
(2012, 107, 'Hukuoka [Fukuoka]', '40', 1),
(2013, 107, 'Saga', '41', 1),
(2014, 107, 'Nagasaki', '42', 1),
(2015, 107, 'Kumamoto', '43', 1),
(2016, 107, 'Ôita [Oita]', '44', 1),
(2017, 107, 'Miyazaki', '45', 1),
(2018, 107, 'Kagosima [Kagoshima]', '46', 1),
(2019, 107, 'Okinawa', '47', 1),
(2020, 110, 'Baringo', '01', 1),
(2021, 110, 'Bomet', '02', 1),
(2022, 110, 'Bungoma', '03', 1),
(2023, 110, 'Busia', '04', 1),
(2024, 110, 'Elgeyo/Marakwet', '05', 1),
(2025, 110, 'Embu', '06', 1),
(2026, 110, 'Garissa', '07', 1),
(2027, 110, 'Homa Bay', '08', 1),
(2028, 110, 'Isiolo', '09', 1),
(2029, 110, 'Kajiado', '10', 1),
(2030, 110, 'Kakamega', '11', 1),
(2031, 110, 'Kericho', '12', 1),
(2032, 110, 'Kiambu', '13', 1),
(2033, 110, 'Kilifi', '14', 1),
(2034, 110, 'Kirinyaga', '15', 1),
(2035, 110, 'Kisii', '16', 1),
(2036, 110, 'Kisumu', '17', 1),
(2037, 110, 'Kitui', '18', 1),
(2038, 110, 'Kwale', '19', 1),
(2039, 110, 'Laikipia', '20', 1),
(2040, 110, 'Lamu', '21', 1),
(2041, 110, 'Machakos', '22', 1),
(2042, 110, 'Makueni', '23', 1),
(2043, 110, 'Mandera', '24', 1),
(2044, 110, 'Marsabit', '25', 1),
(2045, 110, 'Meru', '26', 1),
(2046, 110, 'Migori', '27', 1),
(2047, 110, 'Mombasa', '28', 1),
(2048, 110, 'Murang''a', '29', 1),
(2049, 110, 'Nairobi City', '30', 1),
(2050, 110, 'Nakuru', '31', 1),
(2051, 110, 'Nandi', '32', 1),
(2052, 110, 'Narok', '33', 1),
(2053, 110, 'Nyamira', '34', 1),
(2054, 110, 'Nyandarua', '35', 1),
(2055, 110, 'Nyeri', '36', 1),
(2056, 110, 'Samburu', '37', 1),
(2057, 110, 'Siaya', '38', 1),
(2058, 110, 'Taita/Taveta', '39', 1),
(2059, 110, 'Tana River', '40', 1),
(2060, 110, 'Tharaka-Nithi', '41', 1),
(2061, 110, 'Trans Nzoia', '42', 1),
(2062, 110, 'Turkana', '43', 1),
(2063, 110, 'Uasin Gishu', '44', 1),
(2064, 110, 'Vihiga', '45', 1),
(2065, 110, 'Wajir', '46', 1),
(2066, 110, 'West Pokot', '47', 1),
(2067, 115, 'Batken', 'B', 1),
(2068, 115, 'Chü', 'C', 1),
(2069, 115, 'Bishkek', 'GB', 1),
(2070, 115, 'Osh', 'GO', 1),
(2071, 115, 'Jalal-Abad', 'J', 1),
(2072, 115, 'Naryn', 'N', 1),
(2073, 115, 'Osh', 'O', 1),
(2074, 115, 'Talas', 'T', 1),
(2075, 115, 'Ysyk-Köl', 'Y', 1),
(2076, 36, 'Banteay Mean Chey [Bântéay Méanchey]', '1', 1),
(2077, 36, 'Kracheh [Krâchéh]', '10', 1),
(2078, 36, 'Mondol Kiri [Môndól Kiri]', '11', 1),
(2079, 36, 'Phnom Penh [Phnum Pénh]', '12', 1),
(2080, 36, 'Preah Vihear [Preah Vihéar]', '13', 1),
(2081, 36, 'Prey Veaeng [Prey Vęng]', '14', 1),
(2082, 36, 'Pousaat [Pouthisat]', '15', 1),
(2083, 36, 'Rotanak Kiri [Rôtânôkiri]', '16', 1),
(2084, 36, 'Siem Reab [Siemréab]', '17', 1),
(2085, 36, 'Krong Preah Sihanouk [Krong Preah Sihanouk]', '18', 1),
(2086, 36, 'Stueng Traeng [Stoeng Tręng]', '19', 1),
(2087, 36, 'Baat Dambang [Batdâmbâng]', '2', 1),
(2088, 36, 'Svaay Rieng [Svay Rieng]', '20', 1),
(2089, 36, 'Taakaev [Takęv]', '21', 1),
(2090, 36, 'Otdar Mean Chey [Otdâr Méanchey]', '22', 1),
(2091, 36, 'Krong Kaeb [Krong Kęb]', '23', 1),
(2092, 36, 'Krong Pailin [Krong Pailin]', '24', 1),
(2093, 36, 'Tbong Khmum', '25', 1),
(2094, 36, 'Kampong Chaam [Kâmpóng Cham]', '3', 1),
(2095, 36, 'Kampong Chhnang [Kâmpóng Chhnang]', '4', 1),
(2096, 36, 'Kampong Spueu [Kâmpóng Spś]', '5', 1),
(2097, 36, 'Kampong Thum [Kâmpóng Thum]', '6', 1),
(2098, 36, 'Kampot [Kâmpôt]', '7', 1),
(2099, 36, 'Kandaal [Kândal]', '8', 1),
(2100, 36, 'Kaoh Kong [Kaôh Kong]', '9', 1),
(2101, 111, 'Gilbert Islands', 'G', 1),
(2102, 111, 'Line Islands', 'L', 1),
(2103, 111, 'Phoenix Islands', 'P', 1),
(2104, 48, 'Anjouan', 'A', 1),
(2105, 48, 'Grande Comore', 'G', 1),
(2106, 48, 'Mohéli', 'M', 1),
(2107, 178, 'Christ Church Nichola Town', '01', 1),
(2108, 178, 'Saint Anne Sandy Point', '02', 1),
(2109, 178, 'Saint George Basseterre', '03', 1),
(2110, 178, 'Saint George Gingerland', '04', 1),
(2111, 178, 'Saint James Windward', '05', 1),
(2112, 178, 'Saint John Capisterre', '06', 1),
(2113, 178, 'Saint John Figtree', '07', 1),
(2114, 178, 'Saint Mary Cayon', '08', 1),
(2115, 178, 'Saint Paul Capisterre', '09', 1),
(2116, 178, 'Saint Paul Charlestown', '10', 1),
(2117, 178, 'Saint Peter Basseterre', '11', 1),
(2118, 178, 'Saint Thomas Lowland', '12', 1),
(2119, 178, 'Saint Thomas Middle Island', '13', 1),
(2120, 178, 'Trinity Palmetto Point', '15', 1),
(2121, 112, 'Phyeongyang', '01', 1),
(2122, 112, 'Phyeongannamto', '02', 1),
(2123, 112, 'Phyeonganpukto', '03', 1),
(2124, 112, 'Jakangto', '04', 1),
(2125, 112, 'Hwanghainamto', '05', 1),
(2126, 112, 'Hwanghaipukto', '06', 1),
(2127, 112, 'Kangweonto', '07', 1),
(2128, 112, 'Hamkyeongnamto', '08', 1),
(2129, 112, 'Hamkyeongpukto', '09', 1),
(2130, 112, 'Yanggang-do', '10', 1),
(2131, 112, 'Nason', '13', 1),
(2132, 113, 'Seoul-teukbyeolsi [Seoul]', '11', 1),
(2133, 113, 'Busan Gwang''yeogsi [Pusan-Kwangyokshi]', '26', 1),
(2134, 113, 'Daegu Gwang''yeogsi [Taegu-Kwangyokshi]', '27', 1),
(2135, 113, 'Incheon Gwang''yeogsi [Incheon]', '28', 1),
(2136, 113, 'Gwangju Gwang''yeogsi [Kwangju-Kwangyokshi]', '29', 1),
(2137, 113, 'Daejeon Gwang''yeogsi [Taejon-Kwangyokshi]', '30', 1),
(2138, 113, 'Ulsan Gwang''yeogsi [Ulsan-Kwangyokshi]', '31', 1),
(2139, 113, 'Gyeonggido [Kyonggi-do]', '41', 1),
(2140, 113, 'Gang''weondo [Kang-won-do]', '42', 1),
(2141, 113, 'Chungcheongbugdo [Ch''ungch''ongbuk-do]', '43', 1),
(2142, 113, 'Chungcheongnamdo [Ch''ungch''ongnam-do]', '44', 1),
(2143, 113, 'Jeonrabugdo [Chollabuk-do]', '45', 1),
(2144, 113, 'Jeonranamdo [Chollanam-do]', '46', 1),
(2145, 113, 'Gyeongsangbugdo [Kyongsangbuk-do]', '47', 1),
(2146, 113, 'Gyeongsangnamdo [Kyongsangnam-do]', '48', 1),
(2147, 113, 'Jeju-teukbyeoljachido [Jeju]', '49', 1),
(2148, 113, 'Sejong', '50', 1),
(2149, 114, 'Al A?madi', 'AH', 1),
(2150, 114, 'Al Farwaniyah', 'FA', 1),
(2151, 114, '?awalli', 'HA', 1),
(2152, 114, 'Al Jahra’', 'JA', 1),
(2153, 114, '	Al ‘Asimah', 'KU', 1),
(2154, 114, 'Mubarak al Kabir', 'MU', 1),
(2155, 109, 'Aqmola oblysy', 'AKM', 1),
(2156, 109, 'Aqtöbe oblysy', 'AKT', 1),
(2157, 109, 'Almaty', 'ALA', 1),
(2158, 109, 'Almaty oblysy', 'ALM', 1),
(2159, 109, 'Astana', 'AST', 1),
(2160, 109, 'Atyrau oblysy', 'ATY', 1),
(2161, 109, 'Qaraghandy oblysy', 'KAR', 1),
(2162, 109, 'Qostanay oblysy', 'KUS', 1),
(2163, 109, 'Qyzylorda oblysy', 'KZY', 1),
(2164, 109, 'Mangghystau oblysy', 'MAN', 1),
(2165, 109, 'Pavlodar oblysy', 'PAV', 1),
(2166, 109, 'Soltüstik Qazaqstan oblysy', 'SEV', 1),
(2167, 109, 'Shyghys Qazaqstan oblysy', 'VOS', 1),
(2168, 109, 'Ongtüstik Qazaqstan oblysy', 'YUZ', 1),
(2169, 109, 'Batys Qazaqstan oblysy', 'ZAP', 1),
(2170, 109, 'Zhambyl oblysy', 'ZHA', 1),
(2171, 116, 'Attapu [Attopeu]', 'AT', 1),
(2172, 116, 'Bokčo', 'BK', 1),
(2173, 116, 'Bolikhamxai [Borikhane]', 'BL', 1),
(2174, 116, 'Champasak [Champassak]', 'CH', 1),
(2175, 116, 'Houaphan', 'HO', 1),
(2176, 116, 'Khammouan', 'KH', 1),
(2177, 116, 'Louang Namtha', 'LM', 1),
(2178, 116, 'Louangphabang [Louang Prabang)', 'LP', 1),
(2179, 116, 'Oudômxai [Oudomsai]', 'OU', 1),
(2180, 116, 'Phôngsali [Phong Saly]', 'PH', 1),
(2181, 116, 'Salavan [Saravane]', 'SL', 1),
(2182, 116, 'Savannakhét', 'SV', 1),
(2183, 116, 'Vientiane', 'VI', 1),
(2184, 116, 'Vientiane', 'VT', 1),
(2185, 116, 'Xaignabouli [Sayaboury]', 'XA', 1),
(2186, 116, 'Xékong [Sékong]', 'XE', 1),
(2187, 116, 'Xiangkhouang [Xieng Khouang]', 'XI', 1),
(2188, 116, 'Xaisômboun', 'XS', 1),
(2189, 118, 'Aakkâr', 'AK', 1),
(2190, 118, 'Liban-Nord', 'AS', 1),
(2191, 118, 'Beyrouth', 'BA', 1),
(2192, 118, 'Baalbek-Hermel', 'BH', 1),
(2193, 118, 'El Béqaa', 'BI', 1),
(2194, 118, 'Liban-Sud', 'JA', 1),
(2195, 118, 'Mont-Liban', 'JL', 1),
(2196, 118, 'Nabatîyé', 'NA', 1),
(2197, 179, 'Anse la Raye', '01', 1),
(2198, 179, 'Castries', '02', 1),
(2199, 179, 'Choiseul', '03', 1),
(2200, 179, 'Dennery', '05', 1),
(2201, 179, 'Gros Islet', '06', 1),
(2202, 179, 'Laborie', '07', 1),
(2203, 179, 'Micoud', '08', 1),
(2204, 179, 'Soufričre', '10', 1),
(2205, 179, 'Vieux Fort', '11', 1),
(2206, 179, 'Canaries', '12', 1),
(2207, 122, 'Balzers', '01', 1),
(2208, 122, 'Eschen', '02', 1),
(2209, 122, 'Gamprin', '03', 1),
(2210, 122, 'Mauren', '04', 1),
(2211, 122, 'Planken', '05', 1),
(2212, 122, 'Ruggell', '06', 1),
(2213, 122, 'Schaan', '07', 1),
(2214, 122, 'Schellenberg', '08', 1),
(2215, 122, 'Triesen', '09', 1),
(2216, 122, 'Triesenberg', '10', 1),
(2217, 122, 'Vaduz', '11', 1),
(2218, 196, 'Basnahira pa?ata', '1', 1),
(2219, 196, 'Colombo', '11', 1),
(2220, 196, 'Gampaha', '12', 1),
(2221, 196, 'Kalutara', '13', 1),
(2222, 196, 'Madhyama pa?ata', '2', 1),
(2223, 196, 'Kandy', '21', 1),
(2224, 196, 'Matale', '22', 1),
(2225, 196, 'Nuwara Eliya', '23', 1),
(2226, 196, 'Daku?u pa?ata', '3', 1),
(2227, 196, 'Galle', '31', 1),
(2228, 196, 'Matara', '32', 1),
(2229, 196, 'Hambantota', '33', 1),
(2230, 196, 'Uturu pa?ata', '4', 1),
(2231, 196, 'Jaffna', '41', 1),
(2232, 196, 'Kilinochchi', '42', 1),
(2233, 196, 'Mannar', '43', 1),
(2234, 196, 'Vavuniya', '44', 1),
(2235, 196, 'Mullaittivu', '45', 1),
(2236, 196, 'Nć?genahira pa?ata', '5', 1),
(2237, 196, 'Batticaloa', '51', 1),
(2238, 196, 'Ampara', '52', 1),
(2239, 196, 'Trincomalee', '53', 1),
(2240, 196, 'Vayamba pa?ata', '6', 1),
(2241, 196, 'Kurunegala', '61', 1),
(2242, 196, 'Puttalam', '62', 1),
(2243, 196, 'Uturumć?da pa?ata', '7', 1),
(2244, 196, 'Anuradhapura', '71', 1),
(2245, 196, 'Polonnaruwa', '72', 1),
(2246, 196, 'Uva pa?ata', '8', 1),
(2247, 196, 'Badulla', '81', 1),
(2248, 196, 'Monaragala', '82', 1),
(2249, 196, 'Sabaragamuva pa?ata', '9', 1),
(2250, 196, 'Ratnapura', '91', 1),
(2251, 196, 'Kegalla', '92', 1),
(2252, 120, 'Bong', 'BG', 1),
(2253, 120, 'Bomi', 'BM', 1),
(2254, 120, 'Grand Cape Mount', 'CM', 1),
(2255, 120, 'Grand Bassa', 'GB', 1),
(2256, 120, 'Grand Gedeh', 'GG', 1),
(2257, 120, 'Grand Kru', 'GK', 1),
(2258, 120, 'Gbarpolu', 'GP', 1),
(2259, 120, 'Lofa', 'LO', 1),
(2260, 120, 'Margibi', 'MG', 1),
(2261, 120, 'Montserrado', 'MO', 1),
(2262, 120, 'Maryland', 'MY', 1),
(2263, 120, 'Nimba', 'NI', 1),
(2264, 120, 'River Gee', 'RG', 1),
(2265, 120, '	River Cess', 'RI', 1),
(2266, 120, 'Sinoe', 'SI', 1),
(2267, 119, 'Maseru', 'A', 1),
(2268, 119, 'Butha-Buthe', 'B', 1),
(2269, 119, 'Leribe', 'C', 1),
(2270, 119, 'Berea', 'D', 1),
(2271, 119, 'Mafeteng', 'E', 1),
(2272, 119, 'Mohale''s Hoek', 'F', 1),
(2273, 119, 'Quthing', 'G', 1),
(2274, 119, 'Qacha''s Nek', 'H', 1),
(2275, 119, 'Mokhotlong', 'J', 1),
(2276, 119, 'Thaba-Tseka', 'K', 1),
(2277, 123, 'Akmene', '01', 1),
(2278, 123, 'Alytaus miestas', '02', 1),
(2279, 123, 'Alytus', '03', 1),
(2280, 123, 'Anykšciai', '04', 1),
(2281, 123, 'Birštono', '05', 1),
(2282, 123, 'Biržai', '06', 1),
(2283, 123, 'Druskininkai', '07', 1),
(2284, 123, 'Elektrénai', '08', 1),
(2285, 123, 'Ignalina', '09', 1),
(2286, 123, 'Jonava', '10', 1),
(2287, 123, 'Joniškis', '11', 1),
(2288, 123, 'Jurbarkas', '12', 1),
(2289, 123, 'Kaišiadorys', '13', 1),
(2290, 123, 'Kalvarijos', '14', 1),
(2291, 123, 'Kauno miestas', '15', 1),
(2292, 123, 'Kaunas', '16', 1),
(2293, 123, 'Kazlu Rudos', '17', 1),
(2294, 123, 'Kedainiai', '18', 1),
(2295, 123, 'Kelme', '19', 1),
(2296, 123, 'Klaipedos miestas', '20', 1),
(2297, 123, 'Klaipeda', '21', 1),
(2298, 123, 'Kretinga', '22', 1),
(2299, 123, 'Kupiškis', '23', 1),
(2300, 123, 'Lazdijai', '24', 1),
(2301, 123, 'Marijampole', '25', 1),
(2302, 123, 'Mažeikiai', '26', 1),
(2303, 123, 'Moletai', '27', 1),
(2304, 123, 'Neringa', '28', 1),
(2305, 123, 'Pagégiai', '29', 1),
(2306, 123, 'Pakruojis', '30', 1),
(2307, 123, 'Palangos miestas', '31', 1),
(2308, 123, 'Panevežio miestas', '32', 1),
(2309, 123, 'Panevežys', '33', 1),
(2310, 123, 'Pasvalys', '34', 1),
(2311, 123, 'Plunge', '35', 1),
(2312, 123, 'Prienai', '36', 1),
(2313, 123, 'Radviliškis', '37', 1),
(2314, 123, 'Raseiniai', '38', 1),
(2315, 123, 'Rietavo', '39', 1),
(2316, 123, 'Rokiškis', '40', 1),
(2317, 123, 'Šakiai', '41', 1),
(2318, 123, 'Šalcininkai', '42', 1),
(2319, 123, 'Šiauliu miestas', '43', 1),
(2320, 123, 'Šiauliai', '44', 1),
(2321, 123, 'Šilale', '45', 1),
(2322, 123, 'Šilute', '46', 1),
(2323, 123, 'Širvintos', '47', 1),
(2324, 123, 'Skuodas', '48', 1),
(2325, 123, 'Švencionys', '49', 1),
(2326, 123, 'Taurage', '50', 1),
(2327, 123, 'Telšiai', '51', 1),
(2328, 123, 'Trakai', '52', 1),
(2329, 123, 'Ukmerge', '53', 1),
(2330, 123, 'Utena', '54', 1),
(2331, 123, 'Varena', '55', 1),
(2332, 123, 'Vilkaviškis', '56', 1),
(2333, 123, 'Vilniaus miestas', '57', 1),
(2334, 123, 'Vilnius', '58', 1),
(2335, 123, 'Visaginas', '59', 1),
(2336, 123, 'Zarasai', '60', 1),
(2337, 123, 'Alytaus Apskritis', 'AL', 1),
(2338, 123, 'Klaipedos apskritis', 'KL', 1),
(2339, 123, 'Kauno Apskritis', 'KU', 1),
(2340, 123, 'Marijampoles apskritis', 'MR', 1),
(2341, 123, 'Panevežio apskritis', 'PN', 1),
(2342, 123, 'Šiauliu Apskritis', 'SA', 1),
(2343, 123, 'Taurages apskritis', 'TA', 1),
(2344, 123, 'Telšiu Apskritis', 'TE', 1),
(2345, 123, 'Utenos Apskritis', 'UT', 1),
(2346, 123, 'Vilniaus Apskritis', 'VL', 1),
(2347, 124, 'Capellen', 'CA', 1),
(2348, 124, 'Clervaux', 'CL', 1),
(2349, 124, 'Diekirch', 'DI', 1),
(2350, 124, 'Echternach', 'EC', 1),
(2351, 124, 'Esch-sur-Alzette', 'ES', 1),
(2352, 124, 'Gréivemaacher', 'GR', 1),
(2353, 124, 'Luxembourg', 'LU', 1),
(2354, 124, 'Mersch', 'ME', 1),
(2355, 124, 'Redange', 'RD', 1),
(2356, 124, 'Remich', 'RM', 1),
(2357, 124, 'Vianden', 'VD', 1),
(2358, 124, 'Wiltz', 'WI', 1),
(2359, 117, 'Aglonas novads (Aglona)', '001', 1),
(2360, 117, 'Aizkraukles novads (Aizkraukle)', '002', 1),
(2361, 117, 'Aizputes novads (Aizpute)', '003', 1),
(2362, 117, 'Aknistes novads (Akniste)', '004', 1),
(2363, 117, 'Alojas novads (Aloja)', '005', 1),
(2364, 117, 'Alsungas novads (Alsunga)', '006', 1),
(2365, 117, 'Aluksnes novads (Aluksne)', '007', 1),
(2366, 117, 'Amatas novads (Amata)', '008', 1),
(2367, 117, 'Apes novads (Ape)', '009', 1),
(2368, 117, 'Auces novads (Auce)', '010', 1),
(2369, 117, 'Adažu novads (Adaži)', '011', 1),
(2370, 117, 'Babites novads (Babite)', '012', 1),
(2371, 117, 'Baldones novads (Baldone)', '013', 1),
(2372, 117, 'Baltinavas novads (Baltinava)', '014', 1),
(2373, 117, 'Balvu novads (Balvi)', '015', 1),
(2374, 117, 'Bauskas novads (Bauska)', '016', 1),
(2375, 117, 'Beverinas novads (Beverina)', '017', 1),
(2376, 117, 'Brocenu novads (Broceni)', '018', 1),
(2377, 117, 'Burtnieku novads (Burtnieki)', '019', 1),
(2378, 117, 'Carnikavas novads (Carnikava)', '020', 1),
(2379, 117, 'Cesvaines novads (Cesvaine)', '021', 1),
(2380, 117, 'Cesu novads (Cesis)', '022', 1),
(2381, 117, 'Ciblas novads (Cibla)', '023', 1),
(2382, 117, 'Dagdas novads (Dagda)', '024', 1),
(2383, 117, 'Daugavpils novads (Daugavpils)', '025', 1),
(2384, 117, 'Dobeles novads (Dobele)', '026', 1),
(2385, 117, 'Dundagas novads (Dundaga)', '027', 1),
(2386, 117, 'Durbes novads (Durbe)', '028', 1),
(2387, 117, 'Engures novads (Engure)', '029', 1),
(2388, 117, 'Erglu novads (Ergli)', '030', 1),
(2389, 117, 'Garkalnes novads (Garkalne)', '031', 1),
(2390, 117, 'Grobinas novads (Grobina)', '032', 1),
(2391, 117, 'Gulbenes novads (Gulbene)', '033', 1),
(2392, 117, 'Iecavas novads (Iecava)', '034', 1),
(2393, 117, 'Ikškiles novads (Ikškile)', '035', 1),
(2394, 117, 'Ilukstes novads (Ilukste)', '036', 1),
(2395, 117, 'Incukalna novads (Incukalns)', '037', 1),
(2396, 117, 'Jaunjelgavas novads\n(Jaunjelgava)', '038', 1),
(2397, 117, 'Jaunpiebalgas novads\n(Jaunpiebalga)', '039', 1),
(2398, 117, 'Jaunpils novads (Jaunpils)', '040', 1),
(2399, 117, 'Jelgavas novads (Jelgava)', '041', 1),
(2400, 117, 'Jekabpils novads (Jekabpils)', '042', 1),
(2401, 117, 'Kandavas novads (Kandava)', '043', 1),
(2402, 117, 'Karsavas novads (Karsava)', '044', 1),
(2403, 117, 'Kocenu novads (Koceni)', '045', 1),
(2404, 117, 'Kokneses novads (Koknese)', '046', 1),
(2405, 117, 'Kraslavas novads (Kraslava)', '047', 1),
(2406, 117, 'Krimuldas novads (Krimulda)', '048', 1),
(2407, 117, 'Krustpils novads (Krustpils)', '049', 1),
(2408, 117, 'Kuldigas novads (Kuldiga)', '050', 1),
(2409, 117, 'Keguma novads (Kegums)', '051', 1),
(2410, 117, 'Kekavas novads (Kekava)', '052', 1),
(2411, 117, 'Lielvardes novads (Lielvarde)', '053', 1),
(2412, 117, 'Limbažu novads (Limbaži)', '054', 1),
(2413, 117, 'Ligatnes novads (Ligatne)', '055', 1),
(2414, 117, 'Livanu novads (Livani)', '056', 1),
(2415, 117, 'Lubanas novads (Lubana)', '057', 1),
(2416, 117, 'Ludzas novads (Ludza)', '058', 1),
(2417, 117, 'Madonas novads (Madona)', '059', 1),
(2418, 117, 'Mazsalacas novads (Mazsalaca)', '060', 1),
(2419, 117, 'Malpils novads (Malpils)', '061', 1),
(2420, 117, 'Marupes novads (Marupe)', '062', 1),
(2421, 117, 'Mersraga novads (Mersrags)', '063', 1),
(2422, 117, 'Naukšenu novads (Naukšeni)', '064', 1),
(2423, 117, 'Neretas novads (Nereta)', '065', 1),
(2424, 117, 'Nicas novads (Nica)', '066', 1),
(2425, 117, 'Ogres novads (Ogre)', '067', 1),
(2426, 117, 'Olaines novads (Olaine)', '068', 1),
(2427, 117, 'Ozolnieku novads (Ozolnieki)', '069', 1),
(2428, 117, 'Pargaujas novads (Pargauja)', '070', 1),
(2429, 117, 'Pavilostas novads (Pavilosta)', '071', 1),
(2430, 117, 'Plavinu novads (Plavinas)', '072', 1),
(2431, 117, 'Preilu novads (Preili)', '073', 1),
(2432, 117, 'Priekules novads (Priekule)', '074', 1),
(2433, 117, 'Priekulu novads (Priekuli)', '075', 1),
(2434, 117, 'Raunas novads (Rauna)', '076', 1),
(2435, 117, 'Rezeknes novads (Rezekne)', '077', 1),
(2436, 117, 'Riebinu novads (Riebini)', '078', 1),
(2437, 117, 'Rojas novads (Roja)', '079', 1),
(2438, 117, 'Ropažu novads (Ropaži)', '080', 1),
(2439, 117, 'Rucavas novads (Rucava)', '081', 1),
(2440, 117, 'Rugaju novads (Rugaji)', '082', 1),
(2441, 117, 'Rundales novads (Rundale)', '083', 1),
(2442, 117, 'Rujienas novads (Rujiena)', '084', 1),
(2443, 117, 'Salas novads (Sala)', '085', 1),
(2444, 117, 'Salacgrivas novads (Salacgriva)', '086', 1),
(2445, 117, 'Salaspils novads (Salaspils)', '087', 1),
(2446, 117, 'Saldus novads (Saldus)', '088', 1),
(2447, 117, 'Saulkrastu novads (Saulkrasti)', '089', 1),
(2448, 117, 'Sejas novads (Seja)', '090', 1),
(2449, 117, 'Siguldas novads (Sigulda)', '091', 1),
(2450, 117, 'Skriveru novads (Skriveri)', '092', 1),
(2451, 117, 'Skrundas novads (Skrunda)', '093', 1),
(2452, 117, 'Smiltenes novads (Smiltene)', '094', 1),
(2453, 117, 'Stopinu novads (Stopini)', '095', 1),
(2454, 117, 'Strencu novads (Strenci)', '096', 1),
(2455, 117, 'Talsu novads (Talsi)', '097', 1),
(2456, 117, 'Tervetes novads (Tervete)', '098', 1),
(2457, 117, 'Tukuma novads (Tukums)', '099', 1),
(2458, 117, 'Vainodes novads (Vainode)', '100', 1),
(2459, 117, 'Valkas novads (Valka)', '101', 1),
(2460, 117, 'Varaklanu novads (Varaklani)', '102', 1),
(2461, 117, 'Varkavas novads (Varkava)', '103', 1),
(2462, 117, 'Vecpiebalgas novads\n(Vecpiebalga)', '104', 1),
(2463, 117, 'Vecumnieku novads (Vecumnieki)', '105', 1),
(2464, 117, 'Ventspils novads (Ventspils)', '106', 1),
(2465, 117, 'Viesites novads (Viesite)', '107', 1),
(2466, 117, 'Vilakas novads (Vilaka)', '108', 1),
(2467, 117, 'Vilanu novads (Vilani)', '109', 1),
(2468, 117, 'Zilupes novads (Zilupe)', '110', 1),
(2469, 117, 'Daugavpils', 'DGV', 1),
(2470, 117, 'Jelgava', 'JEL', 1),
(2471, 117, 'Jekabpils', 'JKB', 1),
(2472, 117, 'Jurmala', 'JUR', 1),
(2473, 117, 'Liepaja', 'LPX', 1),
(2474, 117, 'Rezekne', 'REZ', 1),
(2475, 117, 'Riga', 'RIX', 1),
(2476, 117, 'Ventspils', 'VEN', 1),
(2477, 117, 'Valmiera', 'VMR', 1),
(2478, 121, 'Banghazi', 'BA', 1),
(2479, 121, 'Al Butnan', 'BU', 1),
(2480, 121, 'Darnah', 'DR', 1),
(2481, 121, 'Ghat', 'GT', 1),
(2482, 121, 'Al Jabal al Akh?ar', 'JA', 1),
(2483, 121, 'Al Jabal al Gharbi', 'JG', 1),
(2484, 121, 'Al Jafarah', 'JI', 1),
(2485, 121, 'Al Jufrah', 'JU', 1),
(2486, 121, 'Al Kufrah', 'KF', 1),
(2487, 121, 'Al Marqab', 'MB', 1),
(2488, 121, 'Misratah', 'MI', 1),
(2489, 121, 'Al Marj', 'MJ', 1),
(2490, 121, 'Murzuq', 'MQ', 1),
(2491, 121, 'Nalut', 'NL', 1),
(2492, 121, 'An Nuqat al Khams', 'NQ', 1),
(2493, 121, 'Sabha', 'SB', 1),
(2494, 121, 'Surt', 'SR', 1),
(2495, 121, 'Tarabulus', 'TB', 1),
(2496, 121, 'Al Wa?at', 'WA', 1),
(2497, 121, 'Wadi al Hayat', 'WD', 1),
(2498, 121, 'Wadi ash Shati?', 'WS', 1),
(2499, 121, 'Az Zawiyah', 'ZA', 1),
(2500, 144, 'Tanger-Tétouan', '01', 1),
(2501, 144, 'Gharb-Chrarda-Beni Hssen', '02', 1),
(2502, 144, 'Taza-Al Hoceima-Taounate', '03', 1),
(2503, 144, 'L''Oriental', '04', 1),
(2504, 144, 'Fčs-Boulemane', '05', 1),
(2505, 144, 'Meknčs-Tafilalet', '06', 1),
(2506, 144, 'Rabat-Salé-Zemmour-Zaer', '07', 1),
(2507, 144, 'Grand Casablanca', '08', 1),
(2508, 144, 'Chaouia-Ouardigha', '09', 1),
(2509, 144, 'Doukhala-Abda', '10', 1),
(2510, 144, 'Marrakech-Tensift-Al Haouz', '11', 1),
(2511, 144, 'Tadla-Azilal', '12', 1),
(2512, 144, 'Sous-Massa-Draa', '13', 1),
(2513, 144, 'Guelmim-Es Semara', '14', 1),
(2514, 144, 'Laâyoune-Boujdour-Sakia el Hamra', '15', 1),
(2515, 144, 'Oued ed Dahab-Lagouira', '16', 1),
(2516, 144, 'Agadir-Ida-Outanane', 'AGD', 1),
(2517, 144, 'Aousserd', 'AOU', 1),
(2518, 144, 'Assa-Zag', 'ASZ', 1),
(2519, 144, 'Azilal', 'AZI', 1),
(2520, 144, 'Beni Mellal', 'BEM', 1),
(2521, 144, 'Berkane', 'BER', 1),
(2522, 144, 'Ben Slimane', 'BES', 1),
(2523, 144, 'Boujdour (EH)', 'BOD', 1),
(2524, 144, 'Boulemane', 'BOM', 1),
(2525, 144, 'Casablanca [Dar el Beďda]*', 'CAS', 1),
(2526, 144, 'Chefchaouene', 'CHE', 1),
(2527, 144, 'Chichaoua', 'CHI', 1),
(2528, 144, 'Chtouka-Ait Baha', 'CHT', 1),
(2529, 144, 'Errachidia', 'ERR', 1),
(2530, 144, 'Essaouira', 'ESI', 1),
(2531, 144, 'Es Smara (EH)', 'ESM', 1),
(2532, 144, 'Fahs-Beni Makada', 'FAH', 1),
(2533, 144, 'Fčs-Dar-Dbibegh', 'FES', 1),
(2534, 144, 'Figuig', 'FIG', 1),
(2535, 144, 'Guelmim', 'GUE', 1),
(2536, 144, 'El Hajeb', 'HAJ', 1),
(2537, 144, 'Al Haouz', 'HAO', 1),
(2538, 144, 'Al Hoceďma', 'HOC', 1),
(2539, 144, 'Ifrane', 'IFR', 1),
(2540, 144, 'Inezgane-Ait Melloul', 'INE', 1),
(2541, 144, 'El Jadida', 'JDI', 1),
(2542, 144, 'Jrada', 'JRA', 1),
(2543, 144, 'Kénitra', 'KEN', 1),
(2544, 144, 'Kelaat Sraghna', 'KES', 1),
(2545, 144, 'Khemisset', 'KHE', 1),
(2546, 144, 'Khenifra', 'KHN', 1),
(2547, 144, 'Khouribga', 'KHO', 1),
(2548, 144, 'Laâyoune', 'LAA', 1),
(2549, 144, 'Larache', 'LAR', 1),
(2550, 144, 'Médiouna', 'MED', 1),
(2551, 144, 'Meknčs*', 'MEK', 1),
(2552, 144, 'Marrakech-Medina', 'MMD', 1),
(2553, 144, 'Marrakech-Menara', 'MMN', 1),
(2554, 144, 'Mohammadia', 'MOH', 1),
(2555, 144, 'Moulay Yacoub', 'MOU', 1),
(2556, 144, 'Nador', 'NAD', 1),
(2557, 144, 'Nouaceur', 'NOU', 1),
(2558, 144, 'Ouarzazate', 'OUA', 1),
(2559, 144, 'Oued ed Dahab (EH)', 'OUD', 1),
(2560, 144, 'Oujda-Angad', 'OUJ', 1),
(2561, 144, 'Rabat', 'RAB', 1),
(2562, 144, 'Safi', 'SAF', 1),
(2563, 144, 'Salé', 'SAL', 1),
(2564, 144, 'Sefrou', 'SEF', 1),
(2565, 144, 'Settat', 'SET', 1),
(2566, 144, 'Sidi Kacem', 'SIK', 1),
(2567, 144, 'Skhirate-Témara', 'SKH', 1),
(2568, 144, 'Sidi Youssef Ben Ali', 'SYB', 1),
(2569, 144, 'Taourirt', 'TAI', 1),
(2570, 144, 'Taounate', 'TAO', 1),
(2571, 144, 'Taroudannt', 'TAR', 1),
(2572, 144, 'Tata', 'TAT', 1),
(2573, 144, 'Taza', 'TAZ', 1),
(2574, 144, 'Tétouan*', 'TET', 1),
(2575, 144, 'Tiznit', 'TIZ', 1),
(2576, 144, 'Tanger-Assilah', 'TNG', 1),
(2577, 144, 'Tan-Tan', 'TNT', 1),
(2578, 144, 'Zagora', 'ZAG', 1),
(2579, 141, 'La Colle', 'CL', 1),
(2580, 141, 'La Condamine', 'CO', 1),
(2581, 141, 'Fontvieille', 'FO', 1),
(2582, 141, 'La Gare', 'GA', 1),
(2583, 141, 'Jardin Exotique', 'JE', 1),
(2584, 141, 'Larvotto', 'LA', 1),
(2585, 141, 'Malbousquet', 'MA', 1),
(2586, 141, 'Monte-Carlo', 'MC', 1),
(2587, 141, 'Moneghetti', 'MG', 1),
(2588, 141, 'Monaco-Ville', 'MO', 1),
(2589, 141, 'Moulins', 'MU', 1),
(2590, 141, 'Port-Hercule', 'PH', 1),
(2591, 141, 'Sainte-Dévote', 'SD', 1),
(2592, 141, 'La Source', 'SO', 1),
(2593, 141, 'Spélugues', 'SP', 1),
(2594, 141, 'Saint-Roman', 'SR', 1),
(2595, 141, 'Vallon de la Rousse', 'VR', 1),
(2596, 140, 'Anenii Noi', 'AN', 1),
(2597, 140, 'Balti', 'BA', 1),
(2598, 140, 'Bender [Tighina]', 'BD', 1),
(2599, 140, 'Briceni', 'BR', 1),
(2600, 140, 'Basarabeasca', 'BS', 1),
(2601, 140, 'Cahul', 'CA', 1),
(2602, 140, 'Calarasi', 'CL', 1),
(2603, 140, 'Cimislia', 'CM', 1),
(2604, 140, 'Criuleni', 'CR', 1),
(2605, 140, 'Causeni', 'CS', 1),
(2606, 140, 'Cantemir', 'CT', 1),
(2607, 140, 'Chisinau', 'CU', 1),
(2608, 140, 'Donduseni', 'DO', 1),
(2609, 140, 'Drochia', 'DR', 1),
(2610, 140, 'Dubasari', 'DU', 1),
(2611, 140, 'Edinet', 'ED', 1),
(2612, 140, 'Falesti', 'FA', 1),
(2613, 140, 'Floresti', 'FL', 1),
(2614, 140, 'Gagauzia, Unitatea teritoriala\nautonoma (UTAG)', 'GA', 1),
(2615, 140, 'Glodeni', 'GL', 1),
(2616, 140, 'Hîncesti', 'HI', 1),
(2617, 140, 'Ialoveni', 'IA', 1),
(2618, 140, 'Leova', 'LE', 1),
(2619, 140, 'Nisporeni', 'NI', 1),
(2620, 140, 'Ocniţa', 'OC', 1),
(2621, 140, 'Orhei', 'OR', 1),
(2622, 140, 'Rezina', 'RE', 1),
(2623, 140, 'Rîscani', 'RI', 1),
(2624, 140, 'Soldanesti', 'SD', 1),
(2625, 140, 'Sîngerei', 'SI', 1),
(2626, 140, 'Stînga Nistrului, unitatea teritoriala din', 'SN', 1),
(2627, 140, 'Soroca', 'SO', 1),
(2628, 140, 'Straseni', 'ST', 1),
(2629, 140, 'Stefan Voda', 'SV', 1),
(2630, 140, 'Taraclia', 'TA', 1),
(2631, 140, 'Telenesti', 'TE', 1),
(2632, 140, 'Ungheni', 'UN', 1),
(2633, 249, 'Andrijevica', '01', 1),
(2634, 249, 'Bar', '02', 1),
(2635, 249, 'Berane', '03', 1),
(2636, 249, 'Bijelo Polje', '04', 1),
(2637, 249, 'Budva', '05', 1),
(2638, 249, 'Cetinje', '06', 1),
(2639, 249, 'Danilovgrad', '07', 1),
(2640, 249, 'Herceg-Novi', '08', 1),
(2641, 249, 'Kolašin', '09', 1),
(2642, 249, 'Kotor', '10', 1),
(2643, 249, 'Mojkovac', '11', 1),
(2644, 249, 'Nikšic´', '12', 1),
(2645, 249, 'Plav', '13', 1),
(2646, 249, 'Pljevlja', '14', 1),
(2647, 249, 'Plužine', '15', 1),
(2648, 249, 'Podgorica', '16', 1),
(2649, 249, 'Rožaje', '17', 1),
(2650, 249, 'Šavnik', '18', 1),
(2651, 249, 'Tivat', '19', 1),
(2652, 249, 'Ulcinj', '20', 1),
(2653, 249, 'Žabljak', '21', 1),
(2654, 249, 'Gusinje', '22', 1),
(2655, 249, 'Petnjica', '23', 1),
(2656, 127, 'Toamasina', 'A', 1),
(2657, 127, 'Antsiranana', 'D', 1),
(2658, 127, 'Fianarantsoa', 'F', 1),
(2659, 127, 'Mahajanga', 'M', 1),
(2660, 127, 'Antananarivo', 'T', 1),
(2661, 127, 'Toliara', 'U', 1),
(2662, 133, 'Ailuk', 'ALK', 1),
(2663, 133, 'Ailinglapalap', 'ALL', 1),
(2664, 133, 'Arno', 'ARN', 1),
(2665, 133, 'Aur', 'AUR', 1),
(2666, 133, 'Ebon', 'EBO', 1),
(2667, 133, 'Enewetak and Ujelang', 'ENI', 1),
(2668, 133, 'Jabat', 'JAB', 1),
(2669, 133, 'Jaluit', 'JAL', 1),
(2670, 133, 'Bikini and Kili', 'KIL', 1),
(2671, 133, 'Kwajalein', 'KWA', 1),
(2672, 133, 'Ralik chain', 'L', 1),
(2673, 133, 'Lae', 'LAE', 1),
(2674, 133, 'Lib', 'LIB', 1),
(2675, 133, 'Likiep', 'LIK', 1),
(2676, 133, 'Majuro', 'MAJ', 1),
(2677, 133, 'Maloelap', 'MAL', 1),
(2678, 133, 'Mejit', 'MEJ', 1),
(2679, 133, 'Mili', 'MIL', 1),
(2680, 133, 'Namdrik', 'NMK', 1),
(2681, 133, 'Namu', 'NMU', 1),
(2682, 133, 'Rongelap', 'RON', 1),
(2683, 133, 'Ratak chain', 'T', 1),
(2684, 133, 'Ujae', 'UJA', 1),
(2685, 133, 'Utrik', 'UTI', 1),
(2686, 133, 'Wotho', 'WTH', 1),
(2687, 133, 'Wotje', 'WTJ', 1),
(2688, 126, 'Aracinovo', '02', 1),
(2689, 126, 'Berovo', '03', 1),
(2690, 126, 'Bitola', '04', 1),
(2691, 126, 'Bogdanci', '05', 1),
(2692, 126, 'Bogovinje', '06', 1),
(2693, 126, 'Bosilovo', '07', 1),
(2694, 126, 'Brvenica', '08', 1),
(2695, 126, 'Valandovo', '10', 1),
(2696, 126, 'Vasilevo', '11', 1),
(2697, 126, 'Vevcani', '12', 1),
(2698, 126, 'Veles', '13', 1),
(2699, 126, 'Vinica', '14', 1),
(2700, 126, 'Vrapcište', '16', 1),
(2701, 126, 'Gevgelija', '18', 1),
(2702, 126, 'Gostivar', '19', 1),
(2703, 126, 'Gradsko', '20', 1),
(2704, 126, 'Debar', '21', 1),
(2705, 126, 'Debarca', '22', 1),
(2706, 126, 'Delcevo', '23', 1),
(2707, 126, 'Demir Kapija', '24', 1),
(2708, 126, 'Demir Hisar', '25', 1),
(2709, 126, 'Dojran', '26', 1),
(2710, 126, 'Dolneni', '27', 1),
(2711, 126, 'Želino', '30', 1),
(2712, 126, 'Zelenikovo', '32', 1),
(2713, 126, 'Zrnovci', '33', 1),
(2714, 126, 'Ilinden', '34', 1),
(2715, 126, 'Jegunovce', '35', 1),
(2716, 126, 'Kavadarci', '36', 1),
(2717, 126, 'Karbinci', '37', 1),
(2718, 126, 'Kicevo', '40', 1),
(2719, 126, 'Konce', '41', 1),
(2720, 126, 'Kocani', '42', 1),
(2721, 126, 'Kratovo', '43', 1),
(2722, 126, 'Kriva Palanka', '44', 1),
(2723, 126, 'Krivogaštani', '45', 1),
(2724, 126, 'Kruševo', '46', 1),
(2725, 126, 'Kumanovo', '47', 1),
(2726, 126, 'Lipkovo', '48', 1),
(2727, 126, 'Lozovo', '49', 1),
(2728, 126, 'Mavrovo-i-Rostuša', '50', 1),
(2729, 126, 'Makedonska Kamenica', '51', 1),
(2730, 126, 'Makedonski Brod', '52', 1),
(2731, 126, 'Mogila', '53', 1),
(2732, 126, 'Negotino', '54', 1),
(2733, 126, 'Novaci', '55', 1),
(2734, 126, 'Novo Selo', '56', 1),
(2735, 126, 'Ohrid', '58', 1),
(2736, 126, 'Petrovec', '59', 1),
(2737, 126, 'Pehcevo', '60', 1),
(2738, 126, 'Plasnica', '61', 1),
(2739, 126, 'Prilep', '62', 1),
(2740, 126, 'Probištip', '63', 1),
(2741, 126, 'Radoviš', '64', 1),
(2742, 126, 'Rankovce', '65', 1),
(2743, 126, 'Resen', '66', 1),
(2744, 126, 'Rosoman', '67', 1),
(2745, 126, 'Sveti Nikole', '69', 1),
(2746, 126, 'Sopište', '70', 1),
(2747, 126, 'Staro Nagoricane', '71', 1),
(2748, 126, 'Struga', '72', 1),
(2749, 126, 'Strumica', '73', 1),
(2750, 126, 'Studenicani', '74', 1),
(2751, 126, 'Tearce', '75', 1),
(2752, 126, 'Tetovo', '76', 1),
(2753, 126, 'Centar Župa', '78', 1),
(2754, 126, 'Caška', '80', 1),
(2755, 126, 'Cešinovo-Obleševo', '81', 1),
(2756, 126, 'Cucer Sandevo', '82', 1),
(2757, 126, 'Štip', '83', 1),
(2758, 126, 'Skopje', '85', 1),
(2759, 131, 'Kayes', '1', 1),
(2760, 131, 'Koulikoro', '2', 1),
(2761, 131, 'Sikasso', '3', 1),
(2762, 131, 'Ségou', '4', 1),
(2763, 131, 'Mopti', '5', 1),
(2764, 131, 'Tombouctou', '6', 1),
(2765, 131, 'Gao', '7', 1),
(2766, 131, 'Kidal', '8', 1),
(2767, 131, 'Bamako', 'BKO', 1),
(2768, 146, 'Sagaing', '01', 1),
(2769, 146, 'Bago', '02', 1),
(2770, 146, 'Magway', '03', 1),
(2771, 146, 'Mandalay', '04', 1),
(2772, 146, 'Taninthayi', '05', 1),
(2773, 146, 'Yangon', '06', 1),
(2774, 146, 'Ayeyawady', '07', 1),
(2775, 146, 'Kachin', '11', 1),
(2776, 146, 'Kayah', '12', 1),
(2777, 146, 'Kayin', '13', 1),
(2778, 146, 'Chin', '14', 1),
(2779, 146, 'Mon', '15', 1),
(2780, 146, 'Rakhine', '16', 1),
(2781, 146, 'Shan', '17', 1),
(2782, 146, 'Nay Pyi Taw', '18', 1),
(2783, 142, 'Orhon', '035', 1),
(2784, 142, 'Darhan uul', '037', 1),
(2785, 142, 'Hentiy', '039', 1),
(2786, 142, 'Hövagöl', '041', 1),
(2787, 142, 'Hovd', '043', 1),
(2788, 142, 'Uvs', '046', 1),
(2789, 142, 'Töv', '047', 1),
(2790, 142, 'Selenge', '049', 1),
(2791, 142, 'Sühbaatar', '051', 1),
(2792, 142, 'Ömnögovi', '053', 1),
(2793, 142, 'Övörhangay', '055', 1),
(2794, 142, 'Dzavhan', '057', 1),
(2795, 142, 'Dundgovi', '059', 1),
(2796, 142, 'Dornod', '061', 1),
(2797, 142, 'Dornogovi', '063', 1),
(2798, 142, 'Govi-Sümber', '064', 1),
(2799, 142, 'Govi-Altay', '065', 1),
(2800, 142, 'Bulgan', '067', 1),
(2801, 142, 'Bayanhongor', '069', 1),
(2802, 142, 'Bayan-Ölgiy', '071', 1),
(2803, 142, 'Arhangay', '073', 1),
(2804, 142, 'Ulaanbaatar', '1', 1),
(2805, 135, 'Hodh ech Chargui', '01', 1),
(2806, 135, 'Hodh el Gharbi', '02', 1),
(2807, 135, 'Assaba', '03', 1),
(2808, 135, 'Gorgol', '04', 1),
(2809, 135, 'Brakna', '05', 1),
(2810, 135, 'Trarza', '06', 1),
(2811, 135, 'Adrar', '07', 1),
(2812, 135, 'Dakhlet Nouâdhibou', '08', 1),
(2813, 135, 'Tagant', '09', 1),
(2814, 135, 'Guidimaka', '10', 1),
(2815, 135, 'Tiris Zemmour', '11', 1),
(2816, 135, 'Inchiri', '12', 1),
(2817, 135, 'Nouakchott Ouest', '13', 1),
(2818, 135, 'Nouakchott Nord', '14', 1),
(2819, 135, 'Nouakchott Sud', '15', 1),
(2820, 132, 'Attard', '01', 1),
(2821, 132, 'Balzan', '02', 1),
(2822, 132, 'Birgu', '03', 1),
(2823, 132, 'Birkirkara', '04', 1),
(2824, 132, 'Birzebbuga', '05', 1),
(2825, 132, 'Bormla', '06', 1),
(2826, 132, 'Dingli', '07', 1),
(2827, 132, 'Fgura', '08', 1),
(2828, 132, 'Floriana', '09', 1),
(2829, 132, 'Fontana', '10', 1),
(2830, 132, 'Gudja', '11', 1),
(2831, 132, 'Gzira', '12', 1),
(2832, 132, 'Ghajnsielem', '13', 1),
(2833, 132, 'Gharb', '14', 1),
(2834, 132, 'Gharghur', '15', 1),
(2835, 132, 'Ghasri', '16', 1),
(2836, 132, 'Ghaxaq', '17', 1),
(2837, 132, 'Hamrun', '18', 1),
(2838, 132, 'Iklin', '19', 1),
(2839, 132, 'Isla', '20', 1),
(2840, 132, 'Kalkara', '21', 1),
(2841, 132, 'Kercem', '22', 1),
(2842, 132, 'Kirkop', '23', 1),
(2843, 132, 'Lija', '24', 1),
(2844, 132, 'Luqa', '25', 1),
(2845, 132, 'Marsa', '26', 1),
(2846, 132, 'Marsaskala', '27', 1),
(2847, 132, 'Marsaxlokk', '28', 1),
(2848, 132, 'Mdina', '29', 1),
(2849, 132, 'Mellieha', '30', 1),
(2850, 132, 'Mgarr', '31', 1),
(2851, 132, 'Mosta', '32', 1),
(2852, 132, 'Mqabba', '33', 1),
(2853, 132, 'Msida', '34', 1),
(2854, 132, 'Mtarfa', '35', 1),
(2855, 132, 'Munxar', '36', 1),
(2856, 132, 'Nadur', '37', 1),
(2857, 132, 'Naxxar', '38', 1),
(2858, 132, 'Paola', '39', 1),
(2859, 132, 'Pembroke', '40', 1),
(2860, 132, 'Pietŕ', '41', 1),
(2861, 132, 'Qala', '42', 1),
(2862, 132, 'Qormi', '43', 1),
(2863, 132, 'Qrendi', '44', 1),
(2864, 132, 'Rabat Gozo', '45', 1),
(2865, 132, 'Rabat Malta', '46', 1),
(2866, 132, 'Safi', '47', 1),
(2867, 132, 'Saint Julian''s', '48', 1),
(2868, 132, 'Saint John', '49', 1),
(2869, 132, 'Saint Lawrence', '50', 1),
(2870, 132, 'Saint Paul''s Bay', '51', 1),
(2871, 132, 'Sannat', '52', 1),
(2872, 132, 'Saint Lucia''s', '53', 1),
(2873, 132, 'Santa Venera', '54', 1),
(2874, 132, 'Siggiewi', '55', 1),
(2875, 132, 'Sliema', '56', 1),
(2876, 132, 'Swieqi', '57', 1),
(2877, 132, 'Ta'' Xbiex', '58', 1),
(2878, 132, 'Tarxien', '59', 1),
(2879, 132, 'Valletta', '60', 1),
(2880, 132, 'Xaghra', '61', 1),
(2881, 132, 'Xewkija', '62', 1),
(2882, 132, 'Xghajra', '63', 1),
(2883, 132, 'Zabbar', '64', 1),
(2884, 132, 'Zebbug Gozo', '65', 1),
(2885, 132, 'Zebbug Malta', '66', 1),
(2886, 132, 'Zejtun', '67', 1),
(2887, 132, 'Zurrieq', '68', 1),
(2888, 136, 'Agalega Islands', 'AG', 1),
(2889, 136, 'Black River', 'BL', 1),
(2890, 136, 'Beau Bassin-Rose Hill', 'BR', 1),
(2891, 136, 'Cargados Carajos Shoals [Saint Brandon Islands]', 'CC', 1),
(2892, 136, 'Curepipe', 'CU', 1),
(2893, 136, 'Flacq', 'FL', 1),
(2894, 136, 'Grand Port', 'GP', 1),
(2895, 136, 'Moka', 'MO', 1),
(2896, 136, 'Pamplemousses', 'PA', 1),
(2897, 136, 'Port Louis', 'PL', 1),
(2898, 136, 'Port Louis', 'PU', 1),
(2899, 136, 'Plaines wilhems', 'PW', 1),
(2900, 136, 'Quatre Bornes', 'QB', 1),
(2901, 136, 'Rodrigues Island', 'RO', 1),
(2902, 136, 'Rivičre du Rempart', 'RR', 1),
(2903, 136, 'Savanne', 'SA', 1),
(2904, 136, 'Vacoas-Phoenix', 'VP', 1),
(2905, 130, 'Alifu Dhaalu', '00', 1),
(2906, 130, 'Seenu', '01', 1),
(2907, 130, 'Alifu Alifu', '02', 1),
(2908, 130, 'Lhaviyani', '03', 1),
(2909, 130, 'Vaavu', '04', 1),
(2910, 130, 'Laamu', '05', 1),
(2911, 130, 'Haa Alif', '07', 1),
(2912, 130, 'Thaa', '08', 1),
(2913, 130, 'Meemu', '12', 1),
(2914, 130, 'Raa', '13', 1),
(2915, 130, 'Faafu', '14', 1),
(2916, 130, 'Dhaalu', '17', 1),
(2917, 130, 'Baa', '20', 1),
(2918, 130, 'Haa Dhaalu', '23', 1),
(2919, 130, 'Shaviyani', '24', 1),
(2920, 130, 'Noonu', '25', 1),
(2921, 130, 'Kaafu', '26', 1),
(2922, 130, 'Gaafu Alifu', '27', 1),
(2923, 130, 'Gaafu Dhaalu', '28', 1),
(2924, 130, 'Gnaviyani', '29', 1),
(2925, 130, 'Medhu', 'CE', 1),
(2926, 130, 'Male', 'MLE', 1),
(2927, 130, 'Medhu-Uthuru', 'NC', 1),
(2928, 130, 'Uthuru', 'NO', 1),
(2929, 130, 'Medhu-Dhekunu', 'SC', 1),
(2930, 130, 'Dhekunu', 'SU', 1),
(2931, 130, 'Mathi-Uthuru', 'UN', 1),
(2932, 130, 'Mathi-Dhekunu', 'US', 1),
(2933, 128, 'Balaka', 'BA', 1),
(2934, 128, 'Blantyre', 'BL', 1),
(2935, 128, 'Central', 'C', 1),
(2936, 128, 'Chikwawa', 'CK', 1),
(2937, 128, 'Chiradzulu', 'CR', 1),
(2938, 128, 'Chitipa', 'CT', 1),
(2939, 128, 'Dedza', 'DE', 1),
(2940, 128, 'Dowa', 'DO', 1),
(2941, 128, 'Karonga', 'KR', 1),
(2942, 128, 'Kasungu', 'KS', 1),
(2943, 128, 'Lilongwe', 'LI', 1);
INSERT INTO `#__djc2_countries_states` (`id`, `country_id`, `name`, `state_code`, `published`) VALUES
(2944, 128, 'Likoma', 'LK', 1),
(2945, 128, 'Mchinji', 'MC', 1),
(2946, 128, 'Mangochi', 'MG', 1),
(2947, 128, 'Machinga', 'MH', 1),
(2948, 128, 'Mulanje', 'MU', 1),
(2949, 128, 'Mwanza', 'MW', 1),
(2950, 128, 'Mzimba', 'MZ', 1),
(2951, 128, 'Northern', 'N', 1),
(2952, 128, 'Nkhata Bay', 'NB', 1),
(2953, 128, 'Neno', 'NE', 1),
(2954, 128, 'Ntchisi', 'NI', 1),
(2955, 128, 'Nkhotakota', 'NK', 1),
(2956, 128, 'Nsanje', 'NS', 1),
(2957, 128, 'Ntcheu', 'NU', 1),
(2958, 128, 'Phalombe', 'PH', 1),
(2959, 128, 'Rumphi', 'RU', 1),
(2960, 128, 'Southern', 'S', 1),
(2961, 128, 'Salima', 'SA', 1),
(2962, 128, 'Thyolo', 'TH', 1),
(2963, 128, 'Zomba', 'ZO', 1),
(2964, 138, 'Aguascalientes', 'AGU', 1),
(2965, 138, 'Baja California', 'BCN', 1),
(2966, 138, 'Baja California Sur', 'BCS', 1),
(2967, 138, 'Campeche', 'CAM', 1),
(2968, 138, 'Chihuahua', 'CHH', 1),
(2969, 138, 'Chiapas', 'CHP', 1),
(2970, 138, 'Coahuila', 'COA', 1),
(2971, 138, 'Colima', 'COL', 1),
(2972, 138, 'Distrito Federal', 'DIF', 1),
(2973, 138, 'Durango', 'DUR', 1),
(2974, 138, 'Guerrero', 'GRO', 1),
(2975, 138, 'Guanajuato', 'GUA', 1),
(2976, 138, 'Hidalgo', 'HID', 1),
(2977, 138, 'Jalisco', 'JAL', 1),
(2978, 138, 'México', 'MEX', 1),
(2979, 138, 'Michoacán', 'MIC', 1),
(2980, 138, 'Morelos', 'MOR', 1),
(2981, 138, 'Nayarit', 'NAY', 1),
(2982, 138, 'Nuevo León', 'NLE', 1),
(2983, 138, 'Oaxaca', 'OAX', 1),
(2984, 138, 'Puebla', 'PUE', 1),
(2985, 138, 'Querétaro', 'QUE', 1),
(2986, 138, 'Quintana Roo', 'ROO', 1),
(2987, 138, 'Sinaloa', 'SIN', 1),
(2988, 138, 'San Luis Potosí', 'SLP', 1),
(2989, 138, 'Sonora', 'SON', 1),
(2990, 138, 'Tabasco', 'TAB', 1),
(2991, 138, 'Tamaulipas', 'TAM', 1),
(2992, 138, 'Tlaxcala', 'TLA', 1),
(2993, 138, 'Veracruz', 'VER', 1),
(2994, 138, 'Yucatán', 'YUC', 1),
(2995, 138, 'Zacatecas', 'ZAC', 1),
(2996, 129, 'Johor', '01', 1),
(2997, 129, 'Kedah', '02', 1),
(2998, 129, 'Kelantan', '03', 1),
(2999, 129, 'Melaka', '04', 1),
(3000, 129, 'Negeri Sembilan', '05', 1),
(3001, 129, 'Pahang', '06', 1),
(3002, 129, 'Pulau Pinang', '07', 1),
(3003, 129, 'Perak', '08', 1),
(3004, 129, 'Perlis', '09', 1),
(3005, 129, 'Selangor', '10', 1),
(3006, 129, 'Terengganu', '11', 1),
(3007, 129, 'Sabah', '12', 1),
(3008, 129, 'Sarawak', '13', 1),
(3009, 129, 'Wilayah Persekutuan Kuala Lumpur', '14', 1),
(3010, 129, 'Wilayah Persekutuan Labuan', '15', 1),
(3011, 129, 'Wilayah Persekutuan Putrajaya', '16', 1),
(3012, 145, 'Niaosa', 'A', 1),
(3013, 145, 'Manica', 'B', 1),
(3014, 145, 'Gaza', 'G', 1),
(3015, 145, 'Inhambane', 'I', 1),
(3016, 145, 'Maputo', 'L', 1),
(3017, 145, 'Maputo', 'MPM', 1),
(3018, 145, 'Nampula', 'N', 1),
(3019, 145, 'Cabo Delgado', 'P', 1),
(3020, 145, 'Zambézia', 'Q', 1),
(3021, 145, 'Sofala', 'S', 1),
(3022, 145, 'Tete', 'T', 1),
(3023, 147, 'Zambezi', 'CA', 1),
(3024, 147, 'Erongo', 'ER', 1),
(3025, 147, 'Hardap', 'HA', 1),
(3026, 147, 'Karas', 'KA', 1),
(3027, 147, 'Kavango East', 'KE', 1),
(3028, 147, 'Khomas', 'KH', 1),
(3029, 147, 'Kunene', 'KU', 1),
(3030, 147, 'Kavango West', 'KW', 1),
(3031, 147, 'Otjozondjupa', 'OD', 1),
(3032, 147, 'Omaheke', 'OH', 1),
(3033, 147, 'Oshana', 'ON', 1),
(3034, 147, 'Omusati', 'OS', 1),
(3035, 147, 'Oshikoto', 'OT', 1),
(3036, 147, 'Ohangwena', 'OW', 1),
(3037, 155, 'Agadez', '1', 1),
(3038, 155, 'Diffa', '2', 1),
(3039, 155, 'Dosso', '3', 1),
(3040, 155, 'Maradi', '4', 1),
(3041, 155, 'Tahoua', '5', 1),
(3042, 155, 'Tillabéri', '6', 1),
(3043, 155, 'Zinder', '7', 1),
(3044, 155, 'Niamey', '8', 1),
(3045, 156, 'Abia', 'AB', 1),
(3046, 156, 'Adamawa', 'AD', 1),
(3047, 156, 'Akwa Ibom', 'AK', 1),
(3048, 156, 'Anambra', 'AN', 1),
(3049, 156, 'Bauchi', 'BA', 1),
(3050, 156, 'Benue', 'BE', 1),
(3051, 156, 'Borno', 'BO', 1),
(3052, 156, 'Bayelsa', 'BY', 1),
(3053, 156, 'Cross River', 'CR', 1),
(3054, 156, 'Delta', 'DE', 1),
(3055, 156, 'Ebonyi', 'EB', 1),
(3056, 156, 'Edo', 'ED', 1),
(3057, 156, 'Ekiti', 'EK', 1),
(3058, 156, 'Enugu', 'EN', 1),
(3059, 156, 'Abuja Capital Territory', 'FC', 1),
(3060, 156, 'Gombe', 'GO', 1),
(3061, 156, 'Imo', 'IM', 1),
(3062, 156, 'Jigawa', 'JI', 1),
(3063, 156, 'Kaduna', 'KD', 1),
(3064, 156, 'Kebbi', 'KE', 1),
(3065, 156, 'Kano', 'KN', 1),
(3066, 156, 'Kogi', 'KO', 1),
(3067, 156, 'Katsina', 'KT', 1),
(3068, 156, 'Kwara', 'KW', 1),
(3069, 156, 'Lagos', 'LA', 1),
(3070, 156, 'Nasarawa', 'NA', 1),
(3071, 156, 'Niger', 'NI', 1),
(3072, 156, 'Ogun', 'OG', 1),
(3073, 156, 'Ondo', 'ON', 1),
(3074, 156, 'Osun', 'OS', 1),
(3075, 156, 'Oyo', 'OY', 1),
(3076, 156, 'Plateau', 'PL', 1),
(3077, 156, 'Rivers', 'RI', 1),
(3078, 156, 'Sokoto', 'SO', 1),
(3079, 156, 'Taraba', 'TA', 1),
(3080, 156, 'Yobe', 'YO', 1),
(3081, 156, 'Zamfara', 'ZA', 1),
(3082, 154, 'Atlántico Norte', 'AN', 1),
(3083, 154, 'Atlántico Sur', 'AS', 1),
(3084, 154, 'Boaco', 'BO', 1),
(3085, 154, 'Carazo', 'CA', 1),
(3086, 154, 'Chinandega', 'CI', 1),
(3087, 154, 'Chontales', 'CO', 1),
(3088, 154, 'Estelí', 'ES', 1),
(3089, 154, 'Granada', 'GR', 1),
(3090, 154, 'Jinotega', 'JI', 1),
(3091, 154, 'León', 'LE', 1),
(3092, 154, 'Madriz', 'MD', 1),
(3093, 154, 'Managua', 'MN', 1),
(3094, 154, 'Masaya', 'MS', 1),
(3095, 154, 'Matagalpa', 'MT', 1),
(3096, 154, 'Nueva Segovia', 'NS', 1),
(3097, 154, 'Rivas', 'RI', 1),
(3098, 154, 'Río San Juan', 'SJ', 1),
(3099, 150, 'Drenthe', 'DR', 1),
(3100, 150, 'Flevoland', 'FL', 1),
(3101, 150, 'Fryslân', 'FR', 1),
(3102, 150, 'Gelderland', 'GE', 1),
(3103, 150, 'Groningen', 'GR', 1),
(3104, 150, 'Limburg', 'LI', 1),
(3105, 150, 'Noord-Brabant', 'NB', 1),
(3106, 150, 'Noord-Holland', 'NH', 1),
(3107, 150, 'Overijssel', 'OV', 1),
(3108, 150, 'Utrecht', 'UT', 1),
(3109, 150, 'Zeeland', 'ZE', 1),
(3110, 150, 'Zuid-Holland', 'ZH', 1),
(3111, 160, 'Řstfold', '01', 1),
(3112, 160, 'Akershus', '02', 1),
(3113, 160, 'Oslo', '03', 1),
(3114, 160, 'Hedmark', '04', 1),
(3115, 160, 'Oppland', '05', 1),
(3116, 160, 'Buskerud', '06', 1),
(3117, 160, 'Vestfold', '07', 1),
(3118, 160, 'Telemark', '08', 1),
(3119, 160, 'Aust-Agder', '09', 1),
(3120, 160, 'Vest-Agder', '10', 1),
(3121, 160, 'Rogaland', '11', 1),
(3122, 160, 'Hordaland', '12', 1),
(3123, 160, 'Sogn og Fjordane', '14', 1),
(3124, 160, 'Mřre og Romsdal', '15', 1),
(3125, 160, 'Sřr-Trřndelag', '16', 1),
(3126, 160, 'Nord-Trřndelag', '17', 1),
(3127, 160, 'Nordland', '18', 1),
(3128, 160, 'Troms', '19', 1),
(3129, 160, 'Finnmark', '20', 1),
(3130, 160, 'Svalbard (Arctic Region) (See\nalso country code SJ)', '21', 1),
(3131, 160, 'Jan Mayen (Arctic Region) (See\nalso country code SJ)', '22', 1),
(3132, 149, 'Bagmati', 'BA', 1),
(3133, 149, 'Bheri', 'BH', 1),
(3134, 149, 'Dhawalagiri', 'DH', 1),
(3135, 149, 'Gandaki', 'GA', 1),
(3136, 149, 'Janakpur', 'JA', 1),
(3137, 149, 'Karnali', 'KA', 1),
(3138, 149, 'Kosi [Koshi]', 'KO', 1),
(3139, 149, 'Lumbini', 'LU', 1),
(3140, 149, 'Mahakali', 'MA', 1),
(3141, 149, 'Mechi', 'ME', 1),
(3142, 149, 'Narayani', 'NA', 1),
(3143, 149, 'Rapti', 'RA', 1),
(3144, 149, 'Sagarmatha', 'SA', 1),
(3145, 149, 'Seti', 'SE', 1),
(3146, 148, 'Aiwo', '01', 1),
(3147, 148, 'Anabar', '02', 1),
(3148, 148, 'Anetan', '03', 1),
(3149, 148, 'Anibare', '04', 1),
(3150, 148, 'Baiti', '05', 1),
(3151, 148, 'Boe', '06', 1),
(3152, 148, 'Buada', '07', 1),
(3153, 148, 'Denigomodu', '08', 1),
(3154, 148, 'Ewa', '09', 1),
(3155, 148, 'Ijuw', '10', 1),
(3156, 148, 'Meneng', '11', 1),
(3157, 148, 'Nibok', '12', 1),
(3158, 148, 'Uaboe', '13', 1),
(3159, 148, 'Yaren', '14', 1),
(3160, 153, 'Auckland', 'AUK', 1),
(3161, 153, 'Bay of Plenty', 'BOP', 1),
(3162, 153, 'Canterbury', 'CAN', 1),
(3163, 153, 'Chatham Islands Territory', 'CIT', 1),
(3164, 153, 'Gisborne', 'GIS', 1),
(3165, 153, 'Hawkes''s Bay', 'HKB', 1),
(3166, 153, 'Marlborough', 'MBH', 1),
(3167, 153, 'Manawatu-Wanganui', 'MWT', 1),
(3168, 153, '	Nelson', 'NSN', 1),
(3169, 153, 'Northland', 'NTL', 1),
(3170, 153, 'Otago', 'OTA', 1),
(3171, 153, 'Southland', 'STL', 1),
(3172, 153, '	Tasman', 'TAS', 1),
(3173, 153, 'Taranaki', 'TKI', 1),
(3174, 153, 'Wellington', 'WGN', 1),
(3175, 153, 'Waikato', 'WKO', 1),
(3176, 153, 'West Coast', 'WTC', 1),
(3177, 161, 'Janub al Batinah', 'BJ', 1),
(3178, 161, 'Shamal al Batinah', 'BS', 1),
(3179, 161, 'Al Buraymi', 'BU', 1),
(3180, 161, 'Ad Dakhiliyah', 'DA', 1),
(3181, 161, 'Masqat', 'MA', 1),
(3182, 161, 'Musandam', 'MU', 1),
(3183, 161, 'Janub ash Sharqiyah', 'SJ', 1),
(3184, 161, 'Shamal ash Sharqiyah', 'SS', 1),
(3185, 161, 'AI Wusta', 'WU', 1),
(3186, 161, 'Az Zahirah', 'ZA', 1),
(3187, 161, 'Z¸ufar', 'ZU', 1),
(3188, 164, 'Bocas del Toro', '1', 1),
(3189, 164, 'Panamá Oeste', '10', 1),
(3190, 164, 'Coclé', '2', 1),
(3191, 164, 'Colón', '3', 1),
(3192, 164, 'Chiriquí', '4', 1),
(3193, 164, 'Darién', '5', 1),
(3194, 164, 'Herrera', '6', 1),
(3195, 164, 'Los Santos', '7', 1),
(3196, 164, 'Panamá', '8', 1),
(3197, 164, 'Veraguas', '9', 1),
(3198, 164, 'Emberá', 'EM', 1),
(3199, 164, 'Kuna Yala', 'KY', 1),
(3200, 164, 'Ngöbe-Buglé', 'NB', 1),
(3201, 167, 'Amazonas', 'AMA', 1),
(3202, 167, 'Ancash', 'ANC', 1),
(3203, 167, 'Apurímac', 'APU', 1),
(3204, 167, 'Arequipa', 'ARE', 1),
(3205, 167, 'Ayacucho', 'AYA', 1),
(3206, 167, 'Cajamarca', 'CAJ', 1),
(3207, 167, 'El Callao', 'CAL', 1),
(3208, 167, 'Cuzco [Cusco]', 'CUS', 1),
(3209, 167, 'Huánuco', 'HUC', 1),
(3210, 167, 'Huancavelica', 'HUV', 1),
(3211, 167, 'Ica', 'ICA', 1),
(3212, 167, 'Junín', 'JUN', 1),
(3213, 167, 'La Libertad', 'LAL', 1),
(3214, 167, 'Lambayeque', 'LAM', 1),
(3215, 167, 'Lima', 'LIM', 1),
(3216, 167, 'Lima hatun llaqta', 'LMA', 1),
(3217, 167, 'Loreto', 'LOR', 1),
(3218, 167, 'Madre de Dios', 'MDD', 1),
(3219, 167, 'Moquegua', 'MOQ', 1),
(3220, 167, 'Pasco', 'PAS', 1),
(3221, 167, 'Piura', 'PIU', 1),
(3222, 167, 'Puno', 'PUN', 1),
(3223, 167, 'San Martín', 'SAM', 1),
(3224, 167, 'Tacna', 'TAC', 1),
(3225, 167, 'Tumbes', 'TUM', 1),
(3226, 167, 'Ucayali', 'UCA', 1),
(3227, 165, 'Chimbu', 'CPK', 1),
(3228, 165, 'Central', 'CPM', 1),
(3229, 165, 'East New Britain', 'EBR', 1),
(3230, 165, 'Eastern Highlands', 'EHG', 1),
(3231, 165, 'Enga', 'EPW', 1),
(3232, 165, 'East Sepik', 'ESW', 1),
(3233, 165, 'Gulf', 'GPK', 1),
(3234, 165, 'Hela', 'HLA', 1),
(3235, 165, 'Jiwaka', 'JWK', 1),
(3236, 165, 'Milne Bay', 'MBA', 1),
(3237, 165, 'Morobe', 'MPL', 1),
(3238, 165, 'Madang', 'MPM', 1),
(3239, 165, 'Manus', 'MRL', 1),
(3240, 165, 'National Capital District (Port Moresby)', 'NCD', 1),
(3241, 165, 'New Ireland', 'NIK', 1),
(3242, 165, 'Northern', 'NPP', 1),
(3243, 165, 'Bougainville', 'NSB', 1),
(3244, 165, 'West Sepik', 'SAN', 1),
(3245, 165, 'Southern Highlands', 'SHM', 1),
(3246, 165, 'West New Britain', 'WBK', 1),
(3247, 165, 'Western Highlands', 'WHM', 1),
(3248, 165, 'Western', 'WPD', 1),
(3249, 168, 'National Capital Région (Manila)', '00', 1),
(3250, 168, 'Abra', 'ABR', 1),
(3251, 168, 'Agusan del Norte', 'AGN', 1),
(3252, 168, 'Agusan del Sur', 'AGS', 1),
(3253, 168, 'Aklan', 'AKL', 1),
(3254, 168, 'Albay', 'ALB', 1),
(3255, 168, 'Antique', 'ANT', 1),
(3256, 168, 'Apayao', 'APA', 1),
(3257, 168, 'Aurora', 'AUR', 1),
(3258, 168, 'Bataan', 'BAN', 1),
(3259, 168, 'Basilan', 'BAS', 1),
(3260, 168, 'Benguet', 'BEN', 1),
(3261, 168, 'Biliran', 'BIL', 1),
(3262, 168, 'Bohol', 'BOH', 1),
(3263, 168, 'Batangas', 'BTG', 1),
(3264, 168, 'Batanes', 'BTN', 1),
(3265, 168, 'Bukidnon', 'BUK', 1),
(3266, 168, 'Bulacan', 'BUL', 1),
(3267, 168, 'Cagayan', 'CAG', 1),
(3268, 168, 'Camiguin', 'CAM', 1),
(3269, 168, 'Camarines Norte', 'CAN', 1),
(3270, 168, 'Capiz', 'CAP', 1),
(3271, 168, 'Camarines Sur', 'CAS', 1),
(3272, 168, 'Catanduanes', 'CAT', 1),
(3273, 168, 'Cavite', 'CAV', 1),
(3274, 168, 'Cebu', 'CEB', 1),
(3275, 168, 'Compostela Valley', 'COM', 1),
(3276, 168, 'Davao Oriental', 'DAO', 1),
(3277, 168, 'Davao del Sur', 'DAS', 1),
(3278, 168, 'Davao del Norte', 'DAV', 1),
(3279, 168, 'Dinagat Islands', 'DIN', 1),
(3280, 168, 'Kanlurang Dabaw', 'DVO', 1),
(3281, 168, 'Eastern Samar', 'EAS', 1),
(3282, 168, 'Guimaras', 'GUI', 1),
(3283, 168, 'Ifugao', 'IFU', 1),
(3284, 168, 'Iloilo', 'ILI', 1),
(3285, 168, 'Ilocos Norte', 'ILN', 1),
(3286, 168, 'Ilocos Sur', 'ILS', 1),
(3287, 168, 'Isabela', 'ISA', 1),
(3288, 168, 'Kalinga-Apayao', 'KAL', 1),
(3289, 168, 'Laguna', 'LAG', 1),
(3290, 168, 'Lanao del Norte', 'LAN', 1),
(3291, 168, 'Lanao del Sur', 'LAS', 1),
(3292, 168, 'Leyte', 'LEY', 1),
(3293, 168, 'La Union', 'LUN', 1),
(3294, 168, 'Marinduque', 'MAD', 1),
(3295, 168, 'Maguindanao', 'MAG', 1),
(3296, 168, 'Masbate', 'MAS', 1),
(3297, 168, 'Mindoro Occidental', 'MDC', 1),
(3298, 168, 'Mindoro Oriental', 'MDR', 1),
(3299, 168, 'Mountain Province', 'MOU', 1),
(3300, 168, 'Misamis Occidental', 'MSC', 1),
(3301, 168, 'Misamis Oriental', 'MSR', 1),
(3302, 168, 'Kotabato', 'NCO', 1),
(3303, 168, 'Negros occidental', 'NEC', 1),
(3304, 168, 'Negros oriental', 'NER', 1),
(3305, 168, 'Northern Samar', 'NSA', 1),
(3306, 168, 'Nueva Ecija', 'NUE', 1),
(3307, 168, 'Nueva Vizcaya', 'NUV', 1),
(3308, 168, 'Pampanga', 'PAM', 1),
(3309, 168, 'Pangasinan', 'PAN', 1),
(3310, 168, 'Palawan', 'PLW', 1),
(3311, 168, 'Quezon', 'QUE', 1),
(3312, 168, 'Quirino', 'QUI', 1),
(3313, 168, 'Rizal', 'RIZ', 1),
(3314, 168, 'Romblon', 'ROM', 1),
(3315, 168, 'Sarangani', 'SAR', 1),
(3316, 168, 'South Cotabato', 'SCO', 1),
(3317, 168, 'Siquijor', 'SIG', 1),
(3318, 168, 'Southern Leyte', 'SLE', 1),
(3319, 168, 'Sulu', 'SLU', 1),
(3320, 168, 'Sorsogon', 'SOR', 1),
(3321, 168, 'Sultan Kudarat', 'SUK', 1),
(3322, 168, 'Surigao del Norte', 'SUN', 1),
(3323, 168, 'Surigao del Sur', 'SUR', 1),
(3324, 168, 'Tarlac', 'TAR', 1),
(3325, 168, 'Tawi-Tawi', 'TAW', 1),
(3326, 168, 'Western Samar', 'WSA', 1),
(3327, 168, 'Zamboanga del Norte', 'ZAN', 1),
(3328, 168, 'Zamboanga del Sur', 'ZAS', 1),
(3329, 168, 'Zambales', 'ZMB', 1),
(3330, 168, 'Zamboanga Sibuguey [Zamboanga Sibugay]', 'ZSI', 1),
(3331, 162, 'Balochistan', 'BA', 1),
(3332, 162, 'Gilgit-Baltistan', 'GB', 1),
(3333, 162, 'Islamabad', 'IS', 1),
(3334, 162, 'Azad Kashmir', 'JK', 1),
(3335, 162, 'Khyber Pakhtunkhwa', 'KP', 1),
(3336, 162, 'Punjab', 'PB', 1),
(3337, 162, 'Sindh', 'SD', 1),
(3338, 162, 'Federally Administered Tribal Areas', 'TA', 1),
(3339, 170, 'Dolnośląskie', 'DS', 1),
(3340, 170, 'Kujawsko-pomorskie', 'KP', 1),
(3341, 170, 'Lubuskie', 'LB', 1),
(3342, 170, 'Łódzkie', 'LD', 1),
(3343, 170, 'Lubelskie', 'LU', 1),
(3344, 170, 'Małopolskie', 'MA', 1),
(3345, 170, 'Mazowieckie', 'MZ', 1),
(3346, 170, 'Opolskie', 'OP', 1),
(3347, 170, 'Podlaskie', 'PD', 1),
(3348, 170, 'Podkarpackie', 'PK', 1),
(3349, 170, 'Pomorskie', 'PM', 1),
(3350, 170, 'Swietokrzyskie', 'SK', 1),
(3351, 170, 'Śląskie', 'SL', 1),
(3352, 170, 'Warminsko-mazurskie', 'WN', 1),
(3353, 170, 'Wielkopolskie', 'WP', 1),
(3354, 170, 'Zachodniopomorskie', 'ZP', 1),
(3355, 248, 'Bethlehem', 'BTH', 1),
(3356, 248, 'Deir El Balah', 'DEB', 1),
(3357, 248, 'Gaza', 'GZA', 1),
(3358, 248, 'Hebron', 'HBN', 1),
(3359, 248, 'Jerusalem', 'JEM', 1),
(3360, 248, '	Jericho and Al Aghwar', 'JRH', 1),
(3361, 248, 'Khan Yunis', 'KYS', 1),
(3362, 248, 'Nablus', 'NBS', 1),
(3363, 248, 'North Gaza', 'NGZ', 1),
(3364, 248, 'Qalqilya', 'QQA', 1),
(3365, 248, 'Ramallah', 'RBH', 1),
(3366, 248, 'Rafah', 'RFH', 1),
(3367, 248, 'Salfit', 'SLT', 1),
(3368, 248, 'Tubas', 'TBS', 1),
(3369, 248, 'Tulkarm', 'TKM', 1),
(3370, 171, 'Aveiro', '01', 1),
(3371, 171, 'Beja', '02', 1),
(3372, 171, 'Braga', '03', 1),
(3373, 171, 'Bragança', '04', 1),
(3374, 171, 'Castelo Branco', '05', 1),
(3375, 171, 'Coimbra', '06', 1),
(3376, 171, 'Évora', '07', 1),
(3377, 171, 'Faro', '08', 1),
(3378, 171, 'Guarda', '09', 1),
(3379, 171, 'Leiria', '10', 1),
(3380, 171, 'Lisboa', '11', 1),
(3381, 171, 'Portalegre', '12', 1),
(3382, 171, 'Porto', '13', 1),
(3383, 171, 'Santarém', '14', 1),
(3384, 171, 'Setúbal', '15', 1),
(3385, 171, 'Viana do Castelo', '16', 1),
(3386, 171, 'Vila Real', '17', 1),
(3387, 171, 'Viseu', '18', 1),
(3388, 171, 'Regiăo Autónoma dos Açores', '20', 1),
(3389, 171, 'Regiăo Autónoma da Madeira', '30', 1),
(3390, 163, 'Aimeliik    ', '002', 1),
(3391, 163, 'Airai       ', '004', 1),
(3392, 163, 'Angaur      ', '010', 1),
(3393, 163, 'Hatobohei   ', '050', 1),
(3394, 163, 'Kayangel    ', '100', 1),
(3395, 163, 'Koror       ', '150', 1),
(3396, 163, 'Melekeok    ', '212', 1),
(3397, 163, 'Ngaraard    ', '214', 1),
(3398, 163, 'Ngarchelong ', '218', 1),
(3399, 163, 'Ngardmau    ', '222', 1),
(3400, 163, 'Ngatpang    ', '224', 1),
(3401, 163, 'Ngchesar    ', '226', 1),
(3402, 163, 'Ngeremlengui', '227', 1),
(3403, 163, 'Ngiwal      ', '228', 1),
(3404, 163, 'Peleliu     ', '350', 1),
(3405, 163, 'Sonsorol    ', '370', 1),
(3406, 166, 'Concepción', '1', 1),
(3407, 166, 'Alto Paraná', '10', 1),
(3408, 166, 'Central', '11', 1),
(3409, 166, 'Ńeembucú', '12', 1),
(3410, 166, 'Amambay', '13', 1),
(3411, 166, 'Canindeyú', '14', 1),
(3412, 166, 'Presidente Hayes', '15', 1),
(3413, 166, 'Alto Paraguay', '16', 1),
(3414, 166, 'Boquerón', '19', 1),
(3415, 166, 'San Pedro', '2', 1),
(3416, 166, 'Cordillera', '3', 1),
(3417, 166, 'Guairá', '4', 1),
(3418, 166, 'Caaguazú', '5', 1),
(3419, 166, 'Caazapá', '6', 1),
(3420, 166, 'Itapúa', '7', 1),
(3421, 166, 'Misiones', '8', 1),
(3422, 166, 'Paraguarí', '9', 1),
(3423, 166, 'Asunción', 'ASU', 1),
(3424, 173, 'Ad Dawhah', 'DA', 1),
(3425, 173, 'Al Khawr wa adh Dhakhirah', 'KH', 1),
(3426, 173, 'Ash Shamal', 'MS', 1),
(3427, 173, 'Ar Rayyan', 'RA', 1),
(3428, 173, 'Umm Salal', 'US', 1),
(3429, 173, 'Al Wakrah', 'WA', 1),
(3430, 173, 'Az¸ Z¸a‘ayin', 'ZA', 1),
(3431, 175, 'Alba', 'AB', 1),
(3432, 175, 'Arges', 'AG', 1),
(3433, 175, 'Arad', 'AR', 1),
(3434, 175, 'Bucuresti', 'B', 1),
(3435, 175, 'Bacau', 'BC', 1),
(3436, 175, 'Bihor', 'BH', 1),
(3437, 175, 'Bistrita-Nasaud', 'BN', 1),
(3438, 175, 'Braila', 'BR', 1),
(3439, 175, 'Botosani', 'BT', 1),
(3440, 175, 'Brasov', 'BV', 1),
(3441, 175, 'Buzau', 'BZ', 1),
(3442, 175, 'Cluj', 'CJ', 1),
(3443, 175, 'Calarasi', 'CL', 1),
(3444, 175, 'Caras-Severin', 'CS', 1),
(3445, 175, 'Constarta', 'CT', 1),
(3446, 175, 'Covasna', 'CV', 1),
(3447, 175, 'Dâmbovita', 'DB', 1),
(3448, 175, 'Dolj', 'DJ', 1),
(3449, 175, 'Gorj', 'GJ', 1),
(3450, 175, 'Galati', 'GL', 1),
(3451, 175, 'Giurgiu', 'GR', 1),
(3452, 175, 'Hunedoara', 'HD', 1),
(3453, 175, 'Harghita', 'HR', 1),
(3454, 175, 'Ilfov', 'IF', 1),
(3455, 175, 'Ialomita', 'IL', 1),
(3456, 175, 'Iasi', 'IS', 1),
(3457, 175, 'Mehedinti', 'MH', 1),
(3458, 175, 'Maramures', 'MM', 1),
(3459, 175, 'Mures', 'MS', 1),
(3460, 175, 'Neamt', 'NT', 1),
(3461, 175, 'Olt', 'OT', 1),
(3462, 175, 'Prahova', 'PH', 1),
(3463, 175, 'Sibiu', 'SB', 1),
(3464, 175, 'Salaj', 'SJ', 1),
(3465, 175, 'Satu Mare', 'SM', 1),
(3466, 175, 'Suceava', 'SV', 1),
(3467, 175, 'Tulcea', 'TL', 1),
(3468, 175, 'Timis', 'TM', 1),
(3469, 175, 'Teleorman', 'TR', 1),
(3470, 175, 'Vâlcea', 'VL', 1),
(3471, 175, 'Vrancea', 'VN', 1),
(3472, 175, 'Vaslui', 'VS', 1),
(3473, 245, 'Beograd', '00', 1),
(3474, 245, 'Severnobacki okrug', '01', 1),
(3475, 245, 'Srednjebanatski okrug', '02', 1),
(3476, 245, 'Severnobanatski okrug', '03', 1),
(3477, 245, 'Južnobanatski okrug', '04', 1),
(3478, 245, 'Zapadnobacki okrug', '05', 1),
(3479, 245, 'Južnobacki okrug', '06', 1),
(3480, 245, 'Sremski okrug', '07', 1),
(3481, 245, 'Macvanski okrug', '08', 1),
(3482, 245, 'Kolubarski okrug', '09', 1),
(3483, 245, 'Podunavski okrug', '10', 1),
(3484, 245, 'Branicevski okrug', '11', 1),
(3485, 245, 'Šumadijski okrug', '12', 1),
(3486, 245, 'Pomoravski okrug', '13', 1),
(3487, 245, 'Borski okrug', '14', 1),
(3488, 245, 'Zajecarski okrug', '15', 1),
(3489, 245, 'Zlatiborski okrug', '16', 1),
(3490, 245, 'Moravicki okrug', '17', 1),
(3491, 245, 'Raški okrug', '18', 1),
(3492, 245, 'Rasinski okrug', '19', 1),
(3493, 245, 'Nišavski okrug', '20', 1),
(3494, 245, 'Toplicki okrug', '21', 1),
(3495, 245, 'Pirotski okrug', '22', 1),
(3496, 245, 'Jablanicki okrug', '23', 1),
(3497, 245, 'Pcinjski okrug', '24', 1),
(3498, 245, 'Kosovski okrug', '25', 1),
(3499, 245, 'Pecki okrug', '26', 1),
(3500, 245, 'Prizrenski okrug', '27', 1),
(3501, 245, 'Kosovsko-Mitrovacki okrug', '28', 1),
(3502, 245, 'Kosovsko-Pomoravski okrug', '29', 1),
(3503, 245, 'Kosovo-Metohija', 'KM', 1),
(3504, 245, 'Vojvodina', 'VO', 1),
(3505, 176, 'Adygeya, Respublika', 'AD', 1),
(3506, 176, 'Altay, Respublika', 'AL', 1),
(3507, 176, 'Altayskiy kray', 'ALT', 1),
(3508, 176, 'Amurskaya oblast''', 'AMU', 1),
(3509, 176, 'Arkhangel''skaya oblast,', 'ARK', 1),
(3510, 176, 'Astrakhanskaya oblast''', 'AST', 1),
(3511, 176, 'Bashkortostan, Respublika', 'BA', 1),
(3512, 176, 'Belgorodskaya oblast''', 'BEL', 1),
(3513, 176, 'Bryanskaya oblast''', 'BRY', 1),
(3514, 176, 'Buryatiya, Respublika', 'BU', 1),
(3515, 176, 'Chechenskaya Respublika', 'CE', 1),
(3516, 176, 'Chelyabinskaya oblast''', 'CHE', 1),
(3517, 176, 'Chukotskiy avtonomnyy okrug', 'CHU', 1),
(3518, 176, 'Chuvashskaya Respublika', 'CU', 1),
(3519, 176, 'Dagestan, Respublika', 'DA', 1),
(3520, 176, 'Ingushskaya Respublika [Respublika Ingushetiya]', 'IN', 1),
(3521, 176, 'Irkutskaya oblast''', 'IRK', 1),
(3522, 176, 'Ivanovskaya oblast''', 'IVA', 1),
(3523, 176, 'Kamchatskaya oblast''', 'KAM', 1),
(3524, 176, 'Kabardino-Balkarskaya Respublika', 'KB', 1),
(3525, 176, 'Karachayevo-Cherkesskaya Respublika', 'KC', 1),
(3526, 176, 'Krasnodarskiy kray', 'KDA', 1),
(3527, 176, 'Kemerovskaya oblast''', 'KEM', 1),
(3528, 176, 'Kaliningradskaya oblast,', 'KGD', 1),
(3529, 176, 'Kurganskaya oblast''', 'KGN', 1),
(3530, 176, 'Khabarovskiy kray', 'KHA', 1),
(3531, 176, 'Khanty-Mansiyskiy avtonomnyy okrug', 'KHM', 1),
(3532, 176, 'Kirovskaya oblast''', 'KIR', 1),
(3533, 176, 'Khakasiya, Respublika', 'KK', 1),
(3534, 176, 'Kalmykiya, Respublika', 'KL', 1),
(3535, 176, 'Kaluzhskaya oblast''', 'KLU', 1),
(3536, 176, 'Komi, Respublika', 'KO', 1),
(3537, 176, 'Kostromskaya oblast''', 'KOS', 1),
(3538, 176, 'Kareliya, Respublika', 'KR', 1),
(3539, 176, 'Kurskaya oblast''', 'KRS', 1),
(3540, 176, 'Krasnoyarskiy kray', 'KYA', 1),
(3541, 176, 'Leningradskaya oblast''', 'LEN', 1),
(3542, 176, 'Lipetskaya oblast''', 'LIP', 1),
(3543, 176, 'Magadanskaya oblast''', 'MAG', 1),
(3544, 176, 'Mariy El, Respublika', 'ME', 1),
(3545, 176, 'Mordoviya, Respublika', 'MO', 1),
(3546, 176, 'Moskovskaya oblast''', 'MOS', 1),
(3547, 176, 'Moskva', 'MOW', 1),
(3548, 176, 'Murmanskaya oblast''', 'MUR', 1),
(3549, 176, 'Nenetskiy avtonomnyy okrug', 'NEN', 1),
(3550, 176, 'Novgorodskaya oblast''', 'NGR', 1),
(3551, 176, 'Nizhegorodskaya oblast''', 'NIZ', 1),
(3552, 176, 'Novosibirskaya oblast''', 'NVS', 1),
(3553, 176, 'Omskaya oblast''', 'OMS', 1),
(3554, 176, 'Orenburgskaya oblast''', 'ORE', 1),
(3555, 176, 'Orlovskaya oblast''', 'ORL', 1),
(3556, 176, 'Perm', 'PER', 1),
(3557, 176, 'Penzenskaya oblast''', 'PNZ', 1),
(3558, 176, 'Primorskiy kray', 'PRI', 1),
(3559, 176, 'Pskovskaya oblast''', 'PSK', 1),
(3560, 176, 'Rostovskaya oblast''', 'ROS', 1),
(3561, 176, 'Ryazanskaya oblast''', 'RYA', 1),
(3562, 176, 'Sakha, Respublika [Yakutiya]', 'SA', 1),
(3563, 176, 'Sakhalinskaya oblast''', 'SAK', 1),
(3564, 176, 'Samarskaya oblast''', 'SAM', 1),
(3565, 176, 'Saratovskaya oblast''', 'SAR', 1),
(3566, 176, 'Severnaya Osetiya, Respublika Alaniya] [Respublika Severnaya Osetiya-Alaniya]', 'SE', 1),
(3567, 176, 'Smolenskaya oblast''', 'SMO', 1),
(3568, 176, 'Sankt-Peterburg', 'SPE', 1),
(3569, 176, 'Stavropol''skiy kray', 'STA', 1),
(3570, 176, 'Sverdlovskaya oblast''', 'SVE', 1),
(3571, 176, 'Tatarstan, Respublika', 'TA', 1),
(3572, 176, 'Tambovskaya oblast''', 'TAM', 1),
(3573, 176, 'Tomskaya oblast''', 'TOM', 1),
(3574, 176, 'Tul''skaya oblast''', 'TUL', 1),
(3575, 176, 'Tverskaya oblast''', 'TVE', 1),
(3576, 176, 'Tyva, Respublika [Tuva]', 'TY', 1),
(3577, 176, 'Tyumenskaya oblast''', 'TYU', 1),
(3578, 176, 'Udmurtskaya Respublika', 'UD', 1),
(3579, 176, 'Ul''yanovskaya oblast''', 'ULY', 1),
(3580, 176, 'Volgogradskaya oblast''', 'VGG', 1),
(3581, 176, 'Vladimirskaya oblast''', 'VLA', 1),
(3582, 176, 'Vologodskaya oblast''', 'VLG', 1),
(3583, 176, 'Voronezhskaya oblast''', 'VOR', 1),
(3584, 176, 'Yamalo-Nenetskiy avtonomnyy okrug', 'YAN', 1),
(3585, 176, 'Yaroslavskaya oblast''', 'YAR', 1),
(3586, 176, 'Yevreyskaya avtonomnaya oblast''', 'YEV', 1),
(3587, 176, 'Zabaykal''skiy kray', 'ZAB', 1),
(3588, 177, 'Ville de Kigali', '01', 1),
(3589, 177, 'Est', '02', 1),
(3590, 177, 'Nord', '03', 1),
(3591, 177, 'Ouest', '04', 1),
(3592, 177, 'Sud', '05', 1),
(3593, 184, 'Ar Riyad', '01', 1),
(3594, 184, 'Makkah al Mukarramah', '02', 1),
(3595, 184, 'Al Madinah al Munawwarah', '03', 1),
(3596, 184, 'Ash Sharqiyah', '04', 1),
(3597, 184, 'AI Qasim', '05', 1),
(3598, 184, 'Ha''il', '06', 1),
(3599, 184, 'Tabuk', '07', 1),
(3600, 184, 'AI Hudud ash Shamaliyah', '08', 1),
(3601, 184, 'Jazan', '09', 1),
(3602, 184, 'Najran', '10', 1),
(3603, 184, 'AI Bahah', '11', 1),
(3604, 184, 'AI Jawf', '12', 1),
(3605, 184, '''Asir', '14', 1),
(3606, 191, 'Central', 'CE', 1),
(3607, 191, 'Choiseul', 'CH', 1),
(3608, 191, 'Capital Territory (Honiara)', 'CT', 1),
(3609, 191, 'Guadalcanal', 'GU', 1),
(3610, 191, 'Isabel', 'IS', 1),
(3611, 191, 'Makira-Ulawa', 'MK', 1),
(3612, 191, 'Malaita', 'ML', 1),
(3613, 191, 'Rennell and Bellona', 'RB', 1),
(3614, 191, 'Temotu', 'TE', 1),
(3615, 191, 'Western', 'WE', 1),
(3616, 186, 'Anse aux Pins', '01', 1),
(3617, 186, 'Anse Boileau         ', '02', 1),
(3618, 186, 'Anse Étoile          ', '03', 1),
(3619, 186, 'Au Cap', '04', 1),
(3620, 186, 'Anse Royale          ', '05', 1),
(3621, 186, 'Baie Lazare          ', '06', 1),
(3622, 186, 'Baie Sainte Anne     ', '07', 1),
(3623, 186, 'Beau Vallon          ', '08', 1),
(3624, 186, 'Bel Air              ', '09', 1),
(3625, 186, 'Bel Ombre            ', '10', 1),
(3626, 186, 'Cascade              ', '11', 1),
(3627, 186, 'Glacis               ', '12', 1),
(3628, 186, 'Grand''Anse Mahé', '13', 1),
(3629, 186, 'Grand''Anse Praslin', '14', 1),
(3630, 186, 'La Digue             ', '15', 1),
(3631, 186, 'La Rivičre Anglaise  ', '16', 1),
(3632, 186, 'Mont Buxton          ', '17', 1),
(3633, 186, 'Mont Fleuri          ', '18', 1),
(3634, 186, 'Plaisance            ', '19', 1),
(3635, 186, 'Pointe La Rue        ', '20', 1),
(3636, 186, 'Port Glaud           ', '21', 1),
(3637, 186, 'Saint Louis          ', '22', 1),
(3638, 186, 'Takamaka             ', '23', 1),
(3639, 186, 'Lemamel', '24', 1),
(3640, 186, 'Ros Kaiman', '25', 1),
(3641, 199, 'Wasat Darfur Zalinjay', 'DC', 1),
(3642, 199, 'Sharq Darfur', 'DE', 1),
(3643, 199, 'Shamal Darfur', 'DN', 1),
(3644, 199, 'Janub Darfur', 'DS', 1),
(3645, 199, 'Gharb Darfur', 'DW', 1),
(3646, 199, 'Al Qadarif', 'GD', 1),
(3647, 199, 'Gharb Kurdufan', 'GK', 1),
(3648, 199, 'Al Jazirah', 'GZ', 1),
(3649, 199, 'Kassala', 'KA', 1),
(3650, 199, 'Al Khartum', 'KH', 1),
(3651, 199, 'Shiamal Kurdufan', 'KN', 1),
(3652, 199, 'Janub Kurdufan', 'KS', 1),
(3653, 199, 'An Nil al Azraq', 'NB', 1),
(3654, 199, 'Ash Shamaliyah', 'NO', 1),
(3655, 199, 'Nahr an Nil', 'NR', 1),
(3656, 199, 'An Nil al Abya?', 'NW', 1),
(3657, 199, 'Al Ba?r al A?mar', 'RS', 1),
(3658, 199, 'Sinnar', 'SI', 1),
(3659, 203, 'Stockholms län', 'AB', 1),
(3660, 203, 'Västerbottens län', 'AC', 1),
(3661, 203, 'Norrbottens län', 'BD', 1),
(3662, 203, 'Uppsala län', 'C', 1),
(3663, 203, 'Södermanlands län', 'D', 1),
(3664, 203, 'Östergötlands län', 'E', 1),
(3665, 203, 'Jönköpings län', 'F', 1),
(3666, 203, 'Kronoborgs län', 'G', 1),
(3667, 203, 'Kalmar län', 'H', 1),
(3668, 203, 'Gotlands län', 'I', 1),
(3669, 203, 'Blekinge län', 'K', 1),
(3670, 203, 'Skĺne län', 'M', 1),
(3671, 203, 'Hallands län', 'N', 1),
(3672, 203, 'Västra Götalands län', 'O', 1),
(3673, 203, 'Värmlands län', 'S', 1),
(3674, 203, 'Örebro län', 'T', 1),
(3675, 203, 'Västmanlands län', 'U', 1),
(3676, 203, 'Dalarnes län', 'W', 1),
(3677, 203, 'Gävleborgs län', 'X', 1),
(3678, 203, 'Västernorrlands län', 'Y', 1),
(3679, 203, 'Jämtlands län', 'Z', 1),
(3680, 188, 'Central Singapore', '01', 1),
(3681, 188, 'North East', '02', 1),
(3682, 188, 'North West', '03', 1),
(3683, 188, 'South East', '04', 1),
(3684, 188, 'South West', '05', 1),
(3685, 197, 'Ascension', 'AC', 1),
(3686, 197, 'Saint Helena', 'HL', 1),
(3687, 197, 'Tristan da Cunha', 'TA', 1),
(3688, 190, 'Ajdovšcina', '001', 1),
(3689, 190, 'Beltinci', '002', 1),
(3690, 190, 'Bled', '003', 1),
(3691, 190, 'Bohinj', '004', 1),
(3692, 190, 'Borovnica', '005', 1),
(3693, 190, 'Bovec', '006', 1),
(3694, 190, 'Brda', '007', 1),
(3695, 190, 'Brezovica', '008', 1),
(3696, 190, 'Brežice', '009', 1),
(3697, 190, 'Tišina', '010', 1),
(3698, 190, 'Celje', '011', 1),
(3699, 190, 'Cerklje na Gorenjskem', '012', 1),
(3700, 190, 'Cerknica', '013', 1),
(3701, 190, 'Cerkno', '014', 1),
(3702, 190, 'Crenšovci', '015', 1),
(3703, 190, 'Crna na Koroškem', '016', 1),
(3704, 190, 'Crnomelj', '017', 1),
(3705, 190, 'Destrnik', '018', 1),
(3706, 190, 'Divaca', '019', 1),
(3707, 190, 'Dobrepolje', '020', 1),
(3708, 190, 'Dobrova-Polhov Gradec', '021', 1),
(3709, 190, 'Dol pri Ljubljani', '022', 1),
(3710, 190, 'Domžale', '023', 1),
(3711, 190, 'Dornava', '024', 1),
(3712, 190, 'Dravograd', '025', 1),
(3713, 190, 'Duplek', '026', 1),
(3714, 190, 'Gorenja vas-Poljane', '027', 1),
(3715, 190, 'Gorišnica', '028', 1),
(3716, 190, 'Gornja Radgona', '029', 1),
(3717, 190, 'Gornji Grad', '030', 1),
(3718, 190, 'Gornji Petrovci', '031', 1),
(3719, 190, 'Grosuplje', '032', 1),
(3720, 190, 'Šalovci', '033', 1),
(3721, 190, 'Hrastnik', '034', 1),
(3722, 190, 'Hrpelje-Kozina', '035', 1),
(3723, 190, 'Idrija', '036', 1),
(3724, 190, 'Ig', '037', 1),
(3725, 190, 'Ilirska Bistrica', '038', 1),
(3726, 190, 'Ivancna Gorica', '039', 1),
(3727, 190, 'Izola', '040', 1),
(3728, 190, 'Jesenice', '041', 1),
(3729, 190, 'Juršinci', '042', 1),
(3730, 190, 'Kamnik', '043', 1),
(3731, 190, 'Kanal', '044', 1),
(3732, 190, 'Kidricevo', '045', 1),
(3733, 190, 'Kobarid', '046', 1),
(3734, 190, 'Kobilje', '047', 1),
(3735, 190, 'Kocevje', '048', 1),
(3736, 190, 'Komen', '049', 1),
(3737, 190, 'Koper', '050', 1),
(3738, 190, 'Kozje', '051', 1),
(3739, 190, 'Kranj', '052', 1),
(3740, 190, 'Kranjska Gora', '053', 1),
(3741, 190, 'Krško', '054', 1),
(3742, 190, 'Kungota', '055', 1),
(3743, 190, 'Kuzma', '056', 1),
(3744, 190, 'Laško', '057', 1),
(3745, 190, 'Lenart', '058', 1),
(3746, 190, 'Lendava', '059', 1),
(3747, 190, 'Litija', '060', 1),
(3748, 190, 'Ljubljana', '061', 1),
(3749, 190, 'Ljubno', '062', 1),
(3750, 190, 'Ljutomer', '063', 1),
(3751, 190, 'Logatec', '064', 1),
(3752, 190, 'Loška dolina', '065', 1),
(3753, 190, 'Loški Potok', '066', 1),
(3754, 190, 'Luce', '067', 1),
(3755, 190, 'Lukovica', '068', 1),
(3756, 190, 'Majšperk', '069', 1),
(3757, 190, 'Maribor', '070', 1),
(3758, 190, 'Medvode', '071', 1),
(3759, 190, 'Mengeš', '072', 1),
(3760, 190, 'Metlika', '073', 1),
(3761, 190, 'Mežica', '074', 1),
(3762, 190, 'Miren-Kostanjevica', '075', 1),
(3763, 190, 'Mislinja', '076', 1),
(3764, 190, 'Moravce', '077', 1),
(3765, 190, 'Moravske Toplice', '078', 1),
(3766, 190, 'Mozirje', '079', 1),
(3767, 190, 'Murska Sobota', '080', 1),
(3768, 190, 'Muta', '081', 1),
(3769, 190, 'Naklo', '082', 1),
(3770, 190, 'Nazarje', '083', 1),
(3771, 190, 'Nova Gorica', '084', 1),
(3772, 190, 'Novo mesto', '085', 1),
(3773, 190, 'Odranci', '086', 1),
(3774, 190, 'Ormož', '087', 1),
(3775, 190, 'Osilnica', '088', 1),
(3776, 190, 'Pesnica', '089', 1),
(3777, 190, 'Piran', '090', 1),
(3778, 190, 'Pivka', '091', 1),
(3779, 190, 'Podcetrtek', '092', 1),
(3780, 190, 'Podvelka', '093', 1),
(3781, 190, 'Postojna', '094', 1),
(3782, 190, 'Preddvor', '095', 1),
(3783, 190, 'Ptuj', '096', 1),
(3784, 190, 'Puconci', '097', 1),
(3785, 190, 'Race-Fram', '098', 1),
(3786, 190, 'Radece', '099', 1),
(3787, 190, 'Radenci', '100', 1),
(3788, 190, 'Radlje ob Dravi', '101', 1),
(3789, 190, 'Radovljica', '102', 1),
(3790, 190, 'Ravne na Koroškem', '103', 1),
(3791, 190, 'Ribnica', '104', 1),
(3792, 190, 'Rogašovci', '105', 1),
(3793, 190, 'Rogaška Slatina', '106', 1),
(3794, 190, 'Rogatec', '107', 1),
(3795, 190, 'Ruše', '108', 1),
(3796, 190, 'Semic', '109', 1),
(3797, 190, 'Sevnica', '110', 1),
(3798, 190, 'Sežana', '111', 1),
(3799, 190, 'Slovenj Gradec', '112', 1),
(3800, 190, 'Slovenska Bistrica', '113', 1),
(3801, 190, 'Slovenske Konjice', '114', 1),
(3802, 190, 'Starše', '115', 1),
(3803, 190, 'Sveti Jurij', '116', 1),
(3804, 190, 'Šencur', '117', 1),
(3805, 190, 'Šentilj', '118', 1),
(3806, 190, 'Šentjernej', '119', 1),
(3807, 190, 'Šentjur', '120', 1),
(3808, 190, 'Škocjan', '121', 1),
(3809, 190, 'Škofja Loka', '122', 1),
(3810, 190, 'Škofljica', '123', 1),
(3811, 190, 'Šmarje pri Jelšah', '124', 1),
(3812, 190, 'Šmartno ob Paki', '125', 1),
(3813, 190, 'Šoštanj', '126', 1),
(3814, 190, 'Štore', '127', 1),
(3815, 190, 'Tolmin', '128', 1),
(3816, 190, 'Trbovlje', '129', 1),
(3817, 190, 'Trebnje', '130', 1),
(3818, 190, 'Tržic', '131', 1),
(3819, 190, 'Turnišce', '132', 1),
(3820, 190, 'Velenje', '133', 1),
(3821, 190, 'Velike Lašce', '134', 1),
(3822, 190, 'Videm', '135', 1),
(3823, 190, 'Vipava', '136', 1),
(3824, 190, 'Vitanje', '137', 1),
(3825, 190, 'Vodice', '138', 1),
(3826, 190, 'Vojnik', '139', 1),
(3827, 190, 'Vrhnika', '140', 1),
(3828, 190, 'Vuzenica', '141', 1),
(3829, 190, 'Zagorje ob Savi', '142', 1),
(3830, 190, 'Zavrc', '143', 1),
(3831, 190, 'Zrece', '144', 1),
(3832, 190, 'Železniki', '146', 1),
(3833, 190, 'Žiri', '147', 1),
(3834, 190, 'Benedikt', '148', 1),
(3835, 190, 'Bistrica ob Sotli', '149', 1),
(3836, 190, 'Bloke', '150', 1),
(3837, 190, 'Braslovce', '151', 1),
(3838, 190, 'Cankova', '152', 1),
(3839, 190, 'Cerkvenjak', '153', 1),
(3840, 190, 'Dobje', '154', 1),
(3841, 190, 'Dobrna', '155', 1),
(3842, 190, 'Dobrovnik', '156', 1),
(3843, 190, 'Dolenjske Toplice', '157', 1),
(3844, 190, 'Grad', '158', 1),
(3845, 190, 'Hajdina', '159', 1),
(3846, 190, 'Hoce-Slivnica', '160', 1),
(3847, 190, 'Hodoš', '161', 1),
(3848, 190, 'Horjul', '162', 1),
(3849, 190, 'Jezersko', '163', 1),
(3850, 190, 'Komenda', '164', 1),
(3851, 190, 'Kostel', '165', 1),
(3852, 190, 'Križevci', '166', 1),
(3853, 190, 'Lovrenc na Pohorju', '167', 1),
(3854, 190, 'Markovci', '168', 1),
(3855, 190, 'Miklavž na Dravskem polju', '169', 1),
(3856, 190, 'Mirna Pec', '170', 1),
(3857, 190, 'Oplotnica', '171', 1),
(3858, 190, 'Podlehnik', '172', 1),
(3859, 190, 'Polzela', '173', 1),
(3860, 190, 'Prebold', '174', 1),
(3861, 190, 'Prevalje', '175', 1),
(3862, 190, 'Razkrižje', '176', 1),
(3863, 190, 'Ribnica na Pohorju', '177', 1),
(3864, 190, 'Selnica ob Dravi', '178', 1),
(3865, 190, 'Sodražica', '179', 1),
(3866, 190, 'Solcava', '180', 1),
(3867, 190, 'Sveta Ana', '181', 1),
(3868, 190, 'Sveti Andraž v Slovenskih goricah', '182', 1),
(3869, 190, 'Šempeter-Vrtojba', '183', 1),
(3870, 190, 'Tabor', '184', 1),
(3871, 190, 'Trnovska vas', '185', 1),
(3872, 190, 'Trzin', '186', 1),
(3873, 190, 'Velika Polana', '187', 1),
(3874, 190, 'Veržej', '188', 1),
(3875, 190, 'Vransko', '189', 1),
(3876, 190, 'Žalec', '190', 1),
(3877, 190, 'Žetale', '191', 1),
(3878, 190, 'Žirovnica', '192', 1),
(3879, 190, 'Žužemberk', '193', 1),
(3880, 190, 'Šmartno pri Litiji', '194', 1),
(3881, 190, 'Apace', '195', 1),
(3882, 190, 'Cirkulane', '196', 1),
(3883, 190, 'Kosanjevica na Krki', '197', 1),
(3884, 190, 'Makole', '198', 1),
(3885, 190, 'Mokronog-Trebelno', '199', 1),
(3886, 190, 'Poljcane', '200', 1),
(3887, 190, 'Renče-Vogrsko', '201', 1),
(3888, 190, 'Središce ob Dravi', '202', 1),
(3889, 190, 'Straža', '203', 1),
(3890, 190, 'Sveta Trojica v Slovenskih\nGoricah', '204', 1),
(3891, 190, 'Sveti Tomaž', '205', 1),
(3892, 190, 'Šmarješke Toplice', '206', 1),
(3893, 190, 'Gorje', '207', 1),
(3894, 190, 'Log-Dragomer', '208', 1),
(3895, 190, 'Recica ob Savinji', '209', 1),
(3896, 190, 'Sveti Jurij v Slovenskih Goricah', '210', 1),
(3897, 190, 'Šentrupert', '211', 1),
(3898, 190, 'Mirna', '212', 1),
(3899, 189, 'Banskobystrický kraj', 'BC', 1),
(3900, 189, 'Bratislavský kraj', 'BL', 1),
(3901, 189, 'Košický kraj', 'KI', 1),
(3902, 189, 'Nitriansky kraj', 'NI', 1),
(3903, 189, 'Prešovský kraj', 'PV', 1),
(3904, 189, 'Trnavský kraj', 'TA', 1),
(3905, 189, 'Trenciansky kraj', 'TC', 1),
(3906, 189, 'Žilinský kraj', 'ZI', 1),
(3907, 187, 'Eastern', 'E', 1),
(3908, 187, 'Northern', 'N', 1),
(3909, 187, 'Southern', 'S', 1),
(3910, 187, 'Western Area (Freetown)', 'W', 1),
(3911, 182, 'Acquaviva      ', '01', 1),
(3912, 182, 'Chiesanuova    ', '02', 1),
(3913, 182, 'Domagnano      ', '03', 1),
(3914, 182, 'Faetano        ', '04', 1),
(3915, 182, 'Fiorentino     ', '05', 1),
(3916, 182, 'Borgo Maggiore ', '06', 1),
(3917, 182, 'San Marino     ', '07', 1),
(3918, 182, 'Montegiardino  ', '08', 1),
(3919, 182, 'Serravalle     ', '09', 1),
(3920, 185, 'Diourbel', 'DB ', 1),
(3921, 185, 'Dakar', 'DK', 1),
(3922, 185, 'Fatick', 'FK', 1),
(3923, 185, 'Kaffrine', 'KA', 1),
(3924, 185, 'Kolda', 'KD', 1),
(3925, 185, 'Kédougou', 'KE', 1),
(3926, 185, 'Kaolack', 'KL', 1),
(3927, 185, 'Louga', 'LG', 1),
(3928, 185, 'Matam', 'MT', 1),
(3929, 185, 'Sédhiou', 'SE', 1),
(3930, 185, 'Saint-Louis', 'SL', 1),
(3931, 185, 'Tambacounda', 'TC', 1),
(3932, 185, 'Thičs', 'TH', 1),
(3933, 185, 'Ziguinchor', 'ZG', 1),
(3934, 192, 'Awdal', 'AW', 1),
(3935, 192, 'Bakool', 'BK', 1),
(3936, 192, 'Banaadir', 'BN', 1),
(3937, 192, 'Bari', 'BR', 1),
(3938, 192, 'Bay', 'BY', 1),
(3939, 192, 'Galguduud', 'GA', 1),
(3940, 192, 'Gedo', 'GE ', 1),
(3941, 192, 'Hiiraan', 'HI', 1),
(3942, 192, 'Jubbada Dhexe', 'JD', 1),
(3943, 192, 'Jubbada Hoose', 'JH', 1),
(3944, 192, 'Mudug', 'MU', 1),
(3945, 192, 'Nugaal', 'NU', 1),
(3946, 192, 'Sanaag', 'SA', 1),
(3947, 192, 'Shabeellaha Dhexe', 'SD', 1),
(3948, 192, 'Shabeellaha Hoose', 'SH', 1),
(3949, 192, 'Sool', 'SO', 1),
(3950, 192, 'Togdheer', 'TO', 1),
(3951, 192, 'Woqooyi Galbeed', 'WO', 1),
(3952, 200, 'Brokopondo', 'BR', 1),
(3953, 200, 'Commewijne', 'CM', 1),
(3954, 200, 'Coronie', 'CR', 1),
(3955, 200, 'Marowijne', 'MA', 1),
(3956, 200, 'Nickerie', 'NI', 1),
(3957, 200, 'Paramaribo', 'PM', 1),
(3958, 200, 'Para', 'PR', 1),
(3959, 200, 'Saramacca', 'SA', 1),
(3960, 200, 'Sipaliwini', 'SI', 1),
(3961, 200, 'Wanica', 'WA', 1),
(3962, 252, 'Northern Bahr el Ghazal', 'BN', 1),
(3963, 252, 'Western Bahr el Ghazal', 'BW', 1),
(3964, 252, 'Central Equatoria', 'EC', 1),
(3965, 252, 'Eastern Equatoria', 'EE', 1),
(3966, 252, 'Western Equatoria', 'EW', 1),
(3967, 252, 'Jonglei', 'JG', 1),
(3968, 252, 'Lakes', 'LK', 1),
(3969, 252, 'Upper Nile', 'NU', 1),
(3970, 252, 'Unity', 'UY', 1),
(3971, 252, 'Warrap', 'WR', 1),
(3972, 183, 'Príncipe', 'P', 1),
(3973, 183, 'Săo Tomé', 'S', 1),
(3974, 64, 'Ahuachapán', 'AH', 1),
(3975, 64, 'Cabańas', 'CA', 1),
(3976, 64, 'Chalatenango', 'CH', 1),
(3977, 64, 'Cuscatlán', 'CU', 1),
(3978, 64, 'La Libertad', 'LI', 1),
(3979, 64, 'Morazán', 'MO', 1),
(3980, 64, 'La Paz', 'PA', 1),
(3981, 64, 'Santa Ana', 'SA', 1),
(3982, 64, 'San Miguel', 'SM', 1),
(3983, 64, 'Sonsonate', 'SO', 1),
(3984, 64, 'San Salvador', 'SS', 1),
(3985, 64, 'San Vicente', 'SV', 1),
(3986, 64, 'La Unión', 'UN', 1),
(3987, 64, 'Usulután', 'US', 1),
(3988, 205, 'Dimashq', 'DI', 1),
(3989, 205, 'Dar''a', 'DR', 1),
(3990, 205, 'Dayr az Zawr', 'DY', 1),
(3991, 205, 'AI Hasakah', 'HA', 1),
(3992, 205, 'Hims', 'HI', 1),
(3993, 205, 'Halab', 'HL', 1),
(3994, 205, 'Hamah', 'HM', 1),
(3995, 205, 'Idlib', 'ID', 1),
(3996, 205, 'AI Ladhiqiyah', 'LA', 1),
(3997, 205, 'AI Qunaytirah', 'QU', 1),
(3998, 205, 'Ar Raqqah', 'RA', 1),
(3999, 205, 'Rif Dimashq', 'RD', 1),
(4000, 205, 'As Suwayda''', 'SU', 1),
(4001, 205, 'Tartus', 'TA', 1),
(4002, 42, 'Batha', 'BA', 1),
(4003, 42, 'Ba?r al Ghazal', 'BG', 1),
(4004, 42, 'Burku', 'BO', 1),
(4005, 42, 'Chari-Baguirmi', 'CB', 1),
(4006, 42, 'Ennedi-Est', 'EE', 1),
(4007, 42, 'Ennedi-Ouest', 'EO', 1),
(4008, 42, 'Guéra', 'GR', 1),
(4009, 42, 'Hadjer Lamis', 'HL', 1),
(4010, 42, 'Kanem', 'KA', 1),
(4011, 42, 'Lac', 'LC', 1),
(4012, 42, 'Logone-Occidental', 'LO', 1),
(4013, 42, 'Logone-Oriental', 'LR', 1),
(4014, 42, 'Mandoul', 'MA', 1),
(4015, 42, 'Moyen-Chari', 'MC', 1),
(4016, 42, 'Mayo-Kebbi-Est', 'ME', 1),
(4017, 42, 'Mayo-Kebbi-Ouest', 'MO', 1),
(4018, 42, 'Ville de Ndjamena', 'ND', 1),
(4019, 42, 'Ouaddaď', 'OD', 1),
(4020, 42, 'Salamat', 'SA', 1),
(4021, 42, 'Sila', 'SI', 1),
(4022, 42, 'Tandjilé', 'TA', 1),
(4023, 42, 'Tibasti', 'TI', 1),
(4024, 42, 'Wadi Fira', 'WF', 1),
(4025, 210, 'Centre', 'C', 1),
(4026, 210, 'Kara', 'K', 1),
(4027, 210, 'Maritime (Région)', 'M', 1),
(4028, 210, 'Plateaux', 'P', 1),
(4029, 210, 'Savannes', 'S', 1),
(4030, 209, 'Krung Thep Maha Nakhon [Bangkok]', '10', 1),
(4031, 209, 'Samut Prakan', '11', 1),
(4032, 209, 'Nonthaburi', '12', 1),
(4033, 209, 'Pathum Thani', '13', 1),
(4034, 209, 'Phra Nakhon Si Ayutthaya', '14', 1),
(4035, 209, 'Ang Thong', '15', 1),
(4036, 209, 'Lop Buri', '16', 1),
(4037, 209, 'Sing Buri', '17', 1),
(4038, 209, 'Chai Nat', '18', 1),
(4039, 209, 'Saraburi', '19', 1),
(4040, 209, 'Chon Buri', '20', 1),
(4041, 209, 'Rayong', '21', 1),
(4042, 209, 'Chanthaburi', '22', 1),
(4043, 209, 'Trat', '23', 1),
(4044, 209, 'Chachoengsao', '24', 1),
(4045, 209, 'Prachin Buri', '25', 1),
(4046, 209, 'Nakhon Nayok', '26', 1),
(4047, 209, 'Sa Kaeo', '27', 1),
(4048, 209, 'Nakhon Ratchasima', '30', 1),
(4049, 209, 'Buri Ram', '31', 1),
(4050, 209, 'Surin', '32', 1),
(4051, 209, 'Si Sa Ket', '33', 1),
(4052, 209, 'Ubon Ratchathani', '34', 1),
(4053, 209, 'Yasothon', '35', 1),
(4054, 209, 'Chaiyaphum', '36', 1),
(4055, 209, 'Amnat Charoen', '37', 1),
(4056, 209, 'Bueng Kan', '38', 1),
(4057, 209, 'Nong Bua Lam Phu', '39', 1),
(4058, 209, 'Khon Kaen', '40', 1),
(4059, 209, 'Udon Thani', '41', 1),
(4060, 209, 'Loei', '42', 1),
(4061, 209, 'Nong Khai', '43', 1),
(4062, 209, 'Maha Sarakham', '44', 1),
(4063, 209, 'Roi Et', '45', 1),
(4064, 209, 'Kalasin', '46', 1),
(4065, 209, 'Sakon Nakhon', '47', 1),
(4066, 209, 'Nakhon Phanom', '48', 1),
(4067, 209, 'Mukdahan', '49', 1),
(4068, 209, 'Chiang Mai', '50', 1),
(4069, 209, 'Lamphun', '51', 1),
(4070, 209, 'Lampang', '52', 1),
(4071, 209, 'Uttaradit', '53', 1),
(4072, 209, 'Phrae', '54', 1),
(4073, 209, 'Nan', '55', 1),
(4074, 209, 'Phayao', '56', 1),
(4075, 209, 'Chiang Rai', '57', 1),
(4076, 209, 'Mae Hong Son', '58', 1),
(4077, 209, 'Nakhon Sawan', '60', 1),
(4078, 209, 'Uthai Thani', '61', 1),
(4079, 209, 'Kamphaeng Phet', '62', 1),
(4080, 209, 'Tak', '63', 1),
(4081, 209, 'Sukhothai', '64', 1),
(4082, 209, 'Phitsanulok', '65', 1),
(4083, 209, 'Phichit', '66', 1),
(4084, 209, 'Phetchabun', '67', 1),
(4085, 209, 'Ratchaburi', '70', 1),
(4086, 209, 'Kanchanaburi', '71', 1),
(4087, 209, 'Suphan Buri', '72', 1),
(4088, 209, 'Nakhon Pathom', '73', 1),
(4089, 209, 'Samut Sakhon', '74', 1),
(4090, 209, 'Samut Songkhram', '75', 1),
(4091, 209, 'Phetchaburi', '76', 1),
(4092, 209, 'Prachuap Khiri Khan', '77', 1),
(4093, 209, 'Nakhon Si Thammarat', '80', 1),
(4094, 209, 'Krabi', '81', 1),
(4095, 209, 'Phangnga', '82', 1),
(4096, 209, 'Phuket', '83', 1),
(4097, 209, 'Surat Thani', '84', 1),
(4098, 209, 'Ranong', '85', 1),
(4099, 209, 'Chumphon', '86', 1),
(4100, 209, 'Songkhla', '90', 1),
(4101, 209, 'Satun', '91', 1),
(4102, 209, 'Trang', '92', 1),
(4103, 209, 'Phatthalung', '93', 1),
(4104, 209, 'Pattani', '94', 1),
(4105, 209, 'Yala', '95', 1),
(4106, 209, 'Narathiwat', '96', 1),
(4107, 209, 'Phatthaya', 'S ', 1),
(4108, 207, 'Dushanbe', 'DU', 1),
(4109, 207, 'Kuhistoni Badakhshon', 'GB', 1),
(4110, 207, 'Khatlon', 'KT', 1),
(4111, 207, 'Sughd', 'SU', 1),
(4112, 61, 'Aileu', 'AL', 1),
(4113, 61, 'Ainaro', 'AN', 1),
(4114, 61, 'Baucau', 'BA', 1),
(4115, 61, 'Bobonaro', 'BO', 1),
(4116, 61, 'Cova Lima', 'CO', 1),
(4117, 61, 'Díli', 'DI', 1),
(4118, 61, 'Ermera', 'ER', 1),
(4119, 61, 'Lautem', 'LA', 1),
(4120, 61, 'Liquiça', 'LI', 1),
(4121, 61, 'Manufahi', 'MF', 1),
(4122, 61, 'Manatuto', 'MT', 1),
(4123, 61, 'Oecussi', 'OE', 1),
(4124, 61, 'Viqueque', 'VI', 1),
(4125, 216, 'Ahal', 'A', 1),
(4126, 216, 'Balkan', 'B', 1),
(4127, 216, 'Dasoguz', 'D', 1),
(4128, 216, 'Lebap', 'L', 1),
(4129, 216, 'Mary', 'M', 1),
(4130, 216, 'Asgabat', 'S', 1),
(4131, 214, 'Tunis', '11', 1),
(4132, 214, 'L''Ariana', '12', 1),
(4133, 214, 'Ben Arous', '13', 1),
(4134, 214, 'La Manouba', '14', 1),
(4135, 214, 'Nabeul', '21', 1),
(4136, 214, 'Zaghouan', '22', 1),
(4137, 214, 'Bizerte', '23', 1),
(4138, 214, 'Béja', '31', 1),
(4139, 214, 'Jendouba', '32', 1),
(4140, 214, 'Le Kef', '33', 1),
(4141, 214, 'Siliana', '34', 1),
(4142, 214, 'Kairouan', '41', 1),
(4143, 214, 'Kasserine', '42', 1),
(4144, 214, 'Sidi Bouzid', '43', 1),
(4145, 214, 'Sousse', '51', 1),
(4146, 214, 'Monastir', '52', 1),
(4147, 214, 'Mahdia', '53', 1),
(4148, 214, 'Sfax', '61', 1),
(4149, 214, 'Gafsa', '71', 1),
(4150, 214, 'Tozeur', '72', 1),
(4151, 214, '	Kébili', '73', 1),
(4152, 214, 'Gabčs', '81', 1),
(4153, 214, 'Médenine', '82', 1),
(4154, 214, 'Tataouine', '83', 1),
(4155, 212, '''Eua', '01', 1),
(4156, 212, 'Ha''apai', '02', 1),
(4157, 212, 'Niuas', '03', 1),
(4158, 212, 'Tongatapu', '04', 1),
(4159, 212, 'Vava''u', '05', 1),
(4160, 215, 'Adana', '01', 1),
(4161, 215, 'Adiyaman', '02', 1),
(4162, 215, 'Afyonkarahisar', '03', 1),
(4163, 215, 'Agri', '04', 1),
(4164, 215, 'Amasya', '05', 1),
(4165, 215, 'Ankara', '06', 1),
(4166, 215, 'Antalya', '07', 1),
(4167, 215, 'Artvin', '08', 1),
(4168, 215, 'Aydin', '09', 1),
(4169, 215, 'Balikesir', '10', 1),
(4170, 215, 'Bilecik', '11', 1),
(4171, 215, 'Bingöl', '12', 1),
(4172, 215, 'Bitlis', '13', 1),
(4173, 215, 'Bolu', '14', 1),
(4174, 215, 'Burdur', '15', 1),
(4175, 215, 'Bursa', '16', 1),
(4176, 215, 'Canakkale', '17', 1),
(4177, 215, 'Çankiri', '18', 1),
(4178, 215, 'Corum', '19', 1),
(4179, 215, 'Denizli', '20', 1),
(4180, 215, 'Diyarbakir', '21', 1),
(4181, 215, 'Edirne', '22', 1),
(4182, 215, 'Elazig', '23', 1),
(4183, 215, 'Erzincan', '24', 1),
(4184, 215, 'Erzurum', '25', 1),
(4185, 215, 'Eskisehir', '26', 1),
(4186, 215, 'Gaziantep', '27', 1),
(4187, 215, 'Giresun', '28', 1),
(4188, 215, 'Gümüshane', '29', 1),
(4189, 215, 'Hakkari', '30', 1),
(4190, 215, 'Hatay', '31', 1),
(4191, 215, 'Isparta', '32', 1),
(4192, 215, 'Mersin', '33', 1),
(4193, 215, 'Istanbul', '34', 1),
(4194, 215, 'Izmir', '35', 1),
(4195, 215, 'Kars', '36', 1),
(4196, 215, 'Kastamonu', '37', 1),
(4197, 215, 'Kayseri', '38', 1),
(4198, 215, 'Kirklareli', '39', 1),
(4199, 215, 'Kirsehir', '40', 1),
(4200, 215, 'Kocaeli', '41', 1),
(4201, 215, 'Konya', '42', 1),
(4202, 215, 'Kütahya', '43', 1),
(4203, 215, 'Malatya', '44', 1),
(4204, 215, 'Manisa', '45', 1),
(4205, 215, 'Kahramanmaras', '46', 1),
(4206, 215, 'Mardin', '47', 1),
(4207, 215, 'Mugla', '48', 1),
(4208, 215, 'Mus', '49', 1),
(4209, 215, 'Nevsehir', '50', 1),
(4210, 215, 'Nigde', '51', 1),
(4211, 215, 'Ordu', '52', 1),
(4212, 215, 'Rize', '53', 1),
(4213, 215, 'Sakarya', '54', 1),
(4214, 215, 'Samsun', '55', 1),
(4215, 215, 'Siirt', '56', 1),
(4216, 215, 'Sinop', '57', 1),
(4217, 215, 'Sivas', '58', 1),
(4218, 215, 'Tekirdag', '59', 1),
(4219, 215, 'Tokat', '60', 1),
(4220, 215, 'Trabzon', '61', 1),
(4221, 215, 'Tunceli', '62', 1),
(4222, 215, 'Sanliurfa', '63', 1),
(4223, 215, 'Usak', '64', 1),
(4224, 215, 'Van', '65', 1),
(4225, 215, 'Yozgat', '66', 1),
(4226, 215, 'Zonguldak', '67', 1),
(4227, 215, 'Aksaray', '68', 1),
(4228, 215, 'Bayburt', '69', 1),
(4229, 215, 'Karaman', '70', 1),
(4230, 215, 'Kirikkale', '71', 1),
(4231, 215, 'Batman', '72', 1),
(4232, 215, 'Sirnak', '73', 1),
(4233, 215, 'Bartin', '74', 1),
(4234, 215, 'Ardahan', '75', 1),
(4235, 215, 'Igdir', '76', 1),
(4236, 215, 'Yalova', '77', 1),
(4237, 215, 'Karabuk', '78', 1),
(4238, 215, 'Kilis', '79', 1),
(4239, 215, 'Osmaniye', '80', 1),
(4240, 215, 'Düzce', '81', 1),
(4241, 213, 'Arima', 'ARI', 1),
(4242, 213, 'Chaguanas', 'CHA', 1),
(4243, 213, 'Couva-Tabaquite-Talparo', 'CTT', 1),
(4244, 213, 'Diego Martin', 'DMN', 1),
(4245, 213, 'Mayaro-Rio Claro', 'MRC', 1),
(4246, 213, 'Penal-Debe', 'PED', 1),
(4247, 213, 'Port of Spain', 'POS', 1),
(4248, 213, 'Princes Town', 'PRT', 1),
(4249, 213, 'Point Fortin', 'PTF', 1),
(4250, 213, 'San Fernando', 'SFO', 1),
(4251, 213, 'Sangre Grande', 'SGE', 1),
(4252, 213, 'Siparia', 'SIP', 1),
(4253, 213, 'San Juan-Laventille', 'SJL', 1),
(4254, 213, 'Tobago', 'TOB', 1),
(4255, 213, 'Tunapuna-Piarco', 'TUP', 1),
(4256, 218, 'Funafuti', 'FUN', 1),
(4257, 218, 'Niutao', 'NIT', 1),
(4258, 218, 'Nui', 'NIU', 1),
(4259, 218, 'Nukufetau', 'NKF', 1),
(4260, 218, 'Nukulaelae', 'NKL', 1),
(4261, 218, 'Nanumea', 'NMA', 1),
(4262, 218, 'Nanumanga', 'NMG', 1),
(4263, 218, 'Vaitupu', 'VAI', 1),
(4264, 206, 'Changhua', 'CHA', 1),
(4265, 206, 'Chiayi', 'CYI', 1),
(4266, 206, 'Chiayi', 'CYQ', 1),
(4267, 206, 'Hsinchu', 'HSQ', 1),
(4268, 206, 'Hsinchu', 'HSZ', 1),
(4269, 206, 'Hualien', 'HUA', 1),
(4270, 206, 'Yilan', 'ILA', 1),
(4271, 206, 'Keelung', 'KEE', 1),
(4272, 206, 'Kaohsiung', 'KHH', 1),
(4273, 206, 'Kinmen', 'KIN', 1),
(4274, 206, 'Lienchiang', 'LIE', 1),
(4275, 206, 'Miaoli', 'MIA', 1),
(4276, 206, 'Nantou', 'NAN', 1),
(4277, 206, 'New Taipei', 'NWT', 1),
(4278, 206, 'Penghu', 'PEN', 1),
(4279, 206, 'Pingtung', 'PIF', 1),
(4280, 206, 'Taoyuan', 'TAO', 1),
(4281, 206, 'Tainan', 'TNN', 1),
(4282, 206, 'Taipei', 'TPE', 1),
(4283, 206, 'Taitung', 'TTT', 1),
(4284, 206, 'Taichung', 'TXG', 1),
(4285, 206, 'Yunlin', 'YUN', 1),
(4286, 208, 'Arusha', '01', 1),
(4287, 208, 'Dar es Salaam', '02', 1),
(4288, 208, 'Dodoma', '03', 1),
(4289, 208, 'Iringa', '04', 1),
(4290, 208, 'Kagera', '05', 1),
(4291, 208, 'Kaskazini Pemba', '06', 1),
(4292, 208, 'Kaskazini Unguja', '07', 1),
(4293, 208, 'Kigoma', '08', 1),
(4294, 208, 'Kilimanjaro', '09', 1),
(4295, 208, 'Kusini Pemba', '10', 1),
(4296, 208, 'Kusini Unguja', '11', 1),
(4297, 208, 'Lindi', '12', 1),
(4298, 208, 'Mara', '13', 1),
(4299, 208, 'Mbeya', '14', 1),
(4300, 208, 'Mjini Magharibi', '15', 1),
(4301, 208, 'Morogoro', '16', 1),
(4302, 208, 'Mtwara', '17', 1),
(4303, 208, 'Mwanza', '18', 1),
(4304, 208, 'Pwani', '19', 1),
(4305, 208, 'Rukwa', '20', 1),
(4306, 208, 'Ruvuma', '21', 1),
(4307, 208, 'Shinyanga', '22', 1),
(4308, 208, 'Singida', '23', 1),
(4309, 208, 'Tabora', '24', 1),
(4310, 208, 'Tanga', '25', 1),
(4311, 208, 'Manyara', '26', 1),
(4312, 208, 'Geita', '27', 1),
(4313, 208, 'Katavi', '28', 1),
(4314, 208, 'Njombe', '29', 1),
(4315, 208, 'Simiyu', '30', 1),
(4316, 220, 'Vinnytska oblast', '05', 1),
(4317, 220, 'Volynska oblast', '07', 1),
(4318, 220, 'Luhanska oblast', '09', 1),
(4319, 220, 'Dnipropetrovska oblast', '12', 1),
(4320, 220, 'Donetska oblast', '14', 1),
(4321, 220, 'Zhytomyrska oblast', '18', 1),
(4322, 220, 'Zakarpatska oblast', '21', 1),
(4323, 220, 'Zaporizka oblast', '23', 1),
(4324, 220, 'Ivano-Frankivska oblast', '26', 1),
(4325, 220, 'Kyiv', '30', 1),
(4326, 220, 'Kyivska oblast', '32', 1),
(4327, 220, 'Kirovohradska oblast', '35', 1),
(4328, 220, 'Sevastopol', '40', 1),
(4329, 220, 'Avtonomna Respublika Krym', '43', 1),
(4330, 220, 'Lvivska oblast', '46', 1),
(4331, 220, 'Mykolaivska oblast', '48', 1),
(4332, 220, 'Odeska oblast', '51', 1),
(4333, 220, 'Poltavska oblast', '53', 1),
(4334, 220, 'Rivnenska oblast', '56', 1),
(4335, 220, 'Sumska oblast', '59', 1),
(4336, 220, 'Ternopilska oblast', '61', 1),
(4337, 220, 'Kharkivska oblast', '63', 1),
(4338, 220, 'Khersonska oblast', '65', 1),
(4339, 220, 'Khmelnytska oblast', '68', 1),
(4340, 220, 'Cherkaska oblast', '71', 1),
(4341, 220, 'Chernihivska oblast', '74', 1),
(4342, 220, 'Chernivetska oblast', '77', 1),
(4343, 219, 'Kalangala', '101', 1),
(4344, 219, 'Kampala', '102', 1),
(4345, 219, 'Kiboga', '103', 1),
(4346, 219, 'Luwero', '104', 1),
(4347, 219, 'Masaka', '105', 1),
(4348, 219, 'Mpigi', '106', 1),
(4349, 219, 'Mubende', '107', 1),
(4350, 219, 'Mukono', '108', 1),
(4351, 219, 'Nakasongola', '109', 1),
(4352, 219, 'Rakai', '110', 1),
(4353, 219, 'Sembabule', '111', 1),
(4354, 219, 'Kayunga', '112', 1),
(4355, 219, 'Wakiso', '113', 1),
(4356, 219, 'Mityana', '114', 1),
(4357, 219, 'Nakaseke', '115', 1),
(4358, 219, 'Lyantonde', '116', 1),
(4359, 219, 'Buikwe', '117', 1),
(4360, 219, 'Bukomansibi', '118', 1),
(4361, 219, 'Butambala', '119', 1),
(4362, 219, 'Buvuma', '120', 1),
(4363, 219, 'Gomba', '121', 1),
(4364, 219, 'Kalungu', '122', 1),
(4365, 219, 'Kyankwanzi', '123', 1),
(4366, 219, 'Lwengo', '124', 1),
(4367, 219, 'Bugiri', '201', 1),
(4368, 219, 'Busia', '202', 1),
(4369, 219, 'Iganga', '203', 1),
(4370, 219, 'Jinja', '204', 1),
(4371, 219, 'Kamuli', '205', 1),
(4372, 219, 'Kapchorwa', '206', 1),
(4373, 219, 'Katakwi', '207', 1),
(4374, 219, 'Kumi', '208', 1),
(4375, 219, 'Mbale', '209', 1),
(4376, 219, 'Pallisa', '210', 1),
(4377, 219, 'Soroti', '211', 1),
(4378, 219, 'Tororo', '212', 1),
(4379, 219, 'Kaberamaido', '213', 1),
(4380, 219, 'Sironko', '215', 1),
(4381, 219, 'Amuria', '216', 1),
(4382, 219, 'Budaka', '217', 1),
(4383, 219, 'Bukwa', '218', 1),
(4384, 219, 'Butaleja', '219', 1),
(4385, 219, 'Kaliro', '220', 1);
INSERT IGNORE INTO `#__djc2_countries_states` (`id`, `country_id`, `name`, `state_code`, `published`) VALUES
(4386, 219, 'Manafwa', '221', 1),
(4387, 219, 'Namutumba', '222', 1),
(4388, 219, 'Bududa', '223', 1),
(4389, 219, 'Bukedea', '224', 1),
(4390, 219, 'Bulambuli', '225', 1),
(4391, 219, 'Buyende', '226', 1),
(4392, 219, 'Kibuku', '227', 1),
(4393, 219, 'Kween', '228', 1),
(4394, 219, 'Luuka', '229', 1),
(4395, 219, 'Namayingo', '230', 1),
(4396, 219, 'Ngora', '231', 1),
(4397, 219, 'Serere', '232', 1),
(4398, 219, 'Mayuge', '244', 1),
(4399, 219, 'Adjumani', '301', 1),
(4400, 219, 'Apac', '302', 1),
(4401, 219, 'Arua', '303', 1),
(4402, 219, 'Gulu', '304', 1),
(4403, 219, 'Kitgum', '305', 1),
(4404, 219, 'Kotido', '306', 1),
(4405, 219, 'Lira', '307', 1),
(4406, 219, 'Moroto', '308', 1),
(4407, 219, 'Moyo', '309', 1),
(4408, 219, 'Nebbi', '310', 1),
(4409, 219, 'Nakapiripirit', '311', 1),
(4410, 219, 'Pader', '312', 1),
(4411, 219, 'Yumbe', '313', 1),
(4412, 219, 'Amolatar', '314', 1),
(4413, 219, 'Kaabong', '315', 1),
(4414, 219, 'Koboko', '316', 1),
(4415, 219, 'Abim', '317', 1),
(4416, 219, 'Dokolo', '318', 1),
(4417, 219, 'Amuru', '319', 1),
(4418, 219, 'Maracha', '320', 1),
(4419, 219, 'Oyam', '321', 1),
(4420, 219, 'Bundibugyo', '401', 1),
(4421, 219, 'Bushenyi', '402', 1),
(4422, 219, 'Hoima', '403', 1),
(4423, 219, 'Kabale', '404', 1),
(4424, 219, 'Kabarole', '405', 1),
(4425, 219, 'Kasese', '406', 1),
(4426, 219, 'Kibaale', '407', 1),
(4427, 219, 'Kisoro', '408', 1),
(4428, 219, 'Masindi', '409', 1),
(4429, 219, 'Mbarara', '410', 1),
(4430, 219, 'Ntungamo', '411', 1),
(4431, 219, 'Rukungiri', '412', 1),
(4432, 219, 'Kamwenge', '413', 1),
(4433, 219, 'Kanungu', '414', 1),
(4434, 219, 'Kyenjojo', '415', 1),
(4435, 219, 'Ibanda', '416', 1),
(4436, 219, 'Isingiro', '417', 1),
(4437, 219, 'Kiruhura', '418', 1),
(4438, 219, 'Buliisa', '419', 1),
(4439, 219, 'Kiryandongo', '420', 1),
(4440, 219, 'Kyegegwa', '421', 1),
(4441, 219, 'Mitooma', '422', 1),
(4442, 219, 'Ntoroko', '423', 1),
(4443, 219, 'Rubirizi', '424', 1),
(4444, 219, 'Sheema', '425', 1),
(4445, 224, 'Johnston Atoll (ISO reserved code = JT)', '67', 1),
(4446, 224, 'Midway Islands (ISO reserved code = I)', '71', 1),
(4447, 224, 'Navassa Island (ISO reserved code = NV)', '76', 1),
(4448, 224, 'Wake Island (ISO reserved code = WK)', '79', 1),
(4449, 224, 'Baker Island', '81', 1),
(4450, 224, 'Howland Island', '84', 1),
(4451, 224, 'Jarvis Island', '86', 1),
(4452, 224, 'Kingman Reef', '89', 1),
(4453, 224, 'Palmyra Atoll', '95', 1),
(4454, 223, 'Alaska', 'AK', 1),
(4455, 223, 'Alabama', 'AL', 1),
(4456, 223, 'Arkansas', 'AR', 1),
(4457, 223, 'American Samoa (see also separate entry under AS)', 'AS', 1),
(4458, 223, 'Arizona', 'AZ', 1),
(4459, 223, 'California', 'CA', 1),
(4460, 223, 'Colorado', 'CO', 1),
(4461, 223, 'Connecticut', 'CT', 1),
(4462, 223, 'District of Columbia', 'DC', 1),
(4463, 223, 'Delaware', 'DE', 1),
(4464, 223, 'Florida', 'FL', 1),
(4465, 223, 'Georgia', 'GA', 1),
(4466, 223, 'Guam (see also separate entry under GU)', 'GU', 1),
(4467, 223, 'Hawaii', 'HI', 1),
(4468, 223, 'Iowa', 'IA', 1),
(4469, 223, 'Idaho', 'ID', 1),
(4470, 223, 'Illinois', 'IL', 1),
(4471, 223, 'Indiana', 'IN', 1),
(4472, 223, 'Kansas', 'KS', 1),
(4473, 223, 'Kentucky', 'KY', 1),
(4474, 223, 'Louisiana', 'LA', 1),
(4475, 223, 'Massachusetts', 'MA', 1),
(4476, 223, 'Maryland', 'MD', 1),
(4477, 223, 'Maine', 'ME', 1),
(4478, 223, 'Michigan', 'MI', 1),
(4479, 223, 'Minnesota', 'MN', 1),
(4480, 223, 'Missouri', 'MO', 1),
(4481, 223, 'Northern Mariana Islands (see also separate entry MP)', 'MP', 1),
(4482, 223, 'Mississippi', 'MS', 1),
(4483, 223, 'Montana', 'MT', 1),
(4484, 223, 'North Carolina', 'NC', 1),
(4485, 223, 'North Dakota', 'ND', 1),
(4486, 223, 'Nebraska', 'NE', 1),
(4487, 223, 'New Hampshire', 'NH', 1),
(4488, 223, 'New Jersey', 'NJ', 1),
(4489, 223, 'New Mexico', 'NM', 1),
(4490, 223, 'Nevada', 'NV', 1),
(4491, 223, 'New York', 'NY', 1),
(4492, 223, 'Ohio', 'OH', 1),
(4493, 223, 'Oklahoma', 'OK', 1),
(4494, 223, 'Oregon', 'OR', 1),
(4495, 223, 'Pennsylvania', 'PA', 1),
(4496, 223, 'Puerto Rico (see also separate entry under PR)', 'PR', 1),
(4497, 223, 'Rhode Island', 'RI', 1),
(4498, 223, 'South Carolina', 'SC', 1),
(4499, 223, 'South Dakota', 'SD', 1),
(4500, 223, 'Tennessee', 'TN', 1),
(4501, 223, 'Texas', 'TX', 1),
(4502, 223, 'U.S. Minor Outlying Islands (cf. separate entry UM)', 'UM', 1),
(4503, 223, 'Utah', 'UT', 1),
(4504, 223, 'Virginia', 'VA', 1),
(4505, 223, 'Virgin Islands of the U.S. (see also separate entry VI)', 'VI', 1),
(4506, 223, 'Vermont', 'VT', 1),
(4507, 223, 'Washington', 'WA', 1),
(4508, 223, 'Wisconsin', 'WI', 1),
(4509, 223, 'West Virginia', 'WV', 1),
(4510, 223, 'Wyoming', 'WY', 1),
(4511, 225, 'Artigas', 'AR', 1),
(4512, 225, 'Canelones', 'CA', 1),
(4513, 225, 'Cerro Largo', 'CL', 1),
(4514, 225, 'Colonia', 'CO', 1),
(4515, 225, 'Durazno', 'DU', 1),
(4516, 225, 'Florida', 'FD', 1),
(4517, 225, 'Flores', 'FS', 1),
(4518, 225, 'Lavalleja', 'LA', 1),
(4519, 225, 'Maldonado', 'MA', 1),
(4520, 225, 'Montevideo', 'MO', 1),
(4521, 225, 'Paysandú', 'PA', 1),
(4522, 225, 'Río Negro', 'RN', 1),
(4523, 225, 'Rocha', 'RO', 1),
(4524, 225, 'Rivera', 'RV', 1),
(4525, 225, 'Salto', 'SA', 1),
(4526, 225, 'San José', 'SJ', 1),
(4527, 225, 'Soriano', 'SO', 1),
(4528, 225, 'Tacuarembó', 'TA', 1),
(4529, 225, 'Treinta y Tres', 'TT', 1),
(4530, 226, 'Andijon', 'AN', 1),
(4531, 226, 'Bukhoro', 'BU', 1),
(4532, 226, 'Farg‘ona', 'FA', 1),
(4533, 226, 'Jizzax', 'JI', 1),
(4534, 226, 'Khorazm', 'KH', 1),
(4535, 226, 'Namangan', 'NG', 1),
(4536, 226, 'Nawoiy', 'NW', 1),
(4537, 226, 'Qashqadaryo', 'QA', 1),
(4538, 226, 'Qoraqalpog‘iston Respublikasi', 'QR', 1),
(4539, 226, 'Samarqand', 'SA', 1),
(4540, 226, 'Sirdaryo', 'SI', 1),
(4541, 226, 'Surkhondaryo', 'SU', 1),
(4542, 226, 'Toshkent', 'TK', 1),
(4543, 226, 'Toshkent', 'TO', 1),
(4544, 226, 'Xorazm', 'XO', 1),
(4545, 180, 'Charlotte     ', '01', 1),
(4546, 180, 'Saint Andrew  ', '02', 1),
(4547, 180, 'Saint David   ', '03', 1),
(4548, 180, 'Saint George  ', '04', 1),
(4549, 180, 'Saint Patrick ', '05', 1),
(4550, 180, 'Grenadines    ', '06', 1),
(4551, 229, 'Distrito Capital', 'A', 1),
(4552, 229, 'Anzoátegui', 'B', 1),
(4553, 229, 'Apure', 'C', 1),
(4554, 229, 'Aragua', 'D', 1),
(4555, 229, 'Barinas', 'E', 1),
(4556, 229, 'Bolívar', 'F', 1),
(4557, 229, 'Carabobo', 'G', 1),
(4558, 229, 'Cojedes', 'H', 1),
(4559, 229, 'Falcón', 'I', 1),
(4560, 229, 'Guárico', 'J', 1),
(4561, 229, 'Lara', 'K', 1),
(4562, 229, 'Mérida', 'L', 1),
(4563, 229, 'Miranda', 'M', 1),
(4564, 229, 'Monagas', 'N', 1),
(4565, 229, 'Nueva Esparta', 'O', 1),
(4566, 229, 'Portuguesa', 'P', 1),
(4567, 229, 'Sucre', 'R', 1),
(4568, 229, 'Táchira', 'S', 1),
(4569, 229, 'Trujillo', 'T', 1),
(4570, 229, 'Yaracuy', 'U', 1),
(4571, 229, 'Zulia', 'V', 1),
(4572, 229, 'Dependencias Federales', 'W', 1),
(4573, 229, 'vargas', 'X', 1),
(4574, 229, 'Delta Amacuro', 'Y', 1),
(4575, 229, 'Amazonas', 'Z', 1),
(4576, 230, 'Lai Châu', '01', 1),
(4577, 230, 'Lŕo Cai', '02', 1),
(4578, 230, 'Hŕ Giang', '03', 1),
(4579, 230, 'Cao B?ng', '04', 1),
(4580, 230, 'Son La', '05', 1),
(4581, 230, 'Yęn Bái', '06', 1),
(4582, 230, 'Tuyęn Quang', '07', 1),
(4583, 230, 'L?ng Son', '09', 1),
(4584, 230, 'Qu?ng Ninh', '13', 1),
(4585, 230, 'Hňa Běnh', '14', 1),
(4586, 230, 'Ninh Běnh', '18', 1),
(4587, 230, 'Thái Běnh', '20', 1),
(4588, 230, 'Thanh Hóa', '21', 1),
(4589, 230, 'Ngh? An', '22', 1),
(4590, 230, 'Hŕ Tinh', '23', 1),
(4591, 230, 'Qu?ng Běnh', '24', 1),
(4592, 230, 'Qu?ng Tr?', '25', 1),
(4593, 230, 'Th?a Thięn-Hu?', '26', 1),
(4594, 230, 'Qu?ng Nam', '27', 1),
(4595, 230, 'Kon Tum', '28', 1),
(4596, 230, 'Qu?ng Ngăi', '29', 1),
(4597, 230, 'Gia Lai', '30', 1),
(4598, 230, 'Běnh Đ?nh', '31', 1),
(4599, 230, 'Phú Yęn', '32', 1),
(4600, 230, 'Đ?k L?k', '33', 1),
(4601, 230, 'Khánh Hňa', '34', 1),
(4602, 230, 'Lâm Đ?ng', '35', 1),
(4603, 230, 'Ninh Thu?n', '36', 1),
(4604, 230, 'Tây Ninh', '37', 1),
(4605, 230, 'Đ?ng Nai', '39', 1),
(4606, 230, 'Běnh Thu?n', '40', 1),
(4607, 230, 'Long An', '41', 1),
(4608, 230, 'Bŕ R?a - Vung Tŕu', '43', 1),
(4609, 230, 'An Giang', '44', 1),
(4610, 230, 'Đ?ng Tháp', '45', 1),
(4611, 230, 'Ti?n Giang', '46', 1),
(4612, 230, 'Ki?n Giang', '47', 1),
(4613, 230, 'Vinh Long', '49', 1),
(4614, 230, 'B?n Tre', '50', 1),
(4615, 230, 'Trŕ Vinh', '51', 1),
(4616, 230, 'Sóc Trang', '52', 1),
(4617, 230, 'B?c K?n', '53', 1),
(4618, 230, 'B?c Giang', '54', 1),
(4619, 230, 'B?c Lięu', '55', 1),
(4620, 230, 'B?c Ninh', '56', 1),
(4621, 230, 'Běnh Duong', '57', 1),
(4622, 230, 'Běnh Phu?c', '58', 1),
(4623, 230, 'Cŕ Mau', '59', 1),
(4624, 230, 'H?i Duong', '61', 1),
(4625, 230, 'Hŕ Nam', '63', 1),
(4626, 230, 'Hung Yęn', '66', 1),
(4627, 230, 'Nam Đ?nh', '67', 1),
(4628, 230, 'Phú Th?', '68', 1),
(4629, 230, 'Thái Nguyęn', '69', 1),
(4630, 230, 'Vinh Phúc', '70', 1),
(4631, 230, 'Đi?n Bięn', '71', 1),
(4632, 230, 'Đ?k Nông', '72', 1),
(4633, 230, 'H?u Giang', '73', 1),
(4634, 230, 'Can Tho', 'CT', 1),
(4635, 230, 'Da Nang, thanh pho', 'DN', 1),
(4636, 230, 'Ha Noi', 'HN', 1),
(4637, 230, 'Hai Phong', 'HP', 1),
(4638, 230, 'Ho Chi Minh', 'SG', 1),
(4639, 227, 'Malampa', 'MAP', 1),
(4640, 227, 'Pénama', 'PAM', 1),
(4641, 227, 'Sanma', 'SAM', 1),
(4642, 227, 'Shéfa', 'SEE', 1),
(4643, 227, 'Taféa', 'TAE', 1),
(4644, 227, 'Torba', 'TOB', 1),
(4645, 181, 'A''ana', 'AA', 1),
(4646, 181, 'Aiga-i-le-Tai', 'AL', 1),
(4647, 181, 'Atua', 'AT', 1),
(4648, 181, 'Fa''asaleleaga', 'FA', 1),
(4649, 181, 'Gaga''emauga', 'GE', 1),
(4650, 181, 'Gagaifomauga', 'GI', 1),
(4651, 181, 'Palauli', 'PA', 1),
(4652, 181, 'Satupa ''itea', 'SA', 1),
(4653, 181, 'Tuamasaga', 'TU', 1),
(4654, 181, 'Va''a-o-Fonoti', 'VF', 1),
(4655, 181, 'Vaisigano', 'VS', 1),
(4656, 235, 'Abyan', 'AB', 1),
(4657, 235, '‘Adan', 'AD', 1),
(4658, 235, '‘Amran', 'AM', 1),
(4659, 235, 'Al Bay?a’', 'BA', 1),
(4660, 235, '	A? ?ali‘', 'DA', 1),
(4661, 235, 'Dhamar', 'DH', 1),
(4662, 235, '?a?ramawt', 'HD', 1),
(4663, 235, '?ajjah', 'HJ', 1),
(4664, 235, 'Al ?udaydah', 'HU', 1),
(4665, 235, 'Ibb', 'IB', 1),
(4666, 235, 'Al Jawf', 'JA', 1),
(4667, 235, 'Lahij', 'LA', 1),
(4668, 235, 'Ma’rib', 'MA', 1),
(4669, 235, 'Al Mahrah', 'MR', 1),
(4670, 235, 'Al Ma?wit', 'MW', 1),
(4671, 235, 'Raymah', 'RA', 1),
(4672, 235, 'Amanat al ‘Asimah [city]', 'SA', 1),
(4673, 235, 'Sa''dah', 'SD', 1),
(4674, 235, 'Shabwah', 'SH', 1),
(4675, 235, 'San?a''', 'SN', 1),
(4676, 235, 'Arkhabil Suqutrá', 'SU', 1),
(4677, 235, 'Ta''izz', 'TA', 1),
(4678, 193, 'Eastern Cape', 'EC', 1),
(4679, 193, 'Free State', 'FS', 1),
(4680, 193, 'Gauteng', 'GT', 1),
(4681, 193, 'Limpopo', 'LP', 1),
(4682, 193, 'Mpumalanga', 'MP', 1),
(4683, 193, 'Northern Cape', 'NC', 1),
(4684, 193, 'Kwazulu-Natal', 'NL', 1),
(4685, 193, 'North-West', 'NW', 1),
(4686, 193, 'Western Cape', 'WC', 1),
(4687, 238, 'Western', '01', 1),
(4688, 238, 'Central', '02', 1),
(4689, 238, 'Eastern', '03', 1),
(4690, 238, 'Luapula', '04', 1),
(4691, 238, 'Northern', '05', 1),
(4692, 238, 'North-Western', '06', 1),
(4693, 238, 'Southern', '07', 1),
(4694, 238, 'Copperbelt', '08', 1),
(4695, 238, 'Lusaka', '09', 1),
(4696, 238, 'Muchinga', '10', 1),
(4697, 239, 'Bulawayo', 'BU', 1),
(4698, 239, 'Harare', 'HA', 1),
(4699, 239, 'Manicaland', 'MA', 1),
(4700, 239, 'Mashonaland Central', 'MC', 1),
(4701, 239, 'Mashonaland East', 'ME', 1),
(4702, 239, 'Midlands', 'MI', 1),
(4703, 239, 'Matabeleland North', 'MN', 1),
(4704, 239, 'Matabeleland South', 'MS', 1),
(4705, 239, 'Masvingo', 'MV', 1),
(4706, 239, 'Mashonaland West', 'MW', 1);

INSERT IGNORE INTO `#__djc2_users_extra_fields` (`id`, `is_core`, `name`, `label`, `description`, `placeholder`, `attributes`, `alias`, `client_type`, `imagelabel`, `type`, `target_fieldset`, `ordering`, `in_register`, `in_profile`, `in_checkout`, `in_query`, `in_delivery`, `params`) VALUES
(1, 1, 'Client Type', 'COM_DJCATALOG2_UP_CLIENT_TYPE', '', '', '', 'client_type', 'A', NULL, 'core:radio', 'djcatalog2profile', 1, 1, 1, 2, 2, 0, NULL),
(2, 1, 'User\'s ID', 'User\'s ID', '', '', '', 'user_id', 'A', NULL, 'core:djcuser', 'djcatalog2profile', 2, 0, 0, 1, 1, 0, NULL),
(3, 1, 'E-Mail', 'COM_DJCATALOG2_UP_EMAIL', '', '', '', 'email', 'A', NULL, 'core:email', 'djcatalog2profile', 3, 0, 0, 2, 2, 0, NULL),
(4, 1, 'First Name', 'COM_DJCATALOG2_UP_FIRSTNAME', '', '', '', 'firstname', 'A', NULL, 'text', 'djcatalog2profile', 4, 2, 1, 2, 2, 0, NULL),
(5, 1, 'Last Name', 'COM_DJCATALOG2_UP_LASTNAME', '', '', '', 'lastname', 'A', NULL, 'text', 'djcatalog2profile', 5, 1, 1, 2, 2, 0, NULL),
(6, 1, 'Company Name', 'COM_DJCATALOG2_UP_COMPANY', '', '', '', 'company', 'W', NULL, 'text', 'djcatalog2profile', 6, 2, 2, 2, 2, 0, NULL),
(7, 1, 'Position', 'COM_DJCATALOG2_UP_POSITION', '', '', '', 'position', 'A', NULL, 'text', 'djcatalog2profile', 7, 0, 1, 1, 1, 0, NULL),
(8, 1, 'Address', 'COM_DJCATALOG2_UP_ADDRESS', '', '', '', 'address', 'A', NULL, 'text', 'djcatalog2profile', 8, 0, 1, 1, 1, 0, NULL),
(9, 1, 'City', 'COM_DJCATALOG2_UP_CITY', '', '', '', 'city', 'A', NULL, 'text', 'djcatalog2profile', 9, 2, 1, 2, 1, 0, NULL),
(10, 1, 'Country', 'COM_DJCATALOG2_UP_COUNTRY', '', '', '', 'country_id', 'A', NULL, 'core:djccountry', 'djcatalog2profile', 10, 0, 1, 1, 1, 0, NULL),
(11, 1, 'State', 'COM_DJCATALOG2_UP_STATE', '', '', '', 'state_id', 'A', NULL, 'core:djccountrystate', 'djcatalog2profile', 11, 0, 1, 1, 1, 0, NULL),
(12, 1, 'Postcode', 'COM_DJCATALOG2_UP_POSTCODE', '', '', '', 'postcode', 'A', NULL, 'text', 'djcatalog2profile', 12, 0, 1, 1, 1, 0, NULL),
(13, 1, 'VAT ID', 'COM_DJCATALOG2_UP_VATID', '', '', '', 'vat_id', 'A', NULL, 'text', 'djcatalog2profile', 13, 0, 1, 1, 1, 0, NULL),
(14, 1, 'Phone', 'COM_DJCATALOG2_UP_PHONE', '', '', '', 'phone', 'A', NULL, 'text', 'djcatalog2profile', 14, 0, 1, 1, 1, 0, NULL),
(15, 1, 'Fax', 'COM_DJCATALOG2_UP_FAX', '', '', '', 'fax', 'A', NULL, 'text', 'djcatalog2profile', 15, 0, 0, 0, 0, 0, NULL),
(16, 1, 'Website', 'COM_DJCATALOG2_UP_WWW', '', '', 'filter=\"url\"', 'www', 'A', NULL, 'text', 'djcatalog2profile', 16, 0, 0, 0, 0, 0, NULL),
(17, 1, 'Customer Group', 'COM_DJCATALOG2_UP_CUSTOMERGROUP', '', '', '', 'customer_group_id', 'A', NULL, 'core:djccustomergroup', 'djcatalog2profile', 17, 0, 1, 0, 0, 0, NULL),
(18, 1, 'Terms of Service', 'COM_DJCATALOG2_TOS', '', '', '', 'tos', 'A', NULL, 'core:checkbox', 'djcatalog2statements', 18, 2, 2, 2, 2, 0, NULL),
(19, 1, 'GDPR Policy', 'COM_DJCATALOG2_UP_GDPR_POLICY_AGREE', '', '', '', 'gdpr_policy', 'A', NULL, 'core:checkbox', 'djcatalog2statements', 19, 2, 2, 2, 2, 0, NULL),
(20, 1, 'GDPR Agreement', 'COM_DJCATALOG2_UP_GDPR_AGREE', '', '', '', 'gdpr_agreement', 'A', NULL, 'core:checkbox', 'djcatalog2statements', 20, 2, 2, 2, 2, 0, NULL),
(21, 1, 'Want invoice', 'COM_DJCATALOG2_UP_WANT_INVOICE', '', '', '', 'want_invoice', 'A', NULL, 'core:radio', 'djcatalog2profile', 25, 0, 0, 1, 0, 0, NULL);

