<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die();

jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

require_once (dirname(__FILE__).'/file.php');

class DJCatalog2VideoHelper extends DJCatalog2FileHelper {
	
	static $videos = null;
	
	public static function renderInput($itemtype, $itemid=null, $multiple_upload = false) {
		if (!$itemtype) {
			return false;
		}
		
		$db = JFactory::getDbo();
		$params = JComponentHelper::getParams( 'com_djcatalog2' );
		$size_limit = 0;
		$count_limit = -1;
		
		$whitelist = explode(',', $params->get('allowed_video_types', 'mp4,avi,mpeg'));
		//$whitelist = explode(',', $params->get('allowed_image_types', 'jpg,png,gif'));
		foreach($whitelist as $key => $extension) {
			if (!in_array(trim($extension), self::$blacklist)) {
				$whitelist[$key] = strtolower(trim($extension));
			}
		}
		
		$videos = array();
		if ($itemid) {
			$db->setQuery('SELECT * '.
				' FROM #__djc2_videos '.
				' WHERE item_id='.intval($itemid).
				' 	AND type='.$db->quote( $itemtype).
				' ORDER BY ordering ASC');
			$videos = $db->loadObjectList();
		}
		
		
		$record_type = 'video';
		
		return self::getUploader($record_type, $itemtype, $itemid, $count_limit, $size_limit, $whitelist, $videos, $multiple_upload);
	}
	public static function getVideos($itemtype, $itemid) {
		if (!$itemtype || !$itemid) {
			return false;
		}
		$hash = $itemtype.'.'.$itemid;
		if (isset(self::$videos[$hash])) {
			return self::$videos[$hash];
		}
		$db = JFactory::getDbo();
		$videos = array();
		
		$db->setQuery('SELECT * '.
			' FROM #__djc2_videos '.
			' WHERE item_id='.intval($itemid).
			' 	AND type='.$db->Quote($itemtype).
			' ORDER BY ordering ASC ');
		$videos = $db->loadObjectList();
		
		self::$videos[$hash] = $videos;
		
		return self::$videos[$hash];
	}
	
	public static function deleteFiles($itemtype, $itemid) {
		return self::deleteVideos($itemtype, $itemid);
	}
	
	public static function deleteVideos($itemtype, $itemid) {
		if (!$itemtype || !$itemid) {
			return false;
		}
		
		$db = JFactory::getDbo();
		$videos = array();
		$db->setQuery('SELECT id, fullname, path, fullpath '.
			' FROM #__djc2_videos '.
			' WHERE item_id='.intval($itemid).
			' 	AND type='.$db->Quote($itemtype).
			' ORDER BY ordering ASC');
		$videos = $db->loadObjectList();
		
		$videos_to_remove = array();
		if (count($videos)) {
			foreach ($videos as $key=>$video) {
				$videos_to_remove[] = $video->id;
				
				// remote videos do not have files
				if ($video->source == 'remote') continue;
				
				// video files outside DJCATVIDFOLDER should not be removed
				if (empty($video->path) || strpos($video->path, DJCATVIDPATH) !== 0) continue;
				
				$db->setQuery('select count(*) from #__djc2_videos WHERE id != '.$video->id.' AND source = '.$db->quote('local').' AND fullpath = '.$db->quote($video->fullpath));
				$count = $db->loadResult();
				
				if ($count > 0) continue;
				
				$video_dir = DJCATVIDFOLDER.'/'.$video->path;
				$video_path = $video_dir.'/'.$video->fullname;
				
				if (JFile::exists($video_path)) {
					JFile::delete($video_path);
				}
			}
		}
		
		if (count($videos_to_remove)) {
			JArrayHelper::toInteger($videos_to_remove);
			$ids = implode(',',$videos_to_remove);
			$db->setQuery('DELETE FROM #__djc2_videos WHERE id IN ('.$ids.')');
			$db->query();
		}
		
		return true;
		
	}
	
	public static function saveFiles($itemtype, $item, &$params, $isNew) {
		if (!$itemtype || !$item || empty($params)) {
			return false;
		}
		
		$itemid = $item->id;
		if (!($itemid) > 0) {
			return false;
		}
		
		$prefix = $suffix = 'video_';//.$itemtype.'_';
		
		$db = JFactory::getDbo();
		$app = JFactory::getApplication();
		
		$whitelist = explode(',', $params->get('allowed_video_types', 'mp4,avi,mpeg'));
		//$whitelist = explode(',', $params->get('allowed_image_types', 'jpg,png,gif'));
		foreach($whitelist as $key => $extension) {
			$whitelist[$key] = strtolower(trim($extension));
		}
		
		$ids = $app->input->get($prefix.'file_id', array(),'array');
		$names = $app->input->get($prefix.'file_name', array(),'array');
		$captions = $app->input->get($prefix.'caption', array(),'array');
		$sources = $app->input->get($prefix.'source', array(),'array');
		
		$covers = $app->input->files->get($prefix.'cover', array());
		$covers_delete = $app->input->get($prefix.'delete_cover', array(), 'array');
		
		$files_to_update = array();
		$files_to_save = array();
		
		$update_ids = array();
		$files = array();
		
		$destination = self::getDestinationFolder(DJCATVIDFOLDER, $itemid, $itemtype);
		$sub_path = self::getDestinationPath($itemid, $itemtype);
		if (!JFolder::exists($destination)) {
			$destExist = JFolder::create($destination, 0755);
		} else {
			$destExist = true;
		}
		
		$additional_ids = (count($ids) > 0) ? 'OR id IN ('.implode(',', $ids).')' : '';
		$db->setQuery('select * from #__djc2_videos where type='.$db->quote($itemtype).' and (item_id='.(int)$itemid.' '.$additional_ids.')');
		
		$existing_files = $db->loadObjectList('id');
		$ordering = 1;
		
		if (!empty($ids)) {
			foreach($ids as $key => $id) {
				$id = (int)$id;
				$file = new stdClass();
				
				if ($id > 0 && array_key_exists($id, $existing_files)) {
					$file = clone $existing_files[$id];
				}
				
				$file->id = (int)$id;
				$file->item_id = $itemid;
				$file->type = $itemtype;
				
				if (!empty($names[$key]) && !isset($file->fullname)) {
					$file->fullname = $names[$key];
				} else if (!isset($file->fullname)) {
					$file->fullname = '';
				}
				
				$file->caption = (!empty($captions[$key])) ? $captions[$key] : $item->alias;
				$file->ordering = $ordering++;
				$file->_uploaded = 0;
				
				if ($id > 0) {
					$update_ids[] = $id;
				} else {
					$file->fullname = (!empty($names[$key])) ? $names[$key] : '';
					$file->path = null;
					$file->fullpath = null;
					$file->_temp_name = JPATH_ROOT .'/media/djcatalog2/tmp/'.$file->fullname;
					$file->_uploaded = 1;
					$file->source = (!empty($sources[$key])) ? $sources[$key] : 'local';
				}
				
				if ($file->source == 'remote' && empty($file->fullpath)) {
					//$file->fullpath = $file->fullname;
					$file->fullpath = strip_tags($file->fullname);
				}
				
				if (!empty($covers_delete[$key])) {
					$file->cover_path = null;
					$file->cover_fullpath = null;
					$file->cover = null;
					
				} else if (isset($covers[$key]) && !empty($covers[$key]['name'])) {
					$coverArr = static::uploadVideoCover($covers[$key], $file, $itemid);
					if (is_array($coverArr)) {
						$file->cover_path = $coverArr['path'];
						$file->cover_fullpath = $coverArr['fullpath'];
						$file->cover = $coverArr['name'];
					} else {
						$file->cover_path = null;
						$file->cover_fullpath = null;
						$file->cover = null;
					}
				}
				
				$files[] = $file;
				$total_vids++;
			}
		}

		// fetch files from POST
		$post_files = $app->input->files->get($prefix.'file_upload', array());

		foreach ($post_files as $key => $post_file) {
			if (!empty($post_file['name']) && !empty($post_file['tmp_name']) && $post_file['error'] == 0 && $post_file['size'] > 0) {
				$file = new stdClass();
				
				$file->id = 0;
				$file->item_id = $itemid;
				$file->type = $itemtype;
				$file->fullname = $post_file['name'];
				$file->caption 	= $item->alias;//JFile::stripExt($post_file['name']);
				$file->ordering = $ordering++;
				
				$file->path = null;
				$file->fullpath = null;
				
				$file->source = 'local';
				$file->_temp_name = $post_file['tmp_name'];
				$file->_uploaded = -1;
				
				$files[] = $file;
				$total_vids++;
			}
		}
		
		// delete files, unless saveToCopy action is performed
		if (!$isNew && $app->input->get('task') != 'import') {
			
			$condition = 'WHERE item_id='.(int)$itemid.' AND type='.$db->quote($itemtype);
			if (count($update_ids) > 0) {
				JArrayHelper::toInteger($update_ids);
				
				$condition .= ' AND id NOT IN ('.implode(',', $update_ids).')';
			}
			
			$db->setQuery('SELECT id, fullname, path, fullpath, source FROM #__djc2_videos '.$condition);
			$files_to_delete = $db->loadObjectList();
			
			foreach ($files_to_delete as $row) {
				// remote videos do not have files
				if ($row->source == 'remote') continue;
				
				// video files outside DJCATVIDFOLDER should not be removed
				if (empty($row->path) || strpos($row->path, DJCATVIDPATH) !== 0) continue;
				
				$db->setQuery('select count(*) from #__djc2_videos WHERE id != '.$row->id.' AND source = '.$db->quote('local').' AND fullpath = '.$db->quote($row->fullpath));
				$count = $db->loadResult();
				
				if ($count > 0) continue;
				
				$video_dir = DJCATVIDFOLDER.'/'.$row->path;
				$video_path = $video_dir.'/'.$row->fullname;
				
				if (JFile::exists($video_path)) {
					if (!JFile::delete($video_path)) {
						JLog::add(JText::_('COM_DJCATALOG2_IMAGE_FILE_DELETE_ERROR'), JLog::WARNING, 'jerror');
					} 
				}
			}
			
			$db->setQuery('DELETE FROM #__djc2_videos '.$condition);
			$db->query();
		}
		
		// update existing files and move new ones from temporary
		if (count($files)) {
			foreach($files as $k => &$file) {
				$copy = (bool)($isNew && $file->id > 0);
				
				if(strpos($file->fullname, '/') !== false && $file->source == 'local') {
					// if the fullname contains slash it's considered as a image copy from file browser
					$file->_temp_name = JPATH_ROOT.'/'.$file->fullname;
					$file->_from_browser = true;
				}
				
				if ($copy) {
					$file->id = 0;
					
					/*$source = (empty($file->path)) ? DJCATVIDFOLDER : DJCATVIDFOLDER.'/'.$file->path;
					$source .= '/'.$file->fullname;
					
					$file->id = 0;
					$file->fullname = self::createFileName(JString::strtolower($file->fullname), $destination);
					
					if (!JFile::copy($source, $destination.'/'.$file->fullname)) {
						JLog::add(JText::_('COM_DJCATALOG2_IMAGE_FILE_COPY_ERROR'), JLog::WARNING, 'jerror');
						unset($files[$k]);
						continue;
					}
					
					if (empty($file->caption)) {
						$file->caption = $file->name;
					}
					
					$file->path = $sub_path;
					$file->fullpath = $sub_path.'/'.$file->fullname;*/
					
				} else if (empty($file->id) && !$copy) {
					if ($file->source == 'local') {
						
						if (!in_array(JFile::getExt($file->fullname), $whitelist)) {
							JFactory::getApplication()->enqueueMessage('<pre>' . print_r($file, true).'</pre>');
							$app->enqueueMessage(JText::sprintf('COM_DJCATALOG2_UPLOADER_EXT_ERROR', $file->fullname), 'error');
							//JLog::add(JText::_('COM_DJCATALOG2_UPLOADER_EXT_ERROR'), JLog::WARNING, 'jerror');
							continue;
						}
						
						if (isset($file->_from_browser)) {
							$file->path = null;
							$file->fullpath = $file->fullname;
							$file->fullname = basename($file->fullpath); 
						} else {
							$tmp_name = $file->fullname;
							$realname = empty($captions[$k]) ? $tmp_name : $captions[$k];
							
							$source = $file->_temp_name;
							unset($file->_temp_name);
							
							$newname = JString::strtolower(JString::substr($realname, 0, 200).'.'.self::getExtension($file->fullname));
							$file->fullname = self::createFileName($newname, $destination);
							
							if ($file->_uploaded === 1) {
								if (!JFile::copy($source, $destination.'/'.$file->fullname)) {
									JLog::add(JText::_('COM_DJCATALOG2_FILE_COPY_ERROR'), JLog::WARNING, 'jerror');
									unset($files[$k]);
									continue;
								}
							} else if ($file->_uploaded === -1) {
								if (!JFile::upload($source, $destination.'/'.$file->fullname)) {
									JLog::add(JText::_('COM_DJCATALOG2_FILE_COPY_ERROR'), JLog::WARNING, 'jerror');
									unset($files[$k]);
									continue;
								}
							} else {
								unset($files[$k]);
								continue;
							}
							
							unset($file->_uploaded);
							
							$file->path = $sub_path;
							$file->fullpath = $sub_path.'/'.$file->fullname;
						}
					}
				}
			}
			unset($file);
		}
		
		// update DB & process
		foreach ($files as $k=>$v) {
			$ret = false;
			if ($v->id) {
				$ret = $db->updateObject( '#__djc2_videos', $v, 'id', true);
			} else {
				$ret = $db->insertObject( '#__djc2_videos', $v, 'id');
			}
			if( !$ret ){
				unset($files[$k]);
				JLog::add(JText::_('COM_DJCATALOG2_FILE_STORE_ERROR').$db->getErrorMsg(), JLog::WARNING, 'jerror');
				continue;
			}
		}
		return true;
	}
	
	protected static function uploadVideoCover($file, $video, $itemid) {
		if (empty($file['size']) || $file['error'] !== 0){
			return null;
		}
		
		$name = JFile::stripExt($file['name']) .'-'.$video->fullname;
		$ext = JFile::getExt($file['name']);
		
		$destination = self::getDestinationFolder(DJCATIMGFOLDER, $itemid, 'video_cover');
		$sub_path = parent::getDestinationPath($itemid, 'video_cover');
		if (!JFolder::exists($destination)) {
			$destExist = JFolder::create($destination, 0755);
		} else {
			$destExist = true;
		}
		
		$coverName = static::createFileName($name.'.'.$ext, $destination, $ext);
		if (JFile::upload($file['tmp_name'], $destination.'/'.$coverName)) {
			return array('path' => $sub_path, 'name' => $coverName, 'fullpath' => $sub_path.'/'.$coverName);
			
		}
		return null;
	}

	
	public static function getFilenameFromURL($url)
	{
		if (is_string($url))
		{
			$parts = explode('/', $url);
			
			return $parts[count($parts) - 1];
		}
		
		return false;
	}
	
	public static function setOrdering($file1, $file2){
		return parent::setOrdering($file1, $file2);
	}
	public static function getDestinationFolder($path, $itemid, $itemtype) {
		return parent::getDestinationFolder($path, $itemid, $itemtype);
	}
	public static function getDestinationPath($itemid, $itemtype){
		return DJCATVIDPATH . '/'.parent::getDestinationPath($itemid, $itemtype);
	}
}