<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
defined('_JEXEC') or die('Restricted access');

class DJCatalog2HelperMailer
{

	public static function prepare(&$data, $template) {
		$template->body = self::parseTemplate($data, $template);
		$template->subject = self::parseSubject($data, $template);
		
		$data['message'] = $template->body;
		$data['subject'] = $template->subject; 
	}
	
	public static function send(&$data, $template, $CC = array(), $BCC = array(), $replyTo = null, $tracking = false)
	{
		$app = JFActory::getApplication();
		
		if ($tracking) {
			$trackingID = $data['notification_id'];
			$trackingCode = base64_encode($data['sent_time']);
			$pixel = '<img width="1" height="1" alt="Pixel" src="' . JUri::root(false) . 'index.php?option=com_djcatalog2&task=pixelMsg&pixel=' . $trackingID . '&code=' . $trackingCode . '&file=pixel.jpg" />';
			$template->body = str_replace('</body>', $pixel . '</body>', $template->body);
		}
		
		$mailfrom = $app->getCfg('mailfrom');
		$fromname = $app->getCfg('fromname');
		
		$mail = JFactory::getMailer();
		
		$mail->addRecipient($data['recipient_email']);
		$mail->setSender(array(
			$mailfrom,
			$fromname
		));
		
		if ($replyTo) {
			$mail->addReplyTo($replyTo);
		}
		
		$mail->setSubject($template->subject);
		$mail->setBody($template->body);
		$mail->isHtml(true);
		
		if (is_array($CC) && count($CC) > 0) {
			foreach ($CC as $mailCC) {
				$mail->addCC($mailCC);
			}
		}
		
		if (is_array($BCC) && count($BCC) > 0) {
			foreach ($BCC as $mailBCC) {
				$mail->addBCC($mailBCC);
			}
		}
		
		$attachments = DJCatalog2HelperAttachment::getFiles($data);
		
		if (is_array($attachments) && count($attachments) > 0) {
			foreach ($attachments as $file) {
				$mail->addAttachment(JPath::clean(JPATH_ROOT . '/' . $file['fullpath']), $file['name']);
			}
		}
		
		$templateAttachments = (!empty($template->attachments) && $template->attachments != '{}' && $template->attachments != '[]') ? json_decode($template->attachments, true) : false;
		
		if (! empty($templateAttachments)) {
			foreach ($templateAttachments as $file) {
				if (JFile::exists(JPath::clean(JPATH_ROOT . '/' . $file['fullpath']))) {
					$mail->addAttachment(JPath::clean(JPATH_ROOT . '/' . $file['fullpath']), $file['fullname']);
				}
			}
		}
		
		$ret = $mail->Send();
		return $ret;
	}
	
	protected static function parseTemplate($data, $template)
	{
		$body = (string)$template->body;
		
		$juri = str_replace('/administrator', '', JUri::base(false));
		
		foreach ($data as $key => $value) {
			if (is_object($value) || is_array($value)) continue;
			$body = JString::str_ireplace('[[' . $key . ']]', $value, $body);
		}
		
		$body = preg_replace('#(href|src)="([^:"]*)("|(?:(?:%20|\s|\+)[^"]*"))#', '$1="' . $juri . '$2$3', $body);

		return self::addStyles($body);
	}
	
	protected static function parseSubject($data, $template)
	{
		$subject = $template->subject;
		if (trim($subject) == '') {
			$subject = $data['subject'];
		}
		
		foreach ($data as $key => $value) {
			$subject = JString::str_ireplace('[[' . $key . ']]', $value, $subject);
		}
		
		return $subject;
	}
	
	protected static function addStyles($body)
	{
		require_once JPATH_ROOT . '/components/com_djcatalog2/assets/emogrifier/Emogrifier.php';
		
		$params = JComponentHelper::getParams('com_djcatalog2');
		$theme = $params->get('theme', 'default');
		
		$css_file = JPATH_ROOT . '/components/com_djcatalog2/themes/default/css/emails.css';
		
		if ($theme && $theme != 'default' && JFile::exists(JPATH_ROOT . '/components/com_djcatalog2/themes/' . $theme . '/css/emails.css')) {
			$css_file = JPATH_ROOT . '/components/com_djcatalog2/themes/' . $theme . '/css/emails.css';
		}
		
		$css = JFile::read($css_file);
		$emogrifier = new \Pelago\Emogrifier();
		
		$emogrifier->setHtml($body);
		$emogrifier->setCss($css);
		
		$mergedHtml = $emogrifier->emogrify();
		
		return $mergedHtml;
	}
}