<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die();

$cParams = JComponentHelper::getParams('com_djcatalog2');
?>

<div style="clear: both"></div>

<div id="<?php echo $wrapper_id ?>" class="djc_uploader <?php echo $wrapper_class?>">
	<table class="adminlist table table-condensed table-bordered djc_uploader_table jlist-table">
		<thead>
			<tr>
				<th class="djc_uploader_ordering" width="1%">
					<?php echo JText::_('COM_DJCATALOG2_FILE_ORDER_LABEL'); ?>
				</th>
				<th class="djc_uploader_img">
					<?php echo JText::_('COM_DJCATALOG2_VIDEO');?>
				</th>
				<th class="djc_uploader_caption">
					<?php echo JText::_('COM_DJCATALOG2_FILE_CAPTION_LABEL'); ?>
				</th>
				<th class="djc_uploader_video_cover">
					<?php echo JText::_('COM_DJCATALOG2_VIDEO_COVER'); ?>
				</th>
				<th class="djc_uploader_delete">
				</th>
			</tr>
		</thead>
		
		<tfoot>
			<tr id="djc_uploader_simple_<?php echo $suffix; ?>" class="djc_uploader_item_simple" style="display: none;">
				<td colspan="5">
					<input type="file" name="<?php echo $prefix; ?>_file_upload[]" />
				</td>
			</tr>
			<tr>
				<td colspan="5">
					<ul class="nav nav-tabs">
					  <li class="nav-item active"><a class="nav-link active" href="#videouploaderTab" data-toggle="tab"><?php echo JText::_('COM_DJCATALOG2_TAB_VIDEO_UPLOADER') ?></a></li>
					  <?php if($cParams->get('fb') && JFactory::getApplication()->isAdmin()) { ?>
					  <li class="nav-item"><a class="nav-link" href="#videobrowserTab" data-toggle="tab"><?php echo JText::_('COM_DJCATALOG2_TAB_VIDEO_BROWSER') ?></a></li>
					  <?php } ?>
					  <li class="nav-item"><a class="nav-link" href="#videourlTab" data-toggle="tab"><?php echo JText::_('COM_DJCATALOG2_TAB_VIDEO_URL') ?></a></li>
					</ul>
					<div class="tab-content">
						<div class="tab-pane active" id="videouploaderTab">
							<?php if ($multiple_upload) {?>
								<?php echo DJCatalog2UploadHelper::getUploader($uploader_id, $settings); ?>
							<?php } else {?>
								<button id="add_<?php echo $suffix; ?>_button" class="btn button" onclick="DJCatalog2UPAddUploader('<?php echo $suffix; ?>', '<?php echo $wrapper_id?>'); return false;"><?php echo JText::_('COM_DJCATALOG2_ADD_VIDEO'); ?></button>
							<?php } ?>
						</div>
						<?php if ($cParams->get('fb')  && JFactory::getApplication()->isAdmin()) {?>
						<div class="tab-pane" id="videobrowserTab">
							<div id="videobrowser" class="djc_filebrowser"></div>
						</div>
						<?php } ?>
						<div class="tab-pane" id="videourlTab">
							<div id="videourl" class="form form-horizontal">
								<div class="container-fluid">
									<div class="span12">
										<fieldset >
											<div class="control-group">
												<div class="control-label">
													<label for="videourl-address"><?php echo JText::_('COM_DJCATALOG2_VIDEO_URL');?></label>
												</div>
												<div class="controls">
													<input type="text" placeholder="Enter URL of the video..." value="" name="" id="videourl-input" />
												</div>
											</div>
											
											<div class="control-group">
												<div class="controls">
													<button type="button" role="button" class="btn btn-primary" id="videourl-submit"><?php echo JText::_('COM_DJCATALOG2_ADD_VIDEO');?></button>
												</div>
											</div>
										</fieldset>
									</div>
								</div>
							</div>
						</div>
					</div>
				</td>
			</tr>
		</tfoot>
		
		<tbody id="<?php echo $wrapper_id; ?>_items" class="djc_uploader_items"  data-limit="<?php echo (int)$limit;?>">
			<?php if(count($files)) { ?>
			<?php foreach($files as $file) { 
				?>
				<tr class="djc_uploader_item">
					<td class="center ordering_handle">
						<span class="sortable-handler" style="cursor: move;">
							<i class="icon-move"></i>
						</span>
					</td>
					
					<td class="center">
						<a target="_blank" href="<?php echo ($file->source == 'local') ? JUri::root() . $file->fullpath : $file->fullpath; ?>">
							<?php echo htmlspecialchars($file->fullname); ?>
						</a>
						<input type="hidden" name="<?php echo $prefix?>_file_id[]" value="<?php echo (int)$file->id; ?>" />
						<input type="hidden" name="<?php echo $prefix?>_file_name[]" value="<?php echo $file->fullname; ?>" />
						<input type="hidden" name="<?php echo $prefix?>_source[]" value="<?php echo $file->source; ?>" />
					</td>
					
					<td>
						<input type="text" name="<?php echo $prefix ?>_caption[]" value="<?php echo htmlspecialchars($file->caption); ?>" class="djc_uploader_caption inputbox input input-medium" />
					</td>
					<td>
						<?php /*?><input type="text" name="<?php echo $prefix ?>_cover[]" value="<?php echo htmlspecialchars($file->cover); ?>" class="djc_uploader_video_cover inputbox input input-medium" /><?php */ ?>
						<input type="file" name="<?php echo $prefix ?>_cover[]" class="djc_uploader_video_cover inputbox input input-medium" />
						<?php if ($file->cover != '') {?>
							<br />
							<img alt="" src="<?php echo DJCATIMGURLPATH .'/'. $file->cover_fullpath;?>" />
							<br />
							<label><?php echo JText::_('COM_DJCATALOG2_CHECK_TO_DELETE')?> <input type="checkbox" onchange="DJC2VideoCoverDelete(this);"/><input type="hidden" name="<?php echo $prefix ?>_delete_cover[]" value="0" /></label>
						<?php } else {?>
							<input type="hidden" name="<?php echo $prefix ?>_delete_cover[]" value="0" />
						<?php } ?>
					</td>
					<td class="center">
						<button class="button btn djc_uploader_remove_btn"><?php echo JText::_('COM_DJCATALOG2_DELETE_BTN')?></button>
					</td>
				</tr>
			<?php }?>
			<?php }?>
		</tbody>
	</table>
</div>

<script>
function DJC2VideoCoverDelete(input) {
	var toggle = jQuery(input);
	setTimeout(function(){
		var value = toggle.is(':checked') ? 1 : 0;
		toggle.siblings('input[type=hidden]').val(value);
	}, 10);
}
</script>