<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die();
?>

<div style="clear: both"></div>

<div id="<?php echo $wrapper_id ?>" class="djc_uploader <?php echo $wrapper_class?>">
    <table class="adminlist table table-condensed table-bordered djc_uploader_table jlist-table">
        <thead>
        <tr>
            <th class="djc_uploader_ordering" width="1%">
                <?php echo JText::_('COM_DJCATALOG2_FILE_ORDER_LABEL'); ?>
            </th>
            <th class="djc_uploader_img">
                <?php echo JText::_('COM_DJCATALOG2_FILE')?>
            </th>
            <th class="djc_uploader_caption" <?php if (empty($groups)) echo 'colspan="2"'; ?>>
                <?php echo JText::_('COM_DJCATALOG2_FILE_CAPTION_LABEL'); ?>
            </th>

            <?php if (count($groups)) {?>
                <th class="djc_uploader_caption">
                    <?php echo JText::_('COM_DJCATALOG2_FILE_GROUP'); ?>
                </th>
            <?php } ?>

            <th class="djc_uploader_access">
                <?php echo JText::_('JFIELD_ACCESS_LABEL'); ?>
            </th>

            <th class="djc_uploader_hits">
                <?php echo JText::_('COM_DJCATALOG2_FILE_HITS_LABEL'); ?>
            </th>
            <th class="djc_uploader_delete">
            </th>
        </tr>
        </thead>

        <tfoot>
        <tr id="djc_uploader_simple_<?php echo $suffix; ?>" class="djc_uploader_item_simple" style="display:none;">
            <td colspan="7">
                <input type="file" name="<?php echo $prefix; ?>_file_upload[]" />
            </td>
        </tr>
        <tr>

            <td colspan="7">
                <ul class="nav nav-tabs">
                    <li class="nav-item active"><a class="nav-link active" href="#fileUploaderTab" data-toggle="tab"><?php echo JText::_('COM_DJCATALOG2_TAB_FILE_UPLOADER') ?></a></li>
                    <li class="nav-item"><a class="nav-link" href="#fileUrlTab" data-toggle="tab"><?php echo JText::_('COM_DJCATALOG2_TAB_FILE_URL') ?></a></li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="fileUploaderTab">
                        <?php if ($multiple_upload) {?>
                            <?php echo DJCatalog2UploadHelper::getUploader($uploader_id, $settings); ?>
                        <?php } else {?>
                            <button id="add_<?php echo $suffix; ?>_button" class="btn button" onclick="DJCatalog2UPAddUploader('<?php echo $suffix; ?>', '<?php echo $wrapper_id?>'); return false;"><?php echo JText::_('COM_DJCATALOG2_ADD_FILE_LINK'); ?></button>
                        <?php } ?>
                    </div>
                    <div class="tab-pane" id="fileUrlTab">
                        <div id="fileurl" class="form form-horizontal">
                            <div class="container-fluid">
                                <div class="span12">
                                    <fieldset >
                                        <div class="control-group">
                                            <div class="control-label">
                                                <label for="fileurl-address"><?php echo JText::_('COM_DJCATALOG2_FILE_URL_URL');?></label>
                                            </div>
                                            <div class="controls">
                                                <input type="text" placeholder="Enter URL of the file..." value="" name="" id="fileurl-input" />
                                            </div>
                                        </div>

                                        <div class="control-group">
                                            <div class="controls">
                                                <button type="button" role="button" class="btn btn-primary" id="fileurl-submit"><?php echo JText::_('COM_DJCATALOG2_ADD_FILE');?></button>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </td>
        </tr>
        </tfoot>

        <tbody id="<?php echo $wrapper_id; ?>_items" class="djc_uploader_items" data-limit="<?php echo (int)$limit;?>">
        <?php if(count($files)) { ?>
            <?php foreach($files as $file) { ?>
                <tr class="djc_uploader_item">
                    <td class="center ordering_handle">
						<span class="sortable-handler" style="cursor: move;">
							<i class="icon-move"></i>
						</span>
                    </td>
                    <td class="center">
                        <?php if($file->source == 'remote') : ?>

                            <input type="text" name="<?php echo $prefix?>_file_fullpath[]" value="<?php echo $file->fullpath; ?>" />
                            <a target="_blank" href="<?php echo $file->fullpath; ?>">
                                <?php echo htmlspecialchars($file->fullname); ?>
                            </a>
                        <?php else : ?>
                            <input type="hidden" name="<?php echo $prefix?>_file_fullpath[]" value="<?php echo $file->fullpath; ?>" />

                            <a target="_blank" href="<?php echo JUri::root() . 'index.php?option=com_djcatalog2&task=download&format=raw&fid=' . (int) $file->id; ?>">
                                <?php echo htmlspecialchars($file->fullname); ?>
                            </a>
                        <?php endif; ?>

                        <input type="hidden" name="<?php echo $prefix?>_file_id[]" value="<?php echo (int)$file->id; ?>" />
                        <input type="hidden" name="<?php echo $prefix?>_file_name[]" value="<?php echo $file->fullname; ?>" />
                        <input type="hidden" name="<?php echo $prefix?>_file_source[]" value="<?php echo $file->source; ?>" />
                    </td>
                    <td>
                        <?php if (count($captions)) {?>
                            <select name="<?php echo $prefix ?>_caption[]" class="djc_uploader_caption inputbox input input-medium">
                                <?php foreach($captions as $caption) {?>
                                    <?php $selected = ($caption == $file->caption) ? 'selected="selected"' : ''; ?>
                                    <option value="<?php echo htmlspecialchars($caption); ?>" <?php echo $selected; ?>><?php echo htmlspecialchars($caption); ?></option>
                                <?php } ?>
                            </select>
                        <?php } else { ?>
                            <input type="text" name="<?php echo $prefix ?>_caption[]" value="<?php echo htmlspecialchars($file->caption); ?>" class="djc_uploader_caption inputbox input input-medium" />
                        <?php } ?>

                        <?php if (empty($groups)) {?>
                            <input type="hidden" name="<?php echo $prefix ?>_group_label[]" value="" />
                        <?php } ?>
                    </td>

                    <td style="border-left: none;">
                        <?php if (count($groups)) {?>
                            <select name="<?php echo $prefix ?>_group_label[]" class="djc_uploader_caption inputbox input input-medium">
                                <option value=""><?php echo '- '.JText::_('JNONE').' -';?></option>
                                <?php foreach($groups as $group) {?>
                                    <?php $selected = ($group == $file->group_label) ? 'selected="selected"' : ''; ?>
                                    <option value="<?php echo htmlspecialchars($group); ?>" <?php echo $selected; ?>><?php echo htmlspecialchars($group); ?></option>
                                <?php } ?>
                            </select>
                        <?php } ?>
                    </td>

                    <td>
                        <select name="<?php echo $prefix ?>_access[]" class="djc_uploader_access inputbox input input-medium">
                            <?php foreach($acls as $acl) {?>
                                <?php $selected = ($acl->id == $file->access) ? 'selected="selected"' : ''; ?>
                                <option value="<?php echo htmlspecialchars($acl->id); ?>" <?php echo $selected; ?>><?php echo htmlspecialchars($acl->title); ?></option>
                            <?php } ?>
                        </select>
                    </td>

                    <?php if (JFactory::getApplication()->isAdmin()) { ?>
                        <td>
                            <input type="text" name="<?php echo $prefix ?>_hits[]" value="<?php echo htmlspecialchars($file->hits); ?>" class="djc_uploader_hits inputbox input input-small" readonly="readonly" />
                        </td>
                    <?php } else {?>
                        <td class="center">
                            <span><?php echo $file->hits; ?></span>
                        </td>
                    <?php } ?>
                    <td class="center">
                        <button class="button btn djc_uploader_remove_btn"><?php echo JText::_('COM_DJCATALOG2_DELETE_BTN')?></button>
                    </td>
                </tr>
            <?php }?>
        <?php }?>
        </tbody>
    </table>
</div>

