<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

JLoader::register('Djcatalog2AdminHelper', JPATH_ADMINISTRATOR . '/components/com_djcatalog2/helpers/djcatalog2.php');

class JHtmlDJCatalog2
{
    /**
     * Render the list of associated items
     *
     * @param   integer  $id  The id of the helloworld record
     *
     * @return  string  The language HTML
     *
     * @throws  Exception
     */
    public static function associationItem($id)
    {
        // Defaults
        $html = '';
        // Get the associations
        if ($associations = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_items', 'com_djcatalog2.item', (int)$id, 'id', '', ''))
        {
            foreach ($associations as $tag => $associated)
            {
                $associations[$tag] = (int) $associated->id;
            }

            // get the relevant category titles and languages, for the tooltip
            $db = JFactory::getDbo();
            $query = $db->getQuery(true)
                ->select('i.*')
                ->select('l.sef as lang_sef')
                ->select('l.lang_code')
                ->from('#__djc2_items as i')
                ->where('i.id IN (' . implode(',', array_values($associations)) . ')')
                ->join('LEFT', '#__languages as l ON i.language=l.lang_code')
                ->select('l.image')
                ->select('l.title as language_title');
            $db->setQuery($query);

            try
            {
                $items = $db->loadObjectList('id');
            }
            catch (RuntimeException $e)
            {
                throw new Exception($e->getMessage(), 500, $e);
            }

            if ($items)
            {
                foreach ($items as &$item)
                {
                    $text    = $item->lang_sef ? strtoupper($item->lang_sef) : 'XX';
                    $url     = JRoute::_('index.php?option=com_djcatalog2&task=item.edit&id=' . (int) $item->id);

                    $tooltip = htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8') . '<br />';
                    $classes = 'hasPopover label label-association label-' . $item->lang_sef;

                    $item->link = '<a href="' . $url . '" title="' . $item->language_title . '" class="' . $classes
                        . '" data-content="' . $tooltip . '" data-placement="top">'
                        . $text . '</a>';
                }
            }

            JHtml::_('bootstrap.popover');

            $html = JLayoutHelper::render('joomla.content.associations', $items);
        }

        return $html;
    }

    public static function associationCategory($id)
    {
        // Defaults
        $html = '';
        // Get the associations
        if ($associations = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_categories', 'com_djcatalog2.category', (int)$id, 'id', '', ''))
        {

            foreach ($associations as $tag => $associated)
            {
                $associations[$tag] = (int) $associated->id;
            }

            // get the relevant category titles and languages, for the tooltip
            $db = JFactory::getDbo();
            $query = $db->getQuery(true)
                ->select('i.*')
                ->select('l.sef as lang_sef')
                ->select('l.lang_code')
                ->from('#__djc2_categories as i')
                ->where('i.id IN (' . implode(',', array_values($associations)) . ')')
                ->join('LEFT', '#__languages as l ON i.language=l.lang_code')
                ->select('l.image')
                ->select('l.title as language_title');
            $db->setQuery($query);

            try
            {
                $items = $db->loadObjectList('id');
            }
            catch (RuntimeException $e)
            {
                throw new Exception($e->getMessage(), 500, $e);
            }

            if ($items)
            {
                foreach ($items as &$item)
                {
                    $text    = $item->lang_sef ? strtoupper($item->lang_sef) : 'XX';
                    $url     = JRoute::_('index.php?option=com_djcatalog2&task=category.edit&id=' . (int) $item->id);

                    $tooltip = htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8') . '<br />';
                    $classes = 'hasPopover label label-association label-' . $item->lang_sef;

                    $item->link = '<a href="' . $url . '" title="' . $item->language_title . '" class="' . $classes
                        . '" data-content="' . $tooltip . '" data-placement="top">'
                        . $text . '</a>';
                }
            }

            JHtml::_('bootstrap.popover');

            $html = JLayoutHelper::render('joomla.content.associations', $items);
        }

        return $html;
    }

    public static function associationField($id)
    {
    	// Defaults
    	$html = '';
    	// Get the associations
    	if ($associations = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_items_extra_fields', 'com_djcatalog2.field', (int)$id, 'id', '', ''))
    	{
    		
    		foreach ($associations as $tag => $associated)
    		{
    			$associations[$tag] = (int) $associated->id;
    		}
    		
    		// get the relevant category titles and languages, for the tooltip
    		$db = JFactory::getDbo();
    		$query = $db->getQuery(true)
    		->select('i.*')
    		->select('l.sef as lang_sef')
    		->select('l.lang_code')
    		->from('#__djc2_items_extra_fields as i')
    		->where('i.id IN (' . implode(',', array_values($associations)) . ')')
    		->join('LEFT', '#__languages as l ON i.language=l.lang_code')
    		->select('l.image')
    		->select('l.title as language_title');
    		$db->setQuery($query);
    		
    		try
    		{
    			$items = $db->loadObjectList('id');
    		}
    		catch (RuntimeException $e)
    		{
    			throw new Exception($e->getMessage(), 500, $e);
    		}
    		
    		if ($items)
    		{
    			foreach ($items as &$item)
    			{
    				$text    = $item->lang_sef ? strtoupper($item->lang_sef) : 'XX';
    				$url     = JRoute::_('index.php?option=com_djcatalog2&task=field.edit&id=' . (int) $item->id);
    				
    				$tooltip = htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8') . '<br />';
    				$classes = 'hasPopover label label-association label-' . $item->lang_sef;
    				
    				$item->link = '<a href="' . $url . '" title="' . $item->language_title . '" class="' . $classes
    				. '" data-content="' . $tooltip . '" data-placement="top">'
    					. $text . '</a>';
    			}
    		}
    		
    		JHtml::_('bootstrap.popover');
    		
    		$html = JLayoutHelper::render('joomla.content.associations', $items);
    	}
    	
    	return $html;
    }
    
    public static function associationProducer($id)
    {
    	// Defaults
    	$html = '';
    	// Get the associations
    	if ($associations = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_producers', 'com_djcatalog2.producer', (int)$id, 'id', '', ''))
    	{
    		foreach ($associations as $tag => $associated)
    		{
    			$associations[$tag] = (int) $associated->id;
    		}
    		
    		// get the relevant category titles and languages, for the tooltip
    		$db = JFactory::getDbo();
    		$query = $db->getQuery(true)
    		->select('i.*')
    		->select('l.sef as lang_sef')
    		->select('l.lang_code')
    		->from('#__djc2_producers as i')
    		->where('i.id IN (' . implode(',', array_values($associations)) . ')')
    		->join('LEFT', '#__languages as l ON i.language=l.lang_code')
    		->select('l.image')
    		->select('l.title as language_title');
    		$db->setQuery($query);
    		
    		try
    		{
    			$items = $db->loadObjectList('id');
    		}
    		catch (RuntimeException $e)
    		{
    			throw new Exception($e->getMessage(), 500, $e);
    		}
    		
    		if ($items)
    		{
    			foreach ($items as &$item)
    			{
    				$text    = $item->lang_sef ? strtoupper($item->lang_sef) : 'XX';
    				$url     = JRoute::_('index.php?option=com_djcatalog2&task=producer.edit&id=' . (int) $item->id);
    				
    				$tooltip = htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8') . '<br />';
    				$classes = 'hasPopover label label-association label-' . $item->lang_sef;
    				
    				$item->link = '<a href="' . $url . '" title="' . $item->language_title . '" class="' . $classes
    				. '" data-content="' . $tooltip . '" data-placement="top">'
    					. $text . '</a>';
    			}
    		}
    		
    		JHtml::_('bootstrap.popover');
    		
    		$html = JLayoutHelper::render('joomla.content.associations', $items);
    	}
    	
    	return $html;
    }
    
    public static function associationProducerfield($id)
    {
    	// Defaults
    	$html = '';
    	// Get the associations
    	if ($associations = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_producers_extra_fields', 'com_djcatalog2.producerfield', (int)$id, 'id', '', ''))
    	{
    		
    		foreach ($associations as $tag => $associated)
    		{
    			$associations[$tag] = (int) $associated->id;
    		}
    		
    		// get the relevant category titles and languages, for the tooltip
    		$db = JFactory::getDbo();
    		$query = $db->getQuery(true)
    		->select('i.*')
    		->select('l.sef as lang_sef')
    		->select('l.lang_code')
    		->from('#__djc2_producers_extra_fields as i')
    		->where('i.id IN (' . implode(',', array_values($associations)) . ')')
    		->join('LEFT', '#__languages as l ON i.language=l.lang_code')
    		->select('l.image')
    		->select('l.title as language_title');
    		$db->setQuery($query);
    		
    		try
    		{
    			$items = $db->loadObjectList('id');
    		}
    		catch (RuntimeException $e)
    		{
    			throw new Exception($e->getMessage(), 500, $e);
    		}
    		
    		if ($items)
    		{
    			foreach ($items as &$item)
    			{
    				$text    = $item->lang_sef ? strtoupper($item->lang_sef) : 'XX';
    				$url     = JRoute::_('index.php?option=com_djcatalog2&task=producerfield.edit&id=' . (int) $item->id);
    				
    				$tooltip = htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8') . '<br />';
    				$classes = 'hasPopover label label-association label-' . $item->lang_sef;
    				
    				$item->link = '<a href="' . $url . '" title="' . $item->language_title . '" class="' . $classes
    				. '" data-content="' . $tooltip . '" data-placement="top">'
    					. $text . '</a>';
    			}
    		}
    		
    		JHtml::_('bootstrap.popover');
    		
    		$html = JLayoutHelper::render('joomla.content.associations', $items);
    	}
    	
    	return $html;
    }
    
    public static function associationProducercategory($id)
    {
    	// Defaults
    	$html = '';
    	// Get the associations
    	if ($associations = JLanguageAssociations::getAssociations('com_djcatalog2', '#__djc2_producer_categories', 'com_djcatalog2.producercategory', (int)$id, 'id', '', ''))
    	{
    		
    		foreach ($associations as $tag => $associated)
    		{
    			$associations[$tag] = (int) $associated->id;
    		}
    		
    		// get the relevant category titles and languages, for the tooltip
    		$db = JFactory::getDbo();
    		$query = $db->getQuery(true)
    		->select('i.*')
    		->select('l.sef as lang_sef')
    		->select('l.lang_code')
    		->from('#__djc2_producer_categories as i')
    		->where('i.id IN (' . implode(',', array_values($associations)) . ')')
    		->join('LEFT', '#__languages as l ON i.language=l.lang_code')
    		->select('l.image')
    		->select('l.title as language_title');
    		$db->setQuery($query);
    		
    		try
    		{
    			$items = $db->loadObjectList('id');
    		}
    		catch (RuntimeException $e)
    		{
    			throw new Exception($e->getMessage(), 500, $e);
    		}
    		
    		if ($items)
    		{
    			foreach ($items as &$item)
    			{
    				$text    = $item->lang_sef ? strtoupper($item->lang_sef) : 'XX';
    				$url     = JRoute::_('index.php?option=com_djcatalog2&task=producercategory.edit&id=' . (int) $item->id);
    				
    				$tooltip = htmlspecialchars($item->name, ENT_QUOTES, 'UTF-8') . '<br />';
    				$classes = 'hasPopover label label-association label-' . $item->lang_sef;
    				
    				$item->link = '<a href="' . $url . '" title="' . $item->language_title . '" class="' . $classes
    				. '" data-content="' . $tooltip . '" data-placement="top">'
    					. $text . '</a>';
    			}
    		}
    		
    		JHtml::_('bootstrap.popover');
    		
    		$html = JLayoutHelper::render('joomla.content.associations', $items);
    	}
    	
    	return $html;
    }
}
