<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// No direct access
defined('_JEXEC') or die;

class Djcatalog2AdminHelper
{
    protected static $_langs = array();

    public static function addSubmenu($vName = 'cpanel')
    {
        $user = JFactory::getUser();
        $app = JFactory::getApplication();
        $version = new JVersion;
        $catalog_views = array('cpanel', 'items', 'categories', 'producers', 'fieldgroups', 'fields', 'thumbs', 'import');
        $customer_views = array('customers', 'customergroups');
        $order_views = array('orders');
        $price_views = array('prices', 'taxrates', 'taxrules', 'vatrates', 'vatrules');

        $params = JComponentHelper::getParams('com_djcatalog2');

        if ($params->get('backend_sidebar_cpanel', 1)) {
            JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_CPANEL'), 'index.php?option=com_djcatalog2&view=cpanel', $vName == 'cpanel');
            JHtmlSidebar::addEntry('<div class="divider"></div>', '', false);
        }


        if ($user->authorise('djcatalog2.access.catalogue', 'com_djcatalog2') || $user->authorise('djcatalog2.admin.catalogue', 'com_djcatalog2')) {

            // Products
            if ($params->get('backend_sidebar_items', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_ITEMS'), 'index.php?option=com_djcatalog2&view=items', $vName == 'items');
            }
            
            // Reviews
            if ($params->get('backend_sidebar_reviews', 1)) {
            	JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_REVIEWS'), 'index.php?option=com_djcatalog2&view=reviews', $vName == 'reviews');
            }


            // Categories
            if ($params->get('backend_sidebar_categories', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_CATEGORIES'), 'index.php?option=com_djcatalog2&view=categories', $vName == 'categories');
            }

            // Field groups
            if ($params->get('backend_sidebar_fieldgroups', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_FIELDGROUPS'), 'index.php?option=com_djcatalog2&view=fieldgroups', $vName == 'fieldgroups');
            }

            // Labels
            if ($params->get('backend_sidebar_labels', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_LABELS'), 'index.php?option=com_djcatalog2&view=labels', $vName == 'labels');
            }

            // Extra Fields
            if ($params->get('backend_sidebar_fields', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_FIELDS'), 'index.php?option=com_djcatalog2&view=fields', $vName == 'fields');
            }


            // Producers
            if ($params->get('backend_sidebar_producers', 1)) {
                JHtmlSidebar::addEntry('<div class="divider"></div>', '', false);
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_PRODUCERS'), 'index.php?option=com_djcatalog2&view=producers', $vName == 'producers');
            }

            // Producer Categories
            if ($params->get('backend_sidebar_producercategories', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_PRODUCER_CATEGORIES'), 'index.php?option=com_djcatalog2&view=producercategories', $vName == 'producercategories');
            }

            // Producer Extra Fields
            if ($params->get('backend_sidebar_producerfields', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_PRODUCER_FIELDS'), 'index.php?option=com_djcatalog2&view=producerfields', $vName == 'producerfields');
            }
        }

        if ($user->authorise('djcatalog2.admin.misc_settings', 'com_djcatalog2')) {

            // Product customisations
            if ($params->get('backend_sidebar_customisations', 1)) {
                JHtmlSidebar::addEntry('<div class="divider"></div>', '', false);
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_PRODUCT_CUSTOMISATIONS'), 'index.php?option=com_djcatalog2&view=customisations', $vName == 'customisations');
            }

            // Cart fields
            if ($params->get('backend_sidebar_cartfields', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_CART_FIELDS'), 'index.php?option=com_djcatalog2&view=cartfields', $vName == 'cartfields');
            }

            // Vendors
            if ($params->get('backend_sidebar_vendors', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_VENDORS'), 'index.php?option=com_djcatalog2&view=vendors', $vName == 'vendors');
            }

            // Coupons
            if ($params->get('backend_sidebar_coupons', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_COUPONS'), 'index.php?option=com_djcatalog2&view=coupons', $vName == 'coupons');
            }

            //Price rules
            if ($params->get('backend_sidebar_pricerules', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_PRICERULES'), 'index.php?option=com_djcatalog2&view=pricerules', $vName == 'pricerules');
            }

            // Delivery method
            if ($params->get('backend_sidebar_deliveries', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_DELIVERIES'), 'index.php?option=com_djcatalog2&view=deliveries', $vName == 'deliveries');
            }

            // Payment method
            if ($params->get('backend_sidebar_payments', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_PAYMENTS'), 'index.php?option=com_djcatalog2&view=payments', $vName == 'payments');
            }

            // Countries
            if ($params->get('backend_sidebar_countries', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_COUNTRIES'), 'index.php?option=com_djcatalog2&view=countries', $vName == 'countries');
            }
        }

        if ($user->authorise('djcatalog2.access.orders', 'com_djcatalog2') || $user->authorise('djcatalog2.admin.orders', 'com_djcatalog2')) {


            // Queries
            if ($params->get('backend_sidebar_queries', 1)) {
                JHtmlSidebar::addEntry('<div class="divider"></div>', '', false);
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_QUERIES'), 'index.php?option=com_djcatalog2&view=queries', $vName == 'queries');
            }

            //Orders
            if ($params->get('backend_sidebar_orders', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_ORDERS'), 'index.php?option=com_djcatalog2&view=orders', $vName == 'orders');
            }

            // Subscriptions
            if ($params->get('backend_sidebar_subscriptions', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_SUBSCRIPTIONS'), 'index.php?option=com_djcatalog2&view=subscriptions', $vName == 'subscriptions');
            }

        }

        if ($user->authorise('djcatalog2.access.customers', 'com_djcatalog2') || $user->authorise('djcatalog2.admin.customers', 'com_djcatalog2')) {

            // Customers
            if ($params->get('backend_sidebar_customers', 1)) {
                JHtmlSidebar::addEntry('<div class="divider"></div>', '', false);

                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_CUSTOMERS'), 'index.php?option=com_djcatalog2&view=customers', $vName == 'customers');
            }

            // Customer groups
            if ($params->get('backend_sidebar_customergroups', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_CUSTOMERGROUPS'), 'index.php?option=com_djcatalog2&view=customergroups', $vName == 'customergroups');
            }

            // Customer Extra Fields
            if ($params->get('backend_sidebar_userfields', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_USER_FIELDS'), 'index.php?option=com_djcatalog2&view=userfields', $vName == 'userfields');
            }

        }

        if ($user->authorise('djcatalog2.access.catalogue', 'com_djcatalog2') || $user->authorise('djcatalog2.admin.catalogue', 'com_djcatalog2')) {

        }

        if ($user->authorise('djcatalog2.admin.misc_settings', 'com_djcatalog2')) {


            // VAT rates
            if ($params->get('backend_sidebar_vatrates', 1)) {
                JHtmlSidebar::addEntry('<div class="divider"></div>', '', false);
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_VAT_RATES'), 'index.php?option=com_djcatalog2&view=vatrates', $vName == 'vatrates');
            }

            // VAT rules
            if ($params->get('backend_sidebar_vatrules', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_VAT_RULES'), 'index.php?option=com_djcatalog2&view=vatrules', $vName == 'vatrules');
            }

            // Units
            if ($params->get('backend_sidebar_units', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_UNITS'), 'index.php?option=com_djcatalog2&view=units', $vName == 'units');
            }
            
            if ($params->get('backend_sidebar_currencies', 1)) {
            	JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_CURRENCIES'), 'index.php?option=com_djcatalog2&view=currencies', $vName == 'currencies');
            }
            
            if ($params->get('backend_sidebar_order_statuses', 1)) {
            	JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_ORDER_STATUSES'), 'index.php?option=com_djcatalog2&view=orderstatuses', $vName == 'orderstatuses');
            }
            
            // Gauges
            if ($params->get('backend_sidebar_gauges', 1)) {
            	JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_GAUGES'), 'index.php?option=com_djcatalog2&view=gauges', $vName == 'gauges');
            }
            
            if ($params->get('backend_sidebar_messages', 1)) {
            	JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_MESSAGE_TEMPLATES'), 'index.php?option=com_djcatalog2&view=templates', $vName == 'templates');
            	JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_MESSAGES'), 'index.php?option=com_djcatalog2&view=messages', $vName == 'messages');
            }

        }


        if ($user->authorise('djcatalog2.admin.prices', 'com_djcatalog2') || $user->authorise('djcatalog2.admin.catalogue', 'com_djcatalog2')) {

            // Price and Stock
            if ($params->get('backend_sidebar_prices', 1)) {
                JHtmlSidebar::addEntry('<div class="divider"></div>', '', false);
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_PRICES_AND_STOCK'), 'index.php?option=com_djcatalog2&view=prices', $vName == 'prices');

            }
        }

        if ($user->authorise('djcatalog2.admin.misc_settings', 'com_djcatalog2')) {


            //Images manager
            if ($params->get('backend_sidebar_thumbs', 1)) {
                JHtmlSidebar::addEntry('<div class="divider"></div>', '', false);
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_IMAGES_MANAGER'), 'index.php?option=com_djcatalog2&view=thumbs', $vName == 'thumbs');

            }

            // Import configuration
            if ($params->get('backend_sidebar_importconfigs', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_IMPORT_CONFIGS'), 'index.php?option=com_djcatalog2&view=importconfigs', $vName == 'importconfigs');
            }

            // Import data
            if ($params->get('backend_sidebar_import', 1)) {
                JHtmlSidebar::addEntry(JText::_('COM_DJCATALOG2_IMPORT'), 'index.php?option=com_djcatalog2&view=import', $vName == 'import');
            }

        }
    }

    public static function getActions($asset = null, $assetId = 0)
    {
        $user = JFactory::getUser();
        $result = new JObject;

        if (!$asset) {
            $assetName = 'com_djcatalog2';
        } else if ($assetId != 0) {
            $assetName = 'com_djcatalog2.' . $asset . $assetId;
        } else {
            $assetName = 'com_djcatalog2.' . $asset;
        }

        $actions = array(
            'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
        );

        $actions = array(
            'catalog2.admin', 'core.admin'
        );

        foreach ($actions as $action) {
            $result->set($action, $user->authorise($action, $assetName));
        }

        return $result;
    }

    public static function getEnabledLangs($displayAll = false, $reload = false)
    {

        if (!isset(self::$_langs) || $reload) {
            // Get languages
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);
            $query
                ->select(array(
                    'l.lang_code AS value',
                    'l.title AS text'
                ))
                ->from($db->quoteName('#__languages', 'l'))
                ->where('l.published =1');
            $db->setQuery($query);
            $langs = $db->loadObjectList();


            $lang = array(array(
                'value' => '*',
                'text' => JText::_('JALL')
            ));
            self::$_langs = array_merge($lang, $langs);

        }

        return self::$_langs;
    }
}
