<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
defined('_JEXEC') or die;

JTable::addIncludePath(__DIR__ . '/../tables');

class DJCatalog2AssociationsHelper extends JAssociationExtensionHelper
{
    /**
     * The extension name
     */
    protected $extension = 'com_djcatalog2';

    /**
     * Array of item types which have associations
     */
    protected $itemTypes = array('item', 'category');

    /**
     * Has the extension association support
     */
    protected $associationsSupport = true;

    /**
     * Get the associated items for an item
     *
     * @param   string  $typeName  The item type, either 'item' or 'category'
     * @param   int     $id        The id of item for which we need the associated items
     *
     */
    public function getAssociations($typeName, $id)
    {
        $type = $this->getType($typeName);

        $context    = $this->extension . '.item';
        $catidField = 'catid';

        if ($typeName === 'item')
        {
            $context    = 'com_djcatalog2.item';
            $catidField = 'cat_id';
        }
        elseif ($typeName === 'category')
        {
            $context    = 'com_djcatalog2.category';
            $catidField = '';
        }
        else
        {
            return null;
        }

        // Get the associations.
        $associations = JLanguageAssociations::getAssociations(
            $this->extension,
            $type['tables']['a'],
            $context,
            $id,
            'id',
            'alias',
            $catidField
        );

        return $associations;
    }

    /**
     * Get item information
     *
     * @param   string  $typeName  The item type
     * @param   int     $id        The id of item for which we need the associated items
     *
     * @return  JTable object associated with the record id passed in
     */
    public function getItem($typeName, $id)
    {
        if (empty($id))
        {
            return null;
        }

        $table = null;

        switch ($typeName)
        {
            case 'item':
                $table = JTable::getInstance('Items', 'Djcatalog2Table');
                break;

            case 'category':
                $table = JTable::getInstance('Categories', 'Djcatalog2Table');
                break;
        }

        if (empty($table))
        {
            return null;
        }

        $table->load($id);

        return $table;
    }

    /**
     * Get information about the type
     *
     * @param   string  $typeName  The item type
     *
     * @return  array  Array of item types
     */
    public function getType($typeName = '')
    {
        $fields  = $this->getFieldsTemplate();
        $tables  = array();
        $joins   = array();
        $support = $this->getSupportTemplate();
        $title   = '';

        if (in_array($typeName, $this->itemTypes))
        {
            switch ($typeName)
            {
                case 'item':
                    $fields['title'] = 'a.name';
                    $fields['ordering'] = '';
                    $fields['access'] = 'a.access';
                    $fields['state'] = 'a.published';
                    $fields['created_user_id'] = '';
                    $fields['checked_out'] = '';
                    $fields['checked_out_time'] = '';

                    $support['state'] = true;
                    $support['acl'] = true;
                    $support['category'] = true;

                    $tables = array(
                        'a' => '#__djc2_items'
                    );

                    $title = 'item';
                    break;

                case 'category':
                    $fields['created_user_id'] = 'a.created_user_id';
                    $fields['ordering'] = 'a.ordering';
                    $fields['level'] = 'a.access';
                    $fields['catid'] = '';
                    $fields['state'] = 'a.published';

                    $support['state'] = true;
                    $support['acl'] = true;
                    $support['checkout'] = true;
                    $support['level'] = true;

                    $tables = array(
                        'a' => '#__djc2_categories'
                    );

                    $title = 'category';
                    break;
            }
        }

        return array(
            'fields'  => $fields,
            'support' => $support,
            'tables'  => $tables,
            'joins'   => $joins,
            'title'   => $title
        );
    }
}
