<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
 

defined('_JEXEC') or die;

/**
 * Messages list controller class.
 *
 * @since  1.6
 */
class DJCatalog2ControllerTemplates extends JControllerAdmin
{
	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  object  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Template', $prefix = 'DJCatalog2Model', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}
	
	public function download() {
		$app = JFactory::getApplication();
		$name = $app->input->getString('fullname');
		$user = JFactory::getUser();
		if (!$user->authorise('core.manage', 'com_djcatalog2') && !$user->authorise('core.admin', 'com_djcatalog2')){
			return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}

		
		$file_path = JPATH_ROOT.'/media/djcatalog2/messages/attachments/' . $name;
		
		
		if (empty($name) || !JFile::exists($file_path)) {
			$this->setRedirect( 'index.php?option=com_djcatalog2', JText::sprintf('COM_DJCATALOG2_ERROR_FILE_MISSING', base64_decode($path)), 'error' );
			return false;
		}
		
		if (!DJCatalog2FileHelper::getFileByPath($file_path)){
			//JError::raiseError(404);
			throw new Exception('', 404);
			return false;
		}
		exit(0);
	}
}
