<?php
/**
 * @version $Id: taxrate.php 272 2014-05-21 10:25:49Z michal $
 * @package DJ-Catalog2
 * @copyright Copyright (C) 2012 DJ-Extensions.com LTD, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 * @developer Michal Olczyk - michal.olczyk@design-joomla.eu
 *
 * DJ-Catalog2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DJ-Catalog2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DJ-Catalog2. If not, see <http://www.gnu.org/licenses/>.
 *
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

class Djcatalog2ControllerSubscription extends JControllerForm {
	public function save($key = null, $urlVar = null) {
		return parent::save($key, $urlVar);
	}
	protected function allowAdd($data = array())
	{
		$user = JFactory::getUser();
		return $user->authorise('core.create', $this->option) || $user->authorise('djcatalog2.admin.orders', $this->option);
	}
	
	protected function allowEdit($data = array(), $key = 'id')
	{
		$canDo = JFactory::getUser()->authorise('core.edit', $this->option) || JFactory::getUser()->authorise('djcatalog2.admin.orders', $this->option);
		
		if (!$canDo) {
			$task = JFactory::getApplication()->input->getCmd('task');
			if ($task == 'edit' && JFactory::getUser()->authorise('djcatalog2.access.orders', $this->option)) {
				return true;
			} else if ($task == 'cancel') {
				return true;
			}
		}
		
		return $canDo;
	}
}
?>
