<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
defined('_JEXEC') or die( 'Restricted access' );
jimport('joomla.application.component.controlleradmin');


class Djcatalog2ControllerQueries extends JControllerAdmin
{
	public function getModel($name = 'Query', $prefix = 'Djcatalog2Model', $config = array())
	{
		$model = parent::getModel($name, $prefix, array('ignore_request' => true));
		return $model;
	}

	public function export($cid = array()) {

		$app = JFactory::getApplication();
		$jinput = $app->input;

		$cid = $jinput->get('cid', array(), 'array');
		$file = Djcatalog2ExportHelper::exportQuotes($cid);

		if($file['success']) {
			$file_link = '<a href="' . JRoute::_('index.php?option=com_djcatalog2&task=download_file&path=' . base64_encode('media/djcatalog2/export/quotes/' . $file['filename'])) . '">' . $file['filename'] . '</a></br>';
			$this->setRedirect('index.php?option=com_djcatalog2&view=queries', JText::_('COM_DJCATALOG2_EXPORT_SUCCESFULL') . ' ' . $file_link);
		}

	}

	public function change_status (){
		JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));
		
		// Get items to publish from the request.
		$cid = JFactory::getApplication()->input->get('cid', array(), 'array');
		$statuses = JFactory::getApplication()->input->get('status_change', array(), 'array');
		$notifications = JFactory::getApplication()->input->get('status_notify', array(), 'array');
		
		if (empty($cid) || empty($statuses))
		{
			JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
		}
		else
		{
			// Make sure the item ids are integers
			JArrayHelper::toInteger($cid);
			
			$cid = $cid[0];
			
			$value = (isset($statuses[$cid])) ? $statuses[$cid] : false;
			$notify = (isset($notifications[$cid])) ? (bool)$statuses[$cid] : false;
			
			if (!$value) {
				JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
			} else {
				// Get the model.
				$model = $this->getModel();
				
				// Publish the items.
				try
				{
					$model->set_status($cid, $value, $notify);
					
					$this->setMessage(JText::_('COM_DJCATALOG2_STATUS_CHANGED'));
				}
				catch (Exception $e)
				{
					$this->setMessage(JText::_('JLIB_DATABASE_ERROR_ANCESTOR_NODES_LOWER_STATE'), 'error');
				}
			}
		}
		$extension = JFactory::getApplication()->input->get('extension');
		$extensionURL = ($extension) ? '&extension=' . $extension : '';
		$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list . $extensionURL, false));
		
	}
	
}