<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

class Djcatalog2ControllerProducerCategory extends JControllerForm {
	
	protected function allowAdd($data = array())
	{
		$user = JFactory::getUser();
		return $user->authorise('core.create', $this->option) || $user->authorise('djcatalog2.admin.catalogue', $this->option);
	}
	
	protected function allowEdit($data = array(), $key = 'id')
	{
		$canDo = JFactory::getUser()->authorise('core.edit', $this->option) || JFactory::getUser()->authorise('djcatalog2.admin.catalogue', $this->option);
		
		if (!$canDo) {
			$task = JFactory::getApplication()->input->getCmd('task');
			if ($task == 'edit' && JFactory::getUser()->authorise('djcatalog2.access.catalogue', $this->option)) {
				return true;
			} else if ($task == 'cancel') {
				return true;
			}
		}
		
		return $canDo;
	}
}
?>
