<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.controlleradmin');


class Djcatalog2ControllerOrders extends JControllerAdmin
{
    public function getModel($name = 'Order', $prefix = 'Djcatalog2Model', $config = array())
    {
        $model = parent::getModel($name, $prefix, array('ignore_request' => true));
        return $model;
    }

    public function change_status()
    {
        JSession::checkToken() or die(JText::_('JINVALID_TOKEN'));

        // Get items to publish from the request.
        $cid = JFactory::getApplication()->input->get('cid', array(), 'array');
        $statuses = JFactory::getApplication()->input->get('status_change', array(), 'array');
        $notifications = JFactory::getApplication()->input->get('status_notify', array(), 'array');

        if (empty($cid) || empty($statuses)) {
            JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
        } else {
            // Make sure the item ids are integers
            JArrayHelper::toInteger($cid);

            $cid = $cid[0];

            $value = (isset($statuses[$cid])) ? $statuses[$cid] : false;
            $notify = (isset($notifications[$cid])) ? (bool)$statuses[$cid] : false;

            if (!$value) {
                JLog::add(JText::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
            } else {
                // Get the model.
                $model = $this->getModel();

                // Publish the items.
                try {
                    $model->set_status($cid, $value, $notify);

                    $this->setMessage(JText::_('COM_DJCATALOG2_STATUS_CHANGED'));
                } catch (Exception $e) {
                    $this->setMessage(JText::_('JLIB_DATABASE_ERROR_ANCESTOR_NODES_LOWER_STATE'), 'error');
                }
            }
        }
        $extension = JFactory::getApplication()->input->get('extension');
        $extensionURL = ($extension) ? '&extension=' . $extension : '';
        $this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&view=' . $this->view_list . $extensionURL, false));

    }

    protected function importTCPDF()
    {
        $libfile = JPATH_LIBRARIES . '/tcpdf/tcpdf.php';
        if (JFile::exists($libfile) == false) {
            return false;
        }

        require_once $libfile;
        return true;
    }

    public function invoices_selected()
    {
        if (!JSession::checkToken('post') && !JSession::checkToken('get')) jexit('Invalid Token');

        $app = JFactory::getApplication();

        // Get items to publish from the request.
        $cid = $app->input->get('cid', array(), 'array');

        if (empty($cid)) {
            JError::raiseWarning(500, JText::_($this->text_prefix . '_NO_ITEM_SELECTED'));
        } else {
            if (count($cid) == 1) {
                $db = JFactory::getDbo();
                $db->setQuery('select invoice_number from #__djc2_orders where id = ' . (int)$cid[0]);
                $filename = $db->loadResult();
                if (!empty($filename)) {
                    $filename = JFile::makeSafe(str_replace('/', '-', $filename)) . '.pdf';
                    if (JFile::exists(JPATH_ROOT .'/media/djcatalog2/export/invoices/'.$filename)) {
                        JFile::delete(JPATH_ROOT .'/media/djcatalog2/export/invoices/'.$filename);
                    }
                    $app->input->set('export_file', $filename);
                }
            }
            return $this->invoices_filtered($cid);
        }
    }

    public function proforma_selected()
    {
        if (!JSession::checkToken('post') && !JSession::checkToken('get')) jexit('Invalid Token');

        $app = JFactory::getApplication();

        // Get items to publish from the request.
        $cid = $app->input->get('cid', array(), 'array');

        if (empty($cid)) {
            JError::raiseWarning(500, JText::_($this->text_prefix . '_NO_ITEM_SELECTED'));
        } else {
            if (count($cid) == 1) {
                $db = JFactory::getDbo();
                
                $db->setQuery('select order_number, proforma_number from #__djc2_orders where id = ' . (int)$cid[0]);
                $res = $db->loadObject();
                $filename = (empty($res->proforma_number)) ? $res->order_number : $res->proforma_number;
                
                if (!empty($filename)) {
                    $filename = JFile::makeSafe(str_replace('/', '-', 'proforma-' . $filename)) . '.pdf';
                    if (JFile::exists(JPATH_ROOT .'/media/djcatalog2/export/invoices/'.$filename)) {
                        JFile::delete(JPATH_ROOT .'/media/djcatalog2/export/invoices/'.$filename);
                    }
                    $app->input->set('export_file', $filename);
                }
            }
            return $this->invoices_filtered($cid);
        }
    }

    public function invoices_filtered($cid = array())
    {
        if (!JSession::checkToken('post') && !JSession::checkToken('get')) jexit('Invalid Token');

        if (!$this->importTCPDF()) {
            $this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_TCPDF_LIB_IS_MISSING'), 'error');
            return false;
        }

        error_reporting(0);
        @ini_set('display_errors', 0);

        $app = JFactory::getApplication();
        $task = $this->getTask();

        $path = JPATH_ROOT .'/media/djcatalog2/export/invoices';
        if (!JFolder::exists($path)) {
            JFolder::create($path);
        }

        if (!is_writable($path)) {
            $this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_FOLDER_NOT_WRITABLE') . ' ' . $path, 'error');
            return false;
        }

        $layout = ($task == 'proforma_selected') ? 'proforma' : 'invoice';

        $model = $this->getModel('Orders');

        // removed due to FPDI issues
        //$start = $app->input->getInt('start', 0);
        $start = 0;
        //$limit = 10
        $limit = 0;

        $model->setState('list.limit', $limit);
        $model->setState('list.start', $start);
        if ($layout != 'proforma') {
            $model->setState('filter.invoice', true);
        }

        $date_from = $model->getUserStateFromRequest('com_djcatalog2.orders.filter.date_from', 'filter_date_from');
        $model->setState('filter.date_from', $date_from);

        $date_to = $model->getUserStateFromRequest('com_djcatalog2.orders.filter.date_to', 'filter_date_to');
        $model->setState('filter.date_to', $date_to);

        if (($task == 'invoices_selected' || $task == 'proforma_selected') && count($cid) > 0) {
            $limit = $start = 0;
            JArrayHelper::toInteger($cid);

            $model->setState('list.limit', 0);
            $model->setState('list.start', 0);

            $model->setState('filter.ids', implode(',', $cid));
        }

        $items = $model->getItems();

        if (empty($items)) {
            $this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_LIST_IS_EMPTY') . ' ' . $path, 'error');
            return false;
        }

        $filename = $app->input->get('export_file', 'invoice-export-' . date("Y-m-d_H-i-s") . '.pdf', 'raw');

        //$pdf = new DJCatalog2InvoiceFPDI('P', 'mm', 'A4', true, 'UTF-8', false);

        $pdf = new TCPDF();

        $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->setFontSubsetting(true);

        $pdf->SetFont('freesans', '', 9, '', true);
        $pdf->SetPrintHeader(false);
        $pdf->SetPrintFooter(true);
        $pdf->SetFooterMargin('15px');

        // removed due to FPDI issues
        /*
        $pageCount = 0;
        if (JFile::exists($path .'/'. $filename)) {
            $pageCount = $pdf->setSourceFile($path .'/'. $filename);
            if ($pageCount > 0) {
                for ($i = 1; $i <= $pageCount; $i++) {
                    //$pdf->importPage($i);
                    $pdf->AddPage();
                    $tplIdx = $pdf->importPage($i);
                    $pdf->useTemplate($tplIdx);
                    $pdf->endPage();
                }
            }
        }*/

        $db = JFactory::getDbo();

        foreach ($items as $id => $item) {

            $db->setQuery('select * from #__djc2_order_items where order_id=' . $item->id);
            $items[$id]->items = $db->loadObjectList();

            $pdf->AddPage();
            $pdf->_intCurPage = 1;
            $pdf->_intFootNo = $item->invoice_number;
            $html = DJCatalog2HtmlHelper::getThemeLayout($item, $layout, 'pdf');
            $pdf->writeHTML($html, true, false, true, false, '');

        }

        $pdf->Output($path .'/'. $filename, 'F');

        // removed due to FPDI issues
        /*
		$pagination = $model->getPagination();
        if ($pagination->get('pages.total') > $pagination->get('pages.current')) {
            header("refresh: 0; url=" . JURI::base() . 'index.php?option=com_djcatalog2&task=orders.invoices_filtered&start=' . ($start + $limit) . '&export_file=' . $filename . '&' . JSession::getFormToken() . '=1');
            echo '<p>' . $pagination->get('pages.current') . ' / ' . $pagination->get('pages.total') . '</p>';
        } else {
            $file_link = '<a href="' . JRoute::_('index.php?option=com_djcatalog2&task=download_file&path=' . base64_encode('media/djcatalog2/export/invoices/' . $filename)) . '">' . $filename . '</a>';
            $this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_EXPORT_SUCCESFULL') . ' ' . $file_link);
        }*/

        $file_link = '<a href="' . JRoute::_('index.php?option=com_djcatalog2&task=download_file&path=' . base64_encode('media/djcatalog2/export/invoices/' . $filename)) . '">' . $filename . '</a>';
        $this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_EXPORT_SUCCESFULL') . ' ' . $file_link);
        
        return true;
    }

    public function save_counters()
    {
        if (!JSession::checkToken('post') && !JSession::checkToken('get')) jexit('Invalid Token');

        $app = JFactory::getApplication();
        $input = $app->input;

        $counters = $input->get('djc_counters', array(), 'array');

        $total = count($counters);
        if (!$total) {
            $this->setRedirect('index.php?option=com_djcatalog2&view=orders&layout=invcounters&tmpl=component', JText::_('COM_DJCATALOG2_COUNTERS_NOTHING_TO_UPDATE'), 'warning');
            return false;
        }

        require_once JPATH_ROOT . '/components/com_djcatalog2/helpers/invoice.php';
        $done = 0;
        foreach ($counters as $doctype => $years) {
        	foreach ($years as $year => $value) {
        		if (is_numeric($value) && (int)$value >= 0) {
        			DJCatalog2HelperInvoice::updateYear((int)$value, $year, $doctype);
        			$done++;
        		} else {
        			$app->enqueueMessage(JText::sprintf('COM_DJCATALOG2_COUNTERS_INVALID_FOR_YEAR', $year.'/'.$doctype), 'warning');
        		}
        	}
        }

        $this->setRedirect('index.php?option=com_djcatalog2&view=orders&layout=invcounters&tmpl=component', JText::_('COM_DJCATALOG2_COUNTERS_UPDATED'));
        return true;
    }

    public function waybills_selected()
    {
        if (!JSession::checkToken('post') && !JSession::checkToken('get')) jexit('Invalid Token');

        $app = JFactory::getApplication();

        // Get items to publish from the request.
        $cid = $app->input->get('cid', array(), 'array');
        
        if (empty($cid)) {
            JError::raiseWarning(500, JText::_($this->text_prefix . '_NO_ITEM_SELECTED'));
        } else {
            if (count($cid) == 1) {
                $db = JFactory::getDbo();
                $db->setQuery('select invoice_number from #__djc2_orders where id = ' . (int)$cid[0]);
                $filename = 'wz_' . $db->loadResult();
                if (!empty($filename)) {
                    $filename = JFile::makeSafe(str_replace('/', '-', $filename));
                    if (JFile::exists(JPATH_ROOT .'/media/djcatalog2/export/waybills/'.$filename . '.pdf')) {
                        JFile::delete(JPATH_ROOT .'/media/djcatalog2/export/waybills/'.$filename . '.pdf');
                    }
                    $app->input->set('export_file', $filename);
                }
            }
            return $this->waybills_filtered($cid);
        }
    }

    public function waybills_filtered($cid = array())
    {
        if (!JSession::checkToken('post') && !JSession::checkToken('get')) jexit('Invalid Token');

        if (!$this->importTCPDF()) {
            $this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_TCPDF_LIB_IS_MISSING'), 'error');
            return false;
        }

        error_reporting(0);
        @ini_set('display_errors', 0);

        $app = JFactory::getApplication();
        $task = $this->getTask();

        $path = JPATH_ROOT .'/media/djcatalog2/export/waybills';
        if (!JFolder::exists($path)) {
            JFolder::create($path);
        }

        if (!is_writable($path)) {
            $this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_FOLDER_NOT_WRITABLE') . ' ' . $path, 'error');
            return false;
        }

        $layout = 'waybill';

        $model = $this->getModel('Orders');

        $start = $app->input->getInt('start', 0);
        $limit = 10;

        $model->setState('list.limit', $limit);
        $model->setState('list.start', $start);
        //if ($layout != 'proforma') {
        $model->setState('filter.invoice', true);
        //}

        $date_from = $model->getUserStateFromRequest('com_djcatalog2.orders.filter.date_from', 'filter_date_from');
        $model->setState('filter.date_from', $date_from);

        $date_to = $model->getUserStateFromRequest('com_djcatalog2.orders.filter.date_to', 'filter_date_to');
        $model->setState('filter.date_to', $date_to);

        if ($task == 'waybills_selected' || count($cid) > 0) {
            $limit = $start = 0;
            JArrayHelper::toInteger($cid);

            $model->setState('list.limit', 0);
            $model->setState('list.start', 0);

            $model->setState('filter.ids', implode(',', $cid));
        }

        $orders = $model->getOrdersWithShippingDays();

        if (empty($orders)) {
            $this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_LIST_IS_EMPTY') . ' ' . $path, 'error');
            return false;
        }

        $file_link = '';


        foreach ($orders as $order) {
            $waybill_index = 1;
            
            foreach ($order->order_items as $shipping_day) {
                $pdf = new TCPDF();

                $pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
                $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
                $pdf->setFontSubsetting(true);

                $pdf->SetFont('freesans', '', 9, '', true);
                $pdf->SetPrintHeader(false);
                $pdf->SetPrintFooter(true);
                $pdf->SetFooterMargin('15px');
                
                $filename = $app->input->get('export_file', 'waybill-export-'.date("Y-m-d_H-i-s").'.pdf', 'raw');
                $filename .= '-' . (int)$waybill_index . '.pdf';

                if (JFile::exists($path .'/'. $filename)) {
                	JFile::delete($path .'/'. $filename);
                }
                
                /*
                $pageCount = 0;
                if (JFile::exists($path .'/'. $filename)) {

                    $pageCount = $pdf->setSourceFile( realpath($path .'/'. $filename));
                    if ($pageCount > 0) {
                        for ($i = 1; $i <= $pageCount; $i++) {
                            //$pdf->importPage($i);
                            $pdf->AddPage();
                            $tplIdx = $pdf->importPage($i);
                            $pdf->useTemplate($tplIdx);
                            $pdf->endPage();
                        }
                    }
                }*/


                $waybill_data = new stdClass();
                $waybill_data->order_number = $order->order_number;
                $waybill_data->delivery_date = $order->delivery_date;
                $waybill_data->companyname = $order->companyname;
                $waybill_data->firstname = $order->firstname;
                $waybill_data->lastname = $order->lastname;
                $waybill_data->postcode = $order->postcode;
                $waybill_data->city = $order->city;
                $waybill_data->address = $order->address;
                $waybill_data->country = $order->country;
                $waybill_data->phone = $order->phone;
                $waybill_data->order_items = $shipping_day;
                $waybill_data->waybill_index = $waybill_index;

                $pdf->AddPage();
                $pdf->_intCurPage = 1;
                $pdf->_intFootNo = $order->invoice_number;
                $html = DJCatalog2HtmlHelper::getThemeLayout($waybill_data, $layout, 'pdf');
                $pdf->writeHTML($html, true, false, true, false, '');

                $pdf->Output($path .'/'. $filename, 'F');
                $file_link .= '<a href="' . JRoute::_('index.php?option=com_djcatalog2&task=download_file&path=' . base64_encode('media/djcatalog2/export/waybills/' . $filename)) . '">' . $filename . '</a></br>';

                $waybill_index++;
            }
        }
        $this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_EXPORT_SUCCESFULL') . ' ' . $file_link);

        return true;

    }

	public function export($cid = array()) {
    	$app = JFactory::getApplication();
    	$jinput = $app->input;

    	$cid = $jinput->get('cid', array(), 'array');
    	$file = Djcatalog2ExportHelper::exportOrders($cid);

    	if($file['success']) {
			$file_link = '<a href="' . JRoute::_('index.php?option=com_djcatalog2&task=download_file&path=' . base64_encode('media/djcatalog2/export/order/' . $file['filename'])) . '">' . $file['filename'] . '</a></br>';
			$this->setRedirect('index.php?option=com_djcatalog2&view=orders', JText::_('COM_DJCATALOG2_EXPORT_SUCCESFULL') . ' ' . $file_link);
		}

	}

	public function downloadExportedOrders() {

	}
}