<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

class Djcatalog2ControllerOrder extends JControllerForm {
	public function save($key = null, $urlVar = null) {
		return parent::save($key, $urlVar);
	}
	protected function allowAdd($data = array())
	{
		$user = JFactory::getUser();
		return $user->authorise('core.create', $this->option) || $user->authorise('djcatalog2.admin.orders', $this->option);
	}
	
	protected function allowEdit($data = array(), $key = 'id')
	{
		$canDo = JFactory::getUser()->authorise('core.edit', $this->option) || JFactory::getUser()->authorise('djcatalog2.admin.orders', $this->option);
		
		if (!$canDo) {
			$task = JFactory::getApplication()->input->getCmd('task');
			if ($task == 'edit' && JFactory::getUser()->authorise('djcatalog2.access.orders', $this->option)) {
				return true;
			} else if ($task == 'cancel') {
				return true;
			}
		}
		
		return $canDo;
	}

	public function createShipment() {

		$app = JFactory::getApplication();
		$jinput = $app->input;


		$model = $this->getModel();

		$order_id = $jinput->getInt('id');
		$delivery_method_id = $jinput->getInt('delivery_method_id');


		$order = $model->getItem($order_id);
		$deliveryData = $jinput->get('createShipments', array(), 'array');
		$deliveryMethod = $model->getDeliveryMethod($delivery_method_id);


		JPluginHelper::importPlugin('djcatalog2delivery');
		$dispatcher = JEventDispatcher::getInstance();

		$dispatcher->trigger('onDJC2ProcessCreateShipments', array('com_djcatalog2.order.delivery', $order, $deliveryData, $deliveryMethod));
	}

	public function displayDeliveryForm() {
		$app = JFactory::getApplication();
		$jinput = $app->input;

		$model = $this->getModel();

		$order_id = $jinput->getInt('id');
		$delivery_method_id = $jinput->getInt('delivery_method_id');

		$order = $model->getItem($order_id);
		$deliveryMethod = $model->getDeliveryMethod($delivery_method_id);

		JPluginHelper::importPlugin('djcatalog2delivery');
		$dispatcher = JEventDispatcher::getInstance();

	 	$deliveryForm = $dispatcher->trigger('renderShippmentForm', array('com_djcatalog2.order.delivery', $order, $deliveryMethod));
		echo implode("", $deliveryForm);
	}

	public function downloadDeliveryLabel() {
		$app = JFactory::getApplication();
		$jinput = $app->input;

		$model = $this->getModel();
		$order_id = $jinput->getInt('oid');
		$order = $model->getItem($order_id);
		$deliveryMethod = $model->getDeliveryMethod($order->delivery_method_id);

		JPluginHelper::importPlugin('djcatalog2delivery');
		$dispatcher = JEventDispatcher::getInstance();

		$dispatcher->trigger('onDJC2DownloadDeliveryLabel', array('com_djcatalog2.order.delivery', $order, $deliveryMethod));
	}
}
?>
