<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */
 

defined('_JEXEC') or die;

/**
 * Messages list controller class.
 *
 * @since  1.6
 */
class DJCatalog2ControllerMessages extends JControllerAdmin
{
	protected $text_prefix = 'COM_DJCATALOG2_MSG';
	
	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  object  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Message', $prefix = 'DJCatalog2Model', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

    public function export_filtered(){
        $jinput = JFactory::getApplication()->input;

        JSession::getFormToken('default') or jexit( 'COM_DJCATALOG2_INVALID_TOKEN' );


        $cid_model = JModelLegacy::getInstance('Messages', 'DJCatalog2Model', array('ignore_request'=>true));

        $state = $cid_model->getState();

        $search = $cid_model->getUserStateFromRequest('com_djcatalog2.filter.search', 'filter_search');
        $cid_model->setState('filter.search', $search);

        $date_from = $cid_model->getUserStateFromRequest('com_djcatalog2.filter.date_from', 'filter_date_from');
        $cid_model->setState('filter.date_from', $date_from);

        $date_to = $cid_model->getUserStateFromRequest('com_djcatalog2.filter.date_to', 'filter_date_to');
        $cid_model->setState('filter.date_to', $date_to);

        $is_opened = $cid_model->getUserStateFromRequest('com_djcatalog2.filter.is_opened', 'filter_is_opened');
        $cid_model->setState('filter.is_opened', $is_opened);


        $items = $cid_model->getItems();

        $document = JFactory::getDocument();
        $ctype = 'text/csv';

        $document->setMimeEncoding($ctype);

        if(ini_get('zlib.output_compression')){
            ini_set('zlib.output_compression', 'Off');
        }

        $fname = 'messagess-export-'.date("Y-m-d_H-i-s").'.csv';

        header("Pragma: public"); // required
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Cache-Control: private",false); // required for certain browsers
        header("Content-Type: ".$ctype);
        header("Content-Disposition: filename=\"".$fname."\";" );
        header("Content-Disposition: attachment; filename=\"".$fname."\";" );
        header("Content-Transfer-Encoding: binary");

        $fp = fopen('php://output', 'w');
        $output = $cid_model->renderCSV($items, $fp);
        fclose($fp);
        if (!$output) {
            $this->setRedirect( 'index.php?option=com_djcatalog2&view=bookedtickets' );
            return;
        }

        //echo $output;
        exit(0);
    }
}
