<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controller');
jimport( 'joomla.database.table' );


class DJCatalog2ControllerLicense extends JControllerLegacy {
	
	public function save(){
		$app	= JFactory::getApplication();
		$config = JFactory::getConfig();
		$db 	= JFactory::getDbo();
		
		$ext = $app->input->getString('option', '');
		$license = $app->input->getString('license');
		$r = $app->input->getString('release', '0');
		$name = $app->input->getCmd('extension', '');
		
		$license = preg_replace("/[^a-zA-Z0-9:]+/", '', $license);
		
		$secret_file = JFile::makeSafe('license_'.$config->get('secret').'.txt');
		$license_file = JPath::clean(dirname(__FILE__).'/../'.$secret_file);
		
		$query = "SELECT manifest_cache FROM #__extensions WHERE element ='pkg_dj-".strtolower($name)."' AND type='package' ";
		$db->setQuery($query);
		$mc = json_decode($db->loadResult());
		$version = $mc->version;
		
		$extra_query = 'dlid='.$license.'&v='.$version.'&site='.JUri::root();
		$query = "UPDATE #__update_sites SET extra_query='".addslashes($extra_query)."' WHERE name='DJ-".$name."' AND type='extension' ";
		$db->setQuery($query);
		$db->execute();
		
		if ($license == '') {
			JFile::delete($license_file);
		} else {
			JFile::write($license_file, $license);
		}
		
		$msg = ($license == '') ? 'DJUPDATER_KEY_REMOVED' : 'DJUPDATER_KEY_STORED';
		
		echo self::renderAlert(JText::_($msg), 'success');
		$app->close();
	}
	
	public static function renderAlert($msg, $type = '', $title = '') {
		
		if(!in_array($type, array('success', 'error', 'info', ''))) $type = 'info';
		
		$html = 	'<div class="alert alert-'.$type.'">'
			.		(!empty($title) ? '<h3>'.$title.'</h3>' : '')
			.		'<div class="alert-body">'.$msg.'</div>'
				.	'</div>';
				
				return $html;
				
	}
}
