<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

class Djcatalog2ControllerItem extends JControllerForm {
	function __construct($config = array())
	{
		$this->view_list = 'items';
		$this->view_item = 'item';
		parent::__construct($config);
		
	}
	
	protected function allowAdd($data = array())
	{
		$user = JFactory::getUser();
		return $user->authorise('core.create', $this->option) || $user->authorise('djcatalog2.admin.catalogue', $this->option);
	}
	
	protected function allowEdit($data = array(), $key = 'id')
	{
		$canDo = JFactory::getUser()->authorise('core.edit', $this->option) || JFactory::getUser()->authorise('djcatalog2.admin.catalogue', $this->option);
		
		if (!$canDo) {
			$task = JFactory::getApplication()->input->getCmd('task');
			if ($task == 'edit' && JFactory::getUser()->authorise('djcatalog2.access.catalogue', $this->option)) {
				return true;
			} else if ($task == 'cancel') {
				return true;
			}
		}
		
		return $canDo;
	}
	
	public function batch($model = null)
	{
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		
		$model = $this->getModel('Item', '', array());
		
		$this->setRedirect(JRoute::_('index.php?option=com_djcatalog2&view=items' . $this->getRedirectToListAppend(), false));
		return parent::batch($model);
	}
}
?>
