<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

class Djcatalog2ControllerCustomer extends JControllerForm {
	
	public function __construct($config = array())
	{
		parent::__construct($config);
		
		$this->registerTask('edit_vendor', 'edit');
	}
	public function save($key = null, $urlVar = null) {
		return parent::save($key, $urlVar);
	}
	public function edit($key = null, $urlVar = null)
	{
		$app = JFactory::getApplication();
		$cid   = $app->input->get('cid', array(), 'array');
		$recordId = count($cid) ? $cid[0] : 0;
		
		$parts  = explode(',', $recordId);
		if (count($parts) == 2) {
			$cid = $parts[1];
			$user_id = $parts[0];
			$app->input->set('user_id', $user_id);
			$app->input->set('cid', array($cid));
			$app->input->post->set('cid', array($cid));
			$app->input->set('cid', array($cid));
			@JRequest::setVar('cid', array($cid), 'post');
			@JRequest::setVar('user_id', $user_id, 'post');
			
			if (!$cid) {
				return $this->add();
			}
		}
		
		return parent::edit($key, $urlVar);
	}
	public function edituser($key = null, $urlVar = null)
	{
		$app = JFactory::getApplication();
		$cid   = $app->input->post->get('cid', array(), 'array');
		$recordId = count($cid) ? $cid[0] : 0;
		
		$parts  = explode(':', $recordId);
		if (count($parts) == 2) {
			$recordId = $parts[0];
		}
		
		$this->setRedirect('index.php?option=com_users&task=user.edit&id='.$recordId);
		return true;
		
	}
	
	protected function getRedirectToItemAppend($recordId = null, $urlVar = 'id')
	{
		$append = '';
		
		// Setup redirect info.
		if ($tmpl = $this->input->get('tmpl', '', 'string'))
		{
			$append .= '&tmpl=' . $tmpl;
		}

		if ($this->input->getCmd('task') == 'assign_vendor') {
			$append .= '&layout=edit_vendor';
		}
		else if ($layout = $this->input->get('layout', 'edit', 'string'))
		{
			$append .= '&layout=' . $layout;
		}
		
		if ($forcedLanguage = $this->input->get('forcedLanguage', '', 'cmd'))
		{
			$append .= '&forcedLanguage=' . $forcedLanguage;
		}
		
		if ($recordId)
		{
			$append .= '&' . $urlVar . '=' . $recordId;
		}
		
		$return = $this->input->get('return', null, 'base64');
		
		if ($return)
		{
			$append .= '&return=' . $return;
		}
		
		if ($user_id = $this->input->get('user_id')) {
			$append .= '&user_id='.(int)$user_id;
		}
		
		return $append;
	}
	
	protected function allowAdd($data = array())
	{
		$user = JFactory::getUser();
		return $user->authorise('core.create', $this->option) || $user->authorise('djcatalog2.admin.customers', $this->option);
	}
	
	protected function allowEdit($data = array(), $key = 'id')
	{
		$canDo = JFactory::getUser()->authorise('core.edit', $this->option) || JFactory::getUser()->authorise('djcatalog2.admin.customers', $this->option);
		
		if (!$canDo) {
			$task = JFactory::getApplication()->input->getCmd('task');
			if ($task == 'edit' && JFactory::getUser()->authorise('djcatalog2.access.customers', $this->option)) {
				return true;
			} else if ($task == 'cancel') {
				return true;
			}
		}
		
		return $canDo;
	}
}
?>
