<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

jimport('joomla.application.component.controllerform');

class Djcatalog2ControllerCombination extends JControllerForm {
	
	protected function allowAdd($data = array())
	{
		$user = JFactory::getUser();
		return $user->authorise('core.create', $this->option) || $user->authorise('djcatalog2.admin.catalogue', $this->option);
	}
	
	protected function allowEdit($data = array(), $key = 'id')
	{
		$canDo = JFactory::getUser()->authorise('core.edit', $this->option) || JFactory::getUser()->authorise('djcatalog2.admin.catalogue', $this->option);
		
		if (!$canDo) {
			$task = JFactory::getApplication()->input->getCmd('task');
			if ($task == 'edit' && JFactory::getUser()->authorise('djcatalog2.access.catalogue', $this->option)) {
				return true;
			} else if ($task == 'cancel') {
				return true;
			}
		}
		
		return $canDo;
	}
	
	public function save($key = null, $urlVar = null) {
		return parent::save($key, $urlVar);
	}
	
	public function saveImages() {
		$app   = JFactory::getApplication();
		$model = $this->getModel();
		$table = $model->getTable();
		$data  = $this->input->post->get('jform', array(), 'array');
		$checkin = false;
		$context = "$this->option.edit.$this->context";
		$params = JComponentHelper::getParams('com_djcatalog2');
		
		$recordId = $this->input->getInt('id');

		if (!$recordId) {
			throw new Exception(JText::_('JLIB_APPLICATION_ERROR_SAVE_NOT_PERMITTED'), 403);
		}
		
		if (JFactory::getUser()->authorise('core.edit', $this->option) == false) {
			throw new Exception(JText::_('JLIB_APPLICATION_ERROR_SAVE_NOT_PERMITTED'), 403);
		}
		
		if ($table->load($recordId)) {
			$table->alias = $table->id.'-'.$table->sku.'-combination';
			if (!DJCatalog2ImageHelper::saveImages('combination', $table, $params, false)) {
				$app->enqueueMessage(JText::_('COM_DJCATALOG2_ERROR_SAVING_IMAGES'),'error');
			}
		} else {
			throw new Exception($table->getError(), 403);
		}
		
		$this->setRedirect(JRoute::_('index.php?option=com_djcatalog2&view=combination&layout=images&tmpl=component&id='.$recordId, false), JText::_('JLIB_APPLICATION_SAVE_SUCCESS'));
		return true;
	}
}
?>
