<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 *
 */

defined('_JEXEC') or die( 'Restricted access' );

jimport( 'joomla.application.component.controller' );

class DJCatalog2ControllerBatch extends JControllerLegacy
{
    function __construct($config = array())
    {
        parent::__construct($config);
    }

    public function preprocess() {
        $app = JFactory::getApplication();

        $view = $app->input->get('view');

        $app->setUserState('com_djcatalog2.list.' . $view, $app->input->get('cid'));
        $app->setUserState('com_djcatalog2.batch.' . $view, $app->input->get('batch', array(), 'array'));


        $app->redirect('index.php?option=com_djcatalog2&view=batch&type=' . $view);
    }

    public function categories() {
        $app = JFactory::getApplication();

        $id = $app->input->get('id');
        $batch = $app->input->get('batch', array(), 'array');
        $cursor = $app->input->getInt('cursor', 0);

        $model = $this->getModel('Category');
        echo json_encode($model->batch($id, $batch, $cursor));

        $app->close();
    }

    public function items() {
        $app = JFactory::getApplication();

        $id = $app->input->get('id');
        $batch = $app->input->get('batch', array(), 'array');
        $cursor = $app->input->getInt('cursor', 0);

        $model = $this->getModel('Item');
        echo json_encode($model->batch($id, $batch, $cursor));

        $app->close();
    }


    public function fields() {
        $app = JFactory::getApplication();

        $id = $app->input->get('id');
        $batch = $app->input->get('batch', array(), 'array');
        $cursor = $app->input->getInt('cursor', 0);

        $model = $this->getModel('Field');
        echo json_encode($model->batch($id, $batch, $cursor));

        $app->close();
    }

    function display($cachable = true, $urlparams = null) {
        $app = JFactory::getApplication();


        $app->input->set( 'layout', 'default'  );
        $app->input->set( 'view'  , 'cpanel');
        $app->input->set( 'edit', false );

        parent::display($cachable, $urlparams);
    }
}
