<?php
/**
 * @package DJ-Catalog2
 * @copyright Copyright (C) DJ-Extensions.com, All rights reserved.
 * @license http://www.gnu.org/licenses GNU/GPL
 * @author url: http://dj-extensions.com
 * @author email contact@dj-extensions.com
 */

defined('_JEXEC') or die;

class Djcatalog2Controller extends JControllerLegacy
{
	protected $default_view = 'cpanel';
	
	function testmsg() {
		$msg = new DJCatalog2HelperMessenger();
		$msg->notify('test@example.com', ['type'=>'order' ,'skip_db' => true], [], ['order_number' => 'x']);
		echo '<pre>' . print_r($msg, true) . '</pre>';
		die();
	}
	
	public function display($cachable = false, $urlparams = false)
	{
		require_once JPATH_COMPONENT.'/helpers/djcatalog2.php';
		Djcatalog2AdminHelper::addSubmenu(JFactory::getApplication()->input->getCmd('view', 'cpanel'));
		parent::display($cachable, $urlparams);
	}
	public function download_file() {
		$app = JFactory::getApplication();
		$user = JFactory::getUser();
		if (!$user->authorise('core.manage', 'com_djcatalog2') && !$user->authorise('core.admin', 'com_djcatalog2')){
			return JError::raiseWarning(404, JText::_('JERROR_ALERTNOAUTHOR'));
		}
		$path = $app->input->get('path', null, 'base64');
		$file_path = JPATH_ROOT.DIRECTORY_SEPARATOR.str_replace('/', DIRECTORY_SEPARATOR, base64_decode($path));
		
		if (empty($path) || !JFile::exists($file_path) || strpos($file_path, 'media') === false || strpos($file_path, 'djcatalog2') === false) {
			$this->setRedirect( 'index.php?option=com_djcatalog2', JText::sprintf('COM_DJCATALOG2_ERROR_FILE_MISSING', base64_decode($path)), 'error' );
			return false;
		}
		
		if (!DJCatalog2FileHelper::getFileByPath($file_path)){
			//JError::raiseError(404);
			throw new Exception('', 404);
			return false;
		}
		$app->close();
		return true;
	}
	
	public function multiupload() {
	
		// todo: secure upload from injections
		$user = JFactory::getUser();
		if (!$user->authorise('core.manage', 'com_djcatalog2')){
			echo JText::_('JLIB_APPLICATION_ERROR_ACCESS_FORBIDDEN');
			exit(0);
		}
	
		DJCatalog2UploadHelper::upload();
	
		return true;
	}
	
	public function getStatesByCountry() {
		$app = JFactory::getApplication();
		$country = $app->input->getInt('country');
	
		$results = array();
	
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('cs.*')->from('#__djc2_countries_states AS cs')->order('cs.name asc');
	
		if ($country > 0) {
			$query->where('cs.country_id='.(int)$country);
		} else {
			$query->join('inner', '#__djc2_countries AS c ON c.id=cs.country_id AND c.is_default=1');
		}
	
		$db->setQuery($query);
		$results = $db->loadObjectList();
	
		echo json_encode($results);
		$app->close();
	}
	
	public function findItemByName()
	{
		// Required objects
		$app = JFactory::getApplication();
		
		$like = $app->input->getString('like', '');
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('id as value, concat(name, " [", id, "]") as text')
		->from('#__djc2_items')
		->where('name like '.$db->quote('%'.$db->escape($like).'%'))
		->order('name asc');
		
		$db->setQuery($query);
		
		if ($results = $db->loadObjectList())
		{
			// Output a JSON object
			echo json_encode($results);
		}
		
		$app->close();
	}
	
	public function toggleMode() {
		if (!JFactory::getUser()->authorise('core.admin', 'com_djcatalog2')){
			throw new Exception(JText::_('JLIB_APPLICATION_ERROR_ACCESS_FORBIDDEN'), 403);
		}
		$app = JFactory::getApplication();
		$mode = $app->input->getCmd('mode');
		$validModes = array('default', 'catalog');
		if (!in_array($mode, $validModes)) {
			$this->setRedirect(JRoute::_('index.php?option=com_djcatalog2'), 'Mode "'.$mode.'" is invalid', 'error');
			return false;
		}
		
		$presetsPath = JPath::clean(JPATH_ROOT.'/administrator/components/com_djcatalog2/assets/presets');
		
		if (!JFolder::exists($presetsPath) || !JFolder::exists($presetsPath.'/'.$mode)) {
			$this->setRedirect(JRoute::_('index.php?option=com_djcatalog2'), 'Mode "'.$mode.'" doesn\'t exist', 'error');
			return false;
		}
		
		$log = array();
		
		$adminFiles = JFolder::files($presetsPath.'/'.$mode.'/admin');
		$adminFolders = JFolder::folders($presetsPath.'/'.$mode.'/admin');
		
		if (is_array($adminFolders) && count($adminFolders)) {
			foreach($adminFolders as $folder) {
				$target =  JPATH_COMPONENT_ADMINISTRATOR.'/'.$folder;
				if (JFolder::copy($presetsPath.'/'.$mode.'/admin/'.$folder, $target, '', true)) {
					$log[] = $target.' installed successfully';
				} else {
					$log[] = $target.' copy failed';
				}
			}
		}
		if (is_array($adminFiles) && count($adminFiles)) {
			foreach($adminFiles as $file) {
				$target =  JPATH_COMPONENT_ADMINISTRATOR.'/'.$file;
				if (JFile::copy($presetsPath.'/'.$mode.'/admin/'.$file, $target, '', true)) {
					$log[] = $target.' installed successfully';
				} else {
					$log[] = $target.' copy failed';
				}
			}
		}
		
		$siteFiles = JFolder::files($presetsPath.'/'.$mode.'/site');
		$siteFolders = JFolder::folders($presetsPath.'/'.$mode.'/site');
		
		if (is_array($siteFolders) && count($siteFolders)) {
			foreach($siteFolders as $folder) {
				$target =  JPATH_COMPONENT_SITE.'/'.$folder;
				if (JFolder::copy($presetsPath.'/'.$mode.'/site/'.$folder, $target, '', true)) {
					$log[] = $target.' installed successfully';
				} else {
					$log[] = $target.' copy failed';
				}
			}
		}
		if (is_array($siteFiles) && count($siteFiles)) {
			foreach($siteFiles as $file) {
				$target =  JPATH_COMPONENT_SITE.'/'.$file;
				if (JFile::copy($presetsPath.'/'.$mode.'/site/'.$file, $target, '', true)) {
					$log[] = $target.' installed successfully';
				} else {
					$log[] = $target.' copy failed';
				}
			}
		}
		
		$app->enqueueMessage(implode('<br />', $log).'<br /><br />', 'notice');
		
		$this->setRedirect(JRoute::_('index.php?option=com_djcatalog2'), 'DJ-Catalog2 switched to "'.$mode.'" mode<br />PLEASE REMEMBER TO CHECK CONFIGURATION', 'notice');
		return true;
	}
	
	public function fileBrowser(){
	
		$app = JFactory::getApplication();
		$cParams = JComponentHelper::getParams('com_djcatalog2');
		$source = $app->input->getCmd('source', 'image');
	
		// todo: secure upload from injections
		$user = JFactory::getUser();
		if (!$user->authorise('core.create', 'com_djcatalog2')){
			echo JText::_('JLIB_APPLICATION_ERROR_ACCESS_FORBIDDEN');
			exit(0);
		}
	
		$folder = urldecode($app->input->get('folder','','string'));
		$roots = array_map('trim', explode("\n",$cParams->get('fb_paths','images')));
	
		$allow = false;
		foreach($roots as $root) {
			if(strpos($folder, $root) === 0) $allow = true;
		}
		if(!$allow) $folder = $roots[0];
	
		// Set folder path
		$path = JPath::clean(JPATH_ROOT . '/' . $folder);
	
		// Get a list of folders in the search path with the given filter.
		$folders = JFolder::folders($path);
		$files = JFolder::files($path);
	
		$html = array();
	
		$html[] = '<p>';
		if(count($roots) > 1) foreach($roots as $root) {
			$html[] = '<a href="#" class="btn btn-small btn-info" data-folder="'.$root.'">'.$root.'</a>';
		}
		$html[] = '</p>';
	
		$html[] = '<p class="muted">'.$folder.'</p>';
	
		// Build the options list from the list of folders.
		$html[] = '<ul class="inline folders">';
		if(!in_array($folder, $roots)) {
			$html[] = '<li><a href="#" data-folder="'.dirname($folder).'"><i class="icon-undo"></i> [ .. ]</a></li>';
		}
		if (is_array($folders))
		{
			foreach ($folders as $fldr)
			{
				$html[] = '<li><a href="#" data-folder="'.$folder.'/'.$fldr.'"><i class="icon-folder"></i> '.$fldr.'</a></li>';
			}
		}
		$html[] = '</ul>';
	
		$html[] = '<ul class="items">';
		if (is_array($files))
		{
			foreach ($files as $file)
			{
				$path = $folder.'/'.$file;
				
				if ($source == 'image') {
					if(!preg_match('/.+\.(jpg|jpeg|gif|png)$/i', $file) || preg_match('/(_f|_l|_m|_s|_t)\.jpg$/', $file)) continue;
					
					$size = @getimagesize(JPath::clean(JPATH_ROOT.'/'.$path));
					//$thumb = DJCatalog2ImageHelper::getProcessedImage($path, 200, 150, true); // ta funkcja nie zwraca miniatury - do sprawdzenia dlaczego
					//if($size[0] < 200 || $size[1] < 150 || !$thumb) {
						$thumb = $path;
					//}
					
					$html[] = '<li><a class="additem" href="#" data-path="'.$path.'"><span class="valignhelper"></span><img src="'.JURI::root(true).'/'.$thumb.'" /><span class="icon-plus"></span><span class="icon-minus"></span></a><span class="name">'.$file.'</span></li>';
					
				} else if ($source == 'video') {
					if(!preg_match('/.+\.(avi|mp4|mpeg)$/i', $file)) continue;
					$html[] = '<li><a class="additem" href="#" data-path="'.$path.'"><span class="valignhelper"></span><code>'.$file.'</code><span class="icon-plus"></span><span class="icon-minus"></span></a><span class="name">'.$file.'</span></li>';
				}
			}
		}
	
		$html[] = '</ul><div style="clear:both"></div>';
	
		echo implode("\n", $html);
	
		$app->close();
	}


	/**
	 * Method to search Joomla content articles
	 *
	 * @return  void
	 */
	public function searchArticleAjax()
	{
		// Required objects
		$app = JFactory::getApplication();

		$like = trim($app->input->get('like', null, 'string'));

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query->select(array($db->quoteName('a.id', 'value'), $db->quoteName('a.title', 'text')))
			->from($db->quoteName('#__content', 'a'))
			->where($db->quoteName('a.title') . ' LIKE ' . $db->quote('%' . $db->escape($like) . '%'));

		$db->setQuery($query);
		$results = $db->loadObjectList();

		echo json_encode($results);

		$app->close();
	}
}

?>