<?php
/**
* @package SP Page Builder
* @author JoomShaper http://www.joomshaper.com
* @copyright Copyright (c) 2010 - 2016 JoomShaper
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
*/
//no direct accees
defined ('_JEXEC') or die ('restricted aceess');

SpAddonsConfig::addonConfig(
	array(
	
		'type'=>'repeatable',
		'addon_name'=>'sp_advanced_pricing',
		'title'=>JText::_('Advanced Pricing Table'),
		'desc'=>JText::_('Add Advanced Pricing Table'),
		'attr'=>array(
			'general' => array(

				'admin_label'=>array(
					'type'=>'text',
					'title'=>JText::_('Admin Lable'),
					'desc'=>JText::_('This Lable can see only admin in backend only'),
					'std'=> ''
				),

				'table_style'=>array(
					'type'=>'select',
					'title'=>JText::_('Table Style'),
					'values'=>array(
						'sppb-pricing-style1'=>JText::_('Style 1'),
						'sppb-pricing-style2'=>JText::_('Style 2'),
						'sppb-pricing-style3'=>JText::_('Style 3'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),


				'title'=>array(
					'type'=>'text',
					'title'=>JText::_('Pricing Title'),
					'desc'=>JText::_('Add Pricing Title'),
					'std'=>'Basic',
				),

				'price'=>array(
					'type'=>'text',
					'title'=>JText::_('Price'),
					'desc'=>JText::_('Add Price'),
					'std'=>'$29',
				),

				'duration'=>array(
					'type'=>'text',
					'title'=>JText::_('Duration'),
					'desc'=>JText::_('Add Duration of your plan'),
					'std'=>' /Month',
				),

				'table_lightdark'=>array(
					'type'=>'select',
					'title'=>JText::_('Table Light/Dark'),
					'desc'=>JText::_('Slect Table Light/Dark'),
					'values'=>array(
						''=>JText::_('Light'),
						'sppb-pricing-dark'=>JText::_('Dark'),
					),
					'std'=>'',
				),
				

				'background'=>array(
					'type'=>'color',
					'title'=>JText::_('Table Global Color'),
					'desc'=>JText::_('Select Table Global Color'),
					'depends'=>array('table_style'=>'sppb-pricing-style1')
				),
				
				// Is Featured
				'featured'=>array(
					'type'=>'select',
					'title'=>JText::_('Featured'),
					'desc'=>JText::_('Select Yes to make table featured'),
					'values'=>array(
						''=>JText::_('No'),
						'sppb-pricing-featured'=>JText::_('Yes'),
					),
					'std'=>'',
				),
				
				'sp_advanced_pricing_item'=>array(
					'title'=> JText::_('Feature List Content'),
					'attr'=>  array(
						'list_title'=>array(
							'type'=>'text',
							'title'=>JText::_('List Title'),
							'desc'=>JText::_('Add List Title'),
							'std'=>'',
						),
						
						'list_title_color'=>array(
							'type'=>'color',
							'title'=>JText::_('List Title Color'),
							'desc'=>JText::_('Add List Title color'),
							'std'=>'',
						),
						
						'list_title_size'=>array(
							'type'=>'number',
							'title'=>JText::_('List Title Size'),
							'desc'=>JText::_('Select List Title Size'),							
						),
						
						'list_icon'=>array(
							'type'=>'icon',
							'title'=>JText::_('List Icon'),
							'desc'=>JText::_('Select Icon Wich will show in list'),
						),
						'list_icon_color'=>array(
							'type'=>'color',
							'title'=>JText::_('List Icon Color'),
							'desc'=>JText::_('Add List Icon color'),
							'std'=>'',
						),
						'list_icon_size'=>array(
							'type'=>'number',
							'title'=>JText::_('Icon Size'),
							'desc'=>JText::_('Select Icon Size'),							
						),
						
						'tooltip'=>array(
							'type'=>'select',
							'title'=>JText::_('Enable ToolTip'),
							'desc'=>JText::_('Select to Enable ToolTip'),
							'values'=>array(
								'yes'=>JText::_('Yes'),
								'no'=>JText::_('No'),
							),
							'std'=>'no',
						),
						
						'tooltip_content'=>array(
							'type'=>'textarea',
							'title'=>JText::_('ToolTip Content'),
							'desc'=>JText::_('Add ToolTip content'),							
							'std'=>'I Am ToolTip. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam viverra condimentum ligula, ac pellentesque nisl.',
							'depends'=>array('tooltip'=>'yes')
						),
						
						
					),
				),

				'color'=>array(
					'type'=>'color',
					'title'=>JText::_('Color'),
					'desc'=>JText::_('Select Color'),
				),

				//Button
				'button_text'=>array(
					'type'=>'text',
					'title'=>JText::_('Button Text'),
					'desc'=>JText::_('Add Button Text'),
					'std'=>'Button Text',
				),

				'button_fontstyle'=>array(
					'type'=>'select',
					'title'=> JText::_('Button Font Style'),
					'values'=>array(
						'underline'=> JText::_('Underline'),
						'uppercase'=> JText::_('Uppercase'),
						'italic'=> JText::_('Italic'),
						'lighter'=> JText::_('Lighter'),
						'normal'=> JText::_('Normal'),
						'bold'=> JText::_('Bold'),
						'bolder'=> JText::_('Bolder'),
					),
					'multiple'=>true,
					'std'=>'',
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_letterspace'=>array(
					'type'=>'select',
					'title'=>JText::_('Letter Spacing'),
					'values'=>array(
						'0'=> 'Default',
						'1px'=> '1px',
						'2px'=> '2px',
						'3px'=> '3px',
						'4px'=> '4px',
						'5px'=> '5px',
						'6px'=>	'6px',
						'7px'=>	'7px',
						'8px'=>	'8px',
						'9px'=>	'9px',
						'10px'=> '10px'
					),
					'std'=>'0',
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_url'=>array(
					'type'=>'text',
					'title'=>JText::_('Button Url'),
					'desc'=>JText::_('Add Button Url'),
					'placeholder'=>'http://',
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_target'=>array(
					'type'=>'select',
					'title'=>JText::_('Link Target'),
					'desc'=>JText::_('Select LInk target'),
					'values'=>array(
						''=>JText::_('Same Window'),
						'_blank'=>JText::_('New Window'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_type'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Style'),
					'desc'=>JText::_('Select Button Style'),
					'values'=>array(
						'default'=>JText::_('Default'),
						'primary'=>JText::_('Primary'),
						'success'=>JText::_('Success'),
						'info'=>JText::_('Info'),
						'warning'=>JText::_('Warning'),
						'danger'=>JText::_('Danger'),
						'link'=>JText::_('Link'),
						'custom'=>JText::_('custom'),
					),
					'std'=>'default',
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_appearance'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Appearance'),
					'desc'=>JText::_('Select Button Appearance'),
					'values'=>array(
						''=>JText::_('Flat'),
						'outline'=>JText::_('Outline'),
						'3d'=>JText::_('3D'),
					),
					'std'=>'flat',
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_background_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Button Background Color'),
					'desc'=>JText::_('Select Button Background Color'),
					'std' => '#444444',
					'depends'=> array(
						array('button_type', '=', 'custom'),
						array('button_text', '!=', ''),
					)
				),

				'button_color'=>array(
					'type'=>'color',
					'title'=>JText::_('Botton Color'),
					'desc'=>JText::_('Select Button Text Color'),
					'std' => '#fff',
					'depends'=> array(
						array('button_type', '=', 'custom'),
						array('button_text', '!=', ''),
					)
				),

				'button_background_color_hover'=>array(
					'type'=>'color',
					'title'=>JText::_('Button Background Hover Color'),
					'desc'=>JText::_('Select Button Background Hover Color'),
					'std' => '#222',
					'depends'=> array(
						array('button_type', '=', 'custom'),
						array('button_text', '!=', ''),
					)
				),

				'button_color_hover'=>array(
					'type'=>'color',
					'title'=>JText::_('Button Hover Color'),
					'desc'=>JText::_('Select Button Hover Text Color'),
					'std' => '#fff',
					'depends'=> array(
						array('button_type', '=', 'custom'),
						array('button_text', '!=', ''),
					)
				),

				'button_size'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Size'),
					'desc'=>JText::_('Select Button Size'),
					'values'=>array(
						''=>JText::_('Default'),
						'lg'=>JText::_('Large'),
						'xlg'=>JText::_('Extra Large'),
						'sm'=>JText::_('Small'),
						'xs'=>JText::_('Extra Small'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_shape'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Shape'),
					'desc'=>JText::_('Select Button Shape'),
					'values'=>array(
						'rounded'=>JText::_('Rounded'),
						'square'=>JText::_('Square'),
						'round'=>JText::_('Round'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_block'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Block'),
					'desc'=>JText::_('Select Yes to Block Button'),
					'values'=>array(
						''=>JText::_('No'),
						'sppb-btn-block'=>JText::_('Yes'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_icon'=>array(
					'type'=>'icon',
					'title'=>JText::_('Button Icon'),
					'desc'=>JText::_('Select Button Icon'),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				'button_icon_position'=>array(
					'type'=>'select',
					'title'=>JText::_('Button Icon Position'),
					'values'=>array(
						'left'=>JText::_('Left'),
						'right'=>JText::_('Right'),
					),
					'depends'=> array(
						array('button_text', '!=', ''),
					)
				),

				

				'alignment'=>array(
					'type'=>'select',
					'title'=>JText::_('Alignment'),
					'desc'=>JText::_('Select Alignment'),
					'values'=>array(
						'sppb-text-left'=>JText::_('Left'),
						'sppb-text-center'=>JText::_('Center'),
						'sppb-text-right'=>JText::_('Right'),
					),
					'std'=>'sppb-text-left',
				),

				'class'=>array(
					'type'=>'text',
					'title'=>JText::_('Class'),
					'desc'=>JText::_('Add Custom Class To Addon'),
					'std'=>''
				),
				
				

			),
		),
	)
);
